#pragma once

//////////////////////////////////////////////////////////////////////////

typedef CArray<int>		 IntList;
typedef CArray<COLORREF> ColorList;

typedef struct _FLACTALE
{
	double dbRealMin;
	double dbImgMin;
	double dbSide;
	int	   nCountMax;
	int    nHeigth;
	int	   nWidth;
}
FLACTALE, *LPFLACTALE;

typedef struct _FLACTALEDATA
{
	UINT	 nSlaves;
	UINT	 nProcessors;
	NODEINIT nd;
	FLACTALE ft;
}
FLACTALEDATA, *LPFLACTALEDATA;

typedef struct _FTCALCDATA
{
	int		  nIndex;
	int		  nStepNo;
	WORD	  wNodeID;
	WORD	  wSubID;
	UINT      nSize;
	BOOL	  fEnd;
	BYTE	  reserve[4];	// For padding
	double    dbRuntime;
	ColorList list;
}
FTCALCDATA, *LPFTCALCDATA;

//////////////////////////////////////////////////////////////////////////

class CFlactale
{
public:
	CFlactale();
	virtual ~CFlactale();

	void Initialize(FLACTALE Params);
	virtual void Calculation(int nYPoint, LPCOLORREF lpColor) = 0;

protected:
	void SetParameters(FLACTALE Flactale) { m_Flactale = Flactale; }
	void DefPalette();
	void PrintLevel();

protected:
	FLACTALE  m_Flactale;
	ColorList m_Color;
	IntList   m_nPal;
	IntList   m_nLvlPal;
	int		  m_nPalMax;
	int		  m_nLvlMax;
};

//////////////////////////////////////////////////////////////////////////

class CMandelbrot : public CFlactale
{
public:
	CMandelbrot();
	virtual ~CMandelbrot();
	virtual void Calculation(int nYPoint, LPCOLORREF lpColor);
};

//////////////////////////////////////////////////////////////////////////
