import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

/*
 * Created on 2004/05/04
 */
/**
 * implements chess-rule,PGN,FEN etc.
 * 
 * @author qwert
 */
public class Game implements ChessLibrary {
	/*
	 * this class handles any input on Surface by user only when promotion occurs
	 * @author qwert
	 */
	public class InputListener extends AbstractInputListener {
		/**
		 * @param _app
		 */
		public InputListener(MIDlet app) {
			super(app);
		}
		/*
		 * doing commands (non-Javadoc)
		 * 
		 * @see javax.microedition.lcdui.CommandListener#commandAction(javax.microedition.lcdui.Command,
		 *        javax.microedition.lcdui.Displayable)
		 */
		public void commandAction(Command c, Displayable s) {
			if (c == WinboardClone.exit) {
				app.notifyDestroyed();
			} else if (c == WinboardClone.init)
				WinboardClone.game.init();
		}
		/*
		 * this method is only called by Surface.keypressed
		 */
		public void keyPressed(int param) {
			switch (param) {
				case javax.microedition.lcdui.Canvas.KEY_NUM2 :
				//N
				case javax.microedition.lcdui.Canvas.KEY_NUM3 :
				//B
				case javax.microedition.lcdui.Canvas.KEY_NUM4 :
				//R
				case javax.microedition.lcdui.Canvas.KEY_NUM5 :
					//Q
//					Position[LastMove[2]][LastMove[3]] = param
//							- javax.microedition.lcdui.Canvas.KEY_NUM0;
//					promote_mode = false;
//					//						char[] ca = new char[2];
//					//						ca[0] = '=';
//					//						ca[1] = pieceOf(-param);
//					//						newmsg(String.valueOf(ca));
//					newmsg("");
//					return;
				default :
					return;
			}
		}
	}
	//TODO
	/*
	 *
	 * @author qwert
	 */
	public class Line {
		int num0; // the number of the 0th move of the lines
		int length; // the length of moves can be held
		/*
		 * this two arrays(moves and joints) always together
		 */
		private Move[] moves;
		/*
		  * this two arrays(moves and joints) always together
		 */
		private Line[] joints;
		/*
		 * pointers used to joint two lines to make more long line
		 */
		Line pline, cline;// parent,child
		/**
		 *  
		 */
		public Line(int n0,int l,Line pl,Line cl) {
			num0 = n0;
			length = l;
			pline = pl;
			cline = cl;
			moves = new Move[length];
		}
			}

	
	/*
	 * WinboardClone's native chess format @author qwert
	 */
	public class Move {
		/*
		 * piece moves from C(F,R) to c(f,r)
		 */
		public Coordinate c, C;
		/*
		 * fen compatible see FEN, nag is full NAG(Numeric Annotation Glyph)
		 */
		public int fen, nag;
		/*
		 * see ChessLibrary
		 */
		public int piece;
		/*
		 * comments like annotaions
		 */
		public String str;
		/**
		 * init things
		 */
		public Move(int p, Coordinate _c, Coordinate _C, int f, int n, String s) {
			piece = p;
			c = _c;
			C = _C;
			fen = f;
			nag = n;
			str = s;
		}
	}
	/*
	 * stores position;
	 */
	int[][] Position ;//[file][rank]
	/*
	 * implements Line manipulating methods
	 * this line do not store lines usually but sometimes used for tmp-Line
	 * @author qwert
	 */
//	public class RootLine extends Line{
//		/*
//		 * count up lines while parrent is not higher line
//		 */
//		private void subenumline(int num, int[] ienum) {
//			if (parentline == rootline || parentline.basen != num)
//				return;
//			ienum[1]++;
//			parentline.subenumline(num, ienum);
//		}
//		void travelline(int num, Line departureline, int i)
//				throws LineCannotAccessedException {
//			if (i == 0) {
//				departureline = this;
//			} else if (i > 0) {
//				if (getmove(num).connecter == null)
//					throw new LineCannotAccessedException();
//				i--;
//				getmove(num).connecter.travelline(num, departureline, i);
//			} else {
//				i++;
//				if (parentline == rootline)
//					i = 0;
//				parentline.travelline(num, departureline, i);
//			}
//		}
//	
//		void addline(int num, Line addedline)
//		throws LineCannotAccessedException {
//	Line tmpl;
//	if (addedline == null) {
//		getmove(num).connecter = new Line(num, this,
//				getmove(num).connecter, length, rootline);
//		getmove(num).connecter.parentline = this;
//		getmove(num).connecter.childline = getmove(num).connecter;
//	}
//	getmove(num).connecter = addedline;
//	addedline.parentline = this;
//	addedline.childline = getmove(num).connecter;
//}
///*
// * return deled line clearline is the only way to make new line from
// * rootline
// */
//Line clearline() throws LineCannotAccessedException {
//	Line tmpl;
//	try {
//		getmove(basen).connecter.parentline = parentline;
//		if (parentline != rootline)
//			parentline.childline = getmove(basen).connecter;
//	} catch (LineCannotAccessedException e) {
//		/*
//		 * never happen
//		 */
//	}
//	//		try {
//	//			this.finalize();
//	//		} catch (Throwable e) {
//	//		}
//	/*
//	 *  
//	 */
//	tmpl = this;
//	this = parentline;
//	return tmpl;
//}
//int[] enumline(int num) throws LineCannotAccessedException {
//	/*
//	 * ienum[0] length of lines ienum[1] the position of the line in
//	 * the lines
//	 */
//	int[] ienum = new int[2];
//	ienum[0] = 1;
//	subenumline(num, ienum);
//	ienum[0] += ienum[1];
//	sub2enumline(num, ienum);
//	return ienum;
//}
//Move getmove(int num) throws LineCannotAccessedException {
//	if (basen < num) {
//		/*
//		 * the move is stored within this line
//		 */
//		if (num < basen + length)
//			return moves[num];
//		/*
//		 * make childline and call childline's getmove()
//		 */
//		else if (childline == null) {
//			childline = new Line(basen + length, this, null, length,
//					rootline);
//			return childline.getmove(num);
//			/*
//			 * already childline exists and call childline's getmove()
//			 */
//		} else
//			return childline.getmove(num);
//	} else {
//		/*
//		 * parrent line is root so throw a exception;
//		 */
//		if (parentline == rootline) {
//			throw new LineCannotAccessedException();
//			/*
//			 * call childline's getmove()
//			 */
//		} else
//			return parentline.getmove(num);
//	}
//}
//void putmove(int num, Move move) throws LineCannotAccessedException {
//	if (basen < num) {
//		if (num < basen + length)
//			moves[num] = move;
//		else if (childline == null) {
//			throw new LineCannotAccessedException();
//		} else {
//			this = childline;
//		}
//	} else {
//		if (parentline == rootline) {
//			parentline = new Line(basen + length, null, this, length,
//					rootline);
//			this = parentline;
//		} else {
//			this = parentline;
//		}
//	}
//	putmove(num, move);
//}
///*
// * count up lines while connecter is not exists.
// */
//private void sub2enumline(int num, int[] ienum)
//		throws LineCannotAccessedException {
//	try {
//		if (getmove(num).connecter == null)
//			return;
//	} catch (LineCannotAccessedException e) {
//		ienum[0] = 0;
//		return;
//	}
//	ienum[0]++;
//	getmove(num).connecter.sub2enumline(num, ienum);
//
//		/**
//		 * @param n0
//		 * @param l
//		 * @param pl
//		 * @param cl
//		 */
//		public RootLine(int n0, int l, Line pl, Line cl) {
//			super(n0, l, pl, cl);
//			// TODO Auto-generated constructor stub
//		}
//		
//	}
	FEN RootPosition;
	public class FEN {
		
	}
	Line line;//TODO
	int indexnum;//TODO
	InputListener inputListener;
	/*
	 *  
	 */
	public Game() {
		Position = new int[8][8];
		init();
	}
	/*
	 * init the board
	 */
	public void init() {
		Position = new int[8][8];
		Position[0][7] = BR;
		Position[1][7] = BN;
		Position[2][7] = BB;
		Position[3][7] = BQ;
		Position[4][7] = BK;
		Position[5][7] = BB;
		Position[6][7] = BN;
		Position[7][7] = BR;
		for (int i = 0; i <= 7; i++) {
			Position[i][6] = BP;
		}
		Position[0][0] = WR;
		Position[1][0] = WN;
		Position[2][0] = WB;
		Position[3][0] = WQ;
		Position[4][0] = WK;
		Position[5][0] = WB;
		Position[6][0] = WN;
		Position[7][0] = WR;
		for (int i = 0; i <= 7; i++) {
			Position[i][1] = WP;
		}
	}
	public void movepiece(int f, int r, int F, int R)// throws
	// IllegalMoveException
	{
		int p;
		p = Position[f][r];
		try {
			Position[F][R] = Position[f][r];
			Position[f][r] = SP;
//			LastMove[0] = f;
//			LastMove[1] = r;
//			LastMove[2] = F;
//			LastMove[3] = R;
		} catch (ArrayIndexOutOfBoundsException e) {
			//throw new IllegalMoveException();
		}
		if (p == 1 && R == 7 || p == -1 && R == 0) {
			inputListener = new InputListener(WinboardClone.inputlistener.app);
			WinboardClone.surface.setCommandListener(inputListener);
			WinboardClone.messagebar.newmsg("Promote pawn to");
			return;
		}
			WinboardClone.messagebar.newmsg("");

	}
	public char pieceOf(int p) {
		switch (p) {
			case WP :
				return 'p';
			case BP :
				return 'P';
			case WN :
				return 'n';
			case BN :
				return 'N';
			case WB :
				return 'b';
			case BB :
				return 'B';
			case WR :
				return 'r';
			case BR :
				return 'R';
			case WQ :
				return 'q';
			case BQ :
				return 'Q';
			case WK :
				return 'k';
			case BK :
				return 'K';
			default :
				return ' ';
		}
	}
}
