#! /usr/bin/env ruby
# -*- coding: utf-8 -*-
# 
# ウィキペディアの各言語版のサイトから統計情報を取得して更新用ウィキテキストを作成し出力します。
# 更新用ウィキテキストのファイル名は、作業ディレクトリの<tt>new-page.txt</tt> です。
# 更新用ウィキテキストが正常に作成され出力された場合、
# そのウィキテキストで全言語版の統計ページを更新します。
# 統計ページを更新が正常に行われた場合、終了ステータス 0 を返します。
# なんらかの原因で処理が中断した場合、終了ステータスとして 0 以外を返します。
# 

require './languages-statistics'

$stderr.puts 'Console encoding set in config.xml: ' + WikiBotConfig.new.console_encoding

taker = Taker.new
taker.execute
if taker.status != 0 then
	exit(taker.status)
end

updater = Updater.new
updater.execute
if updater.status != 0 then
	exit(updater.status)
end

exit(0)
