<?xml version="1.0" encoding="UTF-8"?>
<xsl:transform version="1.0"
      xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
      xmlns="http://www.w3.org/1999/xhtml">

<xsl:output
  method="xml"
  encoding="UTF-8"
  doctype-public="-//W3C//DTD XHTML 1.1//EN" 
  doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"
  indent="yes"/>
 
<xsl:template match="/">
<xsl:apply-templates/>
</xsl:template>
 
<xsl:template match="document">
<html xml:lang="ja">

<xsl:variable name="title" select="title/text()"/>

<head>
 <title><xsl:value-of select="$title"/></title>
</head>

<body>

<h1><xsl:value-of select="$title"/></h1>

<xsl:apply-templates/>

</body>

</html>
</xsl:template>
 
<xsl:template match="title">
</xsl:template>
 
<xsl:template match="paragraph">
<p>
<xsl:apply-templates/>
</p>
</xsl:template>
 
<xsl:template match="anchor">
<a><xsl:attribute name="href"><xsl:value-of select="@hyperlinkReference"/></xsl:attribute><xsl:value-of select="text()"/></a>
</xsl:template>
 
<xsl:template match="unorderedList">
<ul>
<xsl:apply-templates/>
</ul>
</xsl:template>
 
<xsl:template match="orderedList">
<ol>
<xsl:apply-templates/>
</ol>
</xsl:template>
 
<xsl:template match="listItem">
 <li>
  <xsl:apply-templates/>
 </li>
</xsl:template>
 
<xsl:template match="sectionTitle">

<h2><xsl:value-of select="text()"/></h2>

</xsl:template>
 
<xsl:template match="definitionList">
<dl>
<xsl:apply-templates/>
</dl>
</xsl:template>
 
<xsl:template match="definitionTerm">
<dt><xsl:value-of select="text()"/></dt>
</xsl:template>
 
<xsl:template match="definitionDescription">
<dd><xsl:apply-templates/></dd>
</xsl:template>
 
</xsl:transform>

