package jp.ac.dendai.cdl.mori.wikie.util;

import static org.junit.Assert.*;

import java.util.*;

import org.junit.*;

public class WLinkUtilsTest {
    public Set<String> langSet = new TreeSet<String>(); {
        langSet.add("en");
    }
    public Set<String> proSet = new TreeSet<String>(); {
        proSet.add("w");
    }

    @Test
    public void testGetPage() {
        try {
            WNormalizer n = new WNormalizer("pageHead.xml", proSet, langSet);
            WLinkUtils link = new WLinkUtils(n);

            List<WLink> linkList = link.getLink("[[ 百科事典 # 歴史 | 百科事典の歴史 ]]");
            for (WLink wl : linkList) {
                assertEquals("百科事典#歴史|百科事典の歴史", wl.toString());
            }

            linkList = link.getLink("[[ 百科事典 # 歴史 ]]");
            for (WLink wl : linkList) {
                assertEquals("百科事典#歴史", wl.toString());
            }

            linkList = link.getLink("[[百科事典 | 百科事典の歴史 ]]");
            for (WLink wl : linkList) {
                assertEquals("百科事典|百科事典の歴史", wl.toString());
            }

            linkList = link.getLink("[[ 百科事典 ]]");
            for (WLink wl : linkList) {
                assertEquals("百科事典", wl.toString());
            }

            linkList = link.getLink("[[ # 歴史 | 百科事典の歴史 ]]");
            for (WLink wl : linkList) {
                assertEquals("#歴史|百科事典の歴史", wl.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}
