package jp.ac.dendai.cdl.mori.wikie.mapred;

import java.io.*;

import jp.ac.dendai.cdl.mori.wikie.main.*;
import jp.ac.dendai.cdl.mori.wikie.parser.*;
import jp.ac.dendai.cdl.mori.wikie.util.*;

import org.apache.commons.lang.*;
import org.apache.hadoop.io.*;
import org.apache.hadoop.mapred.*;

public class NodeMapper extends WMapper {
    @Override
    public void map(LongWritable key, Text value, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        try {
            WPageElementHandler page = createPageHandler(value);
            WEntry entry = normalizer.normalize(page.getTitle());
            String title = entry.toString();
            if (StringUtils.isNotBlank(title)) {
                String id  = page.getId();
                String text = WNormalizer.deleteNonPrintingChar(page.getText());
                String kind = linkUtils.getKind(entry, text);
                if (!kind.equals(WikIE.OTHER)) {
                    output.collect(new Text(id), new Text(title + "\t" + kind));
                }
            }

        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}
