package jp.ac.dendai.cdl.mori.wikie.io;

import java.io.*;

import org.apache.hadoop.io.*;
import org.apache.hadoop.mapred.*;

/**
 * XMLファイルから特定の要素毎にテキストを切り出すためのInputFormat。
 * @author Mori
 *
 */
public class XMLInputFormat extends TextInputFormat {

    @Override
    public RecordReader<LongWritable, Text> getRecordReader(InputSplit genericSplit, JobConf job, Reporter reporter) throws IOException {
        reporter.setStatus(genericSplit.toString());
        return new XMLRecordReader(job, (FileSplit)genericSplit);
    }
}
