/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.htmlcleaner.HtmlCleaner;

public class CommandLine {
    private static String getArgValue(String[] args, String name) {
        int i = 0;
        while (i < args.length) {
            String curr = args[i];
            int eqIndex = curr.indexOf(61);
            if (eqIndex >= 0) {
                String argName = curr.substring(0, eqIndex).trim();
                String argValue = curr.substring(eqIndex + 1).trim();
                if (argName.toLowerCase().startsWith(name.toLowerCase())) {
                    return argValue;
                }
            }
            ++i;
        }
        return "";
    }

    private static boolean toBoolean(String s) {
        return s != null && ("on".equalsIgnoreCase(s) || "true".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s));
    }

    public static void main(String[] args) throws IOException {
        String outCharset;
        String inCharset;
        String source = CommandLine.getArgValue(args, "src");
        if ("".equals(source)) {
            System.err.println("Usage: java -jar htmlcleanerXX.jar src = <url | file> [incharset = <charset>] [dest = <file>] [outcharset = <charset>] [options...]");
            System.err.println("");
            System.err.println("where options include:");
            System.err.println("    outputtype = simple | compact | pretty");
            System.err.println("    advancedxmlescape = true | false");
            System.err.println("    usecdata = true | false");
            System.err.println("    specialentities = true | false");
            System.err.println("    unicodechars = true | false");
            System.err.println("    omitunknowntags = true | false");
            System.err.println("    omitdeprtags = true | false");
            System.err.println("    omitcomments = true | false");
            System.err.println("    omitxmldecl = true | false");
            System.err.println("    omitdoctypedecl = true | false");
            System.err.println("    omitxmlnsatt = true | false");
            System.err.println("    hyphenreplacement = <string value>");
            System.exit(1);
        }
        if ("".equals(inCharset = CommandLine.getArgValue(args, "incharset"))) {
            inCharset = HtmlCleaner.DEFAULT_CHARSET;
        }
        if ("".equals(outCharset = CommandLine.getArgValue(args, "outcharset"))) {
            outCharset = HtmlCleaner.DEFAULT_CHARSET;
        }
        String destination = CommandLine.getArgValue(args, "dest");
        String outputType = CommandLine.getArgValue(args, "outputtype");
        String advancedXmlEscape = CommandLine.getArgValue(args, "advancedxmlescape");
        String useCData = CommandLine.getArgValue(args, "usecdata");
        String translateSpecialEntities = CommandLine.getArgValue(args, "specialentities");
        String unicodeChars = CommandLine.getArgValue(args, "unicodechars");
        String omitUnknownTags = CommandLine.getArgValue(args, "omitunknowntags");
        String omitDeprecatedTags = CommandLine.getArgValue(args, "omitdeprtags");
        String omitComments = CommandLine.getArgValue(args, "omitcomments");
        String omitXmlDeclaration = CommandLine.getArgValue(args, "omitxmldecl");
        String omitDoctypeDeclaration = CommandLine.getArgValue(args, "omitdoctypedecl");
        String omitXmlnsAttributes = CommandLine.getArgValue(args, "omitxmlnsatt");
        String commentHyphen = CommandLine.getArgValue(args, "hyphenreplacement");
        HtmlCleaner cleaner = null;
        String src = source.toLowerCase();
        cleaner = src.startsWith("http://") || src.startsWith("https://") ? new HtmlCleaner(new URL(src), inCharset) : new HtmlCleaner(new File(src), inCharset);
        if (!"".equals(omitUnknownTags)) {
            cleaner.setOmitUnknownTags(CommandLine.toBoolean(omitUnknownTags));
        }
        if (!"".equals(omitDeprecatedTags)) {
            cleaner.setOmitDeprecatedTags(CommandLine.toBoolean(omitDeprecatedTags));
        }
        if (!"".equals(advancedXmlEscape)) {
            cleaner.setAdvancedXmlEscape(CommandLine.toBoolean(advancedXmlEscape));
        }
        if (!"".equals(useCData)) {
            cleaner.setUseCdataForScriptAndStyle(CommandLine.toBoolean(useCData));
        }
        if (!"".equals(translateSpecialEntities)) {
            cleaner.setTranslateSpecialEntities(CommandLine.toBoolean(translateSpecialEntities));
        }
        if (!"".equals(unicodeChars)) {
            cleaner.setRecognizeUnicodeChars(CommandLine.toBoolean(unicodeChars));
        }
        if (!"".equals(omitComments)) {
            cleaner.setOmitComments(CommandLine.toBoolean(omitComments));
        }
        if (!"".equals(omitXmlDeclaration)) {
            cleaner.setOmitXmlDeclaration(CommandLine.toBoolean(omitXmlDeclaration));
        }
        if (!"".equals(omitDoctypeDeclaration)) {
            cleaner.setOmitDoctypeDeclaration(CommandLine.toBoolean(omitDoctypeDeclaration));
        }
        if (!"".equals(omitXmlnsAttributes)) {
            cleaner.setOmitXmlnsAttributes(CommandLine.toBoolean(omitXmlnsAttributes));
        }
        if (!"".equals(commentHyphen)) {
            cleaner.setHyphenReplacementInComment(commentHyphen);
        }
        cleaner.clean();
        if ("".equals(destination)) {
            if ("compact".equals(outputType)) {
                cleaner.writeCompactXmlToStream(System.out, outCharset);
            } else if ("pretty".equals(outputType)) {
                cleaner.writePrettyXmlToStream(System.out, outCharset);
            } else {
                cleaner.writeXmlToStream(System.out, outCharset);
            }
        } else if ("compact".equals(outputType)) {
            cleaner.writeCompactXmlToFile(destination, outCharset);
        } else if ("pretty".equals(outputType)) {
            cleaner.writePrettyXmlToFile(destination, outCharset);
        } else {
            cleaner.writeXmlToFile(destination, outCharset);
        }
    }
}

