/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.dendai.cdl.mori.wikie.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;

public class LineReader {
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    private int bufferSize = 65536;
    private InputStream in;
    private byte[] buffer;
    private int bufferLength = 0;
    private int bufferPosn = 0;

    public LineReader(InputStream in, int bufferSize) {
        this.in = in;
        this.bufferSize = bufferSize;
        this.buffer = new byte[this.bufferSize];
    }

    public LineReader(InputStream in, Configuration conf) throws IOException {
        this(in, conf.getInt("io.file.buffer.size", 65536));
    }

    boolean backfill() throws IOException {
        this.bufferPosn = 0;
        this.bufferLength = this.in.read(this.buffer);
        return this.bufferLength > 0;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int readLine(Text str) throws IOException {
        int length;
        str.clear();
        boolean hadFinalNewline = false;
        boolean hadFinalReturn = false;
        boolean hitEndOfFile = false;
        int startPosn = this.bufferPosn;
        block4: while (true) {
            if (this.bufferPosn >= this.bufferLength && !this.backfill()) {
                hitEndOfFile = true;
                break;
            }
            startPosn = this.bufferPosn;
            while (this.bufferPosn < this.bufferLength) {
                switch (this.buffer[this.bufferPosn]) {
                    case 10: {
                        hadFinalNewline = true;
                        ++this.bufferPosn;
                        break block4;
                    }
                    case 13: {
                        if (hadFinalReturn) break block4;
                        hadFinalReturn = true;
                        break;
                    }
                    default: {
                        if (hadFinalReturn) break block4;
                    }
                }
                ++this.bufferPosn;
            }
            int length2 = this.bufferPosn - startPosn - (hadFinalReturn ? 1 : 0);
            if (length2 < 0) continue;
            str.append(this.buffer, startPosn, length2);
        }
        int newlineLength = (hadFinalNewline ? 1 : 0) + (hadFinalReturn ? 1 : 0);
        if (!hitEndOfFile && (length = this.bufferPosn - startPosn - newlineLength) > 0) {
            str.append(this.buffer, startPosn, length);
        }
        return str.getLength() + newlineLength;
    }
}

