/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.api.creator;

import info.bliki.api.Page;
import info.bliki.api.User;
import info.bliki.pdf.PDFGenerator;
import info.bliki.wiki.filter.HTMLConverter;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.PDFConverter;
import info.bliki.wiki.model.IWikiModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.List;

public class DocumentCreator {
    private final String[] fListOfTitleStrings;
    private final User fUser;
    private final IWikiModel fModel;
    private List<Page> fListOfPages = null;
    private String fHeader;
    private String fFooter;

    public DocumentCreator(IWikiModel model, User user, String[] listOfTitleStrings) {
        this.fListOfTitleStrings = listOfTitleStrings;
        this.fUser = user;
        this.fModel = model;
        this.fHeader = null;
        this.fFooter = null;
    }

    public void readPages() {
        this.fUser.login();
        this.fListOfPages = this.fUser.queryContent(this.fListOfTitleStrings);
    }

    public void render(ITextConverter converter, Appendable appendable) throws IOException {
        if (this.fListOfPages == null) {
            this.readPages();
        }
        if (this.fListOfPages != null) {
            if (this.fHeader != null) {
                appendable.append(this.fHeader);
            }
            for (Page page : this.fListOfPages) {
                String rawWikiText = page.getCurrentContent();
                this.fModel.setPageName(page.getTitle());
                appendable.append(this.fModel.render(converter, rawWikiText));
            }
            if (this.fFooter != null) {
                appendable.append(this.fFooter);
            }
        }
    }

    public void render(Appendable appendable) throws IOException {
        this.render(new HTMLConverter(), appendable);
    }

    public void renderPDF(Appendable appendable) throws IOException {
        this.render(new PDFConverter(), appendable);
    }

    public void renderToFile(ITextConverter converter, String filename) throws IOException {
        File file = new File(filename);
        BufferedWriter fw = new BufferedWriter(new FileWriter(file));
        this.render(converter, fw);
        fw.close();
    }

    public void renderToFile(String filename) throws IOException {
        this.renderToFile(new HTMLConverter(), filename);
    }

    public void renderPDFToFile(String baseDirectoryName, String filename, String cssStyle) throws IOException {
        StringBuffer buffer = new StringBuffer();
        this.renderPDF(buffer);
        String renderedXHTML = buffer.toString();
        File baseDirectory = new File(baseDirectoryName);
        try {
            URL url = baseDirectory.toURI().toURL();
            PDFGenerator gen = new PDFGenerator(url);
            gen.create(String.valueOf(baseDirectoryName) + '/' + filename, renderedXHTML, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \n   \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n        <title>{0}</title>\n{1}\n    </head>\n    <body>", "    </body>\n</html>", "Big Test", cssStyle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getHeader() {
        return this.fHeader;
    }

    public void setHeader(String header) {
        this.fHeader = header;
    }

    public String getFooter() {
        return this.fFooter;
    }

    public void setFooter(String footer) {
        this.fFooter = footer;
    }
}

