package jp.ac.dendai.cdl.mori.wikie.mapred;

import java.io.*;
import java.util.*;

import jp.ac.dendai.cdl.mori.wikie.parser.*;
import jp.ac.dendai.cdl.mori.wikie.util.*;

import org.apache.hadoop.io.*;
import org.apache.hadoop.mapred.*;

/**
 * interWiki処理用Mapper
 * @author Mori
 *
 */
public class InterLangMapper extends WMapper {
    @Override
    public void map(LongWritable key, Text value,
            OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        try {
            WPageElementHandler page = createPageHandler(value);
            String id  = page.getId();
            String text = WNormalizer.deleteNonPrintingChar(page.getText());
            Iterator<WLink> interLangItr = linkUtils.getInterLangLink(text).iterator();
            while (interLangItr.hasNext()) {
                output.collect(new Text(id), new Text(interLangItr.next().getEntry().toString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}
