/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.model;

import info.bliki.wiki.filter.Encoder;
import info.bliki.wiki.model.AbstractTracModel;
import info.bliki.wiki.model.Configuration;
import info.bliki.wiki.model.ImageFormat;
import info.bliki.wiki.model.SemanticAttribute;
import info.bliki.wiki.model.SemanticRelation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracModel
extends AbstractTracModel {
    protected Set<String> categories = null;
    protected Set<String> links = null;
    protected Set<String> templates = null;
    protected List<SemanticRelation> semanticRelations = null;
    protected List<SemanticAttribute> semanticAttributes = null;
    protected String fExternalImageBaseURL;
    protected String fExternalWikiBaseURL;

    public TracModel(String imageBaseURL, String linkBaseURL) {
        this(Configuration.DEFAULT_CONFIGURATION, imageBaseURL, linkBaseURL);
    }

    public TracModel(Configuration configuration, String imageBaseURL, String linkBaseURL) {
        super(configuration);
        this.fExternalImageBaseURL = imageBaseURL;
        this.fExternalWikiBaseURL = linkBaseURL;
    }

    public TracModel(Configuration configuration, Locale locale, String imageBaseURL, String linkBaseURL) {
        super(configuration, locale);
        this.fExternalImageBaseURL = imageBaseURL;
        this.fExternalWikiBaseURL = linkBaseURL;
    }

    public TracModel(Configuration configuration, ResourceBundle resourceBundle, String imageBaseURL, String linkBaseURL) {
        super(configuration, resourceBundle);
        this.fExternalImageBaseURL = imageBaseURL;
        this.fExternalWikiBaseURL = linkBaseURL;
    }

    @Override
    public void addCategory(String categoryName, String sortKey) {
        this.categories.add(categoryName);
    }

    @Override
    public void addLink(String topicName) {
        this.links.add(topicName);
    }

    @Override
    public boolean addSemanticAttribute(String attribute, String attributeValue) {
        if (this.semanticAttributes == null) {
            this.semanticAttributes = new ArrayList<SemanticAttribute>();
        }
        this.semanticAttributes.add(new SemanticAttribute(attribute, attributeValue));
        return true;
    }

    @Override
    public boolean addSemanticRelation(String relation, String relationValue) {
        if (this.semanticRelations == null) {
            this.semanticRelations = new ArrayList<SemanticRelation>();
        }
        this.semanticRelations.add(new SemanticRelation(relation, relationValue));
        return true;
    }

    @Override
    public void addTemplate(String template) {
        this.templates.add(template);
    }

    @Override
    public void appendInternalLink(String topic, String hashSection, String topicDescription, String cssClass) {
        String encodedtopic = Encoder.encodeTitleUrl(topic);
        if (this.replaceColon()) {
            encodedtopic = encodedtopic.replaceAll(":", "/");
        }
        String hrefLink = this.fExternalWikiBaseURL.replace("${title}", encodedtopic);
        super.appendInternalLink(hrefLink, hashSection, topicDescription, cssClass);
    }

    public Set<String> getCategories() {
        return this.categories;
    }

    @Override
    public Set<String> getLinks() {
        return this.links;
    }

    @Override
    public List<SemanticAttribute> getSemanticAttributes() {
        return this.semanticAttributes;
    }

    @Override
    public List<SemanticRelation> getSemanticRelations() {
        return this.semanticRelations;
    }

    public Set<String> getTemplates() {
        return this.templates;
    }

    @Override
    public void parseInternalImageLink(String imageNamespace, String name) {
        if (this.fExternalImageBaseURL != null) {
            String imageHref = this.fExternalWikiBaseURL;
            String imageSrc = this.fExternalImageBaseURL;
            ImageFormat imageFormat = ImageFormat.getImageFormat(name, imageNamespace);
            String imageName = imageFormat.getFilename();
            String sizeStr = imageFormat.getSizeStr();
            if (sizeStr != null) {
                imageName = String.valueOf(sizeStr) + '-' + imageName;
            }
            if (imageName.endsWith(".svg")) {
                imageName = String.valueOf(imageName) + ".png";
            }
            imageName = Encoder.encodeUrl(imageName);
            if (this.replaceColon()) {
                imageName = imageName.replaceAll(":", "/");
            }
            if (this.replaceColon()) {
                imageHref = imageHref.replace("${title}", String.valueOf(imageNamespace) + '/' + imageName);
                imageSrc = imageSrc.replace("${image}", imageName);
            } else {
                imageHref = imageHref.replace("${title}", String.valueOf(imageNamespace) + ':' + imageName);
                imageSrc = imageSrc.replace("${image}", imageName);
            }
            this.appendInternalImageLink(imageHref, imageSrc, imageFormat);
        }
    }

    @Override
    public boolean replaceColon() {
        return false;
    }

    @Override
    public void setUp() {
        super.setUp();
        this.categories = new HashSet<String>();
        this.links = new HashSet<String>();
        this.templates = new HashSet<String>();
    }
}

