/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Config;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public final class Util {
    private static final int BUFFER_SIZE = 2048;
    private static final String CSVNewLine = System.getProperty("line.separator");

    private Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(Reader reader) throws IOException {
        if (reader == null) {
            return "";
        }
        try {
            int n;
            char[] cArray = new char[2048];
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = reader.read(cArray, 0, 2048)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
            String string = stringBuffer.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static void outputCSVLine(Writer writer, String[] stringArray) throws IOException {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string != null) {
                if (string == Config.ColumnValueTrue || string == Config.ColumnValueFalse) {
                    writer.write(string);
                } else {
                    writer.write(34);
                    Util.outputValueEscapeQuotes(writer, string);
                    writer.write(34);
                }
            }
            if (++n == stringArray.length) continue;
            writer.write(44);
        }
        writer.write(CSVNewLine);
    }

    private static void outputValueEscapeQuotes(Writer writer, String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            writer.write(c);
            if (c != '\"') continue;
            writer.write(c);
        }
    }

    static char[] getConcatenatedCharArray(String string, String string2) {
        char[] cArray = new char[string.length() + string2.length()];
        string.getChars(0, string.length(), cArray, 0);
        string2.getChars(0, string2.length(), cArray, string.length());
        return cArray;
    }

    static StringBuffer appendTo(StringBuffer stringBuffer, CharSequence charSequence) {
        if (charSequence instanceof String) {
            return stringBuffer.append((String)charSequence);
        }
        if (charSequence instanceof StringBuffer) {
            return stringBuffer.append((StringBuffer)charSequence);
        }
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(charSequence.charAt(i));
        }
        return stringBuffer;
    }

    static StringBuffer appendTo(StringBuffer stringBuffer, CharSequence charSequence, int n, int n2) {
        while (n < n2) {
            stringBuffer.append(charSequence.charAt(n));
            ++n;
        }
        return stringBuffer;
    }

    static Writer appendTo(Writer writer, CharSequence charSequence) throws IOException {
        writer.write(((Object)charSequence).toString());
        return writer;
    }

    static Writer appendTo(Writer writer, CharSequence charSequence, int n, int n2) throws IOException {
        if (charSequence instanceof String) {
            writer.write((String)charSequence, n, n2 - n);
            return writer;
        }
        writer.write(((Object)charSequence.subSequence(n, n2)).toString());
        return writer;
    }
}

