//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCRworkingDialog.h>
#include <WSCbase.h>
#include <WSCbaseList.h>
#include <WSCworkingDialog.h>

WSMFclassInit(WSCRworkingDialog,WSCRbaseDialog);
WSMFremoteClassInit(WSCRworkingDialog,WSCworkingDialog);

WSCRworkingDialog::WSCRworkingDialog(){
}

WSCRworkingDialog::~WSCRworkingDialog(){
}

void WSCRworkingDialog::setValue(WSCushort val){
  if (_local != NULL){
    WSCworkingDialog* target = (WSCworkingDialog*)_local->cast("WSCworkingDialog");
    if (target != NULL){
      target->setValue(val);
      return;
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSCworkingDialog");
  rc.setOperationName("setValue");
  beginRemoteCall(&rc);
  _db->save(WS_DcRUShort,"val",(void*)&val);
  if (_db == NULL){
    return;
  }
  endRemoteCall();
}

void _WSCworkingDialog_remote_call(WSDserialize* db,WSCremoteCall* rc){
  if ( rc->_op[0] == 's'){
    if (!strcmp(rc->_op,"setValue")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSCushort val;
        db->load(WS_DcRUShort,"val",(void*)&val);
        WSCworkingDialog* target = (WSCworkingDialog*)inst->cast("WSCworkingDialog");
        if (target != NULL){
          target->setValue(val);
        }
      }
      return;
    }
  }

extern void _WSCbaseDialog_remote_call(WSDserialize* db,WSCremoteCall* rc);
  _WSCbaseDialog_remote_call(db,rc);
}

WSMFdefineDrNetServer(WSCworkingDialog,_WSCworkingDialog_remote_call);

