//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <basic.h>
#include <assert.h>
#include <WSCbaseList.h>
#include <WSCbase.h>
#include <WSCdevice.h>
#include <WSCcolorSet.h>
#include <WSCfontSet.h>
#include <WSClocaleSet.h>
#include <btron/WSDbtronAppDev.h>
#include <btron/WSDbtronKeyboard.h>
#include <btron/WSDbtronPrivateTimer.h>
#ifndef TE
#include <btron/WSDbtronExecute.h>
#endif
#include <WSCinitializeManager.h>
#include <WSDmouse.h>
#include <WSDtimer.h>
#include <WSCdevice.h>
#include <btron/WSDbtronSocket.h>
//#include <btron/WSDunixExecute.h>
#include <WSDfile.h>
#include <btron/WSDbtronFormDev.h>
#ifdef TE
#include <btron/errcode.h>
#else
#include <errcode.h>
#endif

WSMFclassInit(WSDbtronAppDev,WSDappDev);

WSDbtronAppDev* WSGIbtronAppDev(){
dbprintf("WSGIbtronAppDev() %s:%d started.\n",__FILE__,__LINE__);
  WSDappDev* appdev = WSGIappDev();
  if (appdev == NULL){
    return NULL;
  }
  WSDbtronAppDev* btronAppdev =(WSDbtronAppDev*)appdev->cast("WSDbtronAppDev");
  return btronAppdev;
}

WSDappDev* _btronAppDev_create_handler(){
dbprintf("_btronAppDev_create_handler %s:%d started.\n",__FILE__,__LINE__);
  return new WSDbtronAppDev();
}

class _btronAppDev_init{
  public: _btronAppDev_init(){
dbprintf("_btronAppDev_init %s:%d started.\n",__FILE__,__LINE__);
    WSDappDev::setCreateInstanceHandler(_btronAppDev_create_handler);
  };
};

_btronAppDev_init _btronAppDev_init_run_constructor;

void WSGFdeviceInitialize(){
dbprintf("WSGFdeviceInitialize.. started..\n");
  static WSCbool initialized = False;
  if (initialized == False){
extern WSDfile* _unix_fp_chandler();
    WSDfile::setCreateInstanceHandler((void*)_unix_fp_chandler);
//extern WSDdragDrop* _xdrag_drop_create_handler_();
//    WSDdragDrop::setCreateHandler(_xdrag_drop_create_handler_);
//extern WSDmessage* _xclient_msg_create();
//    WSDmessage::setCreateHandler(_xclient_msg_create);
extern WSDmouse* _btronMouse_create_handler();
    WSDmouse::setCreateInstanceHandler(_btronMouse_create_handler);
extern WSDprivateTimer* _btronPrivatetimer_create();
    WSDprivateTimer::setCreateInstanceHandler((void*)_btronPrivatetimer_create);
extern WSDsocket* _btronSocket_create_handler();
    WSDsocket::setCreateHandler(_btronSocket_create_handler);
extern WSDtimer* _btronTimer_create_handler();
    WSDtimer::setCreateInstanceHandler(_btronTimer_create_handler);

extern WSDdev* _wsdbtronFormdev_init_();
    WSGIappDevice()->setCreateHandler("formDev",_wsdbtronFormdev_init_);
extern WSDdev* _wsdbtronWindev_init_();
    WSGIappDevice()->setCreateHandler("windowDev",_wsdbtronWindev_init_);
extern WSDdev* _wsdbtronNwdev_init_();
    WSGIappDevice()->setCreateHandler("nwDev",_wsdbtronNwdev_init_);
extern WSDdev* _wsdbtronScrdev_init_();
    WSGIappDevice()->setCreateHandler("scrFrameDev",_wsdbtronScrdev_init_);
extern WSDdev* _wsdbtronmwindev_init_();
    WSGIappDevice()->setCreateHandler("mwindowDev",_wsdbtronmwindev_init_);

extern WSDkeyboard* _btronKeyboard_create_handler();
    WSDkeyboard::setCreateInstanceHandler(_btronKeyboard_create_handler);

    WSDappDev::setCreateInstanceHandler(_btronAppDev_create_handler);
extern WSDcodeConvert* _code_convert_create_handler_();
    WSDcodeConvert::_set_code_convert_handler(_code_convert_create_handler_);
    WSGIappCodeConvert()->initialize();
    initialized = True;
extern void _btronFont_init();
    _btronFont_init();
extern void _btronColor_init();
    _btronColor_init();
extern void _btronImage_init();
    _btronImage_init();
    WSGIappInitializeManager()->execInitializeProcs();
  }
dbprintf("WSGFdeviceInitialize.. done..\n");
}
WSDbtronAppDev::WSDbtronAppDev(){
  _gid = 0; 
  _fgid = 0; 
  _have_color_map = False;
  _color_map = NULL;
}
WSDbtronAppDev::~WSDbtronAppDev(){}

WSCushort WSDbtronAppDev::getWidth(){
//  return (WSCushort)DisplayWidth(display(),DefaultScreen(display()));
  RECT r;
  wget_inf(WI_WORKSIZE,&r,sizeof(r));
dbprintf("WSDbtronAppDev::getWidth()=%d\n",r.c.right - r.c.left);
  return r.c.right - r.c.left;
#if 0
#ifdef TE
  return 240;
#else
  return 1024;
#endif
#endif

}
WSCushort WSDbtronAppDev::getHeight(){
//  return (WSCushort)DisplayHeight(display(),DefaultScreen(display()));
  RECT r;
  wget_inf(WI_WORKSIZE,&r,sizeof(r));
dbprintf("WSDbtronAppDev::getHeight()=%d\n",r.c.bottom - r.c.top);
  return r.c.bottom - r.c.top;
#if 0
#ifdef TE
  return 300;
#else
  return 768;
#endif
#endif
}

long WSDbtronAppDev::getDeviceResource(){
//  return (long)XtDisplay(appWidget());
  return 0;
}

long WSDbtronAppDev::getWindowResource(){
//  return (long)XtWindow(appWidget());
  return 0;
}

long WSDbtronAppDev::getContextResource(){
  return 0;
}

long WSDbtronAppDev::getSpecialResource(){
//  return (long)appWidget();
  return 0;
}

long WSDbtronAppDev::setInitPrm(int iprm,char** cprm){
   _iprm = iprm;
   _cprm = cprm;
   return WS_NO_ERR;
}
long is_own_window(W w){
  WDSTAT wst;
  wget_sts(w,&wst,NULL);
  W pid = prc_sts(0,NULL,NULL);
  if (wst.pid == pid){
    return True;
  }
  return False;
}
long WSDbtronAppDev::loadGuiPolicy(){
#if 0
  WSCstring* envstr = WSGFreadTextFile("$(HOME)/.wsrc");
  if (envstr != NULL){
    while(envstr->eof() == False){
      WSCstring index = envstr->gets();
      WSCstring data = envstr->gets();
      WSCstring data2;
      data2 = data;
      index.delHeadSpace();
      index.delTailSpace();
      index.delLineFeed();
      data.delHeadSpace();
      data.delTailSpace();
      data.delLineFeed();
      if (!strcmp((char*)index,"#POLICY") && strcmp((char*)data,"")){
        long val = atoi((char*)data);
        if (_policy == -1){
          setGuiPolicy(val,False);
        }
      }else
      if (!strcmp((char*)index,"#TOPSHADOWCOLOR") && strcmp((char*)data,"")){
        short cno = WSGIappColorSet()->getColorNo((char*)data);
        WSGIappColorSet()->setDefaultColorNo(WS_DF_TOPSHADOWCOLOR,cno);
      }else
      if (!strcmp((char*)index,"#BOTTOMSHADOWCOLOR") && strcmp((char*)data,"")){
        short cno = WSGIappColorSet()->getColorNo((char*)data);
        WSGIappColorSet()->setDefaultColorNo(WS_DF_BOTTOMSHADOWCOLOR,cno);
      }else
      if (!strcmp((char*)index,"#BACKCOLOR") && strcmp((char*)data,"")){
        short cno = WSGIappColorSet()->getColorNo((char*)data);
        WSGIappColorSet()->setDefaultColorNo(WS_DF_BACKCOLOR,cno);
      }else
      if (!strcmp((char*)index,"#FORECOLOR") && strcmp((char*)data,"")){
        short cno = WSGIappColorSet()->getColorNo((char*)data);
        WSGIappColorSet()->setDefaultColorNo(WS_DF_FORECOLOR,cno);
      }else
      if (!strcmp((char*)index,"#MENUFORECOLOR") && strcmp((char*)data,"")){
        short cno = WSGIappColorSet()->getColorNo((char*)data);
        WSGIappColorSet()->setDefaultColorNo(WS_DF_MENUFORECOLOR,cno);
      }else
      if (!strcmp((char*)index,"#MENUBACKCOLOR") && strcmp((char*)data,"")){
        short cno = WSGIappColorSet()->getColorNo((char*)data);
        WSGIappColorSet()->setDefaultColorNo(WS_DF_MENUBACKCOLOR,cno);
      }else
      if (!strcmp((char*)index,"#MENUSELECTCOLOR") && strcmp((char*)data,"")){
        short cno = WSGIappColorSet()->getColorNo((char*)data);
        WSGIappColorSet()->setDefaultColorNo(WS_DF_MENUSELECTCOLOR,cno);
      }else
      if (!strcmp((char*)index,"#MENUTOPSHADOWCOLOR") && strcmp((char*)data,"")){
        short cno = WSGIappColorSet()->getColorNo((char*)data);
        WSGIappColorSet()->setDefaultColorNo(WS_DF_MENUTOPSHADOWCOLOR,cno);
      }else
      if (!strcmp((char*)index,"#MENUBOTTOMSHADOWCOLOR") && strcmp((char*)data,"")){
        short cno = WSGIappColorSet()->getColorNo((char*)data);
        WSGIappColorSet()->setDefaultColorNo(WS_DF_MENUBOTTOMSHADOWCOLOR,cno);
      }else
      if (!strcmp((char*)index,"#WORKBACKCOLOR") && strcmp((char*)data,"")){
        short cno = WSGIappColorSet()->getColorNo((char*)data);
        WSGIappColorSet()->setDefaultColorNo(WS_DF_WORKBACKCOLOR,cno);
      }else
      if (!strcmp((char*)index,"#DARKBACKCOLOR") && strcmp((char*)data,"")){
        short cno = WSGIappColorSet()->getColorNo((char*)data);
        WSGIappColorSet()->setDefaultColorNo(WS_DF_DARKBACKCOLOR,cno);
      }else
      if (!strcmp((char*)index,"#BARSHADOWCOLOR") && strcmp((char*)data,"")){
        short cno = WSGIappColorSet()->getColorNo((char*)data);
        WSGIappColorSet()->setDefaultColorNo(WS_DF_BARSHADOWCOLOR,cno);
      }else
      if (!strcmp((char*)index,"#NWTOPSHADOWCOLOR") && strcmp((char*)data,"")){
        short cno = WSGIappColorSet()->getColorNo((char*)data);
        WSGIappColorSet()->setDefaultColorNo(WS_DF_NWTOPSHADOWCOLOR,cno);
      }else
      if (!strcmp((char*)index,"#NWBOTTOMSHADOWCOLOR") && strcmp((char*)data,"")){
        short cno = WSGIappColorSet()->getColorNo((char*)data);
        WSGIappColorSet()->setDefaultColorNo(WS_DF_NWBOTTOMSHADOWCOLOR,cno);
      }else
      if (!strcmp((char*)index,"#NWBACKCOLOR") && strcmp((char*)data,"")){
        short cno = WSGIappColorSet()->getColorNo((char*)data);
        WSGIappColorSet()->setDefaultColorNo(WS_DF_NWBACKCOLOR,cno);
      }else
      if (!strcmp((char*)index,"#NWFORECOLOR") && strcmp((char*)data,"")){
        short cno = WSGIappColorSet()->getColorNo((char*)data);
        WSGIappColorSet()->setDefaultColorNo(WS_DF_NWFORECOLOR,cno);
      }else
      if (!strcmp((char*)index,"#DARKBOTTOMSHADOWCOLOR") && strcmp((char*)data,"")){
        short cno = WSGIappColorSet()->getColorNo((char*)data);
        WSGIappColorSet()->setDefaultColorNo(WS_DF_DARKBOTTOMSHADOWCOLOR,cno);
      }else
      if (!strcmp((char*)index,"#MENUSELECTFORECOLOR") && strcmp((char*)data,"")){
        short cno = WSGIappColorSet()->getColorNo((char*)data);
        WSGIappColorSet()->setDefaultColorNo(WS_DF_MENUSELECTFORECOLOR,cno);
      }else
      if (!strcmp((char*)index,"#AQUAFORECOLOR") && strcmp((char*)data,"")){
        short cno = WSGIappColorSet()->getColorNo((char*)data);
        WSGIappColorSet()->setDefaultColorNo(WS_DF_AQUAFORECOLOR,cno);
      }else
      if (!strcmp((char*)index,"#AQUAHIGHLIGHTCOLOR") && strcmp((char*)data,"")){
        short cno = WSGIappColorSet()->getColorNo((char*)data);
        WSGIappColorSet()->setDefaultColorNo(WS_DF_AQUAHIGHLIGHTCOLOR,cno);
      }else
      if (!strcmp((char*)index,"#DEFAULTFONT") && strcmp((char*)data2,"")){
        WSDfont* font = WSGIappFontSet()->getFont(8);
        font->setFontName(data2);
      }
    }
    if (_policy == -1){
      _policy = WS_POLICY_WINDOWS;
    }
    delete envstr;
    return WS_NO_ERR;
  }
#endif
  return WS_ERR;
}
long WSDbtronAppDev::saveGuiPolicy(){
  WSCstring str;
  str << "#POLICY\n";
  str << getGuiPolicy() << "\n";
  str << "#TOPSHADOWCOLOR\n";
  str << WSGIappColorSet()->getColor(WS_DF_TOPSHADOWCOLOR)->getSrc() << "\n";
  str << "#BOTTOMSHADOWCOLOR\n";
  str << WSGIappColorSet()->getColor(WS_DF_BOTTOMSHADOWCOLOR)->getSrc() << "\n";
  str << "#BACKCOLOR\n";
  str << WSGIappColorSet()->getColor(WS_DF_BACKCOLOR)->getSrc() << "\n";
  str << "#FORECOLOR\n";
  str << WSGIappColorSet()->getColor(WS_DF_FORECOLOR)->getSrc() << "\n";
  str << "#MENUFORECOLOR\n";
  str << WSGIappColorSet()->getColor(WS_DF_MENUFORECOLOR)->getSrc() << "\n";
  str << "#MENUBACKCOLOR\n";
  str << WSGIappColorSet()->getColor(WS_DF_MENUBACKCOLOR)->getSrc() << "\n";
  str << "#MENUSELECTCOLOR\n";
  str << WSGIappColorSet()->getColor(WS_DF_MENUSELECTCOLOR)->getSrc() << "\n";
  str << "#MENUSELECTFORECOLOR\n";
  str << WSGIappColorSet()->getColor(WS_DF_MENUSELECTFORECOLOR)->getSrc() << "\n";
  str << "#MENUTOPSHADOWCOLOR\n";
  str << WSGIappColorSet()->getColor(WS_DF_MENUTOPSHADOWCOLOR)->getSrc() << "\n";
  str << "#MENUBOTTOMSHADOWCOLOR\n";
  str << WSGIappColorSet()->getColor(WS_DF_MENUBOTTOMSHADOWCOLOR)->getSrc() << "\n";
  str << "#WORKBACKCOLOR\n";
  str << WSGIappColorSet()->getColor(WS_DF_WORKBACKCOLOR)->getSrc() << "\n";
  str << "#DARKBACKCOLOR\n";
  str << WSGIappColorSet()->getColor(WS_DF_DARKBACKCOLOR)->getSrc() << "\n";
  str << "#BARSHADOWCOLOR\n";
  str << WSGIappColorSet()->getColor(WS_DF_BARSHADOWCOLOR)->getSrc() << "\n";
  str << "#NWTOPSHADOWCOLOR\n";
  str << WSGIappColorSet()->getColor(WS_DF_NWTOPSHADOWCOLOR)->getSrc() << "\n";
  str << "#NWBOTTOMSHADOWCOLOR\n";
  str << WSGIappColorSet()->getColor(WS_DF_NWBOTTOMSHADOWCOLOR)->getSrc() << "\n";
  str << "#NWBACKCOLOR\n";
  str << WSGIappColorSet()->getColor(WS_DF_NWBACKCOLOR)->getSrc() << "\n";
  str << "#NWFORECOLOR\n";
  str << WSGIappColorSet()->getColor(WS_DF_NWFORECOLOR)->getSrc() << "\n";
  str << "#DARKBOTTOMSHADOWCOLOR\n";
  str << WSGIappColorSet()->getColor(WS_DF_DARKBOTTOMSHADOWCOLOR)->getSrc() << "\n";
  str << "#AQUAHIGHLIGHTCOLOR\n";
  str << WSGIappColorSet()->getColor(WS_DF_AQUAHIGHLIGHTCOLOR)->getSrc() << "\n";
  str << "#AQUAFORECOLOR\n";
  str << WSGIappColorSet()->getColor(WS_DF_AQUAFORECOLOR)->getSrc() << "\n";
  str << "#DEFAULTFONT\n";
  str << WSGIappFontSet()->getDefaultFont()->getFontName() << "\n";

  return WSGFreplaceTextFile("$(HOME)/.wsrc",str,False);
}

long WSDbtronAppDev::initialize(){
  WSDappDev::initialize();


  short cno;

  cno = WSGIappColorSet()->getColorNo("gray85");
  WSGIappColorSet()->setDefaultColorNo(WS_DF_BACKCOLOR,cno);

  cno = WSGIappColorSet()->getColorNo("black");
  WSGIappColorSet()->setDefaultColorNo(WS_DF_FORECOLOR,cno);

  cno = WSGIappColorSet()->getColorNo("gray95");
  WSGIappColorSet()->setDefaultColorNo(WS_DF_TOPSHADOWCOLOR,cno);

  cno = WSGIappColorSet()->getColorNo("gray55");
  WSGIappColorSet()->setDefaultColorNo(WS_DF_BOTTOMSHADOWCOLOR,cno);

  cno = WSGIappColorSet()->getColorNo("black");
  WSGIappColorSet()->setDefaultColorNo(WS_DF_MENUFORECOLOR,cno);

  cno = WSGIappColorSet()->getColorNo("white");
  WSGIappColorSet()->setDefaultColorNo(WS_DF_MENUSELECTFORECOLOR,cno);

  cno = WSGIappColorSet()->getColorNo("gray80");
  WSGIappColorSet()->setDefaultColorNo(WS_DF_MENUBACKCOLOR,cno);

  cno = WSGIappColorSet()->getColorNo("slategray4");
  WSGIappColorSet()->setDefaultColorNo(WS_DF_MENUSELECTCOLOR,cno);


  cno = WSGIappColorSet()->getColorNo("gray95");
  WSGIappColorSet()->setDefaultColorNo(WS_DF_MENUTOPSHADOWCOLOR,cno);

  cno = WSGIappColorSet()->getColorNo("gray55");
  WSGIappColorSet()->setDefaultColorNo(WS_DF_MENUBOTTOMSHADOWCOLOR,cno);

  cno = WSGIappColorSet()->getColorNo("gray80");
  WSGIappColorSet()->setDefaultColorNo(WS_DF_DARKBACKCOLOR,cno);

  cno = WSGIappColorSet()->getColorNo("white");
  WSGIappColorSet()->setDefaultColorNo(WS_DF_WORKBACKCOLOR,cno);

  cno = WSGIappColorSet()->getColorNo("gray80");
  WSGIappColorSet()->setDefaultColorNo(WS_DF_BARSHADOWCOLOR,cno);

  cno = WSGIappColorSet()->getColorNo("gray85");
  WSGIappColorSet()->setDefaultColorNo(WS_DF_NWBACKCOLOR,cno);

  cno = WSGIappColorSet()->getColorNo("black");
  WSGIappColorSet()->setDefaultColorNo(WS_DF_NWFORECOLOR,cno);
  WSGIappColorSet()->setDefaultColorNo(WS_DF_DARKBOTTOMSHADOWCOLOR,cno);

  cno = WSGIappColorSet()->getColorNo("gray95");
  WSGIappColorSet()->setDefaultColorNo(WS_DF_NWTOPSHADOWCOLOR,cno);

  cno = WSGIappColorSet()->getColorNo("gray55");
  WSGIappColorSet()->setDefaultColorNo(WS_DF_NWBOTTOMSHADOWCOLOR,cno);

  cno = WSGIappColorSet()->getColorNo("#e0e0ff");
  WSGIappColorSet()->setDefaultColorNo(WS_DF_AQUAFORECOLOR,cno);

  cno = WSGIappColorSet()->getColorNo("#d0d0ff");
  WSGIappColorSet()->setDefaultColorNo(WS_DF_AQUAHIGHLIGHTCOLOR,cno);

  loadGuiPolicy();

  return WS_NO_ERR;
}

long WSDbtronAppDev::handleEvents(){
  WSGIappDevice()->clearDeleteList();
  WSGIappObjectList()->execUpdate();

  while(1){
dbprintf("WSDbtronAppDev::handleEvents start dispatchEvent().   XXXXXXXX\n");
    dispatchEvent();
dbprintf("WSDbtronAppDev::handleEvents start clearDeleteList(). XXXXXXXX\n");
    WSGIappDevice()->clearDeleteList();
  }
  return WS_NO_ERR;
}
long WSDbtronAppDev::dispatchEvent(){
  return _dispatchEvent(True);
}
long WSDbtronAppDev::processEvent(){
  return _dispatchEvent(False);
}

EXPORT  PAT     windpat =       /* ɥطʥѥ*/
            {{0, 16, 16, 0x10888888, 0x10888888, FILL100}};
//            {{0, 16, 16, 0x10FFFFFF, 0x10FFFFFF, FILL100}};
//            {{0, 16, 16, 0x10000000, 0x10000000, FILL100}};
void _exec_resize(W window,RECT* r){
  WSDbtronFormDev* dev;
  if (is_own_window(window) == False){
    return;
  }
  W ret = wget_dat(window,(W*)&dev);
  if (ret != 0){
dbprintf("_resize(W=0x%x) is invalid.\n",window);
    return;
  }

  if (dev == NULL){
dbprintf("_resize(W=0x%x) has no instance.\n",window);
    return;
  }
  dev->_evh_resize(r);
} 
void _destroy_evt(W window,WEVENT* ev){
  if (is_own_window(window) == False){
    return;
  }
  WSDbtronFormDev* dev;
  W ret = wget_dat(window,(W*)&dev);
  if (ret != 0){
dbprintf("_btn_press(W=0x%x) is invalid.\n",window);
    return;
  }
  if (dev == NULL){
dbprintf("_btn_press(W=0x%x) has no instance.\n",window);
    return;
  }
  dev->_evh_destroy(ev);
}

void _expose(W window){
  if (is_own_window(window) == False){
    return;
  }
  WSDbtronFormDev* dev;
  W ret = wget_dat(window,(W*)&dev);
  if (ret != 0){
dbprintf("_expose(W=0x%x) is invalid.\n",window);
    return;
  }

  if (dev == NULL){
dbprintf("_expose(W=0x%x) has no instance.\n",window);
    return;
  }
  RECT r;
  do {
    RLIST rlist[N_VIEWR];
    long i;
    for(i=0; i<N_VIEWR-1;i++){
      rlist[i].next = &rlist[i+1];
    }
    rlist[N_VIEWR-1].next = NULL;

    dev->clearClipList();
    W nr2 = gget_for(dev->getParentGID(), dev->getClipList());
    W nr  = wsta_dsp(window, &r,rlist);

    if (nr <= 0){
      break;
    }
    dev->setClipNum(nr2);

    if (nr > N_VIEWR){
dbprintf("need expose %d,%d,%d,%d .. wnd=0x%x\n",r.c.left,r.c.top,r.c.right-r.c.left,r.c.bottom - r.c.top,window);
      dev->_evh_expose(&r);
    }else{
      long i;
      for(i=0; i<nr; i++){
        RECT rc = rlist[i].rcomp;
dbprintf("need expose2 %d,%d,%d,%d .. wnd=0x%x 0x%x\n",rc.c.left,rc.c.top,rc.c.right-rc.c.left,rc.c.bottom - rc.c.top,window,dev->getContextResource());
        if (rc.c.left == rc.c.right ||rc.c.top == rc.c.bottom ){
          dev->_evh_expose(&r);
        }else{
          dev->_evh_expose(&rlist[i].rcomp);
        }
      }
    }
  }while (wend_dsp(window) > 0);
}
//static WSDbtronFormDev* grab_dev = NULL;
void _btn_press(W window,WEVENT* ev){
  if (is_own_window(window) == False){
    return;
  }
  WSDbtronFormDev* dev;
  W ret = wget_dat(window,(W*)&dev);
  if (ret != 0){
dbprintf("_btn_press(W=0x%x) is invalid.\n",window);
    return;
  }
  if (dev != NULL){
    dev = dev->getChildWithPoint(ev->e.pos.x,ev->e.pos.y);
  }
  if (dev == NULL){
dbprintf("_btn_press(W=0x%x) has no instance.\n",window);
    return;
  }
//  grab_dev = dev;
  dev->_evh_btn_press(ev);
}
void _btn_press_abst(W window,WEVENT* ev){
  if (is_own_window(window) == False){
    return;
  }
  WSDbtronFormDev* dev;
  W ret = wget_dat(window,(W*)&dev);
  if (ret != 0){
dbprintf("_btn_press(W=0x%x) is invalid.\n",window);
    return;
  }
  if (dev != NULL){
    PNT pt;
    pt.x = ev->e.pos.x;
    pt.y = ev->e.pos.y;
    if (ev->s.type == EV_MENU){
      gcnv_rel(dev->getParentGID(),&pt);
    }

    dev = dev->getChildWithPoint(pt.x,pt.y);
  }
  if (dev == NULL){
dbprintf("_btn_press(W=0x%x) has no instance.\n",window);
    return;
  }
//  grab_dev = dev;
  dev->_evh_btn_press(ev);
}

void _btn_release(W window,WEVENT* ev){
  WSDbtronFormDev* dev = NULL;
  WSDbtronFormDev* tdev = WSGIbtronAppDev()->getBtnPressGrabTarget();
  if (tdev == NULL ||
      WSDbtronFormDev::isValidInstance(tdev) == False){
    WSGIbtronAppDev()->setBtnPressGrabTarget(NULL);
    if (is_own_window(window) == False){
      return;
    }
    W ret = wget_dat(window,(W*)&dev);
    if (ret != 0){
dbprintf("_btn_release(W=0x%x) is invalid.\n",window);
      return;
    }
    if (dev != NULL){
      dev = dev->getChildWithPoint(ev->e.pos.x,ev->e.pos.y);
    }
    if (dev == NULL){
dbprintf("_btn_release(W=0x%x) has no instance.\n",window);
      return;
    }
  }else{
    dev = tdev;
  } 
dbprintf("_evh_release(W=0x%x) start.\n",window);
  dev->_evh_btn_release(ev);
#if 0
  long state = WSGIappMouse()->getStatus();
  if ((state & WS_MOUSE_BTN1) == 0 &&
      (state & WS_MOUSE_BTN2) == 0 &&
      (state & WS_MOUSE_BTN3) == 0 ){
    grab_dev = NULL;
  }
dbprintf("_evh_release(W=0x%x) done.status=0x%x btn_target=0x%x\n",window,state,WSGIbtronAppDev()->getBtnPressGrabTarget());
#endif

}
void _btn_release_abst(W window,WEVENT* ev){
  WSDbtronFormDev* dev = NULL;
  WSDbtronFormDev* tdev = WSGIbtronAppDev()->getBtnPressGrabTarget();
  if (tdev == NULL ||
      WSDbtronFormDev::isValidInstance(tdev) == False){
    WSGIbtronAppDev()->setBtnPressGrabTarget(NULL);
    if (is_own_window(window) == False){
      return;
    }
    W ret = wget_dat(window,(W*)&dev);
    if (ret != 0){
dbprintf("_btn_release_abst(W=0x%x) is invalid.\n",window);
      return;
    }
    if (dev != NULL){
      PNT pt;
      pt.x = ev->e.pos.x;
      pt.y = ev->e.pos.y;
      if (ev->s.type == EV_MENU){
        gcnv_rel(dev->getParentGID(),&pt);
      }
      dev = dev->getChildWithPoint(pt.x,pt.y);
    }
    if (dev == NULL){
dbprintf("_btn_release_abst(W=0x%x) has no instance.\n",window);
      return;
    }
  }else{
    dev = tdev;
  } 
dbprintf("_evh_release_abst(W=0x%x) start.\n",window);
  dev->_evh_btn_release(ev);
#if 0
  long state = WSGIappMouse()->getStatus();
  if ((state & WS_MOUSE_BTN1) == 0 &&
      (state & WS_MOUSE_BTN2) == 0 &&
      (state & WS_MOUSE_BTN3) == 0 ){
    grab_dev = NULL;
  }
dbprintf("_evh_release_abst(W=0x%x) done.status=0x%x btn_target=0x%x\n",window,state,WSGIbtronAppDev()->getBtnPressGrabTarget());
#endif
}

static WSDbtronFormDev* _mouse_target = NULL;
static WSDbtronFormDev* _mouse_grab_target = NULL;
static WSDbtronFormDev* _mouse_btn_grab_target = NULL;
static WSCbool _mouse_grabbed = False;
static WSCbool _mouse_btn_grabbed = False;

WSDbtronFormDev* WSDbtronAppDev::getGrabTarget(){
  if (_mouse_grabbed != False){
    return _mouse_grab_target;
  }
  return NULL;
}
WSDbtronFormDev* WSDbtronAppDev::getBtnPressGrabTarget(){
  if (_mouse_btn_grabbed != False){
    return _mouse_btn_grab_target;
  }
  return NULL;
}
void WSDbtronAppDev::setGrabTarget(WSDbtronFormDev* dev){
  if (dev == NULL){
    _mouse_grabbed = False;
    _mouse_grab_target = NULL;
    return;
  }
  _mouse_grab_target = dev;
  _mouse_grabbed = True;
}
WSCbool WSDbtronAppDev::getMouseGrabbed(){
  if ( _mouse_grabbed != False ||
       _mouse_btn_grabbed != False){
    return True;
  }
  return False;
}
void WSDbtronAppDev::setBtnPressGrabTarget(WSDbtronFormDev* dev){
  if (dev == NULL){
    _mouse_btn_grabbed = False;
    _mouse_btn_grab_target = NULL;
    return;
  }
  _mouse_btn_grab_target = dev;
  _mouse_btn_grabbed = True;
}
void recvmsg(){
  char buffer[128];
  MESSAGE* msg = (MESSAGE*)buffer;
  W ret = rcv_msg(MM_TYPE2|MM_TYPE1,msg,sizeof(W)*4,NOWAIT);
#ifndef TE
  _read_event_send_type data;
  if (ret <0){
     ret = rcv_msg(MM_TYPE3,msg,sizeof(MESSAGE)+ sizeof(_read_event_send_type)-sizeof(void*),NOWAIT);
  }
#endif
  if (ret <0){
  }else if (msg->msg_type == MS_TYPE1){ 
    _accept_send_type* data = NULL;
    memcpy(&data,msg->msg_body.ANYMSG.msg_str,sizeof(data));
    void(*hd)(WSDsocket*,void*,WSCulong) = data->hd;
    if (hd != NULL){
      hd(data->sock,(void*)data->socket,data->addr);
    }
dbprintf("WSDxappDev::_dispatchEvent %s:%d APPL5x done\n",__FILE__,__LINE__);
    delete data;
  }else if (msg->msg_type == MS_TYPE2){ 
dbprintf("WSDxappDev::_dispatchEvent %s:%d APPL5x start\n",__FILE__,__LINE__);
    WSDbtronPrivateTimer* timer = NULL;
    W tid = 0;
    memcpy(&timer,msg->msg_body.ANYMSG.msg_str,sizeof(W));
    memcpy(&tid,&msg->msg_body.ANYMSG.msg_str[sizeof(W)],sizeof(W));
    if (WSDbtronPrivateTimer::isValid(timer)){
      timer->_timer_callback(tid);
    }
dbprintf("WSDxappDev::_dispatchEvent %s:%d APPL5x2 done\n",__FILE__,__LINE__);
  }else if (msg->msg_type == MS_TYPE3){ 
#ifndef TE
dbprintf("WSDxappDev::_dispatchEvent %s:%d APPL5x2 start\n",__FILE__,__LINE__);
printf("recvmsg.. type=3\n");
    memcpy(&data,msg->msg_body.ANYMSG.msg_str,sizeof(data));
    WSDbtronExecute* obj = data.obj;
printf("this=0x%x id=%d,%d sizeof(data)=%D\n",obj,obj->getId(),data.id,sizeof(data));
    if (obj->getId() == data.id){
printf("this=0x%x\n",obj);
      WSDbtronExecute::_callback(obj);
    }
dbprintf("WSDxappDev::_dispatchEvent %s:%d APPL5x2 done\n",__FILE__,__LINE__);
#endif
  }
}

long WSDbtronAppDev::_dispatchEvent(WSCbool wait){
  WEVENT ev;
  W w = WAIT;
  if (wait == False){
    w = NOWAIT;
  }
  if (_mouse_grabbed == True || _mouse_btn_grabbed == True){
    W ret = wget_evt(&ev,NOWAIT | DSPEVT);
    if (ret != EV_NOMSG){
      switch(ev.r.cmd){
        case W_REDISP:{
            _expose(ev.s.wid);
          break;
        }
        case W_PASTE:{
          break;
        }
        case W_FINISH:{
          break;
        }
        case W_DELETE:{
          break;
        }
      }
    }
    recvmsg();
  }
  if (_mouse_grabbed == True){
//    w |= (NOMSG | RAWEVT | DRGEVT);
    w |= DRGEVT;
  }
  if (_mouse_btn_grabbed == True){
//    w |= (NOMSG | RAWEVT | DRGEVT);
    w |= DRGEVT;
  }

  W ret = wget_evt(&ev,w);
  W ty;

//if (ret != EV_NULL) dbprintf("EV=0x%x\n",ret);
//printf("EV=%d.. key=0x%x code=0x%x status=0x%x\n",ret,ev.s.cmd,ev.s.wid,ev.s.stat);
//printf("mask=0x%x\n",chg_emk(-1));
//printf("EV=%d.. key=0x%x code=0x%x status=0x%x mask=0x%x\n",ret,ev.s.cmd,ev.s.wid,ev.s.stat,chg_emk(-1));

  switch(ret){
    case EV_APPL4:{
      break;
    }
    case EV_APPL5:{
      break;
    }
    case EV_NOMSG:{
dbprintf("EV_NOMSG.. wnd=0x%x\n",ev.s.wid);
      break;
    }
    case EV_MSG:{
dbprintf("EV_MSG.. wnd=0x%x\n",ev.s.wid);
      recvmsg();
      return WS_NO_ERR;
    }
    case EV_MENU:{

dbprintf("EV_MENU.. wnd=0x%x\n",ev.s.wid);
dbprintf("EV_MENU.. wnd=0x%x %d pos=%d,%d\n",ev.s.wid,ev.s.cmd,ev.e.pos.x,ev.e.pos.y);
dbprintf("EV_MENU.. stat=0x%x\n",ev.s.stat);
//if (ev.s.stat & ES_BUT) dbprintf("EV_MENU.. btn1\n");
//if (ev.s.stat & ES_BUT2) dbprintf("EV_MENU.. btn2\n");

          _btn_press_abst(ev.s.wid,&ev);
      break;
    }
    case EV_REQUEST:{
dbprintf("EV_REQUEST.. wnd=0x%x\n",ev.s.wid);
      switch(ev.r.cmd){
        case W_REDISP:{
dbprintf("W_REDISP.. wnd=0x%x src=%d\n",ev.s.wid,ev.r.src);
          _expose(ev.s.wid);
          break;
        }
        case W_PASTE:{
dbprintf("W_PASTE.. wnd=0x%x\n",ev.s.wid);
          break;
        }
        case W_FINISH:{
dbprintf("W_FINISH.. wnd=0x%x\n",ev.s.wid);
          break;
        }
        case W_DELETE:{
dbprintf("W_DELETE.. wnd=0x%x\n",ev.s.wid);
          break;
        }
      }
      break;
    }
    case EV_INACT:{
dbprintf("EV_INACT.. wnd=0x%x\n",ev.s.wid);
      break;
    }
    case EV_RSWITCH:{
dbprintf("EV_RSWITCH.. wnd=0x%x\n",ev.s.wid);
      _expose(ev.s.wid);
      break;
    }
    case EV_SWITCH:{
dbprintf("EV_SWITCH.. wnd=0x%x\n",ev.s.wid);
      _expose(ev.s.wid);
      break;
    }
    case EV_BUTDWN:{
dbprintf("EV_BUTDWN.. wnd=0x%x %d pos=%d,%d\n",ev.s.wid,ev.s.cmd,ev.e.pos.x,ev.e.pos.y);
dbprintf("EV_BUTDWN.. stat=0x%x\n",ev.s.stat);
//if (ev.s.stat & ES_BUT) dbprintf("EV_BUTDWN.. btn1\n");
//if (ev.s.stat & ES_BUT2) dbprintf("EV_BUTDWN.. btn2\n");

      switch(ev.s.cmd){
        case W_WORK:{
dbprintf("W_WORK.. wnd=0x%x\n",ev.s.wid);
          _btn_press(ev.s.wid,&ev);
          break;
        }
        case W_LTHD:
        case W_LBHD:
        case W_RTHD:
        case W_RBHD:{
dbprintf("HD=%d.. wnd=0x%x\n",ev.s.cmd,ev.s.wid);
          if ((ty = wchk_dck(ev.s.time)) == W_DCLICK){
            RECT rect;
            W mode = wchg_wnd(ev.s.wid,&rect,W_MOVE);
            if (mode == W_FULL){
dbprintf("mode=W_FULL.. need redisp..\n");
            }
          }else if (ty == W_PRESS || ty == W_QPRESS){
            RECT rect;
            if (wrsz_drg(&ev,NULL,&rect) || 
                ev.s.cmd == W_LTHD ||
                ev.s.cmd == W_LBHD ||
                ev.s.cmd == W_RTHD ){

dbprintf("mode=W_FULL.. need redisp2..\n");
//printf("EE> moe=W_FULL.. need redisp2.. %d,%d,%d,%d 0x%x\n",rect.c.left,rect.c.top,rect.c.right - rect.c.left,rect.c.bottom - rect.c.top,wget_gid(ev.s.wid));
//              wget_wrk(ev.s.wid,&rect);
              RECT r2;
              wget_wrk(ev.s.wid,&r2);
//printf("EE> moe=W_FULL.. need redisp2.. work=%d,%d,%d,%d 0x%x\n",r2.c.left,r2.c.top,r2.c.right - r2.c.left,r2.c.bottom - r2.c.top,wget_gid(ev.s.wid));
              wscr_wnd(ev.s.wid,&r2,r2.c.left,r2.c.top,W_SCRL | W_RDSET);
              wget_wrk(ev.s.wid,&r2);
//printf("EE> moe=W_FULL.. need redisp2.. work2=%d,%d,%d,%d 0x%x\n",r2.c.left,r2.c.top,r2.c.right - r2.c.left,r2.c.bottom - r2.c.top,wget_gid(ev.s.wid));
              gset_vis(ev.s.wid,r2);
              _exec_resize(ev.s.wid,&r2);
              _expose(ev.s.wid);
            }else{
              _exec_resize(ev.s.wid,&rect);
            }
          }else{
            RECT rect;
            wget_wrk(ev.s.wid,&rect);
            _exec_resize(ev.s.wid,&rect);
            _expose(ev.s.wid);
          }
          break;
        }
        case W_PICT:{
dbprintf("mode=W_PICT.. need close..\n");
          if ((ty = wchk_dck(ev.s.time)) == W_DCLICK){
            _destroy_evt(ev.s.wid,&ev);
          }
          break;
        }
        case W_TITL:
        case W_FRAM:{
dbprintf("W_TITL/W_PICT.. move..\n");
          RECT rect;
          W ret = wmov_drg(&ev,&rect);
          if (ret){
            wget_wrk(ev.s.wid,&rect);
            _exec_resize(ev.s.wid,&rect);
            _expose(ev.s.wid);
dbprintf("W_TITL/W_PICT.. need expose..\n");
          }else{
            _exec_resize(ev.s.wid,&rect);
          }

          break;
        }
        case W_CLOSED:{
dbprintf("need close child window..\n");
          break;
        }
        default:
dbprintf("default.. wnd=0x%x\n",ev.s.wid);
        break;
      }
 
      break;
    }
    case EV_KEYDWN:
//printf("EV_KEYDWN.. key=0x%x code=0x%x status=0x%x\n",ev.s.cmd,ev.s.wid,ev.s.stat);
      WSGIbtronKeyboard()->deliverKeyEvent(&ev,True);
      chg_emk(EM_ALL);
      break;
    case EV_KEYUP:
//printf("EV_KEYUP.. key=0x%x code=0x%x status=0x%x\n",ev.s.cmd,ev.s.wid,ev.s.stat);
      WSGIbtronKeyboard()->deliverKeyEvent(&ev,False);
      chg_emk(EM_ALL & ~EM_KEYUP);
      break;
    case EV_AUTKEY:{
//printf("EV_KEY%d.. key=0x%x code=0x%x status=0x%x\n",ev.s.type,ev.s.cmd,ev.s.wid,ev.s.stat);
      WSGIbtronKeyboard()->deliverKeyEvent(&ev,True);
//      if (ev.s.type == EV_AUTKEY){
//        WSGIbtronKeyboard()->deliverKeyEvent(&ev,False);
//      }
      break;
    }
    case EV_BUTUP:{
dbprintf("EV_BUTUP.. wnd=0x%x\n",ev.s.wid);
      WSDbtronFormDev* mouse_target = _mouse_target;
      if (_mouse_btn_grab_target != NULL){
        mouse_target = _mouse_btn_grab_target;
//printf("EV_BUTUP.. mouse_btn_grab_target! wnd=0x%x\n",mouse_target);
      }
      if (_mouse_grab_target != NULL){
        mouse_target = _mouse_grab_target;
//printf("EV_BUTUP.. mouse_grab_target! wnd=0x%x\n",mouse_target);
      }
      if (mouse_target != NULL &&
          WSDbtronFormDev::isValidInstance(mouse_target) == False){
        mouse_target = NULL;
//printf("EV_BUTUP.. mouse_target=NULL! wnd=0x%x\n",mouse_target);
      }
      if (mouse_target != NULL){
        mouse_target->_evh_btn_release(&ev);
#if 0
        long state = WSGIappMouse()->getStatus();
        if ((state & WS_MOUSE_BTN1) == 0 &&
          (state & WS_MOUSE_BTN2) == 0 &&
          (state & WS_MOUSE_BTN3) == 0 ){
          grab_dev = NULL;
        }
#endif
      }else{
        _btn_release(ev.s.wid,&ev);
      }
      break;
    }
    case EV_NULL:{
//dbprintf("EV_NULL.. wnd=0x%x\n",ev.s.wid);
//dbprintf("EV_NULL.. wnd=0x%x\n",ev.s.wid);
static W posx = -1;
static W posy = -1;
      WSDbtronFormDev* mouse_target = NULL;
      if (_mouse_btn_grab_target != NULL){
        mouse_target = _mouse_btn_grab_target;
      }
      if (_mouse_grab_target != NULL){
        mouse_target = _mouse_grab_target;
      }
      if (mouse_target != NULL &&
          WSDbtronFormDev::isValidInstance(mouse_target) == False){
        mouse_target = NULL;
      }
      if (mouse_target != NULL ){
        if (posx != ev.e.pos.x || posy != ev.e.pos.y ){
          int dptx = ev.e.pos.x;
          int dpty = ev.e.pos.y;
          posx = dptx;
          posy = dpty;
          mouse_target->_evh_mouse_move(&ev);
        }
        long state = WSGIappMouse()->getStatus();
        if ( ((ev.s.stat & ES_BUT2) == 0) &&
            (state & WS_MOUSE_BTN3) ){
          state &= ~WS_MOUSE_BTN3;
          WSGIappMouse()->setTargetBtn(WS_MOUSE_BTN3);
          WSGIappMouse()->setStatus(state);
          _btn_release_abst(ev.s.wid,&ev);
        }else
        if ( ((ev.s.stat & ES_BUT) == 0) &&
            (state & WS_MOUSE_BTN1) ){
          state &= ~WS_MOUSE_BTN1;
          WSGIappMouse()->setTargetBtn(WS_MOUSE_BTN1);
          WSGIappMouse()->setStatus(state);
          _btn_release_abst(ev.s.wid,&ev);
        }
        break;
//        return WS_NO_ERR;
      }

      if (_mouse_target != NULL &&
        WSDbtronFormDev::isValidInstance(_mouse_target) == False){
        _mouse_target = NULL;
      }

      WSDbtronFormDev* dev = NULL;
      W ret = wget_dat(ev.s.wid,(W*)&dev);
      if (is_own_window(ev.s.wid) == False){
        dev = NULL;
      }
      if (ret != 0){
        if (_mouse_target != NULL){
          _mouse_target->_evh_mouse_out();
        }
        _mouse_target = NULL;
        break;
//        return WS_NO_ERR;
      }
      if (dev != NULL &&
        WSDbtronFormDev::isValidInstance(dev) == False){
        dev = NULL;
      }
      if (dev != NULL){
        dev = dev->getChildWithPoint(ev.e.pos.x,ev.e.pos.y);
      }
      if (dev == NULL ||
          WSDbtronFormDev::isValidInstance(dev) == False){
        if (_mouse_target != NULL){
          _mouse_target->_evh_mouse_out();
        }
        _mouse_target = NULL;
        break;
//        return WS_NO_ERR;
      }

//printf("EV_NULL mouse here1.. mouse_target=0x%x\n",_mouse_target);
      if (_mouse_target != NULL && _mouse_target != dev){
        _mouse_target->_evh_mouse_out();
        _mouse_target = NULL;
      }
      if (_mouse_target == NULL){
        _mouse_target = dev;
        _mouse_target->_evh_mouse_in(ev.e.pos.x,ev.e.pos.y);
      }
      long state = WSGIappMouse()->getStatus();
      if ( ((ev.s.stat & ES_BUT2) == 0) &&
          (state & WS_MOUSE_BTN3) ){
        state &= ~WS_MOUSE_BTN3;
        WSGIappMouse()->setTargetBtn(WS_MOUSE_BTN3);
        WSGIappMouse()->setStatus(state);
dbprintf("EV_NULL mouse release btn2.. wnd=0x%x %d pos=%d,%d\n",ev.s.wid,ev.s.cmd,ev.e.pos.x,ev.e.pos.y);
        mouse_target->_evh_btn_release(&ev);
//        _btn_release(ev.s.wid,&ev);
      }else{
        if (posx != ev.e.pos.x || posy != ev.e.pos.y ){
dbprintf("EV_NULL mouse move.. wnd=0x%x %d pos=%d,%d\n",ev.s.wid,ev.s.cmd,ev.e.pos.x,ev.e.pos.y);
          PNT pt;
          pt.x = posx;
          pt.y = posy;
          dev->_evh_mouse_move(&ev);

          posx = ev.e.pos.x;
          posy = ev.e.pos.y;
        }
      }
      WSDbtronFormDev::executeUpdate();
      WSGIappObjectList()->execInitialize();
      WSGIappObjectList()->execUpdate();
dbprintf("WSDbtronAppDev::_dispatchEvent start executeUpdate().   XXXXXXXX\n");

      return WS_NO_ERR;
    }
    WSDbtronFormDev::executeUpdate();
    WSGIappObjectList()->execInitialize();
    WSGIappObjectList()->execUpdate();
dbprintf("WSDbtronAppDev::_dispatchEvent start executeUpdate().   XXXXXXXX\n");

    return WS_NO_ERR;
  }
  WSDbtronFormDev::executeUpdate();
  WSGIappObjectList()->execInitialize();
  WSGIappObjectList()->execUpdate();
dbprintf("WSDbtronAppDev::_dispatchEvent start executeUpdate().   XXXXXXXX\n");

  return WS_ERR;
}

void WSDbtronAppDev::update(){

}
DEV_SPEC* WSDbtronAppDev::getDevSpec(){
  return &_dev_spec;
}
CSPEC* WSDbtronAppDev::getCSpec(){
  return &_cspec;
}
void WSDbtronAppDev::setGid(W gid){
dbprintf("WSDbtronAppDev::setGid.. gid=0x%x\n",gid);
  if (gid != NULL && _gid == NULL){
    gget_dsp(gid,&_dev_spec);
    gget_csp(gid,&_cspec);
    if (_dev_spec.attr & 0x08){
// need implement of setting the color map..
      _have_color_map = True;
      _color_map = new COLOR[256];
      gget_col(gid,0,_color_map,256);
      _cspec.colmap = _color_map;
    }else{
      _have_color_map = False;
    }
  }
  _gid = gid;
  _fgid = getNewMemGid(32,32);
}
WSCbool WSDbtronAppDev::getGidInitialized(){
  if (_gid != 0){
    return True;
  }
  return False;
}
W WSDbtronAppDev::getFontGid(){
  return _fgid;
}
WSCbool WSDbtronAppDev::haveColorMap(){
  return _have_color_map;
}
GID WSDbtronAppDev::getNewMemGid(WSCulong w,WSCulong h){
  if (getGidInitialized() == False){
//printf(">> WSDbtronAppDev::getNewMemGid not initialized.. \n");
    return 0;
  }
  DEV_SPEC* dev_spec = getDevSpec();
  CSPEC* cspec = getCSpec();
  BMP bmp;
  bmp.planes =1;
  bmp.pixbits = dev_spec->pixbits;
  int k = (bmp.pixbits >> 8) * w;
  if (k & 15 !=0){
    k = (k & ~15) + 16;
  }
  bmp.rowbytes = k/8;
  bmp.bounds.c.left = 0;
  bmp.bounds.c.right = w;
  bmp.bounds.c.top = 0;
  bmp.bounds.c.bottom = h;
  bmp.baseaddr[0] = (UB*)malloc(bmp.rowbytes * h);
  return gopn_mem(NULL,&bmp,(B*)cspec);
}


