//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCindexForm.h>
#include <WSCclassInformation.h>
//#include <WSCvscrBar.h>
//#include <WSCscrFrame.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSDappDev.h>
#include <WSCvbtn.h>

WSMFguiClassInitialize(WSCindexForm,WSCform);
WSMFversion(WSCindexForm,WSCform);
#define WS_INDENT_WIDTH 2

//WSMFpropertyValueChange( WSCindexForm, WSNshadowType , char,WS_SHADOW_IN);

WSCindexForm::WSCindexForm(WSCbase* base,char* objname):
                WSCform(base,objname){
  _value = 0;
  _need_adjust = 1;
  _bar_thick = 23;
  _menu_string = WSGFstrdup("index1,index2");
  _orientation = WS_HORIZONTAL;
  _flipped = False;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCindexForm);

    WSMFpropertyCreate(WSNbarThickness, WSCushort, _bar_thick,WSSbarThickness );
    WSMFpropertyCreate(WSNorientation,char,_orientation,WSSorientation);
      WSMFpropertySetSelection(WSRorientation, WSRorientationD);
    WSMFpropertyCreate(WSNmenuItems, char*, _menu_string,WSSmenuItems);
    WSMFpropertyCreate(WSNvalue, WSCuchar, _value,WSSvalue);
    WSMFpropertyCreate(WSNflip, WSCbool, _flipped,WSSflip);
      WSMFpropertySetSelection(WSRbool1, WSRbool1D);


//    WSMFpropertyVisibleOff(WSNshadowType);

    WSMFaddTrigger(WSEV_VALUE_CH    );
    WSMFaddTrigger(WSEV_ACTIVATE    );

  WSMFpropertyCreateEnd

}

WSMFproperty( WSCindexForm, WSNbarThickness,  WSCushort, _bar_thick    ,23);
WSMFproperty( WSCindexForm, WSNmenuItems,  char*, _menu_string, WSGFstrdup("index1,index2"));
WSMFproperty( WSCindexForm, WSNorientation, WSCuchar, _orientation, WS_HORIZONTAL);
WSMFproperty( WSCindexForm, WSNvalue, WSCuchar, _value, 0);
WSMFproperty( WSCindexForm, WSNflip, WSCbool, _flipped, 0);


void WSCindexForm::setWorkWSNbarThickness(WSCushort){
  _adjust();
//    _need_adjust = 1;
}

void WSCindexForm::getWorkWSNbarThickness(WSCushort*){}
void WSCindexForm::setWorkWSNorientation(WSCuchar data){
    _need_adjust = 1;
}
void WSCindexForm::getWorkWSNorientation(WSCuchar* ){}
void WSCindexForm::setWorkWSNvalue(WSCuchar data){
  _value_adjust();
}
void WSCindexForm::getWorkWSNvalue(WSCuchar* ){}
void WSCindexForm::setWorkWSNflip(WSCbool){
  _value_adjust();
}
void WSCindexForm::getWorkWSNflip(WSCbool* ){}

void WSCindexForm::setWorkWSNmenuItems(char* data){
    _need_adjust = 1;
}
void WSCindexForm::getWorkWSNmenuItems(char** ){}
WSCindexForm::~WSCindexForm(){
}

void WSCindexForm::_index_op(WSCbase* btn){
  WSCindexForm* obj = (WSCindexForm*)btn->getUserData("parent-form**");
  WSCulong val;
  btn->getPropertyV(WSNuserValue,(long*)&val);
  obj->_value = val;
  obj->_value_adjust();
  obj->execProcedure(WSEV_VALUE_CH);
}
void WSCindexForm::_value_adjust(){
  _adjust();
  WSCulong val;
  long i;
  long num = _btns.getNum();
  if (_value > num -1){
    _value = num -1;
  }
  _tab_form->clear();
  for(i=0; i<num; i++){
    WSCvbtn* item = (WSCvbtn*)_btns[i];
    item->getPropertyV(WSNuserValue,(long*)&val);
    if (_value == val){
      if (_orientation == WS_HORIZONTAL){
        if (_flipped == False){
          if (_shadow_type == WS_SHADOW_OUT){
            item->setPropertyV(WSNy,(short)0);
          }else{
            item->setPropertyV(WSNy,(short)_shadow_thick);
          }
        }else{
          if (_shadow_type == WS_SHADOW_OUT){
            item->setPropertyV(WSNy,(short)(-_shadow_thick-2));
          }else{
            item->setPropertyV(WSNy,(short)(-_shadow_thick*2-2));
          }
        }
      }else{
        if (_flipped == False){
          if (_shadow_type == WS_SHADOW_OUT){
            item->setPropertyV(WSNx,(short)0);
          }else{
            item->setPropertyV(WSNx,(short)_shadow_thick);
          }
        }else{
          if (_shadow_type == WS_SHADOW_OUT){
            item->setPropertyV(WSNx,(short)(-_shadow_thick-2));
          }else{
            item->setPropertyV(WSNx,(short)(-_shadow_thick*2-2));
          }
        }
      }
    }else{
      if (_orientation == WS_HORIZONTAL){
        if (_flipped == False){
          if (_shadow_type == WS_SHADOW_OUT){
            item->setPropertyV(WSNy,(short)WS_INDENT_WIDTH);
          }else{
            item->setPropertyV(WSNy,(short)(_shadow_thick + WS_INDENT_WIDTH));
          }
        }else{
          if (_shadow_type == WS_SHADOW_OUT){
            item->setPropertyV(WSNy,(short)(-_shadow_thick-2-WS_INDENT_WIDTH));
          }else{
            item->setPropertyV(WSNy,(short)(-_shadow_thick*2-2-WS_INDENT_WIDTH));
          }
        }
      }else{
        if (_flipped == False){
          if (_shadow_type == WS_SHADOW_OUT){
            item->setPropertyV(WSNx,(short)WS_INDENT_WIDTH);
          }else{
            item->setPropertyV(WSNx,(short)(_shadow_thick + WS_INDENT_WIDTH));
          }
        }else{
          if (_shadow_type == WS_SHADOW_OUT){
            item->setPropertyV(WSNx,(short)(-_shadow_thick-2-WS_INDENT_WIDTH));
          }else{
            item->setPropertyV(WSNx,(short)(-_shadow_thick*2-2-WS_INDENT_WIDTH));
          }
        }
      }
    }
    if (_orientation == WS_HORIZONTAL){
      item->setPropertyV(WSNheight, (WSCushort)(_bar_thick + _shadow_thick +2));
    }else{
      item->setPropertyV(WSNwidth, (WSCushort)(_bar_thick + _shadow_thick +2));
    }
  }
  _tab_form->redraw();
  redraw();
}

void WSCindexForm::_vis_adjust(){
  WSClistData children = getChildren();
  if (getInternalObject() != False){
    WSCbase* base_parent = this;
    while(1){
      if (base_parent != NULL){
        if (base_parent != this && base_parent->getPublicDevChild() == this){
          break;
        }
        base_parent = base_parent->getParent();
      }else{
        break;
      }
    }
    if (base_parent != NULL){
      WSClistData bchildren = base_parent->getChildren();
      long num = bchildren.getNum();
      long i;
      for(i=0;i<num; i++){
        WSCbase* child = (WSCbase*)bchildren[i];
        if (child->getUseParentBaseDev() == False){
          children.add(child);
        }
      }
    }
  }
  long num = children.getNum();
  long i;
  long val;
  WSCulong value = _value+1;
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getUserData("parent-form**") != NULL){
      continue;
    }
    child->getPropertyV(WSNuserValue,&val);
    if (val == 0){
      val = value;
      child->setPropertyV(WSNuserValue,val);
    }
    if (val == -1){
      continue;
    }
    if ((unsigned)val != value){
      WSCbool vis;
      child->getPropertyV(WSNvis,&vis);
      if (vis == True){
        child->clear();
        child->setVisible(False);
      }
    }else{
      if (child->getVisible() == False){
        child->setVisible(True);
      }
//      child->draw();
    }
  }

}

void WSCindexForm::_adjust(){
  _need_adjust = 0;
  WSCstring tmp(_menu_string);
  long tabs = tmp.getWords(",");
  long btns = _btns.getNum();
  long i;
  if (tabs < 1){
    tabs = 1;
  }
  if (tabs > btns){
    for(i=btns; i<tabs; i++){
      WSCvbtn* btn = new WSCvbtn(_tab_form,"tablets");
      btn->setInternalObject(True);
      btn->initialize();
      btn->setProperty(WSNenableFocusMove,False);
      btn->setPropertyV(WSNshadowThickness,(WSCuchar)0);
      btn->setProperty(WSNalignmentH,WS_LEFT);
      btn->setNoBackground(True);
      btn->setUserData("parent-form**",(void*)this);
      btn->setPropertyV(WSNuserValue,(long)(i));
      btn->setDrawFocusBorder(False);
      WSCprocedure* op = new WSCprocedure("activate",WSEV_ACTIVATE);
      op->setInternal(True);
      op->setFunction(_index_op,"_index_op");
      btn->addProcedure(op);

      _btns.add((void*)btn);
    }
  }
  for(i=0; i<tabs; i++){
    WSCvbtn* btn = (WSCvbtn*)_btns[i];
    WSCstring tmp2 = tmp.getWord(i,",");
    if (!strcmp(tmp2.getString(),"")){
      btn->setPropertyV(WSNlabelString,"index");
    }else{
      btn->setPropertyV(WSNlabelString,tmp2.getString());
    }
    WSCulong val;
    btn->getPropertyV(WSNuserValue,(long*)&val);
    btn->setPropertyV(WSNforeColor,_fore_color);
    btn->setPropertyV(WSNbackColor,_back_color);
    btn->setPropertyV(WSNtopShadowColor,_ts_color);
    btn->setPropertyV(WSNbottomShadowColor,_bs_color);
    btn->setPropertyV(WSNshadowThickness,(WSCuchar)_shadow_thick);
    if (_orientation == WS_HORIZONTAL){
      if (_value == val){
        if (_flipped == False){
          if (_shadow_type == WS_SHADOW_OUT){
            btn->setPropertyV(WSNy,(short)0);
          }else{
            btn->setPropertyV(WSNy,(short)_shadow_thick);
          }
        }else{
          if (_shadow_type == WS_SHADOW_OUT){
            btn->setPropertyV(WSNy,(short)(-_shadow_thick-2));
          }else{
            btn->setPropertyV(WSNy,(short)(-_shadow_thick*2-2));
          }
        }
      }else{
        if (_flipped == False){
          if (_shadow_type == WS_SHADOW_OUT){
            btn->setPropertyV(WSNy,(short)(WS_INDENT_WIDTH));
          }else{
            btn->setPropertyV(WSNy,(short)(_shadow_thick + WS_INDENT_WIDTH));
          }
        }else{
          if (_shadow_type == WS_SHADOW_OUT){
            btn->setPropertyV(WSNy,(short)(-_shadow_thick-2 -WS_INDENT_WIDTH));
          }else{
            btn->setPropertyV(WSNy,(short)(-_shadow_thick*2-2 -WS_INDENT_WIDTH));
          }
        }
      }
      if (_shadow_type == WS_SHADOW_OUT){
        btn->setPropertyV(WSNx,(short)(_w * i/tabs));
        btn->setPropertyV(WSNwidth,(WSCushort)(_w/tabs));
      }else{
        btn->setPropertyV(WSNx,
                (short)(_shadow_thick +(_w - _shadow_thick*2) * i/tabs));
        btn->setPropertyV(WSNwidth,(WSCushort)((_w - _shadow_thick*2)/tabs));
      }
      btn->setPropertyV(WSNheight, (WSCushort)(_bar_thick + _shadow_thick +2));

    }else{
      if (_value == val){
        if (_flipped == False){
          if (_shadow_type == WS_SHADOW_OUT){
            btn->setPropertyV(WSNx,(short)0);
          }else{
            btn->setPropertyV(WSNx,(short)_shadow_thick);
          }
        }else{
          if (_shadow_type == WS_SHADOW_OUT){
            btn->setPropertyV(WSNx,(short)(-_shadow_thick-2));
          }else{
            btn->setPropertyV(WSNx,(short)(-_shadow_thick*2-2));
          }
        }
      }else{
        if (_flipped == False){
          if (_shadow_type == WS_SHADOW_OUT){
            btn->setPropertyV(WSNx,(short)WS_INDENT_WIDTH);
          }else{
            btn->setPropertyV(WSNx,(short)(_shadow_thick+WS_INDENT_WIDTH));
          }
        }else{
          if (_shadow_type == WS_SHADOW_OUT){
            btn->setPropertyV(WSNx,(short)(-_shadow_thick-2 -WS_INDENT_WIDTH));
          }else{
            btn->setPropertyV(WSNx,(short)(-_shadow_thick*2-2 -WS_INDENT_WIDTH));
          }
        }
      }
      if (_shadow_type == WS_SHADOW_OUT){
        btn->setPropertyV(WSNy,(short)(_h * i/tabs));
        btn->setPropertyV(WSNheight,(WSCushort)(_h/tabs));
      }else{
        btn->setPropertyV(WSNy,
                (short)(_shadow_thick +(_h - _shadow_thick*2) * i/tabs));
        btn->setPropertyV(WSNheight,(WSCushort)((_h - _shadow_thick*2)/tabs));
      }
      btn->setPropertyV(WSNwidth, (WSCushort)(_bar_thick + _shadow_thick +2));

    }
    btn->setVisible(True);
  }
  if (tabs < btns){
    for(i=tabs; i<btns; i++){
      WSCvbtn* btn = (WSCvbtn*)_btns[i];
      btn->setVisible(False);
    }
  }

  if (_orientation == WS_HORIZONTAL){
    if (_flipped == False){
      _tab_form->setPropertyV(WSNy,(short)0);
    }else{
      _tab_form->setPropertyV(WSNy,(short)(_h - _bar_thick));
    }
    _tab_form->setPropertyV(WSNx,(short)0);
    _tab_form->setPropertyV(WSNwidth,(WSCushort)_w);
    if (_bar_thick > 0){
      _tab_form->setPropertyV(WSNheight,(WSCushort)_bar_thick);
      _tab_form->setVisible(True);
    }else{
      _tab_form->setVisible(False);
    }
  }else{
    if (_flipped == False){
      _tab_form->setPropertyV(WSNx,(short)0);
    }else{
      _tab_form->setPropertyV(WSNx,(short)(_w - _bar_thick));
    }
    _tab_form->setPropertyV(WSNy,(short)0);
    _tab_form->setPropertyV(WSNheight,(WSCushort)_h);
    if (_bar_thick > 0){
      _tab_form->setPropertyV(WSNwidth,(WSCushort)_bar_thick);
      _tab_form->setVisible(True);
    }else{
      _tab_form->setVisible(False);
    }
  }
  if (_shadow_type != WS_SHADOW_OUT){
    if (_shadow_type == WS_SHADOW_NONE &&
        !(WSGIappDev()->getGuiPolicy() & WS_POLICY_OTHER)){
    _tab_form->setProperty(WSNshadowType,WS_SHADOW_IN);
    }else{
    _tab_form->setProperty(WSNshadowType,_shadow_type);
    }
    _tab_form->setProperty(WSNshadowThickness,_shadow_thick);
  }else{
    _tab_form->setProperty(WSNshadowType,WS_SHADOW_NONE);
    _tab_form->setProperty(WSNshadowThickness,0);
  }
  _tab_form->setPropertyV(WSNbackColor,_back_color);
  _tab_form->redraw();
}

void WSCindexForm::setWorkWSNbackColor(short no){
  if (_initialized != False){
    _adjust();
  }
  WSCform::setWorkWSNbackColor(no);
}

void WSCindexForm::setWorkWSNshadowType(char st){
  WSCform::setWorkWSNshadowType(st);
  if (_initialized != False){
    _adjust();
  }
}
void WSCindexForm::setWorkWSNshadowThickness(WSCuchar st){
  WSCform::setWorkWSNshadowThickness(st);
  if (_initialized != False){
    _adjust();
  }
}

void WSCindexForm::setWorkWSNforeColor(short no){
  if (_initialized != False){
    _adjust();
  }
  WSCform::setWorkWSNforeColor(no);
}

void WSCindexForm::setWorkWSNwidth(WSCushort no){
  if (_initialized != False){
    _adjust();
  }
  WSCform::setWorkWSNwidth(no);
}

void WSCindexForm::setWorkWSNheight(WSCushort no){
  if (_initialized != False){
    _adjust();
  }
  WSCform::setWorkWSNheight(no);
}

long WSCindexForm::initialize(){
  WSCform::initialize();
  _tab_form = new WSCform(this,"tabform");
  _tab_form->setInternalObject(True);
  _tab_form->initialize();
  _tab_form->setPropertyV(WSNx,(short)0);
  _tab_form->setPropertyV(WSNy,(short)0);
//  _tab_form->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  _tab_form->setUserData("parent-form**",(void*)this);

  _adjust();

  return WS_NO_ERR;
}

long WSCindexForm::cdraw(){
  if (_tab_form != NULL){
    _tab_form->cdraw();
  }
  return WSCform::cdraw();
}
long WSCindexForm::redraw(){
  if (_tab_form != NULL){
    _tab_form->redraw();
  }
  WSCform::redraw();
  return WS_NO_ERR;
}

long WSCindexForm::clear(){
  if (_tab_form != NULL){
    _tab_form->clear();
  }
  WSCform::clear();
  return WS_NO_ERR;
}
long WSCindexForm::draw(){
  if (getVisible() == False){
    return WS_NO_ERR;
  }
  if (_need_adjust != 0){
    _adjust();
  }

  WSCulong value = _value+1;
//  WSCform::draw();
  WSCbool absolute = getAbsoluteDraw();
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
//  if (_shadow_thick > 0){
  if (WSGIappDev()->getExtGuiPolicySelected() != False){
    if (_ext_draw_proc == NULL){
      _ext_draw_proc = (void(*)(void*))WSGIappDev()->
                               getExtGuiPolicyProc("WSCindexForm::draw");
    }
    if (_ext_draw_proc != NULL){
      WSCindexForm_draw_struct st;
      st._this = this;
      st.dev = dev;
      st.x = _x;
      st.y = _y;
      st.width = _w;
      st.height = _h;
      st.shadow_thickness = _shadow_thick;
      st.shadow_type = _shadow_type;
      st.fore_color = _fore_color;
      st.back_color = _back_color;
      st.top_shadow_color = _ts_color;
      st.bottom_shadow_color = _bs_color;
      st.back_pixmap = _bp_color;
      st.gradation = _grad_no;
      st.gradation_margin = _grad_margin;
      st.bar_thickness = _bar_thick;
      st.orientation = _orientation;
      st.flipped = _flipped;
      st.menu_string = _menu_string;
      st.value = value;
      _ext_draw_proc(&st);

      _tab_form->draw();
      _vis_adjust();
      return WS_NO_ERR;
    }
  }



    long err = dev->beginDraw(0,0,_w,_h,absolute);

    if (err != WS_NO_ERR){
      return WS_NO_ERR;
    }
    short ex = 0;
    short ey = 0;
    WSCushort ew = _w;
    WSCushort eh = _h;
    if (absolute == False){
      dev->getExposedArea(&ex,&ey,&ew,&eh);
    }
    WSCbase::update();
    setAbsoluteDraw(False);

    if (_bp_color == -1){
      if (_grad_no == 0){
        dev->setForeColor(_back_color);
        dev->drawFillRect(0,0,_w,_h);
      }else{
        dev->drawGradation(_grad_no,_ts_color,_back_color,_bs_color,
                            0,0,_w,_h,_grad_margin);
      }
    }
    WSGFdrawBtnShadow(dev,_shadow_type,_shadow_thick,
                       _fore_color,_ts_color,_bs_color,_back_color,0,0,_w,_h);
    if (getDotMode() == True){
      dev->setForeColor(_fore_color);
      long i,j;
      for(i=0; i<_w; i+=10){
        for(j=0; j<_h; j+=10){
          if (ex < i && i < ex+ ew &&
              ey < j && j < ey+ eh ){
            dev->drawFillRect(i,j,1,1);
          }
        }
      }
    }

    long st = _shadow_thick;
    if (st > 1 && WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
      st -=1;
    }
    WSCstring tmp(_menu_string);
    long num = tmp.getWords(",");
    if (num > 1){
      if ( _orientation == WS_HORIZONTAL){
        if (_flipped == False){
          dev->setForeColor(_ts_color);
          if (value > 1){
            dev->drawFillRect(0,_bar_thick,_w * (value -1)/num,st);
          }
          if (value < (unsigned)num){
            dev->drawFillRect(_w * value/num,_bar_thick,
                              _w * (num - value)/num,st);
          }
        }else{
          dev->setForeColor(_bs_color);
          if (value > 1){
            dev->drawFillRect(0,_h -_bar_thick-st,_w * (value -1)/num,st);
          }
          if (value < (unsigned)num){
            dev->drawFillRect(_w * value/num,_h -_bar_thick-st,
                              _w * (num - value)/num,st);
          }
        }
      }else{
        if (_flipped == False){
          dev->setForeColor(_ts_color);
          if (value > 1){
            dev->drawFillRect(_bar_thick,0,st,_h * (value -1)/num);
          }
          if (value < (unsigned)num){
            dev->drawFillRect(_bar_thick,_h * value/num,st,
                              _h * (num - value)/num);
          }
        }else{
          dev->setForeColor(_bs_color);
          if (value > 1){
            dev->drawFillRect(_w -_bar_thick-st,0,st,_h * (value -1)/num);
          }
          if (value < (unsigned)num){
            dev->drawFillRect(_w -_bar_thick-st,_h * value/num,st,
                              _h * (num - value)/num);
          }
        }
      }
    }
    dev->endDraw();
//  }
  _tab_form->draw();
  _vis_adjust();
  return WS_NO_ERR;
}
void(*WSCindexForm::_ext_draw_proc)(void*) = NULL;
WSCstring WSCindexForm::_policy_name;

void WSCindexForm::onGuiPolicyChange(long policy){
  WSCbase::onGuiPolicyChange(policy);
  if (WSGIappDev()->getExtGuiPolicySelected() == False){
    _ext_draw_proc = NULL;
  }else{
    if (!strcmp((char*)_policy_name,(char*)WSGIappDev()->getExtGuiPolicyName())){
    }else{
      _ext_draw_proc = (void(*)(void*))WSGIappDev()->getExtGuiPolicyProc("WSCindexForm::draw");
    }
  }
  needUpdate();
  setAbsoluteDraw(True);
  redraw();
}
WSCbase* WSCindexForm::get_target_btn(){
  int i;
  long num = _btns.getNum();
  long val;
  for(i=0; i<num; i++){
    WSCvbtn* item = (WSCvbtn*)_btns[i];
    item->getPropertyV(WSNuserValue,(long*)&val);
    if (_value == val){
      return item;
    } 
  } 
  return NULL;
}
void WSCindexForm::set_btn_background(short no){
  int i;
  long num = _btns.getNum();
  long val;
  for(i=0; i<num; i++){
    WSCvbtn* item = (WSCvbtn*)_btns[i];
    item->setProperty(WSNbackColor,no);
  } 
  return;
}
