//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCmfile.h>

WSCmfile::WSCmfile(){
  _buf = NULL;
  _seek_pt = 0;
  _buf_len = 0;
}

WSCmfile::~WSCmfile(){
  if (_buf != NULL){
    delete _buf;
    _buf = NULL;
  }
}

long WSCmfile::open(void* data,long len){
  if (_buf != NULL){
    delete _buf;
  }
  _buf = new char[len];
  memcpy(_buf,data,len);
  _seek_pt = 0;
  _buf_len = len;
  return WS_NO_ERR;
}

long WSCmfile::close(){
  if (_buf != NULL){
    delete _buf;
  }
  _buf = NULL;
  _seek_pt = 0;
  _buf_len = 0;
  return WS_NO_ERR;
}

long WSCmfile::read(void* buf,long len){
  long clen;
  clen = len;
  if (clen > _buf_len - _seek_pt){
    clen = _buf_len - _seek_pt;
  }
  if (clen == 0){
    return 0;
  }
  memcpy(buf,&_buf[_seek_pt],clen);
  return clen;
}

long WSCmfile::write(void* buf,long len){
  long clen;
  clen = len;
  if (clen > _buf_len - _seek_pt){
    char* newbuf = new char[_seek_pt + clen];
    if (_buf != NULL){
      memcpy(newbuf,_buf,_seek_pt);
      delete _buf;
    }
    _buf = newbuf;
  }
  memcpy(&_buf[_seek_pt],buf,clen);
  return clen;
}

WSCbool WSCmfile::eof(){
  if (_buf == NULL){
    return 1;
  }
  if (_seek_pt >= _buf_len ){
    return 1;
  }
  return 0;
}

long WSCmfile::seek(long addr){
  if (addr < 0){
    _seek_pt = 0;
    return WS_ERR;
  }
  if (addr > _buf_len ){
    _seek_pt = _buf_len;
    return WS_ERR;
  }
  _seek_pt = addr;
  return WS_NO_ERR;
}

long WSCmfile::seekSet(){
  _seek_pt = 0;
  return WS_NO_ERR;
}

long WSCmfile::seekEnd(){
  _seek_pt = _buf_len;
  return WS_NO_ERR;
}

long WSCmfile::getSize(){
  return _buf_len;
}

long WSCmfile::tell(){
  return _seek_pt;
}
