//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>

#include <WSCindexData.h>

WSCindexData::WSCindexData(){}

WSCindexData::~WSCindexData(){
  clear();
}

long WSCindexData::getNum(){
  return _index.getNum();
}
long WSCindexData::setData(char* index,void* data){
  long num = _index.getNum();
  long i;
  for(i=0; i<num; i++){
    char* ptr = (char*)_index[i];
    if (ptr[0] == index[0] && !strcmp(ptr,index)){
      _data[i] = data;
      return 0;
    }
  }
  _index.add(WSGFstrdup(index));
  _data.add(data);
  return 0;
}

long WSCindexData::del(char* index){
  long num = _index.getNum();
  long i;
  for(i=0; i<num; i++){
    char* ptr = (char*)_index[i];
    if (ptr[0] == index[0] && !strcmp(ptr,index)){
      char* str = (char*)_index[i];
      delete str;
      _index.delPos(i);
      _data.delPos(i);
      return 0;
    }
  }
  return -1;
} 

long WSCindexData::delPos(long pos){
  if (pos < 0){
    pos = _index.getNum() -1;
    if (pos < 0){
      return -1;
    }
  }
  if (pos < _index.getNum()){
    char* str = (char*)_index[pos];
    delete str;
    _index.delPos(pos);
    _data.delPos(pos);
    return 0;
  }
  return -1;
}

void WSCindexData::clear(){
  long num = _index.getNum();
  long i;
  for(i=0; i<num; i++){
    char* index =(char*)_index[i];
    delete index;
  }
  _index.clear();
  _data.clear();

}
void* WSCindexData::getData(char* index){
  long num = _index.getNum();
  long i;
  for(i=0; i<num; i++){
    char* ptr = (char*)_index[i];
    if (ptr[0] == index[0] && !strcmp(ptr,index)){
      return _data[i];
    }
  }
  return 0;
}

void* WSCindexData::getData(long i){
  return _data[i];
}

char* WSCindexData::getIndex(long i){
  return (char*)_index[i];
}

WSCindexData::WSCindexData(WSCindexData& src){

  long num = src._index.getNum();
  long i;
  for(i=0; i<num; i++){
    _index.add(WSGFstrdup( (char*)src._index[i]));
    _data.add(src._data[i]);
  }
}
WSCindexData::WSCindexData(const WSCindexData& csrc){
  WSCindexData src(csrc); 
  long num = src._index.getNum();
  long i;
  for(i=0; i<num; i++){
    _index.add(WSGFstrdup( (char*)src._index[i]));
    _data.add(src._data[i]);
  }
}

void*& WSCindexData::operator [] (char* index){
  long num = _index.getNum();
//printf("WSCindexData::operator[] num=%d\n",num);
  long i;
  for(i=0; i<num; i++){
    char* ptr = (char*)_index[i];
    if (ptr[0] == index[0] && !strcmp(ptr,index)){
      return _data[i];
    }
  }
  setData(index,0);
  return (*this)[index];
}

WSCindexData& WSCindexData::operator = (WSCindexData& src){
  clear();

  long num = src._index.getNum();
  long i;
  for(i=0; i<num; i++){
    _index.add(WSGFstrdup( (char*)src._index[i]));
    _data.add(src._data[i]);
  }
  return *this;
}
