//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCfontSet.h>
static WSCfontSet* _the_app_font_list = NULL;

WSCfontSet* WSGIappFontSet(){
  if (_the_app_font_list == NULL){
    _the_app_font_list = new WSCfontSet();
    if (_the_app_font_list == NULL){
      return NULL;
    }
  }
  return _the_app_font_list;
}
WSCfontSet::WSCfontSet(){
  _default_font = WS_DEFAULT_FONT_NO;
  _create_handler = NULL;
  _setup_handler = NULL;
  _default_init_handler = NULL;
}
WSCfontSet::~WSCfontSet(){
  long i;
  long num = _font_list.getNum();
  for(i=0; i<num; i++){
    delete (WSDfont*)_font_list[i];
  }
}
long WSCfontSet::initializeDefault(){
  if (_default_init_handler != NULL){
    _default_init_handler(this);
  }
  return WS_NO_ERR;
}
long WSCfontSet::addFont(WSDfont* font){
  _font_list.add((void*)font);
  return WS_ERR;
}
WSDfont* WSCfontSet::getFont(short no){
  long i;
  long num = _font_list.getNum();
  for(i=0; i<num; i++){
    WSDfont* fon = (WSDfont*)_font_list[i];
    if (fon->getId() == no){
      return fon;
    }
  }
  no = _default_font;
  for(i=0; i<num; i++){
    WSDfont* fon = (WSDfont*)_font_list[i];
    if (fon->getId() == no){
      return fon;
    }
  }
  return NULL;
}
WSDfont* WSCfontSet::getDefaultFont(){
  long i;
  long num = _font_list.getNum();
  for(i=0; i<num; i++){
    WSDfont* fon = (WSDfont*)_font_list[i];
    if (fon->getId() == _default_font){
      return fon;
    }
  }
  return NULL;
}
short WSCfontSet::getDefaultFontNo(){
  return _default_font;
}
long WSCfontSet::getStringWidth(short no,WSCstring* str){
  WSDfont* fon = getFont(no); 
  if (fon == NULL){
    return 0;
  }
  return fon->getStringWidth(str);
}
long WSCfontSet::getStringHeight(short no,WSCstring* str){
  WSDfont* fon = getFont(no); 
  if (fon == NULL){
    return 0;
  }
  return fon->getStringHeight(str);
}
void WSCfontSet::setDefaultFont(short no){
  _default_font = no;
}
void WSCfontSet::setCreateHandler(WSDfont* (*hd)()){
  _create_handler = hd;
}
void WSCfontSet::setSetupHandler(long (*hd)(WSDfont*,char*)){
  _setup_handler = hd;
}
void WSCfontSet::setDefaultInitializeHandler(long(*hd)(WSCfontSet*)){
  _default_init_handler = hd;
}
long WSCfontSet::getStringWidth(short no,char* s,long en){
  WSCstring str;
  str.setString(s,en);
  return getStringWidth(no,&str); 
}
long WSCfontSet::getStringHeight(short no,char* s,long en){
  WSCstring str;
  str.setString(s,en);
  return getStringHeight(no,&str); 
}
