//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCVSLIDER_H
#define WSCVSLIDER_H

#include <WScom.h>
#include <WSCnwbase.h>
#define WSCvslider_VER  1010

class WSCvslider  :public WSCnwbase{

  protected:
    long      _timer_id;
    short     _bg_no;
    short     _ts_no;
    short     _bs_no;
    WSCushort _slider_size;
    short     _maximum;
    short     _minimum;
    WSCushort _dragInterval;
    short     _value;
    short     _btn_x_bk;
    short     _btn_y_bk;
    short     _value_bk;
    WSCuchar  _clock_bk;
    unsigned  _shadow_thick:4;
    unsigned  _bar_status:4;
    unsigned  _orientation:1;
    unsigned  _timer_on:1;
   
    WSMFpropertyDef(WSNshadowThickness,   WSCuchar,  _shadow_thick);
    WSMFpropertyDef(WSNbackColor,         short,     _bg_no);
    WSMFpropertyDef(WSNtopShadowColor,    short,     _ts_no);
    WSMFpropertyDef(WSNbottomShadowColor, short,     _bs_no);
    WSMFpropertyDef(WSNsliderSize,        WSCushort, _slider_size);
    WSMFpropertyDef(WSNmaximum,           short,     _maximum);
    WSMFpropertyDef(WSNminimum,           short,     _minimum);
    WSMFpropertyDef(WSNdragInterval,      WSCushort, _dragInterval);
    WSMFpropertyDef(WSNvalue,             short,     _value);
    WSMFpropertyDef(WSNorientation,       WSCuchar,  _orientation);

    static void _timer_work(WSCuchar,void*);

    long _bar_in(short px,short py, short x,short y,WSCushort w,WSCushort h,
                  WSCushort st);


    virtual long _device_initialize();

  public:
    WSCvslider(WSCbase*,char*);

    virtual void onActivate();
    virtual void onDragInterval();
    virtual void onMousePress(WSCpoint*);
    virtual void onMouseMove(WSCpoint*);
    virtual void onMouseRelease(WSCpoint*);
    virtual void onValueChange();

    virtual long draw();
    virtual long execEventProc(long ev,void* data);

    WSMFguiClassDef(WSCvslider,WSCnwbase);
    WSMFversionDef(WSCvslider);
};
#endif
