//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCVSCRBAR_H
#define WSCVSCRBAR_H

#include <WScom.h>
#include <WSCnwbase.h>
#define WSCvscrBar_VER  1000

#define WS_MINIMUM_WIDTH 10

#define WS_OVER   0
#define WS_BBTN1  1
#define WS_BBTN2  2
#define WS_BBTN3  3
#define WS_BBTN4  4
#define WS_BAR    5
#define WS_INTER1 6
#define WS_INTER2 7

class WSDmwindowDev;
class WSCvscrBar :public WSCnwbase{

  protected:
    long      _timer_id;
    WSCulong  _slider_size;
    WSCulong  _maximum;
    WSCulong  _value;
    WSCulong  _value_bk;
    WSDmwindowDev** _mask_images;
    short     _bp_no;
    short     _bg_no;
    short     _bg2_no;
    short     _ts_no;
    short     _bs_no;
    WSCushort _increment;
    WSCushort _page_increment;
    short     _btn_x_bk;
    short     _btn_y_bk;
    WSCuchar  _clock_bk;
    unsigned  _shadow_thick:4;
    unsigned  _bar_status:4;
    unsigned  _orientation:1;
    unsigned  _timer_on:1;
    unsigned  _grad_on:1;

    WSMFpropertyDef(WSNshadowThickness,   WSCuchar,  _shadow_thick  );
    WSMFpropertyDef(WSNbackColor,         short,     _bg_no         );
    WSMFpropertyDef(WSNbarShadowColor,    short,     _bg2_no        );
    WSMFpropertyDef(WSNtopShadowColor,    short,     _ts_no         );
    WSMFpropertyDef(WSNbottomShadowColor, short,     _bs_no         );
    WSMFpropertyDef(WSNsliderSize,        WSCulong,  _slider_size   );
    WSMFpropertyDef(WSNmaximum,           WSCulong,  _maximum       );
    WSMFpropertyDef(WSNincrement,         WSCushort, _increment     );
    WSMFpropertyDef(WSNpageIncrement,     WSCushort, _page_increment);
    WSMFpropertyDef(WSNvalue,             WSCulong,  _value         );
    WSMFpropertyDef(WSNorientation,       WSCuchar,  _orientation   );
    WSMFpropertyDef(WSNbackPixmap,        short,     _bp_no         );
    WSMFpropertyDef(WSNgradation,         WSCbool,   _grad_on       );

    static void _timer_work(WSCuchar,void*);

    long _bar_in(short px,short py, short x,short y,WSCushort w,WSCushort h,
                  WSCushort st);
    long _draw_sl_bar();


    virtual long _device_initialize();
static void      (*_ext_draw_proc)(void*);
static WSCstring _policy_name;

  public:
    WSCvscrBar(WSCbase*,char*);
    virtual ~WSCvscrBar();

    virtual void onActivate();
    virtual void onBegin();
    virtual void onEnd();
    virtual void onIncrement();
    virtual void onDecrement();
    virtual void onPageIncrement();
    virtual void onPageDecrement();
    virtual void onMousePress(WSCpoint*);
    virtual void onMouseMove(WSCpoint*);
    virtual void onMouseRelease(WSCpoint*);
    virtual void onValueChange();
    virtual void onGuiPolicyChange(long);

    virtual long execEventProc(long ev,void* data);
    virtual long draw();

    WSCulong getMaxSlideValue();

    WSMFguiClassDef(WSCvscrBar,WSCnwbase);
    WSMFversionDef(WSCvscrBar);
};

struct WSCvscrBar_draw_struct{
  WSCvscrBar* _this;
  WSDdev* dev;
  short x;
  short y;
  WSCushort width;
  WSCushort height;
  WSCushort shadow_thickness;
  WSCulong  slider_size;
  WSCulong  maximum;
  WSCulong  value;
  WSCuchar  bar_status;
  WSCuchar  orientation;
  short fore_color;
  short back_color;
  short back_color2;
  short top_shadow_color;
  short bottom_shadow_color;
  short back_pixmap;
  long  gradation;
};


#endif
