//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCPULLDOWNMENUPOPUP_H
#define WSCPULLDOWNMENUPOPUP_H

#include <WScom.h>
#include <WSCwindow.h>
#include <WSCstring.h>
#include <WSDkeyboard.h>

class WSCpulldownMenuPopup    :public WSCwindow{

  protected:
    WSCpulldownMenuPopup* _popup;
    WSCpulldownMenuPopup* _parent_pld_menu;
    void*            _pld_data;
    char*            _menu_string;
    WSCushort        _item_height;
    WSCstring        _prc_name;
    long             _id_value;
    WSClistData      _child_pld_list;
    signed char             _selected_item;
    char             _items;
    unsigned         _font:4;
    unsigned         _selected:1;
    unsigned         _next_popup:1;
    unsigned         _emboss:1;
    unsigned         _mouse_no_check:1;
    unsigned         _wait_child_popup:1;
    unsigned         _child_popup_waited:1;

    //menu string = string:prcname:short cut key:value,
    //              string:prcname:short cur key;value,
    //              leveldown:{
    //                string:prcname:short cur key;value,
    //                string:prcname:short cur key;value
    //              },
    //              string:prcname:short cur key;value,

    WSMFpropertyDef( WSNfont,           WSCuchar,  _font       );
    WSMFpropertyDef( WSNmenuItems,      char*,     _menu_string); 
    WSMFpropertyDef( WSNmenuItemHeight, WSCushort, _item_height); 

    virtual void setWorkWSNwidth(WSCushort);
    virtual void setWorkWSNheight(WSCushort);
    virtual void setWorkWSNemboss(WSCbool);

    virtual long _device_initialize();

    WSCpulldownMenuPopup* _check_child_status_no_mouse();
static void      (*_ext_draw_proc)(void*);
static WSCstring _policy_name;

  public:
    WSCpulldownMenuPopup(WSCbase*,char*);
    virtual ~WSCpulldownMenuPopup();

    virtual void onVisibleChange(WSCbool);
    virtual void onResize(WSCrect*);
    virtual void onKeyPress(WSDkeyboard*,WSCbool);
    virtual void onGuiPolicyChange(long);

    virtual long initialize();
    virtual long draw();

    void setEmboss(WSCbool);
    long setItemSensitive(short no,WSCbool flag);    
    long setValueSensitive(short id,WSCbool flag);    
    void setParentMenu(WSCpulldownMenuPopup*);

    WSCpulldownMenuPopup* getParentMenu();
    WSCushort getItemHeight();
    WSCuchar  getFontNo();
    long      getItems();
    char*     getProcName();
    WSCbool   getSelected();
    WSCbool   getNextPopup();
    WSCbool   getEmboss();
    WSCbool*  getItemSensitive();
    long      getValue();
    void   setSelected(WSCbool);

    //internal
    void set_items(long items);
    WSCstring& get_prc_name();
    void set_selected(WSCbool fl);
    void* get_pld_data();
    void set_child_popup_waited(WSCbool fl);
    void set_selected_item(long item);
    void set_id_value(long v);
    WSClistData& get_child_pld_list();
    void popupChildPld(short childno,char* menustr, short x, short y);
    void popdownChildPld(short childno);
    void updateChild();
    WSCbool checkChildStatus();

    WSMFguiClassDef(WSCpulldownMenuPopup,WSCwindow);
};

struct WSCpulldownData {
  WSCstring  _label;
  WSCstring  _op;
  WSCstring  _sc;
  WSCpulldownData*  _next;
  WSCpulldownData*  _cascade_data;
  short _id;
  WSCbool    _separator;
  WSCbool    _cascaded;
  WSCbool    _sensitive;

  WSCpulldownData();
  ~WSCpulldownData();
  WSCbool   getSensitive(long no);
  WSCbool   getSensitiveWithId(long id);
  WSCpulldownData* getItem(long no);
  WSCpulldownData* getItemWithId(long no);
  long   setSensitive(long no,WSCbool fl );
  long   setSensitiveWithId(long id,WSCbool fl );
  void   setCascaded(WSCbool fl);
  void   add(WSCpulldownData* data);
  long   getItems();

  static  WSCpulldownData* parse(char* menu_string);
};

struct WSCpulldownMenuPopup_draw_struct{
  WSCpulldownMenuPopup* _this;
  WSDdev* dev;
  short x;
  short y;
  WSCushort width;
  WSCushort height;
  WSCushort shadow_thickness;
  short fore_color;
  short back_color;
  short top_shadow_color;
  short bottom_shadow_color;
  short back_pixmap;
  long shadow_type;
  short gradation;
  short gradation_margin;
  char*            menu_string;
  WSCushort        item_height;
  WSCstring        prc_name;
  long             id_value;
  signed char      selected_item;
  char             items;
  unsigned         font:4;
  unsigned         selected:1;
  unsigned         next_popup:1;
  unsigned         emboss:1;
  unsigned         mouse_no_check:1;
  unsigned         wait_child_popup:1;
  unsigned         child_popup_waited:1;
};

#endif
