//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCPOPUPMENU_H
#define WSCPOPUPMENU_H

#include <WScom.h>
#include <WSCpulldownMenuPopup.h>

class WSCpopupMenu  :public WSCpulldownMenuPopup{

  protected:
    WSClistData   _client_list;
    WSCbase*      _modal_bk;
    void*         _client;
    unsigned      _press_state:1;
    unsigned      _grabed:1;

    WSMFpropertyDef( WSNclient,  void*,          _client );

    static void _on_btn_press(WSCbase*);
    static void _on_btn_release(WSCbase*);
    static void _on_btn_move(WSCbase*);

    static void _on_btn_press_recursive(WSCbase*);
    static void _on_btn_release_recursive(WSCbase*);
    static void _on_btn_move_recursive(WSCbase*);
    static void _on_delete(WSCbase*);

    long _registerClient(WSCbase*,WSCbool recursive = False);
    static WSCpopupMenu* _popuped_instance;

  public:
    WSCpopupMenu(WSCbase*,char*);
    virtual ~WSCpopupMenu();

    virtual void onActivate();

    long popup();
    long popdown();
    long popdownAndExecute();
    long registerClient(WSCbase*,WSCbool recursive = False);
    long unregisterClient(WSCbase*);
    WSMFguiClassDef(WSCpopupMenu,WSCpulldownMenuPopup);
};
#endif
