//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCFFORM_H
#define WSCFFORM_H

#include <WScom.h>
#include <WSCbase.h>
#include <WSDprivateTimer.h>

#define WSCfform_VER  1010

class WSCfform :public WSCbase{

  protected:
    char*          _user_string;
    long           _user_value;
    WSClistData    _children;
    short          _x;
    short          _y;
    short          _x_bak;
    short          _y_bak;
    WSCushort      _w;
    WSCushort      _h;
    short          _fore_color;
    short          _back_color;
    short          _ts_color;
    short          _bs_color;
    short          _bp_no;
    WSCushort      _mouse_no;
    unsigned short _anchor_top;
    unsigned short _anchor_bottom;
    unsigned short _anchor_left;
    unsigned short _anchor_right;
    WSCuchar       _grad_no;
    WSCuchar       _grad_margin;
    WSCuchar       _margin;
    WSCuchar       _bar_thick;
    short          _mouse_x;
    short          _mouse_y;
    short          _x_original;
    short          _y_original;
    char*          _title_string;
    unsigned  _anchor_top_use:1;
    unsigned  _anchor_bottom_use:1;
    unsigned  _anchor_left_use:1;
    unsigned  _anchor_right_use:1;

    unsigned       _shadow_thick:4;
    signed         _shadow_type:4;
    unsigned       _pixmap_style:2;
    unsigned       _no_refresh:1;
    unsigned       _update_resize:1;
    unsigned  _mouse_pressed:1;
    unsigned  _floated:1;
    unsigned  _vis_bk:1;
    unsigned  _change_sequence:1;
    unsigned  _orientation:1;
    unsigned  _mouse_pressed_resize:1;
    unsigned  _indicator:1;
    unsigned  _font:4;

static WSDprivateTimer* _move_timer;
static WSDprivateTimer* _resize_timer;

    WSMFpropertyDef(WSNname,       char*,     _instance_name ); 
    WSMFpropertyDef(WSNuserString,       char*,     _user_string ); 
    WSMFpropertyDef(WSNtitleString,      char*,     _title_string ); 
    WSMFpropertyDef(WSNuserValue,        long,      _user_value  ); 
    WSMFpropertyDef(WSNx,                short,     _x           );
    WSMFpropertyDef(WSNy,                short,     _y           );
    WSMFpropertyDef(WSNwidth,            WSCushort, _w           );
    WSMFpropertyDef(WSNheight,           WSCushort, _h           );
    WSMFpropertyDef(WSNshadowThickness,  WSCuchar,  _shadow_thick);
    WSMFpropertyDef(WSNforeColor,        short,     _fore_color  );
    WSMFpropertyDef(WSNbackColor,        short,     _back_color  );
    WSMFpropertyDef(WSNtopShadowColor,   short,     _ts_color    );
    WSMFpropertyDef(WSNbottomShadowColor,short,     _bs_color    );
    WSMFpropertyDef(WSNbackPixmap,       short,     _bp_no    );
    WSMFpropertyDef(WSNshadowType,       char,      _shadow_type );
    WSMFpropertyDef(WSNvis,              WSCbool,   _vis         );
    WSMFpropertyDef(WSNdet,              WSCbool,   _sensitive   );
    WSMFpropertyDef(WSNpixmapStyle,      WSCuchar,  _pixmap_style);
    WSMFpropertyDef(WSNmouse,   WSCushort,  _mouse_no    );
    WSMFpropertyDef(WSNgradation,   WSCuchar,  _grad_no    );
    WSMFpropertyDef(WSNgradationMargin,   WSCuchar,  _grad_margin    );
    WSMFpropertyDef(WSNanchorTop,     WSCushort,      _anchor_top  );
    WSMFpropertyDef(WSNanchorBottom,  WSCushort,      _anchor_bottom  );
    WSMFpropertyDef(WSNanchorLeft,    WSCushort,      _anchor_left  );
    WSMFpropertyDef(WSNanchorRight,   WSCushort,      _anchor_right  );
    WSMFpropertyDef(WSNanchorTopFlag,     WSCbool,      _anchor_top_use  );
    WSMFpropertyDef(WSNanchorBottomFlag,  WSCbool,      _anchor_bottom_use  );
    WSMFpropertyDef(WSNanchorLeftFlag,    WSCbool,      _anchor_left_use  );
    WSMFpropertyDef(WSNanchorRightFlag,   WSCbool,      _anchor_right_use  );
    WSMFpropertyDef(WSNorientation,   WSCuchar,      _orientation  );
    WSMFpropertyDef(WSNexport,   WSCbool,      _export_  );
    WSMFpropertyDef(WSNindicatorOn,   WSCbool,  _indicator    );
    WSMFpropertyDef(WSNbarThickness,   WSCuchar,  _bar_thick    );
    WSMFpropertyDef(WSNfont,         WSCuchar,   _font         );
    WSMFpropertyDef(WSNmargin,   WSCuchar,  _margin    );

    virtual long  _device_initialize();
    virtual void  _exec_child_adjust_for_anchors();
static void _delay_proc(WSCuchar,void*);
static void _move_proc(void*);
static void _resize_proc(void*);
    void _set_floated();
    void _detach_dev();
    void _detach_dev_sub(WSCbase*);
  public:
    WSCfform(WSCbase*,char*);
    virtual ~WSCfform();

    virtual long execEventProc(long ev,void*);

    virtual void onResize(WSCrect*);
    virtual void onVisibleChange(WSCbool);
    virtual void onMousePress(WSCpoint*);
    virtual void onMouseMove(WSCpoint*);
    virtual void onMouseRelease(WSCpoint*);
    virtual void onParentVisibleChange(WSCbool);
    virtual void onStatusChange(WSCbool floated);
    virtual void _adjust_for_anchors(WSCushort,WSCushort);

    virtual long draw();
    virtual long clear();
    virtual long redraw();
    virtual long cdraw();
//    virtual long execEventProc(long ev, void*);
//    virtual long drawGriphand();
    virtual void update();
    virtual long getObjectType();
    virtual WSClistData& getChildren();
    virtual void setChildren(WSClistData&);
    void execResizeEvent();
    void setNoRefresh(WSCbool);
    WSCbool getNoRefresh();
    void setFloated(WSCbool);
    WSCbool getFloated();
    long getPixmapStyle();

    WSMFguiClassDef(WSCfform,WSCbase);
    WSMFsetUseDevice(fformDev);
    WSMFversionDef(WSCfform);
};
#endif
