/*-------------------------------------------------------------------------*/
/*  J3W ver 6.40  3D Animation Kit                                         */
/*  vertex.cpp    11/22/97                                                 */
/*  Copyright (C) 1996 - 1999 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#include  "vertex.h"

TVertex::TVertex(int vn)
{
    Max = vn;
    vert = new VectorSet*[vn];
    for(int i = 0; i<vn; i++) vert[i] = 0;
    Count = 0;
    Offset = 0;
    rposition = Vector(0,0,0);
}

TVertex::~TVertex()
{
    for (int i=0; i<Count; i++) delete vert[i];
    delete vert;
}

void TVertex::Add(Vector v)
{
    if (Count < Max) {
        vert[Count] = new VectorSet;
        vert[Count]->local = v + rposition;
        Count++;
    }
}

void TVertex::Assign(int pos, Vector v)
{
    if (pos < Count) vert[pos]->local = v;
}

void TVertex::Query(int pos, Vector &v)
{
    if (pos < Count) v = vert[pos]->local;
}

void TVertex::Transpose(int pos, Vector v)
{
    if (pos < Count) vert[pos]->local = vert[pos]->local + v;
}

