//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSDmessage.h>
#include <WSClistData.h>

WSMFclassInit(WSDmessage,WSCroot) ;

long WSDmessage::initialize() {
WSMFtrace("WSDmessage::initialize() ERROR,this system does not support WSDmessage.\n");
	return 0 ;
}

WSDmessage* (*  WSDmessage::_chandler)() = NULL;
WSDmessage* WSDmessage::getNewInstance(){
  if (_chandler != NULL){
    return _chandler();
  }
  return new WSDmessage();
}
void WSDmessage::setCreateHandler(WSDmessage* (*hd)()){
  _chandler = hd;
}
void WSDmessage::_setup_ext_send_msg_proc(void* fn1,void* fn2){
  _ext_send_msg1 = (int(*)(char*,char*,char*))fn1;
  _ext_send_msg2 = (int(*)(char*,char*,char*))fn2;
}
void WSDmessage::setupMessage(char *name, void (*cbwork)(char *)) {
  _exec_action = cbwork;
  _exec_action2 = NULL;
  _id.setString(name);
  _data = NULL;
  initialize();
}
void WSDmessage::setupMessage(char *name, void (*cbwork)(char *,void* data),void* data){
  _exec_action  = NULL;
  _exec_action2 = cbwork;
  _id.setString(name);
  _data = data;
  initialize();
}

int (* WSDmessage::_ext_send_msg1)(char*,char*,char*) = NULL;
int (* WSDmessage::_ext_send_msg2)(char*,char*,char*) = NULL;

int WSDmessage::extSendNewMessage(char* disp,char *message,char *data){
  if ( _ext_send_msg2 != NULL ){
    _ext_send_msg2(disp,message,data);
  }
  return 0;
}
int WSDmessage::extSendMessage(char* disp, char* message, char* data){
  if ( _ext_send_msg1 != NULL ){
    _ext_send_msg1(disp,message,data);
  }
  return 0;
}
int WSDmessage::sendMessageEx(char* disp, char* message, char* data){
  if ( _ext_send_msg1 != NULL ){
    _ext_send_msg1(disp,message,data);
  }
  return 0;
}

void WSDmessage::sendMessage(char*){}

