//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSDfile.h>

WSMFclassInit(WSDfile,WSCroot);

WSDfile* (*WSDfile::_create_handler)() = NULL;

WSDfile::WSDfile(){
  _read_only = False;
  _type = WS_TEXT;
}

//WSDfile::~WSDfile(){
//}

void WSDfile::setType(char type){
  _type = type;
};
char WSDfile::getType(){
  return _type;
}
void WSDfile::setReadOnly(WSCbool fl){
  if (fl != False){
    fl = True;
  }
  _read_only = fl;
}

WSCbool WSDfile::isReadOnly(){
  return _read_only;
}

WSDfile* WSDfile::getNewInstance(){
  if (_create_handler == NULL){
    return new WSDfile();
  }
  return _create_handler();
}

void* WSDfile::getCreateInstanceHandler(){
  return (void*)_create_handler;
}

void WSDfile::setCreateInstanceHandler(void* hd){
  _create_handler = (WSDfile* (*)())hd;
}

long WSDfile::open(char* ,char*){
WSMFtrace("WSDfile Warring. This system does not support open().\n");
  return WS_ERR;
}

long WSDfile::close(){
WSMFtrace("WSDfile Warring. This system does not support close().\n");
  return WS_ERR;
}

long WSDfile::read(void*,long ){
WSMFtrace("WSDfile Warring. This system does not support read().\n");
  return 0;
}

long WSDfile::write(void*,long ){
WSMFtrace("WSDfile Warring. This system does not support write().\n");
  return 0;
}

WSCbool WSDfile::eof(){
WSMFtrace("WSDfile Warring. This system does not support eof().\n");
  return True;
}

long WSDfile::seek(long){
WSMFtrace("WSDfile Warring. This system does not support seek().\n");
  return 0;
}

long WSDfile::seekSet(){
WSMFtrace("WSDfile Warring. This system does not support seekSet().\n");
  return 0;
}

long WSDfile::seekEnd(){
WSMFtrace("WSDfile Warring. This system does not support seekEnd().\n");
  return 0;
}

long WSDfile::getSize(){
WSMFtrace("WSDfile Warring. This system does not support getSize().\n");
  return 0;
}

long WSDfile::tell(){
WSMFtrace("WSDfile Warring. This system does not support tell().\n");
  return 0;
}

