//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCvlabel.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSCblink.h>
#include <WSCcolorSet.h>
#include <WSCimageSet.h>
#include <WSDdev.h>
#include <WSDcolor.h>
#include <WSCfontSet.h>
#include <WSDappDev.h>
#include <WSClist.h>

WSMFguiClassInitialize(WSCvlabel, WSCnwbase);
WSMFversion(WSCvlabel, WSCnwbase);

WSCuchar  WSCvlabel::_vk_draw = WS_NORMAL;
WSCbool   WSCvlabel::_use_icon = 0;
WSCstring WSCvlabel::_bar_pos;

WSCvlabel::WSCvlabel(WSCbase* base, char* objname):
			WSCnwbase(base, objname){
  _shadow_type = WS_SHADOW_EIN;
  _shadow_thick = 2;
//  _back_color =  WSGFcolor("gray85");
//  _ts_color = WSGFcolor("gray95");
//  _bs_color =  WSGFcolor("gray65");
  _back_color =  WS_DF_NWBACKCOLOR;
  _ts_color = WS_DF_NWTOPSHADOWCOLOR;
  _bs_color =  WS_DF_NWBOTTOMSHADOWCOLOR;
  _bl_type = WS_FORE;
//  _bg_blink_color =  WSGFcolor("gray85");
  _bg_blink_color =  WS_DF_NWBACKCOLOR;
  _rv_fl = False;
  _emboss = False;
  _use_pix = False;
  _select_color = 0;
  _select_fore_color = 0;

  _max_length = WS_VLABEL_MAXLEN_DEFAULT;
  _label_string = WSGFstrdup("");
  _alignment_v = WS_CENTER;
  _alignment_h = WS_CENTER;
  _margin_top = 2;
  _margin_bottom = 2;
  _margin_left = 2;
  _margin_right = 2;
  _label_pixmap = -1;
  _blink_pixmap = -1;
  _grad_no = 0;
  _grad_margin = 0;
  _font = (char)WSGIappFontSet()->getDefaultFontNo();
  _orientation = WS_HORIZONTAL;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvlabel);

    WSMFpropertyCreate(WSNshadowType,   char,    _shadow_type,WSSshadowType);
    WSMFpropertySetSelection(WSRshadowType, WSRshadowTypeD);
    WSMFpropertyCreate(WSNshadowThickness,       WSCuchar, _shadow_thick,WSSshadowThickness);
    WSMFpropertyCreate(WSNbackColor,         short,  _back_color,WSSbackColor);
    WSMFpropertyCreate(WSNtopShadowColor,    short,  _ts_color,WSStopShadowColor);
    WSMFpropertyCreate(WSNbottomShadowColor, short,  _bs_color,WSSbottomShadowColor);
    WSMFpropertyCreate(WSNreverseFlag,       WSCbool, _rv_fl,WSSreverseFlag);
    WSMFpropertySetSelection(WSRbool4, WSRbool4D);
    WSMFpropertyCreate(WSNbackBlinkColor, short,   _bg_blink_color,WSSbackBlinkColor);
    WSMFpropertyCreate(WSNblinkType,      WSCuchar, _bl_type,WSSblinkType);
    WSMFpropertySetSelection(WSRblinkType, WSRblinkTypeD);
    WSMFpropertyCreate(WSNemboss,           WSCbool,  _emboss,WSSemboss);
    WSMFpropertySetSelection(WSRbool1, WSRbool1D);
    WSMFpropertyCreate(WSNusePixmap,    WSCbool,  _use_pix,WSSusePixmap);
    WSMFpropertySetSelection(WSRbool4, WSRbool4D);

    WSMFpropertyCreate(WSNlabelString,  char*,   _label_string,WSSlabelString);
    WSMFpropertyCreate(WSNorientation,  WSCuchar, _orientation,WSSorientation );
      WSMFpropertySetSelection(WSRorientation, WSRorientationD);
    WSMFpropertyCreate(WSNalignmentV,   WSCuchar,   _alignment_v,WSSalignmentV );
      WSMFpropertySetSelection(WSRalignmentV, WSRalignmentVD);
    WSMFpropertyCreate(WSNalignmentH,   WSCuchar,   _alignment_h,WSSalignmentH);
      WSMFpropertySetSelection( WSRalignmentH, WSRalignmentHD);
    WSMFpropertyCreate(WSNmarginTop,    WSCuchar,  _margin_top,WSSmarginTop );
    WSMFpropertyCreate(WSNmarginBottom, WSCuchar,  _margin_bottom,WSSmarginBottom);
    WSMFpropertyCreate(WSNmarginLeft,   WSCuchar,  _margin_left,WSSmarginLeft );
    WSMFpropertyCreate(WSNmarginRight,  WSCuchar,  _margin_right,WSSmarginRight);
    WSMFpropertyCreate(WSNmaxLength,    WSCushort,  _max_length,WSSmaxLength);
    WSMFpropertyCreate(WSNfont,         WSCuchar,   _font,WSSfont  );
    WSMFpropertyCreate(WSNlabelPixmap,  short,     _label_pixmap,WSSlabelPixmap);
    WSMFpropertyCreate(WSNblinkPixmap,  short,   _blink_pixmap,WSSblinkPixmap);

    WSMFpropertyCreate(WSNgradation,   WSCuchar,   _grad_no,WSSgradation);
      WSMFpropertySetSelection( WSRgradation, WSRgradationD);
    WSMFpropertyCreate(WSNgradationMargin,   WSCuchar,   _grad_margin,WSSgradationMargin);


  WSMFpropertyCreateEnd

}

WSMFproperty(WSCvlabel, WSNshadowType,        char,           _shadow_type, WS_SHADOW_EIN      );
WSMFproperty(WSCvlabel, WSNshadowThickness,   WSCuchar, _shadow_thick, 2                  );
//WSMFproperty(WSCvlabel, WSNbackColor,         short,        _back_color, WSGFcolor("gray85"));
WSMFproperty(WSCvlabel, WSNbackColor,         short,        _back_color, WS_DF_NWBACKCOLOR);
//WSMFproperty(WSCvlabel, WSNtopShadowColor,    short,        _ts_color, WSGFcolor("gray95"));
WSMFproperty(WSCvlabel, WSNtopShadowColor,    short,        _ts_color, WS_DF_NWTOPSHADOWCOLOR);
//WSMFproperty(WSCvlabel, WSNbottomShadowColor, short,        _bs_color, WSGFcolor("gray65"));
WSMFproperty(WSCvlabel, WSNbottomShadowColor, short,        _bs_color, WS_DF_NWBOTTOMSHADOWCOLOR);
WSMFproperty(WSCvlabel, WSNblinkType,         WSCuchar,       _bl_type, WS_FORE          );
//WSMFproperty(WSCvlabel, WSNbackBlinkColor,    short,        _bg_blink_color, WSGFcolor("gray85"));
WSMFproperty(WSCvlabel, WSNbackBlinkColor,    short,        _bg_blink_color, WS_DF_NWBACKCOLOR);
WSMFproperty(WSCvlabel, WSNreverseFlag,       WSCbool,        _rv_fl, False              );
WSMFproperty(WSCvlabel, WSNemboss,            WSCbool,        _emboss, False );
WSMFproperty(WSCvlabel, WSNusePixmap,         WSCbool,       _use_pix, False );
WSMFproperty(WSCvlabel, WSNlabelString, char*,    _label_string,  WSGFstrdup(""));
WSMFproperty(WSCvlabel, WSNorientation, WSCuchar, _orientation,     WS_HORIZONTAL );
WSMFproperty(WSCvlabel, WSNalignmentV,  WSCuchar, _alignment_v,   WS_CENTER     );
WSMFproperty(WSCvlabel, WSNmarginTop,   WSCuchar,_margin_top,    2             );
WSMFproperty(WSCvlabel, WSNmarginBottom,WSCuchar,_margin_bottom, 2             );
WSMFproperty(WSCvlabel, WSNalignmentH,  WSCuchar, _alignment_h,   WS_CENTER     );
WSMFproperty(WSCvlabel, WSNmarginLeft,  WSCuchar,_margin_left,   2             );
WSMFproperty(WSCvlabel, WSNmarginRight, WSCuchar,_margin_right,  2             );
WSMFproperty(WSCvlabel, WSNmaxLength,   WSCushort,_max_length,    WS_VLABEL_MAXLEN_DEFAULT );
WSMFproperty(WSCvlabel, WSNfont,        WSCuchar, _font,(char)WSGIappFontSet()->getDefaultFontNo());
WSMFproperty(WSCvlabel, WSNlabelPixmap,  short,   _label_pixmap,  -1  );
WSMFproperty(WSCvlabel, WSNblinkPixmap,  short,   _blink_pixmap,  -1  );
WSMFproperty(WSCvlabel, WSNgradation,    WSCuchar, _grad_no,  0  );
WSMFproperty(WSCvlabel, WSNgradationMargin,    WSCuchar, _grad_margin,  0  );

void WSCvlabel::setWorkWSNshadowThickness(WSCuchar){}
void WSCvlabel::getWorkWSNshadowThickness(WSCuchar*){}
void WSCvlabel::setWorkWSNshadowType(char stype){
  if (_use_pix != False && stype == WS_SHADOW_TRANS){
    WSCbool fl = False;
    _use_pix = False;
    if (_dev != NULL){
      _dev->setValue(WSDEV_USE_PIXMAP,(void*)&fl);
    }
  }
}
void WSCvlabel::getWorkWSNshadowType(char*){}
void WSCvlabel::setWorkWSNbackColor(short){}
void WSCvlabel::getWorkWSNbackColor(short*){}
void WSCvlabel::setWorkWSNtopShadowColor(short){}
void WSCvlabel::getWorkWSNtopShadowColor(short*){}
void WSCvlabel::setWorkWSNbottomShadowColor(short){}
void WSCvlabel::getWorkWSNbottomShadowColor(short*){}
void WSCvlabel::setWorkWSNblinkType(WSCuchar){}
void WSCvlabel::getWorkWSNblinkType(WSCuchar*){}
void WSCvlabel::setWorkWSNbackBlinkColor(short){}
void WSCvlabel::getWorkWSNbackBlinkColor(short*){}
void WSCvlabel::setWorkWSNreverseFlag(WSCbool){}
void WSCvlabel::getWorkWSNreverseFlag(WSCbool*){}
void WSCvlabel::setWorkWSNemboss(WSCbool){}
void WSCvlabel::getWorkWSNemboss(WSCbool*){}

void WSCvlabel::setWorkWSNusePixmap(WSCbool fl) {
  if (_dev != NULL){
    if (fl != False && _shadow_type == WS_SHADOW_TRANS){
      fl = False;
      _use_pix = False;
    }
    _dev->setValue(WSDEV_USE_PIXMAP,(void*)&fl);
  }
}

void WSCvlabel::getWorkWSNusePixmap(WSCbool*){}
void WSCvlabel::setWorkWSNlabelString(char* ){}
void WSCvlabel::getWorkWSNlabelString(char**){}
void WSCvlabel::setWorkWSNalignmentV(WSCuchar){}
void WSCvlabel::getWorkWSNalignmentV(WSCuchar*){}
void WSCvlabel::setWorkWSNmarginTop(WSCuchar){}
void WSCvlabel::getWorkWSNmarginTop(WSCuchar*){}
void WSCvlabel::setWorkWSNmarginBottom(WSCuchar){}
void WSCvlabel::getWorkWSNmarginBottom(WSCuchar*){}
void WSCvlabel::setWorkWSNalignmentH(WSCuchar){}
void WSCvlabel::getWorkWSNalignmentH(WSCuchar*){}
void WSCvlabel::setWorkWSNmarginLeft(WSCuchar){} 
void WSCvlabel::getWorkWSNmarginLeft(WSCuchar*){} 
void WSCvlabel::setWorkWSNmarginRight(WSCuchar){} 
void WSCvlabel::getWorkWSNmarginRight(WSCuchar*){}
void WSCvlabel::setWorkWSNmaxLength(WSCushort len) {
  if (len > 1024) {
    _max_length = 1024;
  }
}

void WSCvlabel::getWorkWSNmaxLength(WSCushort*){}
void WSCvlabel::setWorkWSNfont(WSCuchar){}
void WSCvlabel::getWorkWSNfont(WSCuchar*){}
void WSCvlabel::setWorkWSNorientation(WSCuchar){}
void WSCvlabel::getWorkWSNorientation(WSCuchar*){}
void WSCvlabel::setWorkWSNlabelPixmap(short){}
void WSCvlabel::getWorkWSNlabelPixmap(short*){}
void WSCvlabel::setWorkWSNblinkPixmap(short no){}
void WSCvlabel::getWorkWSNblinkPixmap(short*){}
void WSCvlabel::setWorkWSNgradation(WSCuchar no){}
void WSCvlabel::getWorkWSNgradation(WSCuchar*){}
void WSCvlabel::setWorkWSNgradationMargin(WSCuchar no){}
void WSCvlabel::getWorkWSNgradationMargin(WSCuchar*){}

WSCvlabel::~WSCvlabel() {
  if (_label_string != NULL) {
    delete _label_string;
    _label_string = (char*)NULL;
  }
}
void WSCvlabel::update(){
  if (isNeedUpdate() == True){
    if (_shadow_type == WS_SHADOW_TRANS){
      redraw();
    }else{
      draw();
    }
    WSCbase::update();
  }
}
long WSCvlabel::_device_initialize(){
  WSCnwbase::_device_initialize();

  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
  
  if (_use_pix != False){
    char fl = True;
    dev->setValue(WSDEV_USE_PIXMAP,&fl);
  }

  return WS_NO_ERR;
}

long WSCvlabel::draw(){
  if (getVisible() == False){
    return WS_NO_ERR;
  }
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }

  short x = _x;
  short y = _y;
  WSCushort w = _w;
  WSCushort h = _h;

  WSCbool absolute = getAbsoluteDraw();
  if (absolute == False && dev->isExposed(x, y, w, h) == False){
    return WS_NO_ERR;
  }

  WSCushort st       = _shadow_thick;
  long blinking      = _bl_fl;
  long blinkfore     =  WSGIappBlink()->getBlinkFore(_blink_rate);
  long shadowtype    = _shadow_type;
  long blinktype     = _bl_type;
  short fgno         = _fore_color;
  short fgno2        = _fore_color;
  short bgno         = _back_color;
  short blinkcolorno = _blink_color;
  short backblinkno  = _bg_blink_color;
  short tsno         = _ts_color;
  short bsno         = _bs_color;
  WSCbool bldraw     = (blinking != False && blinkfore != False);
  if (_select_fore_color != 0){
    fgno = _select_fore_color;
  }
  if (shadowtype == WS_SHADOW_NONE){
    st = 0;
  }
  if ( shadowtype == WS_SHADOW_NONE &&
        bldraw && _tw_fl == False){
    return WS_NO_ERR;
  }

  WSCstring str;
  str.setString(_label_string);
  if (_orientation == WS_VERTICAL) {
    WSGFcreateVerticalString(&str);
  } else {
    str.replaceString("\\n", "\n", 0);
    str.replaceString("\\\n", "\\n", 0);
  }

  long err = dev->beginDraw(x, y, w, h, absolute);
  if (err != WS_NO_ERR){
     return WS_NO_ERR;
  }

  short     xx = st + _margin_left;
  short     yy = st + _margin_top;
  WSCushort ww = w - st*2;
  WSCushort hh = h - st*2;
  WSCushort h_margin = _margin_left + _margin_right;
  WSCushort v_margin = _margin_top + _margin_bottom;
  long indent_level = 0;
  short     mx = 0;

  if (ww < h_margin) {
    ww = 1;
  } else {
    ww = ww - h_margin;
  }
  if (hh < v_margin) {
    hh = 1;
  } else {
    hh = hh - v_margin;
  }

  if (_vk_draw == WS_TREE){
    indent_level = (long)getUserData(WS_LIST_INDENT_LEVEL);
  }

  long ialign = getAlignment();
  WSCushort iww = w - st*2;
  if (_use_icon != 0){
    if (_vk_draw == WS_TREE){
      xx = hh + indent_level*hh;
      iww = hh;
      ialign = WS_CENTER;
    }else{
      xx = 0;
    }
  }

  WSCbase::update();
  setAbsoluteDraw(False);
  if (shadowtype != (char)WS_SHADOW_TRANS) {
    if (_rv_fl == True) {
      if (bldraw && blinktype != WS_FORE ){
        dev->setForeColor(blinkcolorno);
      } else {
        dev->setForeColor(fgno);
      }
    } else {
      if (bldraw && blinktype != WS_FORE ){
        dev->setForeColor(backblinkno);
      } else {
        dev->setForeColor(bgno);
      }
    }
    if (_grad_no == 0){
      dev->drawFillRect( 0, 0, w, h);
    }else{
      dev->drawGradation(_grad_no,tsno,bgno,bsno,0, 0, w, h,_grad_margin);
    }
  }
  if (_select_color != 0){
    dev->setForeColor(_select_color);
    if (_vk_draw == WS_TREE){
      short x1 = hh + hh/4 + hh*indent_level;
      if (_use_icon != 0){
        x1 = hh*2 + hh/4 + hh*indent_level;
      }
      if ( w - x1 > 0){
        dev->drawFillRect( x1, 0, w -x1, h);
      }
    }else{
      short x1 = 0;
      if (_use_icon != 0){
        x1 = hh + hh/4 ;
      }
      if ( w - x1 > 0){
        dev->drawFillRect( x1, 0, w -x1, h);
      }
    }
  }

  WSDimage* image;
  if (bldraw && blinktype != WS_BACK ){
      if (_blink_pixmap != -1 && _tw_fl != False){
        image = WSGIappImageSet()->getImage(_blink_pixmap);
        dev->drawImage (xx, yy, iww, hh, image, ialign);
      }
  }else{
      if (_label_pixmap != -1){
        image = WSGIappImageSet()->getImage(_label_pixmap);
        dev->drawImage (xx, yy, iww, hh, image, ialign);
      }
  }

  if (shadowtype != WS_SHADOW_TRANS && st > 0){
    WSGFdrawShadow(dev, shadowtype, st, tsno, tsno, bsno, bgno,0, 0, w, h);
  }

  if (_use_icon != 0){
    if (_vk_draw == WS_TREE){
      xx = hh*2 + hh/4 + hh * indent_level;
      mx = hh/4 + indent_level*hh;
    }else{
      xx = hh + hh/4;
    }
  }else{
    if (_vk_draw == WS_TREE){
      xx = hh + hh/4 + hh * indent_level;
      mx = hh/4 + indent_level*hh;
    }
  }

  if (_emboss != False){
    if (_rv_fl == True) {
      if (bldraw && blinktype != WS_BACK &&
          _tw_fl != False){
        dev->setForeColor(backblinkno);
      } else {
        dev->setForeColor(tsno);
      }
    } else {
      if (bldraw && blinktype != WS_BACK &&
          _tw_fl != False){
        dev->setForeColor(blinkcolorno);
      } else {
        dev->setForeColor(tsno);
      }
    }

    if (bldraw && blinktype != WS_BACK &&
        _tw_fl == False){
     // 褷ʤ
    }else{
      if (_tw_fl == False || _bl_fl == False){
        if (_vk_draw != WS_VERBOSE){
          dev->drawString(xx+1, yy+1, ww, hh, &str, _font,
                           getAlignment(), -1, False);
        }else{
          WSCstring sep(",");
          if (getParent() != NULL){
            WSClist* list = (WSClist*)getParent()->cast("WSClist");
            if (list != NULL){
              sep = list->getSeparator();
            }
          }
          long num2 = _bar_pos.getWords(sep);
          long i;
          short xx1 = xx;
          for(i=0; i<num2; i++){
            WSCstring tmp = str.getWord(i,sep);
            WSCstring pos("0");
            if(i > 0){
              pos = _bar_pos.getWord(i-1,sep);
            }
            WSCstring pos2;
            if (i < num2){
              pos2 = _bar_pos.getWord(i,sep);
            }else{
              pos2 = WSGFltoa(ww);
            }
//            long wt = atoi((char*)pos2) - atoi((char*)pos)
//                      - _margin_left - _margin_right;
            long wt = atoi((char*)pos2) - atoi((char*)pos);
            if (_use_icon != 0 && i == 0){
              wt = wt - hh - hh/4;
              if (wt < 1){
                wt = 0;
              }
            }
            dev->drawString(xx1 +1 + atoi((char*)pos), yy+1,
                            wt, hh, &str, _font, getAlignment(), -1, False);
            xx1 = st + _margin_left;
          }
        }
      }
    }
  }
  if (_vk_draw == WS_TREE){
    dev->setLineDashType(8);
    dev->setForeColor(fgno2);
    dev->setLineWidth(1);
    if ((long)getUserData(WS_LIST_INDENT_STATUS) & (long)WS_HAVE_BROS){
      if (getUserData(WS_LIST_TOP) == 0){
        dev->drawLine(mx + hh/4 + _margin_left,_margin_top,
                      mx + hh/4 + _margin_left,hh + _margin_top);
      }else{
        dev->drawLine(mx + hh/4 + _margin_left,hh/2 + _margin_top,
                      mx + hh/4 + _margin_left,hh + _margin_top);
      }
    }else{
      if (getUserData(WS_LIST_TOP) == 0){
        dev->drawLine(mx + hh/4 + _margin_left,_margin_top,
                    mx + hh/4 + _margin_left,hh/2 + _margin_top);
      }
    }
    dev->drawLine(mx + hh/4 + _margin_left,hh/2+_margin_top,
                  mx + hh*3/4 + _margin_left,hh/2+_margin_top);
    WSClistData* lblist = (WSClistData*)getUserData(WS_LIST_LABEL_LIST);
    if (lblist != NULL){
      long lnum = lblist->getNum();
      long pt = 0;
      for(pt=0; pt <lnum; pt++){
        WSCbase* item= (WSCbase*)lblist->getData(pt);
        if (item == this){
          long t;
          long wlevel = (long)getUserData(WS_LIST_INDENT_LEVEL);
          for(t=pt -1; t > -1; t--){
            if (wlevel <1){
              break;
            }
            WSCbase* tlb = (WSCbase*)lblist->getData(t);
            long tlevel = (long)tlb->getUserData(WS_LIST_INDENT_LEVEL);
            if (tlevel < wlevel ){
              wlevel = tlevel;

              if (  ((long)tlb->getUserData(WS_LIST_INDENT_STATUS) & WS_HAVE_BROS)){
                long mx1 = hh/4 + wlevel*hh;
                dev->drawLine(mx1 + hh/4 + _margin_left,_margin_top,
                            mx1 + hh/4 + _margin_left,hh + _margin_top);
              }
            }

          }
          break;
        }
      }
    }
    dev->setLineDashType(0);
    if ((long)getUserData(WS_LIST_INDENT_STATUS) & (long)WS_HAVE_CHILD){
      dev->setForeColor(bgno);
      dev->drawFillRect( mx + _margin_left, hh/4 + _margin_top, hh/2, hh/2);
      if ((long)getUserData(WS_LIST_TREE_OPEN) == (long)0){
//        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
//          WSGFdrawShadow(dev, WS_SHADOW_OUT, 2, tsno, tsno, bsno,bgno,
//                  mx + _margin_left, hh/4 + _margin_top, hh/2, hh/2);
//        }else
//        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          dev->setForeColor(fgno2);
          dev->drawRect( mx + hh/4 +_margin_left - 4,
                         hh/2+_margin_top -4,9,9);
          dev->drawLine( mx + hh/4 +_margin_left - 2,
                         hh/2+_margin_top ,
                         mx + hh/4 +_margin_left + 3,
                         hh/2+_margin_top );
          dev->drawLine( mx + hh/4 +_margin_left,
                         hh/2+_margin_top -2,
                         mx + hh/4 +_margin_left,
                         hh/2+_margin_top +3);

////          WSGFdrawShadow(dev, WS_SHADOW_OUT, 2, tsno, tsno, bsno,bgno,
////                  mx + _margin_left, hh/4 + _margin_top, hh/2, hh/2);
//        }
      }else{
//        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
//          WSGFdrawShadow(dev, WS_SHADOW_IN, 2, tsno, tsno, bsno,bgno,
//                  mx + _margin_left, hh/4 + _margin_top, hh/2, hh/2);
//        }else
//        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          dev->setForeColor(fgno2);
          dev->drawRect( mx + hh/4 +_margin_left - 4,
                         hh/2+_margin_top -4,9,9);
          dev->drawLine( mx + hh/4 +_margin_left - 2,
                         hh/2+_margin_top ,
                         mx + hh/4 +_margin_left + 3,
                         hh/2+_margin_top );

////          WSGFdrawShadow(dev, WS_SHADOW_IN, 2, tsno, tsno, bsno,bgno,
////                  mx + _margin_left, hh/4 + _margin_top, hh/2, hh/2);
//        }
      }
    }
  }
 
  if (_rv_fl != False) {
      if (bldraw && blinktype != WS_BACK &&
          _tw_fl != False){
        dev->setForeColor(backblinkno);
      } else {
        if (_emboss == False){
          dev->setForeColor(bgno);
        }else{
          dev->setForeColor(bsno);
        }
      }
  } else {
      if (bldraw && blinktype != WS_BACK &&
          _tw_fl != False){
        dev->setForeColor(blinkcolorno);
      } else {
        if (_emboss == False){
          dev->setForeColor(fgno);
        }else{
          dev->setForeColor(bsno);
        }
      }
  }
  if ( !( bldraw && blinktype != WS_BACK && _tw_fl == False) ){
    if (_vk_draw != WS_VERBOSE){
      dev->drawString(xx, yy, ww, hh, &str, _font, getAlignment(), -1, False);
    }else{
      WSCstring sep(",");
      if (getParent() != NULL){
        WSClist* list = (WSClist*)getParent()->cast("WSClist");
        if (list != NULL){
          sep = list->getSeparator();
        }
      }
      long num2 = _bar_pos.getWords(sep);
      long i;
      short xx1 = xx;
      for(i=0; i<num2 + 1; i++){
        WSCstring tmp = str.getWord(i,sep);
        WSCstring pos("0");
        if(i > 0){
          pos = _bar_pos.getWord(i-1,sep);
        }
        WSCstring pos2;
        if (i < num2){
          pos2 = _bar_pos.getWord(i,sep);
        }else{
          pos2 = WSGFltoa(ww);
        }
        long wt = atoi((char*)pos2) - atoi((char*)pos);
        if (_use_icon != 0 && i == 0){
          wt = wt - hh - hh/4;
          if (wt < 1){
            wt = 0;
          }
        }
        dev->drawString(xx1 + atoi((char*)pos), yy, 
              wt, hh, &tmp,_font,getAlignment(), -1, False);
        xx1 = st + _margin_left;
      }
    }
  }
  dev->endDraw();
  return WS_NO_ERR;
}

char WSCvlabel::getAlignment() {
static char fl = 0;
static long table[3][3];
  if (fl == 0){
    fl = 1;
    table[WS_LEFT][WS_CENTER - WS_CENTER] = WS_LEFT;
    table[WS_LEFT][WS_TOP - WS_CENTER] = WS_LEFT_TOP;
    table[WS_LEFT][WS_BOTTOM - WS_CENTER] = WS_LEFT_BOTTOM;
    table[WS_RIGHT][WS_CENTER - WS_CENTER] = WS_RIGHT;
    table[WS_RIGHT][WS_TOP - WS_CENTER] = WS_RIGHT_TOP;
    table[WS_RIGHT][WS_BOTTOM - WS_CENTER] = WS_RIGHT_BOTTOM;
    table[WS_CENTER][WS_CENTER - WS_CENTER] = WS_CENTER;
    table[WS_CENTER][WS_TOP - WS_CENTER] = WS_TOP;
    table[WS_CENTER][WS_BOTTOM - WS_CENTER] = WS_BOTTOM;
  }
  return table[_alignment_h][_alignment_v - WS_CENTER];
}
char* WSCvlabel::getDefaultProperty(){
  return WSNlabelString;
}
