//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCmessageDialog.h>
#include <WSCclassInformation.h>
#include <WSDdev.h>
#include <WSCdevice.h>
#include <WSCform.h>
#include <WSCvlabel.h>
#include <WSDappDev.h>

WSMFguiClassInitialize(WSCmessageDialog,WSCbaseDialog);
WSMFversion(WSCmessageDialog,WSCbaseDialog);

#define D_BTN_WIDTH 80
WSMFpropertyValueChange(WSCmessageDialog,WSNno,WSCbool,False);
static WSCmessageDialog* _the_app_message_dialog = NULL;

WSCmessageDialog* WSGIappMessageDialog(){
  if (_the_app_message_dialog == NULL){
    _the_app_message_dialog = new WSCmessageDialog(NULL,"app-fselect");
    if (_the_app_message_dialog == NULL){
//      assert(0);
      return NULL;
    }else{
      _the_app_message_dialog->initialize();
      _the_app_message_dialog->setPropertyV(WSNwidth,(WSCushort)(400));
      _the_app_message_dialog->setPropertyV(WSNheight,(WSCushort)(120));
      _the_app_message_dialog->setPropertyV(WSNtitleString,"Message");
      _the_app_message_dialog->setPropertyV(WSNlabelPixmap,"$(WSDIR)/sys/pixmaps/bi23.xpm");
    }
  }
  return _the_app_message_dialog;
};



WSCmessageDialog::WSCmessageDialog(WSCbase* base,char* objname):
                WSCbaseDialog(base,objname){

  _label_string = WSGFstrdup("");
  _label = NULL;
  _area1 = NULL;
  _no = 0;
  _wbg_no = WS_DF_DARKBACKCOLOR;


  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCmessageDialog);
    WSMFpropertyCreate(WSNlabelString,   char*, _label_string,WSSlabelString);
    WSMFpropertyValueChangeDef(WSCmessageDialog,WSNno,WSCbool);
    WSMFpropertyCreate(WSNworkBackColor,  short, _wbg_no,WSSworkBackColor );
    WSMFpropertyDelete(WSNshadowThickness);
  WSMFpropertyCreateEnd
}

WSCmessageDialog::~WSCmessageDialog(){
  if (_label_string != NULL){
    delete _label_string;
    _label_string = NULL;
  }
}

WSMFproperty( WSCmessageDialog, WSNlabelString, char*, _label_string,WSGFstrdup("") );
WSMFproperty( WSCmessageDialog, WSNworkBackColor,short, _wbg_no ,WS_DF_DARKBACKCOLOR);

void WSCmessageDialog::setWorkWSNlabelString(char* str){
  if (_label != NULL){
    _label->setPropertyV(WSNlabelString,str);
  }
}
void WSCmessageDialog::getWorkWSNlabelString(char** str){}


void WSCmessageDialog::setWorkWSNworkBackColor(short no){
  if (_area1 != NULL){
    _area1->setProperty(WSNbackColor,no);
  }
}
void WSCmessageDialog::getWorkWSNworkBackColor(short* ){}

long WSCmessageDialog::initialize(){
  WSCbaseDialog::initialize();
  _area1 = new WSCform(this,"md-label");
  _area1->setInternalObject(True);
  _area1->initialize();
  _area1->setInternalObject(True);
  _area1->setPropertyV(WSNx,     (short)0 );
  _area1->setPropertyV(WSNy,     (short)5 );
//  _area1->setPropertyV(WSNtopShadowColor,WSGFcolor("gray95"));
//  _area1->setPropertyV(WSNbackColor,WSGFcolor("gray80"));
  _area1->setProperty(WSNbackColor,_wbg_no);
//  _area1->setPropertyV(WSNbottomShadowColor,WSGFcolor("gray55"));
  _area1->setVisible(True);

  WSCvlabel* sp1 = new WSCvlabel(_area1,"md-lb");
  sp1->setInternalObject(True);
  sp1->initialize();
  WSGFsetGeometry(sp1,0,5,1280,2);
  sp1->setProperty(WSNtopShadowColor,WS_DF_TOPSHADOWCOLOR);
  sp1->setProperty(WSNbottomShadowColor,WS_DF_BOTTOMSHADOWCOLOR);
  sp1->setVisible(True);

  _label = new WSCvlabel(_area1,"md-lb");
  _label->setInternalObject(True);
  _label->initialize();
  _label->setPropertyV(WSNx,     (short)1);
  _label->setPropertyV(WSNy,     (short)7);
//  _label->setPropertyV(WSNforeColor,"black");
  _label->setPropertyV(WSNmaxLength,(WSCushort)128);
//  _label->setPropertyV(WSNbackColor,WSGFcolor("gray80"));
  _label->setPropertyV(WSNlabelString,_label_string);
  _label->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  _label->setVisible(True);

  onGuiPolicyChange(WSGIappDev()->getGuiPolicy());

  return WS_NO_ERR;
}

void WSCmessageDialog::adjustForm(){
  WSCbaseDialog::adjustForm();
  if(_area1 != NULL){
    long diff = 0;
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
      diff = 0;
    }else
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
      diff = 5;
    }
    if (_w > 2){
      _area1->setPropertyV(WSNwidth, (WSCushort)(_w));
    }else{
      _area1->setPropertyV(WSNwidth, (WSCushort)(1));
    }
    if (_h+diff > 45){
      _area1->setPropertyV(WSNheight,(WSCushort)(_h+diff - 45));
      _label->setPropertyV(WSNheight,(WSCushort)(_h+diff - 58));
    }else{
      _area1->setPropertyV(WSNheight,(WSCushort)(1));
      _label->setPropertyV(WSNheight,(WSCushort)(1));
    }
    if (_w > 20){
      _label->setPropertyV(WSNwidth,(WSCushort)(_w-2));
    }else{
      _label->setPropertyV(WSNwidth,(WSCushort)(1));
    }
  }  
}
void WSCmessageDialog::onActivate(){
  WSCbaseDialog::onActivate();
  if (getStatus() != WS_DIALOG_CANCEL){
    _popuped = 0;
    setVisible(False);
  }
}
void WSCmessageDialog::onGuiPolicyChange(long policy){
  if (_area1 != NULL){
    WSCbaseDialog::onGuiPolicyChange(policy);
    if (policy & WS_POLICY_ORIGINAL){
      _area1->setProperty(WSNy,5);
      _area1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    }else{
      _area1->setProperty(WSNy,0);
      _area1->setPropertyV(WSNshadowThickness,(WSCuchar)0);
    }
    adjustForm();
  }
}


