//
// Copyright (C) 1999-2003 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <advance/WSCprojectEditor.h>
#include <WSCclassInformation.h>
#include <WSDdev.h>
#include <WSCdevice.h>
#include <WSCform.h>
#include <WSCvlabel.h>
#include <WSCindexForm.h>
#include <WSCvifield.h>
#include <WSCvslider.h>
#include <WSCvtoggle.h>
#include <WSCvbtn.h>
#include <WSClist.h>
#include <WSCindexData.h>
#include <WSCmessageDialog.h>
#include <WSCfileSelect.h>
#include <WSDexternal.h>
#include <advance/WSCobjectBox.h>
#include <WSCfontSet.h>
#include <WSDappDev.h>
#include <WSCoption.h>
#include <WSCvradio.h>
#include <WSClocaleSet.h>
#include <WSCfileSelect.h>

WSMFguiClassInitialize(WSCprojectEditor,WSCbaseDialog);
WSMFversion(WSCprojectEditor,WSCbaseDialog);

#define D_BTN_WIDTH 80
WSMFpropertyValueChange(WSCprojectEditor,WSNno,WSCbool,False);

WSCprojectEditor::WSCprojectEditor(WSCbase* base,char* objname):
                WSCbaseDialog(base,objname){

//  _file_name = WSGFstrdup("");
//  _file_name2 = WSGFstrdup("");
  _area1 = NULL;
  _no = 0;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCprojectEditor);
    WSMFpropertyValueChangeDef(WSCprojectEditor,WSNno,WSCbool);
    WSMFparentCheckVerSrc(WSCprojectEditor);
  WSMFpropertyCreateEnd
}

WSCprojectEditor::~WSCprojectEditor(){
  long i;
  long num = _project_data.getNum();
  for(i=0; i<num; i++){
    char* data = (char*)_project_data.getData(i);
    delete data;
  }
}

void _set_visible(WSCbase* base){
  base->setInternalObject(True);
  base->setVisible(True);
  long i;
  WSClistData children = base->getChildren();
  long num = children.getNum();
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      _set_visible(child);
    }
  }
}


long WSCprojectEditor::initialize(){
  WSCbaseDialog::initialize();
  _area1 = new WSCform(this,"pe-area");
  _area1->setInternalObject(True);
  _area1->initialize();
  _area1->setInternalObject(True);
  _area1->setPropertyV(WSNx,     (short)1 );
  _area1->setPropertyV(WSNy,     (short)5 );
  _area1->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _area1->setVisible(True);

  _area2 = new WSCindexForm(_area1,"pe-index");
  _area2->setInternalObject(True);
  _area2->initialize();
  _area2->setInternalObject(True);
  _area2->setPropertyV(WSNx,     (short)5 );
  _area2->setPropertyV(WSNy,     (short)15 );
  _area2->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _area2->setPropertyV(WSNmenuItems,WSGFgettext("D3:WSSTR Defaults,Environments,Imports,Compiling,Linking,Fonts,Etc.."));
  _area2->setVisible(True);

//page1
    _pe_lb2 = new  WSCvlabel(_area2,"_pe_lb2");
    _pe_lb2->initialize();
    _pe_lb2->setPropertyV(WSNlabelString,WSGFgettext("F3:WSSTR Default size"));
    _pe_lb2->setPropertyV(WSNuserValue,(long)1);
    WSGFsetGeometry(_pe_lb2,5,30,150,20);
    WSGFsetMargin(_pe_lb2,0);

    _pe_sl1 = new  WSCvslider(_area2,"_pe_sl1");
    _pe_sl1->initialize();
    _pe_sl1->setPropertyV(WSNsliderSize,(WSCushort)15);
    _pe_sl1->setPropertyV(WSNmaximum,(short)500);
    _pe_sl1->setPropertyV(WSNminimum,(short)5);
    _pe_sl1->setPropertyV(WSNdragInterval,(WSCushort)5);
    _pe_sl1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_sl1->setPropertyV(WSNvalue,(short)10);
    _pe_sl1->setPropertyV(WSNuserValue,(long)1);
    WSGFsetGeometry(_pe_sl1,215,30,110,20);
    WSCprocedure* op__pe_sl1_0 = new WSCprocedure("WSNx-valuech",WSEV_VALUE_CH);
    op__pe_sl1_0->setFunction(_sldnum_op,"_sldnum_op");
    _pe_sl1->addProcedure(op__pe_sl1_0);

    _pe_sl2 = new  WSCvslider(_area2,"_pe_sl2");
    _pe_sl2->initialize();
    _pe_sl2->setPropertyV(WSNsliderSize,(WSCushort)15);
    _pe_sl2->setPropertyV(WSNmaximum,(short)500);
    _pe_sl2->setPropertyV(WSNminimum,(short)5);
    _pe_sl2->setPropertyV(WSNdragInterval,(WSCushort)5);
    _pe_sl2->setPropertyV(WSNvalue,(short)5);
    _pe_sl2->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_sl2->setPropertyV(WSNuserValue,(long)1);
    WSGFsetGeometry(_pe_sl2,215,50,110,20);
    WSCprocedure* op__pe_sl2_0 = new WSCprocedure("WSNy-valuech",WSEV_VALUE_CH);
    op__pe_sl2_0->setFunction(_sldnum_op,"_sldnum_op");
    _pe_sl2->addProcedure(op__pe_sl2_0);

    _pe_sl3 = new  WSCvslider(_area2,"_pe_sl3");
    _pe_sl3->initialize();
    _pe_sl3->setPropertyV(WSNsliderSize,(WSCushort)15);
    _pe_sl3->setPropertyV(WSNmaximum,(short)10);
    _pe_sl3->setPropertyV(WSNdragInterval,(WSCushort)5);
    _pe_sl3->setPropertyV(WSNvalue,(short)5);
    _pe_sl3->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_sl3->setPropertyV(WSNuserValue,(long)1);
    WSGFsetGeometry(_pe_sl3,215,70,110,20);
    WSCprocedure* op__pe_sl3_0 = new WSCprocedure("WSNwidth-valuech",WSEV_VALUE_CH);
    op__pe_sl3_0->setFunction(_sldnum_op,"_sldnum_op");
    _pe_sl3->addProcedure(op__pe_sl3_0);

    _pe_sl5 = new  WSCvslider(_area2,"_pe_sl5");
    _pe_sl5->initialize();
    _pe_sl5->setPropertyV(WSNsliderSize,(WSCushort)15);
    _pe_sl5->setPropertyV(WSNmaximum,(short)50);
    _pe_sl5->setPropertyV(WSNminimum,(short)1);
    _pe_sl5->setPropertyV(WSNdragInterval,(WSCushort)1);
    _pe_sl5->setPropertyV(WSNvalue,(short)1);
    _pe_sl5->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_sl5->setPropertyV(WSNuserValue,(long)1);
    WSGFsetGeometry(_pe_sl5,215,100,130,20);
    WSCprocedure* op__pe_sl5_0 = new WSCprocedure("gridx-valuech",WSEV_VALUE_CH);
    op__pe_sl5_0->setFunction(_sldnum_op,"_sldnum_op");
    _pe_sl5->addProcedure(op__pe_sl5_0);

    _pe_sl6 = new  WSCvslider(_area2,"_pe_sl6");
    _pe_sl6->initialize();
    _pe_sl6->setPropertyV(WSNsliderSize,(WSCushort)15);
    _pe_sl6->setPropertyV(WSNmaximum,(short)50);
    _pe_sl6->setPropertyV(WSNminimum,(short)1);
    _pe_sl6->setPropertyV(WSNdragInterval,(WSCushort)1);
    _pe_sl6->setPropertyV(WSNvalue,(short)1);
    _pe_sl6->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_sl6->setPropertyV(WSNuserValue,(long)1);
    WSGFsetGeometry(_pe_sl6,215,120,130,20);
    WSCprocedure* op__pe_sl6_0 = new WSCprocedure("gridy-valuech",WSEV_VALUE_CH);
    op__pe_sl6_0->setFunction(_sldnum_op,"_sldnum_op");
    _pe_sl6->addProcedure(op__pe_sl6_0);

    _pe_if1 = new  WSCvifield(_area2,"_pe_if1");
    _pe_if1->initialize();
    _pe_if1->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_if1->setPropertyV(WSNshadowType,(char)1);
    _pe_if1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_if1->setPropertyV(WSNmaxLength,(WSCushort)5);
    _pe_if1->setUserData("SLD",(void*)_pe_sl1);
    _pe_if1->setPropertyV(WSNuserValue,(long)1);
    _pe_sl1->setUserData("IFD",(void*)_pe_if1);
    _object_index["#DWIDTH"] = (void*)((WSCbase*)_pe_if1);
    WSGFsetGeometry(_pe_if1,160,30,50,20);

    WSCprocedure* op__pe_if1_0 = new WSCprocedure("Values",WSEV_ACTIVATE);
    op__pe_if1_0->setFunction(_ifnum_op,"_ifnumop");
    _pe_if1->addProcedure(op__pe_if1_0);

    _pe_if2 = new  WSCvifield(_area2,"_pe_if2");
    _pe_if2->initialize();
    _pe_if2->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_if2->setPropertyV(WSNshadowType,(char)1);
    _pe_if2->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_if2->setPropertyV(WSNmaxLength,(WSCushort)5);
    _pe_if2->setUserData("SLD",(void*)_pe_sl2);
    _pe_if2->setPropertyV(WSNuserValue,(long)1);
    _pe_sl2->setUserData("IFD",(void*)_pe_if2);
    _object_index["#DHEIGHT"] = (void*)((WSCbase*)_pe_if2);
    WSGFsetGeometry(_pe_if2,160,50,50,20);

    WSCprocedure* op__pe_if2_0 = new WSCprocedure("Values",WSEV_ACTIVATE);
    op__pe_if2_0->setFunction(_ifnum_op,"_ifnum_op");
    _pe_if2->addProcedure(op__pe_if2_0);

    _pe_if3 = new  WSCvifield(_area2,"_pe_if3");
    _pe_if3->initialize();
    _pe_if3->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_if3->setPropertyV(WSNshadowType,(char)1);
    _pe_if3->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_if3->setPropertyV(WSNmaxLength,(WSCushort)5);
    _pe_if3->setUserData("SLD",(void*)_pe_sl3);
    _pe_if3->setPropertyV(WSNuserValue,(long)1);
    _pe_sl3->setUserData("IFD",(void*)_pe_if3);
    _object_index["#DTHICKNESS"] = (void*)((WSCbase*)_pe_if3);
    WSGFsetGeometry(_pe_if3,160,70,50,20);

    WSCprocedure* op__pe_if3_0 = new WSCprocedure("Values",WSEV_ACTIVATE);
    op__pe_if3_0->setFunction(_ifnum_op,"_ifnum_op");
    _pe_if3->addProcedure(op__pe_if3_0);

    _pe_gt1 = new  WSCvlabel(_area2,"_pe_gt1");
    _pe_gt1->initialize();
    _pe_gt1->setPropertyV(WSNlabelString,":WSNwidth");
    _pe_gt1->setPropertyV(WSNalignmentH,(WSCuchar)0);
    _pe_gt1->setPropertyV(WSNuserValue,(long)1);
    WSGFsetGeometry(_pe_gt1,330,30,80,20);
    WSGFsetMargin(_pe_gt1,0);
    _pe_gt1->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);

    _pe_gt2 = new  WSCvlabel(_area2,"_pe_gt2");
    _pe_gt2->initialize();
    _pe_gt2->setPropertyV(WSNlabelString,":WSNheight");
    _pe_gt2->setPropertyV(WSNalignmentH,(WSCuchar)0);
    _pe_gt2->setPropertyV(WSNuserValue,(long)1);
    WSGFsetGeometry(_pe_gt2,330,50,80,20);
    WSGFsetMargin(_pe_gt2,0);
    _pe_gt2->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);

    _pe_gt3 = new  WSCvlabel(_area2,"_pe_gt3");
    _pe_gt3->initialize();
    _pe_gt3->setPropertyV(WSNlabelString,":WSNshadowThickness");
    _pe_gt3->setPropertyV(WSNalignmentH,(WSCuchar)0);
    _pe_gt3->setPropertyV(WSNuserValue,(long)1);
    WSGFsetGeometry(_pe_gt3,330,70,180,20);
    WSGFsetMargin(_pe_gt3,0);
    _pe_gt3->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);

    WSCvlabel* _pe_sp2 = new  WSCvlabel(_area2,"_pe_sp2");
    _pe_sp2->initialize();
    _pe_sp2->setPropertyV(WSNshadowType,(char)1);
    _pe_sp2->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_sp2->setProperty(WSNtopShadowColor,WS_DF_TOPSHADOWCOLOR);
    _pe_sp2->setProperty(WSNbottomShadowColor,WS_DF_BOTTOMSHADOWCOLOR);
    _pe_sp2->setPropertyV(WSNuserValue,(long)1);
    WSGFsetGeometry(_pe_sp2,0,95,1280,2);

    WSCvlabel* _pe_lb3 = new  WSCvlabel(_area2,"_pe_lb3");
    _pe_lb3->initialize();
    _pe_lb3->setPropertyV(WSNlabelString,WSGFgettext("G3:WSSTR Grid size"));
    _pe_lb3->setPropertyV(WSNuserValue,(long)1);
    WSGFsetGeometry(_pe_lb3,5,100,150,20);
    WSGFsetMargin(_pe_lb3,0);

    _pe_if5 = new  WSCvifield(_area2,"_pe_if5");
    _pe_if5->initialize();
    _pe_if5->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_if5->setPropertyV(WSNshadowType,(char)1);
    _pe_if5->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_if5->setPropertyV(WSNmaxLength,(WSCushort)5);
    WSGFsetGeometry(_pe_if5,160,100,50,20);
    _pe_if5->setUserData("SLD",(void*)_pe_sl5);
    _pe_if5->setPropertyV(WSNuserValue,(long)1);
    _pe_sl5->setUserData("IFD",(void*)_pe_if5);
    WSCprocedure* op__pe_if5_0 = new WSCprocedure("",WSEV_VALUE_CH);
    op__pe_if5_0->setFunction(_ifnum_op,"_ifnum_op");
    _pe_if5->addProcedure(op__pe_if5_0);
    _object_index["#GRIDX"] = (void*)((WSCbase*)_pe_if5);
    _pe_if5->setUserData("GRIDX",(void*)1);
    

    _pe_if6 = new  WSCvifield(_area2,"_pe_if6");
    _pe_if6->initialize();
    _pe_if6->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_if6->setPropertyV(WSNshadowType,(char)1);
    _pe_if6->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_if6->setPropertyV(WSNmaxLength,(WSCushort)5);
    WSGFsetGeometry(_pe_if6,160,120,50,20);
    _pe_if6->setUserData("SLD",(void*)_pe_sl6);
    _pe_if6->setPropertyV(WSNuserValue,(long)1);
    _pe_sl6->setUserData("IFD",(void*)_pe_if6);
    _pe_if6->setUserData("GRIDY",(void*)1);

    WSCprocedure* op__pe_if6_0 = new WSCprocedure("Values",WSEV_VALUE_CH);
    op__pe_if6_0->setFunction(_ifnum_op,"_ifnum_op");
    _pe_if6->addProcedure(op__pe_if6_0);
    _object_index["#GRIDY"] = (void*)((WSCbase*)_pe_if6);

    WSCvlabel* _pe_gt5 = new  WSCvlabel(_area2,"_pe_gt5");
    _pe_gt5->initialize();
    _pe_gt5->setPropertyV(WSNlabelString,WSGFgettext("H3:WSSTR :Horizontal"));
    _pe_gt5->setPropertyV(WSNalignmentH,(WSCuchar)0);
    _pe_gt5->setPropertyV(WSNuserValue,(long)1);
    WSGFsetGeometry(_pe_gt5,350,100,180,20);
    _pe_gt5->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
    WSGFsetMargin(_pe_gt5,0);

    WSCvlabel* _pe_tg6 = new  WSCvlabel(_area2,"_pe_tg6");
    _pe_tg6->initialize();
    _pe_tg6->setPropertyV(WSNlabelString,WSGFgettext("I3:WSSTR :Vertical"));
    _pe_tg6->setPropertyV(WSNalignmentH,(WSCuchar)0);
    _pe_tg6->setPropertyV(WSNuserValue,(long)1);
    WSGFsetGeometry(_pe_tg6,350,120,180,20);
    _pe_tg6->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
    WSGFsetMargin(_pe_tg6,0);

    WSCvlabel* _pe_sp3 = new  WSCvlabel(_area2,"_pe_sp3");
    _pe_sp3->initialize();
    _pe_sp3->setPropertyV(WSNshadowType,(char)1);
    _pe_sp3->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_sp3->setProperty(WSNtopShadowColor,WS_DF_TOPSHADOWCOLOR);
    _pe_sp3->setProperty(WSNbottomShadowColor,WS_DF_BOTTOMSHADOWCOLOR);
    _pe_sp3->setPropertyV(WSNuserValue,(long)1);
    WSGFsetGeometry(_pe_sp3,0,145,1280,2);

    WSCvlabel* _pe_lab009 = new  WSCvlabel(_area2,"_pe_lab009");
    _pe_lab009->initialize();
    _pe_lab009->setPropertyV(WSNlabelString,WSGFgettext("J3:WSSTR Base Window"));
    _pe_lab009->setPropertyV(WSNuserValue,(long)1);
    WSGFsetGeometry(_pe_lab009,5,150,150,20);
    WSGFsetMargin(_pe_lab009,0);

    _pe_ifi004 = new  WSCvifield(_area2,"_pe_ifi004");
    _pe_ifi004->initialize();
    _pe_ifi004->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_ifi004->setPropertyV(WSNshadowType,(char)1);
    _pe_ifi004->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_ifi004->setPropertyV(WSNuserValue,(long)1);
    _pe_ifi004->setPropertyV(WSNmaxLength,(WSCushort)0);
    WSGFsetGeometry(_pe_ifi004,160,150,275,20);
    _object_index["#WINC_NAME"] = (void*)((WSCbase*)_pe_ifi004);


//page3
    WSCvlabel* _pe_lb4 = new  WSCvlabel(_area2,"_pe_lb4");
    _pe_lb4->initialize();
    _pe_lb4->setPropertyV(WSNlabelString,WSGFgettext("K3:WSSTR Import Libraries"));
    _pe_lb4->setPropertyV(WSNuserValue,(long)3);
    WSGFsetGeometry(_pe_lb4,5,30,150,20);
    WSGFsetMargin(_pe_lb4,0);

    _pe_elist = new WSClist(_area2,"_pe_elist");
    _pe_elist->initialize();
    WSGFsetGeometry(_pe_elist,160,30,275,200);
    _pe_elist->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    _pe_elist->setPropertyV(WSNuserValue,(long)3);
    _object_index["#WS_DLL"] = (void*)((WSCbase*)_pe_elist);

    _pe_bt1 = new  WSCvbtn(_area2,"_pe_bt1");
    _pe_bt1->initialize();
    _pe_bt1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_bt1->setPropertyV(WSNlabelString,WSGFgettext("L3:WSSTR Add"));
    _pe_bt1->setPropertyV(WSNlabelPixmap,"$(WSDIR)/sys/pixmaps/tbtn2.xpm");
    WSGFsetGeometry(_pe_bt1,5,55,75,25);
    _pe_bt1->setPropertyV(WSNuserValue,(long)3);
    WSGFsetMargin(_pe_bt1,0);
    _pe_bt1->setUserData("THIS",(void*)this);

    WSCprocedure* op__pe_bt1_0 = new WSCprocedure("Add library",WSEV_ACTIVATE);
    op__pe_bt1_0->setFunction(_pe_btn1_work,"_pe_btn1_work");
    _pe_bt1->addProcedure(op__pe_bt1_0);

    _pe_btn3 = new  WSCvbtn(_area2,"_pe_btn3");
    _pe_btn3->initialize();
    _pe_btn3->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_btn3->setPropertyV(WSNlabelString,WSGFgettext("M3:WSSTR Delete"));
    _pe_btn3->setPropertyV(WSNlabelPixmap,"$(WSDIR)/sys/pixmaps/tbtn2.xpm");
    WSGFsetGeometry(_pe_btn3,80,55,75,25);
    _pe_btn3->setPropertyV(WSNuserValue,(long)3);
    WSGFsetMargin(_pe_btn3,0);
    _pe_btn3->setUserData("THIS",(void*)this);

    WSCprocedure* op__pe_btn3_0 = new WSCprocedure("Delete library",WSEV_ACTIVATE);
    op__pe_btn3_0->setFunction(_pe_btn3_work,"_pe_btn3_work");
    _pe_btn3->addProcedure(op__pe_btn3_0);

//page2

    WSCvlabel* _pe_lab002 = new  WSCvlabel(_area2,"_pe_lab002");
    _pe_lab002->initialize();
    _pe_lab002->setPropertyV(WSNlabelString,WSGFgettext("N3:WSSTR Terminal"));
    _pe_lab002->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(_pe_lab002,6,30,150,20);
    WSGFsetMargin(_pe_lab002,0);

    _pe_ifi002 = new  WSCvifield(_area2,"_pe_ifi002");
    _pe_ifi002->initialize();
    _pe_ifi002->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_ifi002->setPropertyV(WSNshadowType,(char)1);
    _pe_ifi002->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_ifi002->setPropertyV(WSNmaxLength,(WSCushort)0);
    _pe_ifi002->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(_pe_ifi002,160,30,275,20);
    _object_index2["#TERMINAL"] = (void*)((WSCbase*)_pe_ifi002);

    WSCvbtn* _pe_ifi001_bt = new  WSCvbtn(_area2,"_pe_ifi001_bt");
    _pe_ifi001_bt->initialize();
    _pe_ifi001_bt->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_ifi001_bt->setPropertyV(WSNshadowType,(char)1);
    _pe_ifi001_bt->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_ifi001_bt->setPropertyV(WSNlabelString,"..");
    _pe_ifi001_bt->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(_pe_ifi001_bt,440,30,20,20);
    _pe_ifi001_bt->setUserData("this",(void*)this);

    WSCprocedure* pe_fbt1 = new WSCprocedure("Values",WSEV_ACTIVATE);
    pe_fbt1->setFunction(_pe_fbt1_work,"_pe_fbt1_work");
    _pe_ifi001_bt->addProcedure(pe_fbt1);

    WSCvbtn* _pe_ifi002_bt = new  WSCvbtn(_area2,"_pe_ifi002_bt");
    _pe_ifi002_bt->initialize();
    _pe_ifi002_bt->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_ifi002_bt->setPropertyV(WSNshadowType,(char)1);
    _pe_ifi002_bt->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_ifi002_bt->setPropertyV(WSNlabelString,"..");
    _pe_ifi002_bt->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(_pe_ifi002_bt,340,55,20,20);
    _pe_ifi002_bt->setUserData("this",(void*)this);

    WSCprocedure* pe_fbt2 = new WSCprocedure("Values",WSEV_ACTIVATE);
    pe_fbt2->setFunction(_pe_fbt2_work,"_pe_fbt2_work");
    _pe_ifi002_bt->addProcedure(pe_fbt2);

    WSCvbtn* _pe_ifi003_bt = new  WSCvbtn(_area2,"_pe_ifi003_bt");
    _pe_ifi003_bt->initialize();
    _pe_ifi003_bt->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_ifi003_bt->setPropertyV(WSNshadowType,(char)1);
    _pe_ifi003_bt->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_ifi003_bt->setPropertyV(WSNlabelString,"..");
    _pe_ifi003_bt->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(_pe_ifi003_bt,440,80,20,20);
    _pe_ifi003_bt->setUserData("this",(void*)this);

    WSCprocedure* pe_fbt3 = new WSCprocedure("Values",WSEV_ACTIVATE);
    pe_fbt3->setFunction(_pe_fbt3_work,"_pe_fbt3_work");
    _pe_ifi003_bt->addProcedure(pe_fbt3);

    WSCvbtn* _pe_ifi004_bt = new  WSCvbtn(_area2,"_pe_ifi004_bt");
    _pe_ifi004_bt->initialize();
    _pe_ifi004_bt->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_ifi004_bt->setPropertyV(WSNshadowType,(char)1);
    _pe_ifi004_bt->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_ifi004_bt->setPropertyV(WSNlabelString,"..");
    _pe_ifi004_bt->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(_pe_ifi004_bt,440,105,20,20);
    _pe_ifi004_bt->setUserData("this",(void*)this);

    WSCprocedure* pe_fbt4 = new WSCprocedure("Values",WSEV_ACTIVATE);
    pe_fbt4->setFunction(_pe_fbt4_work,"_pe_fbt4_work");
    _pe_ifi004_bt->addProcedure(pe_fbt4);

    WSCvbtn* _pe_ifi005_bt = new  WSCvbtn(_area2,"_pe_ifi005_bt");
    _pe_ifi005_bt->initialize();
    _pe_ifi005_bt->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_ifi005_bt->setPropertyV(WSNshadowType,(char)1);
    _pe_ifi005_bt->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_ifi005_bt->setPropertyV(WSNlabelString,"..");
    _pe_ifi005_bt->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(_pe_ifi005_bt,440,130,20,20);
    _pe_ifi005_bt->setUserData("this",(void*)this);

    WSCprocedure* pe_fbt5 = new WSCprocedure("Values",WSEV_ACTIVATE);
    pe_fbt5->setFunction(_pe_fbt5_work,"_pe_fbt5_work");
    _pe_ifi005_bt->addProcedure(pe_fbt5);

    WSCvbtn* _pe_ifi006_bt = new  WSCvbtn(_area2,"_pe_ifi006_bt");
    _pe_ifi006_bt->initialize();
    _pe_ifi006_bt->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_ifi006_bt->setPropertyV(WSNshadowType,(char)1);
    _pe_ifi006_bt->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_ifi006_bt->setPropertyV(WSNlabelString,"..");
    _pe_ifi006_bt->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(_pe_ifi006_bt,440,155,20,20);
    _pe_ifi006_bt->setUserData("this",(void*)this);

    WSCprocedure* pe_fbt6 = new WSCprocedure("Values",WSEV_ACTIVATE);
    pe_fbt6->setFunction(_pe_fbt6_work,"_pe_fbt6_work");
    _pe_ifi006_bt->addProcedure(pe_fbt6);

    WSCvbtn* _pe_ifi007_bt = new  WSCvbtn(_area2,"_pe_ifi007_bt");
    _pe_ifi007_bt->initialize();
    _pe_ifi007_bt->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_ifi007_bt->setPropertyV(WSNshadowType,(char)1);
    _pe_ifi007_bt->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_ifi007_bt->setPropertyV(WSNlabelString,"..");
    _pe_ifi007_bt->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(_pe_ifi007_bt,440,180,20,20);
    _pe_ifi007_bt->setUserData("this",(void*)this);

    WSCprocedure* pe_fbt7 = new WSCprocedure("Values",WSEV_ACTIVATE);
    pe_fbt7->setFunction(_pe_fbt7_work,"_pe_fbt7_work");
    _pe_ifi007_bt->addProcedure(pe_fbt7);

    WSCvbtn* _pe_ifi008_bt = new  WSCvbtn(_area2,"_pe_ifi008_bt");
    _pe_ifi008_bt->initialize();
    _pe_ifi008_bt->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_ifi008_bt->setPropertyV(WSNshadowType,(char)1);
    _pe_ifi008_bt->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_ifi008_bt->setPropertyV(WSNlabelString,"..");
    _pe_ifi008_bt->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(_pe_ifi008_bt,440,205,20,20);
    _pe_ifi008_bt->setUserData("this",(void*)this);

    WSCprocedure* pe_fbt8 = new WSCprocedure("Values",WSEV_ACTIVATE);
    pe_fbt8->setFunction(_pe_fbt8_work,"_pe_fbt8_work");
    _pe_ifi008_bt->addProcedure(pe_fbt8);

    WSCvbtn* _pe_ifi009_bt = new  WSCvbtn(_area2,"_pe_ifi009_bt");
    _pe_ifi009_bt->initialize();
    _pe_ifi009_bt->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_ifi009_bt->setPropertyV(WSNshadowType,(char)1);
    _pe_ifi009_bt->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_ifi009_bt->setPropertyV(WSNlabelString,"..");
    _pe_ifi009_bt->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(_pe_ifi009_bt,440,230,20,20);
    _pe_ifi009_bt->setUserData("this",(void*)this);

    WSCprocedure* pe_fbt9 = new WSCprocedure("Values",WSEV_ACTIVATE);
    pe_fbt9->setFunction(_pe_fbt9_work,"_pe_fbt9_work");
    _pe_ifi009_bt->addProcedure(pe_fbt9);

    WSCvlabel* _pe_lab007 = new  WSCvlabel(_area2,"_pe_lab007");
    _pe_lab007->initialize();
    _pe_lab007->setPropertyV(WSNlabelString,WSGFgettext("O3:WSSTR Source editor"));
    _pe_lab007->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(_pe_lab007,5,55,150,20);
    WSGFsetMargin(_pe_lab007,0);

    _pe_ifi003 = new  WSCvifield(_area2,"_pe_ifi003");
    _pe_ifi003->initialize();
    _pe_ifi003->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_ifi003->setPropertyV(WSNshadowType,(char)1);
    _pe_ifi003->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_ifi003->setPropertyV(WSNmaxLength,(WSCushort)0);
    _pe_ifi003->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(_pe_ifi003,160,55,175,20);
    _object_index2["#EDITOR_NAME"] = (void*)((WSCbase*)_pe_ifi003);

    WSCvlabel* _pe_lab_etype = new  WSCvlabel(_area2,"_pe_lab_etype");
    _pe_lab_etype->initialize();
    _pe_lab_etype->setPropertyV(WSNlabelString,WSGFgettext("O3:WSSTR Editor options"));
    _pe_lab_etype->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(_pe_lab_etype,370,55,145,20);
    WSGFsetMargin(_pe_lab_etype,0);

    _pe_ifi012 = new  WSCvifield(_area2,"_pe_ifi012");
    _pe_ifi012->initialize();
    _pe_ifi012->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_ifi012->setPropertyV(WSNshadowType,(char)1);
    _pe_ifi012->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_ifi012->setPropertyV(WSNmaxLength,(WSCushort)0);
    _pe_ifi012->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(_pe_ifi012,520,55,100,20);
    _object_index2["#EDITOR_OPTION"] = (void*)((WSCbase*)_pe_ifi012);

    _opt3 = new  WSCoption(_area2,"fdiavopt3");
    _opt3->initialize();
    WSGFsetGeometry(_opt3,625,55,120,20);
    _opt3->setPropertyV(WSNuserValue,(long)2);
    _opt3->setProperty(WSNshadowThickness,1);
    _opt3->setVisible(True);
    _opt3->setUserData("this",(void*)this);

    WSCprocedure* op_eop = new WSCprocedure("editor-opt",WSEV_VALUE_CH);
    op_eop->setFunction(_editor_option_work,"_editor_option_work");
    _opt3->addProcedure(op_eop);


    WSCvlabel* _pe_lab011 = new  WSCvlabel(_area2,"_pe_lab011");
    _pe_lab011->initialize();
    _pe_lab011->setPropertyV(WSNlabelString,WSGFgettext("P3:WSSTR Web browser"));
    _pe_lab011->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(_pe_lab011,5,80,150,20);
    WSGFsetMargin(_pe_lab011,0);

    _pe_ifi005 = new  WSCvifield(_area2,"_pe_ifi005");
    _pe_ifi005->initialize();
    _pe_ifi005->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_ifi005->setPropertyV(WSNshadowType,(char)1);
    _pe_ifi005->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_ifi005->setPropertyV(WSNuserValue,(long)2);
    _pe_ifi005->setPropertyV(WSNmaxLength,(WSCushort)0);
    WSGFsetGeometry(_pe_ifi005,160,80,275,20);
    _object_index2["#WEBB_NAME"] = (void*)((WSCbase*)_pe_ifi005);

    WSCvlabel* _pe_lab012 = new  WSCvlabel(_area2,"_pe_lab012");
    _pe_lab012->initialize();
    _pe_lab012->setPropertyV(WSNlabelString,WSGFgettext("P3:WSSTR Ruby"));
    _pe_lab012->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(_pe_lab012,5,105,150,20);
    WSGFsetMargin(_pe_lab012,0);

    _pe_ifi006 = new  WSCvifield(_area2,"_pe_ifi006");
    _pe_ifi006->initialize();
    _pe_ifi006->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_ifi006->setPropertyV(WSNshadowType,(char)1);
    _pe_ifi006->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_ifi006->setPropertyV(WSNuserValue,(long)2);
    _pe_ifi006->setPropertyV(WSNmaxLength,(WSCushort)0);
    WSGFsetGeometry(_pe_ifi006,160,105,275,20);
    _object_index2["#RUBY"] = (void*)((WSCbase*)_pe_ifi006);

    WSCvlabel* _pe_lab013 = new  WSCvlabel(_area2,"_pe_lab013");
    _pe_lab013->initialize();
    _pe_lab013->setPropertyV(WSNlabelString,WSGFgettext("P3:WSSTR Ruby(DBG)"));
    _pe_lab013->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(_pe_lab013,5,130,150,20);
    WSGFsetMargin(_pe_lab013,0);

    _pe_ifi007 = new  WSCvifield(_area2,"_pe_ifi007");
    _pe_ifi007->initialize();
    _pe_ifi007->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_ifi007->setPropertyV(WSNshadowType,(char)1);
    _pe_ifi007->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_ifi007->setPropertyV(WSNuserValue,(long)2);
    _pe_ifi007->setPropertyV(WSNmaxLength,(WSCushort)0);
    WSGFsetGeometry(_pe_ifi007,160,130,275,20);
    _object_index2["#RUBYD"] = (void*)((WSCbase*)_pe_ifi007);

    WSCvlabel* _pe_lab014 = new  WSCvlabel(_area2,"_pe_lab014");
    _pe_lab014->initialize();
    _pe_lab014->setPropertyV(WSNlabelString,WSGFgettext("P3:WSSTR Python"));
    _pe_lab014->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(_pe_lab014,5,155,150,20);
    WSGFsetMargin(_pe_lab014,0);

    _pe_ifi008 = new  WSCvifield(_area2,"_pe_ifi008");
    _pe_ifi008->initialize();
    _pe_ifi008->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_ifi008->setPropertyV(WSNshadowType,(char)1);
    _pe_ifi008->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_ifi008->setPropertyV(WSNuserValue,(long)2);
    _pe_ifi008->setPropertyV(WSNmaxLength,(WSCushort)0);
    WSGFsetGeometry(_pe_ifi008,160,155,275,20);
    _object_index2["#PYTHON"] = (void*)((WSCbase*)_pe_ifi008);

    WSCvlabel* _pe_lab015 = new  WSCvlabel(_area2,"_pe_lab015");
    _pe_lab015->initialize();
    _pe_lab015->setPropertyV(WSNlabelString,WSGFgettext("P3:WSSTR Python(DBG)"));
    _pe_lab015->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(_pe_lab015,5,180,150,20);
    WSGFsetMargin(_pe_lab015,0);

    _pe_ifi009 = new  WSCvifield(_area2,"_pe_ifi009");
    _pe_ifi009->initialize();
    _pe_ifi009->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_ifi009->setPropertyV(WSNshadowType,(char)1);
    _pe_ifi009->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_ifi009->setPropertyV(WSNuserValue,(long)2);
    _pe_ifi009->setPropertyV(WSNmaxLength,(WSCushort)0);
    WSGFsetGeometry(_pe_ifi009,160,180,275,20);
    _object_index2["#PYTHOND"] = (void*)((WSCbase*)_pe_ifi009);

    WSCvlabel* _pe_lab016 = new  WSCvlabel(_area2,"_pe_lab016");
    _pe_lab016->initialize();
    _pe_lab016->setPropertyV(WSNlabelString,WSGFgettext("P3:WSSTR Perl"));
    _pe_lab016->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(_pe_lab016,5,205,150,20);
    WSGFsetMargin(_pe_lab016,0);

    _pe_ifi010 = new  WSCvifield(_area2,"_pe_ifi008");
    _pe_ifi010->initialize();
    _pe_ifi010->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_ifi010->setPropertyV(WSNshadowType,(char)1);
    _pe_ifi010->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_ifi010->setPropertyV(WSNuserValue,(long)2);
    _pe_ifi010->setPropertyV(WSNmaxLength,(WSCushort)0);
    WSGFsetGeometry(_pe_ifi010,160,205,275,20);
    _object_index2["#PERL"] = (void*)((WSCbase*)_pe_ifi010);

    WSCvlabel* _pe_lab017 = new  WSCvlabel(_area2,"_pe_lab017");
    _pe_lab017->initialize();
    _pe_lab017->setPropertyV(WSNlabelString,WSGFgettext("P3:WSSTR Perl(DBG)"));
    _pe_lab017->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(_pe_lab017,5,230,150,20);
    WSGFsetMargin(_pe_lab017,0);

    _pe_ifi011 = new  WSCvifield(_area2,"_pe_ifi011");
    _pe_ifi011->initialize();
    _pe_ifi011->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_ifi011->setPropertyV(WSNshadowType,(char)1);
    _pe_ifi011->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_ifi011->setPropertyV(WSNuserValue,(long)2);
    _pe_ifi011->setPropertyV(WSNmaxLength,(WSCushort)0);
    WSGFsetGeometry(_pe_ifi011,160,230,275,20);
    _object_index2["#PERLD"] = (void*)((WSCbase*)_pe_ifi011);






//page4

    WSCvlabel* pe_lab001 = new  WSCvlabel(_area2,"_pe_lab005");
    pe_lab001->initialize();
    pe_lab001->setPropertyV(WSNlabelString,WSGFgettext("Q3:WSSTR Include path"));
    pe_lab001->setPropertyV(WSNuserValue,(long)4);
    WSGFsetGeometry(pe_lab001,5,30,150,20);
    WSGFsetMargin(pe_lab001,0);

    WSCvifield* pe_ifi001 = new  WSCvifield(_area2,"pe_ifi001");
    pe_ifi001->initialize();
    pe_ifi001->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    pe_ifi001->setPropertyV(WSNshadowType,(char)1);
    pe_ifi001->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    pe_ifi001->setPropertyV(WSNuserValue,(long)4);
    pe_ifi001->setPropertyV(WSNmaxLength,(WSCushort)0);
    WSGFsetGeometry(pe_ifi001,160,30,270,20);
    _object_index3["#USER_INCLUDE"] = (void*)((WSCbase*)pe_ifi001);

    WSCvlabel* pe_lab002 = new  WSCvlabel(_area2,"pe_lab001");
    pe_lab002->initialize();
    pe_lab002->setPropertyV(WSNlabelString,WSGFgettext("R3:WSSTR Compiler flags"));
    pe_lab002->setPropertyV(WSNuserValue,(long)4);
    WSGFsetGeometry(pe_lab002,5,55,150,20);
    WSGFsetMargin(pe_lab002,0);

    WSCvifield* pe_ifi002 = new  WSCvifield(_area2,"pe_ifi002");
    pe_ifi002->initialize();
    pe_ifi002->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    pe_ifi002->setPropertyV(WSNshadowType,(char)1);
    pe_ifi002->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    pe_ifi002->setPropertyV(WSNuserValue,(long)4);
    pe_ifi002->setPropertyV(WSNmaxLength,(WSCushort)0);
    WSGFsetGeometry(pe_ifi002,160,55,270,20);
    _object_index3["#USER_FL"] = (void*)((WSCbase*)pe_ifi002);


    WSCvlabel* pe_lab004 = new  WSCvlabel(_area2,"pe_lab002");
    pe_lab004->initialize();
    pe_lab004->setPropertyV(WSNlabelString,WSGFgettext("S3:WSSTR Compile mode"));
    pe_lab004->setPropertyV(WSNuserValue,(long)4);
    WSGFsetGeometry(pe_lab004,5,80,150,20);
    WSGFsetMargin(pe_lab004,0);

    WSCvtoggle* pe_tgl001 = new  WSCvtoggle(_area2,"pe_tgl001");
    pe_tgl001->initialize();
    pe_tgl001->setPropertyV(WSNindicatorSize,(WSCuchar)16);
    pe_tgl001->setPropertyV(WSNindicatorShadow,(WSCuchar)0);
    pe_tgl001->setPropertyV(WSNindicatorPixmap,"$(WSDIR)/sys/pixmaps/tbl1.xpm");
    pe_tgl001->setPropertyV(WSNselectPixmap,"$(WSDIR)/sys/pixmaps/tbl2.xpm");
    pe_tgl001->setPropertyV(WSNshadowThickness,(WSCuchar)0);
    pe_tgl001->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    pe_tgl001->setPropertyV(WSNlabelString,WSGFgettext("T3:WSSTR  Debug mode"));
    pe_tgl001->setPropertyV(WSNalignmentH,(WSCuchar)0);
    pe_tgl001->setPropertyV(WSNuserValue,(long)4);
    WSGFsetGeometry(pe_tgl001,160,77,270,25);
    _object_index["#CMODE"] = (void*)((WSCbase*)pe_tgl001);

    WSCvlabel* pe_lab005 = new  WSCvlabel(_area2,"pe_lab002");
    pe_lab005->initialize();
    pe_lab005->setPropertyV(WSNlabelString,WSGFgettext("U3:WSSTR Class library"));
    pe_lab005->setPropertyV(WSNuserValue,(long)4);
    WSGFsetGeometry(pe_lab005,5,105,150,20);
    WSGFsetMargin(pe_lab005,0);

    _pe_tgl007 = new  WSCvtoggle(_area2,"_pe_tgl007");
    _pe_tgl007->initialize();
    _pe_tgl007->setPropertyV(WSNindicatorSize,(WSCuchar)16);
    _pe_tgl007->setPropertyV(WSNindicatorShadow,(WSCuchar)0);
    _pe_tgl007->setPropertyV(WSNindicatorPixmap,"$(WSDIR)/sys/pixmaps/tbl1.xpm");
    _pe_tgl007->setPropertyV(WSNselectPixmap,"$(WSDIR)/sys/pixmaps/tbl2.xpm");
    _pe_tgl007->setPropertyV(WSNshadowThickness,(WSCuchar)0);
    _pe_tgl007->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    _pe_tgl007->setPropertyV(WSNlabelString,WSGFgettext("V3:WSSTR  Generate class library"));
    _pe_tgl007->setPropertyV(WSNalignmentH,(WSCuchar)0);
    _pe_tgl007->setPropertyV(WSNuserValue,(long)4);
    WSGFsetGeometry(_pe_tgl007,160,102,270,25);
    _object_index["#LIB_CREATE"] = (void*)((WSCbase*)_pe_tgl007);

    WSCvlabel* pe_lab003 = new  WSCvlabel(_area2,"pe_lab003");
    pe_lab003->initialize();
    pe_lab003->setPropertyV(WSNlabelString,WSGFgettext("W3:WSSTR Compiler"));
    pe_lab003->setPropertyV(WSNuserValue,(long)4);
    WSGFsetGeometry(pe_lab003,5,130,150,20);
    WSGFsetMargin(pe_lab003,0);

    WSCvifield* pe_ifi003 = new  WSCvifield(_area2,"pe_ifi003");
    pe_ifi003->initialize();
    pe_ifi003->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    pe_ifi003->setPropertyV(WSNshadowType,(char)1);
    pe_ifi003->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    pe_ifi003->setPropertyV(WSNuserValue,(long)4);
    pe_ifi003->setPropertyV(WSNmaxLength,(WSCushort)0);

    WSGFsetGeometry(pe_ifi003,160,130,270,20);
    _object_index3["#CC"] = (void*)((WSCbase*)pe_ifi003);


    WSCvlabel* pe_lab004c = new  WSCvlabel(_area2,"pe_lab004c");
    pe_lab004c->initialize();
    pe_lab004c->setPropertyV(WSNlabelString,WSGFgettext("W3:WSSTR OBJS"));
    pe_lab004c->setPropertyV(WSNuserValue,(long)4);
    WSGFsetGeometry(pe_lab004c,5,160,150,20);
    WSGFsetMargin(pe_lab004c,0);

    _pe_obj1 = new  WSCvifield(_area2,"_pe_obj1");
    _pe_obj1->initialize();
    _pe_obj1->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    _pe_obj1->setPropertyV(WSNshadowType,(char)1);
    _pe_obj1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _pe_obj1->setPropertyV(WSNuserValue,(long)4);
    _pe_obj1->setPropertyV(WSNmaxLength,(WSCushort)0);

    WSGFsetGeometry(_pe_obj1,160,160,270,20);
    _object_index["#OBJS"] = (void*)((WSCbase*)_pe_obj1);

    index002 = new WSCindexForm(_area2,"index002");
    index002->initialize();
    WSGFsetGeometry(index002,5,190,470,85);
    index002->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    index002->setPropertyV(WSNmenuItems,WSGFgettext("X3:WSSTR Runtime mode,Debug mode"));
    index002->setPropertyV(WSNuserValue,(long)4);

    //page4-1
    WSCvlabel* pe_lab011 = new  WSCvlabel(index002,"_pe_lab011");
    pe_lab011->initialize();
    pe_lab011->setPropertyV(WSNlabelString,WSGFgettext("Y3:WSSTR Include path"));
    pe_lab011->setPropertyV(WSNuserValue,(long)1);
    WSGFsetGeometry(pe_lab011,5,30,150,20);
    WSGFsetMargin(pe_lab011,0);

    WSCvifield* pe_ifi011 = new  WSCvifield(index002,"pe_ifi011");
    pe_ifi011->initialize();
    pe_ifi011->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    pe_ifi011->setPropertyV(WSNshadowType,(char)1);
    pe_ifi011->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    pe_ifi011->setPropertyV(WSNuserValue,(long)1);
    pe_ifi011->setPropertyV(WSNmaxLength,(WSCushort)0);
    WSGFsetGeometry(pe_ifi011,160,30,300,20);
    _object_index3["#USER_RT_INCLUDE"] = (void*)((WSCbase*)pe_ifi011);

    WSCvlabel* pe_lab012 = new  WSCvlabel(index002,"pe_lab012");
    pe_lab012->initialize();
    pe_lab012->setPropertyV(WSNlabelString,WSGFgettext("Z3:WSSTR Compiler flags"));
    pe_lab012->setPropertyV(WSNuserValue,(long)1);
    WSGFsetGeometry(pe_lab012,5,55,150,20);
    WSGFsetMargin(pe_lab012,0);

    WSCvifield* pe_ifi012 = new  WSCvifield(index002,"pe_ifi002");
    pe_ifi012->initialize();
    pe_ifi012->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    pe_ifi012->setPropertyV(WSNshadowType,(char)1);
    pe_ifi012->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    pe_ifi012->setPropertyV(WSNuserValue,(long)1);
    pe_ifi012->setPropertyV(WSNmaxLength,(WSCushort)0);
    WSGFsetGeometry(pe_ifi012,160,55,300,20);
    _object_index3["#USER_RT_FL"] = (void*)((WSCbase*)pe_ifi012);

    //page4-2
    WSCvlabel* pe_lab021 = new  WSCvlabel(index002,"_pe_lab021");
    pe_lab021->initialize();
    pe_lab021->setPropertyV(WSNlabelString,WSGFgettext("a3:WSSTR Include path"));
    pe_lab021->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(pe_lab021,5,30,200,20);
    WSGFsetMargin(pe_lab021,0);

    WSCvifield* pe_ifi021 = new  WSCvifield(index002,"pe_ifi021");
    pe_ifi021->initialize();
    pe_ifi021->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    pe_ifi021->setPropertyV(WSNshadowType,(char)1);
    pe_ifi021->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    pe_ifi021->setPropertyV(WSNuserValue,(long)2);
    pe_ifi021->setPropertyV(WSNmaxLength,(WSCushort)0);
    WSGFsetGeometry(pe_ifi021,210,30,250,20);
    _object_index3["#USER_DBG_INCLUDE"] = (void*)((WSCbase*)pe_ifi021);

    WSCvlabel* pe_lab022 = new  WSCvlabel(index002,"pe_lab022");
    pe_lab022->initialize();
    pe_lab022->setPropertyV(WSNlabelString,WSGFgettext("b3:WSSTR Compiler flags"));
    pe_lab022->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(pe_lab022,5,55,200,20);
    WSGFsetMargin(pe_lab022,0);

    WSCvifield* pe_ifi022 = new  WSCvifield(index002,"pe_ifi022");
    pe_ifi022->initialize();
    pe_ifi022->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    pe_ifi022->setPropertyV(WSNshadowType,(char)1);
    pe_ifi022->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    pe_ifi022->setPropertyV(WSNuserValue,(long)2);
    pe_ifi022->setPropertyV(WSNmaxLength,(WSCushort)0);
    WSGFsetGeometry(pe_ifi022,210,55,250,20);
    _object_index3["#USER_DBG_FL"] = (void*)((WSCbase*)pe_ifi022);

//page5
    WSCvlabel* pe_lab0051 = new  WSCvlabel(_area2,"_pe_lab0051");
    pe_lab0051->initialize();
    pe_lab0051->setPropertyV(WSNlabelString,WSGFgettext("c3:WSSTR Libraries"));
    pe_lab0051->setPropertyV(WSNuserValue,(long)5);
    WSGFsetGeometry(pe_lab0051,5,30,150,20);
    WSGFsetMargin(pe_lab0051,0);

    WSCvifield* pe_ifi0051 = new  WSCvifield(_area2,"pe_ifi0051");
    pe_ifi0051->initialize();
    pe_ifi0051->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    pe_ifi0051->setPropertyV(WSNshadowType,(char)1);
    pe_ifi0051->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    pe_ifi0051->setPropertyV(WSNuserValue,(long)5);
    pe_ifi0051->setPropertyV(WSNmaxLength,(WSCushort)0);
    WSGFsetGeometry(pe_ifi0051,160,30,270,20);
    _object_index3["#USER_LIB"] = (void*)((WSCbase*)pe_ifi0051);

    WSCvlabel* pe_lab0052 = new  WSCvlabel(_area2,"pe_lab0052");
    pe_lab0052->initialize();
    pe_lab0052->setPropertyV(WSNlabelString,WSGFgettext("d3:WSSTR Linker flags"));
    pe_lab0052->setPropertyV(WSNuserValue,(long)5);
    WSGFsetGeometry(pe_lab0052,5,55,150,20);
    WSGFsetMargin(pe_lab0052,0);

    WSCvifield* pe_ifi0052 = new  WSCvifield(_area2,"pe_ifi0052");
    pe_ifi0052->initialize();
    pe_ifi0052->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    pe_ifi0052->setPropertyV(WSNshadowType,(char)1);
    pe_ifi0052->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    pe_ifi0052->setPropertyV(WSNuserValue,(long)5);
    pe_ifi0052->setPropertyV(WSNmaxLength,(WSCushort)0);
    WSGFsetGeometry(pe_ifi0052,160,55,270,20);
    _object_index3["#USER_LD_FL"] = (void*)((WSCbase*)pe_ifi0052);

    WSCvlabel* pe_lab0053 = new  WSCvlabel(_area2,"pe_lab0053");
    pe_lab0053->initialize();
    pe_lab0053->setPropertyV(WSNlabelString,WSGFgettext("e3:WSSTR Linker"));
    pe_lab0053->setPropertyV(WSNuserValue,(long)5);
    WSGFsetGeometry(pe_lab0053,5,80,150,20);
    WSGFsetMargin(pe_lab0053,0);

    WSCvifield* pe_ifi0053 = new  WSCvifield(_area2,"pe_ifi0053");
    pe_ifi0053->initialize();
    pe_ifi0053->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    pe_ifi0053->setPropertyV(WSNshadowType,(char)1);
    pe_ifi0053->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    pe_ifi0053->setPropertyV(WSNuserValue,(long)5);
    pe_ifi0053->setPropertyV(WSNmaxLength,(WSCushort)0);
    WSGFsetGeometry(pe_ifi0053,160,80,270,20);
    _object_index3["#LD"] = (void*)((WSCbase*)pe_ifi0053);

    WSCvlabel* pe_lab0054 = new  WSCvlabel(_area2,"pe_lab0054");
    pe_lab0054->initialize();
    pe_lab0054->setPropertyV(WSNlabelString,WSGFgettext("f3:WSSTR Debugger"));
    pe_lab0054->setPropertyV(WSNuserValue,(long)5);
    WSGFsetGeometry(pe_lab0054,5,105,150,20);
    WSGFsetMargin(pe_lab0054,0);

    WSCvifield* pe_ifi0054 = new  WSCvifield(_area2,"pe_ifi0054");
    pe_ifi0054->initialize();
    pe_ifi0054->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    pe_ifi0054->setPropertyV(WSNshadowType,(char)1);
    pe_ifi0054->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    pe_ifi0054->setPropertyV(WSNuserValue,(long)5);
    pe_ifi0054->setPropertyV(WSNmaxLength,(WSCushort)0);
    WSGFsetGeometry(pe_ifi0054,160,105,270,20);
    _object_index2["#DEBUGGER"] = (void*)((WSCbase*)pe_ifi0054);

    WSCvlabel* pe_lab0055 = new  WSCvlabel(_area2,"pe_lab0055");
    pe_lab0055->initialize();
    pe_lab0055->setPropertyV(WSNlabelString,WSGFgettext("f3:WSSTR Make"));
    pe_lab0055->setPropertyV(WSNuserValue,(long)5);
    WSGFsetGeometry(pe_lab0055,5,130,150,20);
    WSGFsetMargin(pe_lab0055,0);

    WSCvifield* pe_ifi0055 = new  WSCvifield(_area2,"pe_ifi0055");
    pe_ifi0055->initialize();
    pe_ifi0055->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    pe_ifi0055->setPropertyV(WSNshadowType,(char)1);
    pe_ifi0055->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    pe_ifi0055->setPropertyV(WSNuserValue,(long)5);
    pe_ifi0055->setPropertyV(WSNmaxLength,(WSCushort)0);
    WSGFsetGeometry(pe_ifi0055,160,130,270,20);
    _object_index3["#MAKE"] = (void*)((WSCbase*)pe_ifi0055);


    index0052 = new WSCindexForm(_area2,"index0052");
    index0052->initialize();
    WSGFsetGeometry(index0052,5,160,470,100);
    index0052->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    index0052->setPropertyV(WSNmenuItems,WSGFgettext("g3:WSSTR Runtime mode,Debug mode"));
    index0052->setPropertyV(WSNuserValue,(long)5);

    //page5-1
    WSCvlabel* pe_lab0511 = new  WSCvlabel(index0052,"_pe_lab0511");
    pe_lab0511->initialize();
    pe_lab0511->setPropertyV(WSNlabelString,WSGFgettext("h3:WSSTR Libraries"));
    pe_lab0511->setPropertyV(WSNuserValue,(long)1);
    WSGFsetGeometry(pe_lab0511,5,30,150,20);
    WSGFsetMargin(pe_lab0511,0);

    WSCvifield* pe_ifi0511 = new  WSCvifield(index0052,"pe_ifi0511");
    pe_ifi0511->initialize();
    pe_ifi0511->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    pe_ifi0511->setPropertyV(WSNshadowType,(char)1);
    pe_ifi0511->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    pe_ifi0511->setPropertyV(WSNuserValue,(long)1);
    pe_ifi0511->setPropertyV(WSNmaxLength,(WSCushort)0);
    WSGFsetGeometry(pe_ifi0511,160,30,300,20);
    _object_index3["#USER_RT_LIB"] = (void*)((WSCbase*)pe_ifi0511);

    WSCvlabel* pe_lab0512 = new  WSCvlabel(index0052,"pe_lab0512");
    pe_lab0512->initialize();
    pe_lab0512->setPropertyV(WSNlabelString,WSGFgettext("i3:WSSTR Output file"));
    pe_lab0512->setPropertyV(WSNuserValue,(long)1);
    WSGFsetGeometry(pe_lab0512,5,55,150,20);
    WSGFsetMargin(pe_lab0512,0);

    WSCvifield* pe_ifi0512 = new  WSCvifield(index0052,"pe_ifi002");
    pe_ifi0512->initialize();
    pe_ifi0512->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    pe_ifi0512->setPropertyV(WSNshadowType,(char)1);
    pe_ifi0512->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    pe_ifi0512->setPropertyV(WSNuserValue,(long)1);
    pe_ifi0512->setPropertyV(WSNmaxLength,(WSCushort)0);
    WSGFsetGeometry(pe_ifi0512,160,55,300,20);
    _object_index["#OUTPUT"] = (void*)((WSCbase*)pe_ifi0512);


    //page5-2
    WSCvlabel* pe_lab0521 = new  WSCvlabel(index0052,"_pe_lab0521");
    pe_lab0521->initialize();
    pe_lab0521->setPropertyV(WSNlabelString,WSGFgettext("j3:WSSTR Libraries"));
    pe_lab0521->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(pe_lab0521,5,30,170,20);
    WSGFsetMargin(pe_lab0521,0);

    WSCvifield* pe_ifi0521 = new  WSCvifield(index0052,"pe_ifi0521");
    pe_ifi0521->initialize();
    pe_ifi0521->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    pe_ifi0521->setPropertyV(WSNshadowType,(char)1);
    pe_ifi0521->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    pe_ifi0521->setPropertyV(WSNuserValue,(long)2);
    pe_ifi0521->setPropertyV(WSNmaxLength,(WSCushort)0);
    WSGFsetGeometry(pe_ifi0521,180,30,280,20);
    _object_index3["#USER_DBG_LIB"] = (void*)((WSCbase*)pe_ifi0521);

    WSCvlabel* pe_lab0522 = new  WSCvlabel(index0052,"pe_lab0522");
    pe_lab0522->initialize();
    pe_lab0522->setPropertyV(WSNlabelString,WSGFgettext("k3:WSSTR Output file"));
    pe_lab0522->setPropertyV(WSNuserValue,(long)2);
    WSGFsetGeometry(pe_lab0522,5,55,170,20);
    WSGFsetMargin(pe_lab0522,0);

    WSCvifield* pe_ifi0522 = new  WSCvifield(index0052,"pe_ifi002");
    pe_ifi0522->initialize();
    pe_ifi0522->setPropertyV(WSNenableFocusMove,(WSCbool)1);
    pe_ifi0522->setPropertyV(WSNshadowType,(char)1);
    pe_ifi0522->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    pe_ifi0522->setPropertyV(WSNuserValue,(long)2);
    pe_ifi0522->setPropertyV(WSNmaxLength,(WSCushort)0);
    WSGFsetGeometry(pe_ifi0522,180,55,280,20);
    _object_index["#DBG_OUTPUT"] = (void*)((WSCbase*)pe_ifi0522);

//page6
    fdiavbtn000 = new  WSCvbtn(_area2,"fdiavbtn000");
    fdiavbtn000->initialize();
    fdiavbtn000->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    WSGFsetGeometry(fdiavbtn000,120,30,380,20);
    WSCprocedure* op_fdiavbtn000_0 = new WSCprocedure("new_ep",WSEV_ACTIVATE);
    op_fdiavbtn000_0->setFunction(_feditop,"_feditop");
    fdiavbtn000->addProcedure(op_fdiavbtn000_0);
    fdiavbtn000->setPropertyV(WSNuserValue,(long)6);
    fdiavbtn000->setProperty(WSNalignmentH,WS_LEFT);
    fdiavbtn000->setUserData("FONTNO",(void*)0);
    fdiavbtn000->setVisible(True);
    _object_index3["#FONT0"] = (void*)((WSCbase*)fdiavbtn000);

    fdiavbtn001 = new  WSCvbtn(_area2,"fdiavbtn001");
    fdiavbtn001->initialize();
    fdiavbtn001->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    WSGFsetGeometry(fdiavbtn001,120,50,380,20);
    WSCprocedure* op_fdiavbtn001_0 = new WSCprocedure("new_ep",WSEV_ACTIVATE);
    op_fdiavbtn001_0->setFunction(_feditop,"_feditop");
    fdiavbtn001->addProcedure(op_fdiavbtn001_0);
    fdiavbtn001->setPropertyV(WSNuserValue,(long)6);
    fdiavbtn001->setUserData("FONTNO",(void*)1);
    fdiavbtn001->setProperty(WSNalignmentH,WS_LEFT);
    fdiavbtn001->setVisible(True);
    _object_index3["#FONT1"] = (void*)((WSCbase*)fdiavbtn001);

    fdiavbtn002 = new  WSCvbtn(_area2,"fdiavbtn002");
    fdiavbtn002->initialize();
    fdiavbtn002->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    WSGFsetGeometry(fdiavbtn002,120,70,380,20);
    WSCprocedure* op_fdiavbtn002_0 = new WSCprocedure("new_ep",WSEV_ACTIVATE);
    op_fdiavbtn002_0->setFunction(_feditop,"_feditop");
    fdiavbtn002->addProcedure(op_fdiavbtn002_0);
    fdiavbtn002->setPropertyV(WSNuserValue,(long)6);
    fdiavbtn002->setProperty(WSNalignmentH,WS_LEFT);
    fdiavbtn002->setVisible(True);
    fdiavbtn002->setUserData("FONTNO",(void*)2);
    _object_index3["#FONT2"] = (void*)((WSCbase*)fdiavbtn002);

    fdiavbtn003 = new  WSCvbtn(_area2,"fdiavbtn003");
    fdiavbtn003->initialize();
    fdiavbtn003->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    WSGFsetGeometry(fdiavbtn003,120,90,380,20);
    WSCprocedure* op_fdiavbtn003_0 = new WSCprocedure("new_ep",WSEV_ACTIVATE);
    op_fdiavbtn003_0->setFunction(_feditop,"_feditop");
    fdiavbtn003->addProcedure(op_fdiavbtn003_0);
    fdiavbtn003->setPropertyV(WSNuserValue,(long)6);
    fdiavbtn003->setUserData("FONTNO",(void*)3);
    fdiavbtn003->setProperty(WSNalignmentH,WS_LEFT);
    fdiavbtn003->setVisible(True);
    _object_index3["#FONT3"] = (void*)((WSCbase*)fdiavbtn003);

    fdiavbtn004 = new  WSCvbtn(_area2,"fdiavbtn004");
    fdiavbtn004->initialize();
    fdiavbtn004->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    WSGFsetGeometry(fdiavbtn004,120,110,380,20);
    WSCprocedure* op_fdiavbtn004_0 = new WSCprocedure("new_ep",WSEV_ACTIVATE);
    op_fdiavbtn004_0->setFunction(_feditop,"_feditop");
    fdiavbtn004->addProcedure(op_fdiavbtn004_0);
    fdiavbtn004->setPropertyV(WSNuserValue,(long)6);
    fdiavbtn004->setUserData("FONTNO",(void*)4);
    fdiavbtn004->setProperty(WSNalignmentH,WS_LEFT);
    fdiavbtn004->setVisible(True);
    _object_index3["#FONT4"] = (void*)((WSCbase*)fdiavbtn004);

    fdiavbtn005 = new  WSCvbtn(_area2,"fdiavbtn005");
    fdiavbtn005->initialize();
    fdiavbtn005->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    WSGFsetGeometry(fdiavbtn005,120,130,380,20);
    WSCprocedure* op_fdiavbtn005_0 = new WSCprocedure("new_ep",WSEV_ACTIVATE);
    op_fdiavbtn005_0->setFunction(_feditop,"_feditop");
    fdiavbtn005->addProcedure(op_fdiavbtn005_0);
    fdiavbtn005->setPropertyV(WSNuserValue,(long)6);
    fdiavbtn005->setUserData("FONTNO",(void*)5);
    fdiavbtn005->setProperty(WSNalignmentH,WS_LEFT);
    fdiavbtn005->setVisible(True);
    _object_index3["#FONT5"] = (void*)((WSCbase*)fdiavbtn005);

    fdiavbtn006 = new  WSCvbtn(_area2,"fdiavbtn006");
    fdiavbtn006->initialize();
    fdiavbtn006->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    WSGFsetGeometry(fdiavbtn006,120,150,380,20);
    WSCprocedure* op_fdiavbtn006_0 = new WSCprocedure("new_ep",WSEV_ACTIVATE);
    op_fdiavbtn006_0->setFunction(_feditop,"_feditop");
    fdiavbtn006->addProcedure(op_fdiavbtn006_0);
    fdiavbtn006->setPropertyV(WSNuserValue,(long)6);
    fdiavbtn006->setUserData("FONTNO",(void*)6);
    fdiavbtn006->setProperty(WSNalignmentH,WS_LEFT);
    fdiavbtn006->setVisible(True);
    _object_index3["#FONT6"] = (void*)((WSCbase*)fdiavbtn006);

    fdiavbtn007 = new  WSCvbtn(_area2,"fdiavbtn007");
    fdiavbtn007->initialize();
    fdiavbtn007->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    WSGFsetGeometry(fdiavbtn007,120,170,380,20);
    WSCprocedure* op_fdiavbtn007_0 = new WSCprocedure("new_ep",WSEV_ACTIVATE);
    op_fdiavbtn007_0->setFunction(_feditop,"_feditop");
    fdiavbtn007->addProcedure(op_fdiavbtn007_0);
    fdiavbtn007->setPropertyV(WSNuserValue,(long)6);
    fdiavbtn007->setUserData("FONTNO",(void*)7);
    fdiavbtn007->setProperty(WSNalignmentH,WS_LEFT);
    fdiavbtn007->setVisible(True);
    _object_index3["#FONT7"] = (void*)((WSCbase*)fdiavbtn007);

    fdiavbtn000->setDrawFocusBorder(False);
    fdiavbtn001->setDrawFocusBorder(False);
    fdiavbtn002->setDrawFocusBorder(False);
    fdiavbtn003->setDrawFocusBorder(False);
    fdiavbtn004->setDrawFocusBorder(False);
    fdiavbtn006->setDrawFocusBorder(False);
    fdiavbtn007->setDrawFocusBorder(False);



    WSCvlabel* fdiavtex006 = new  WSCvlabel(_area2,"fdiavtex006");
    fdiavtex006->initialize();
    fdiavtex006->setPropertyV(WSNlabelString,"FONT0:");
    WSGFsetGeometry(fdiavtex006,5,30,110,20);
    fdiavtex006->setPropertyV(WSNuserValue,(long)6);
    fdiavtex006->setVisible(True);

    WSCvlabel* fdiavtex007 = new  WSCvlabel(_area2,"fdiavtex007");
    fdiavtex007->initialize();
    fdiavtex007->setPropertyV(WSNlabelString,"FONT1:");
    WSGFsetGeometry(fdiavtex007,5,50,110,20);
    fdiavtex007->setPropertyV(WSNuserValue,(long)6);
    fdiavtex007->setVisible(True);

    WSCvlabel* fdiavtex008 = new  WSCvlabel(_area2,"fdiavtex008");
    fdiavtex008->initialize();
    fdiavtex008->setPropertyV(WSNlabelString,"FONT2:");
    WSGFsetGeometry(fdiavtex008,5,70,110,20);
    fdiavtex008->setPropertyV(WSNuserValue,(long)6);
    fdiavtex008->setVisible(True);

    WSCvlabel* fdiavtex010 = new  WSCvlabel(_area2,"fdiavtex010");
    fdiavtex010->initialize();
    fdiavtex010->setPropertyV(WSNlabelString,"FONT3:");
    WSGFsetGeometry(fdiavtex010,5,90,110,20);
    fdiavtex010->setPropertyV(WSNuserValue,(long)6);
    fdiavtex010->setVisible(True);

    WSCvlabel* fdiavtex009 = new  WSCvlabel(_area2,"fdiavtex009");
    fdiavtex009->initialize();
    fdiavtex009->setPropertyV(WSNlabelString,"FONT4:");
    WSGFsetGeometry(fdiavtex009,5,110,110,20);
    fdiavtex009->setPropertyV(WSNuserValue,(long)6);
    fdiavtex009->setVisible(True);

    WSCvlabel* fdiavtex015 = new  WSCvlabel(_area2,"fdiavtex015");
    fdiavtex015->initialize();
    fdiavtex015->setPropertyV(WSNlabelString,"FONT5:");
    WSGFsetGeometry(fdiavtex015,5,130,110,20);
    fdiavtex015->setPropertyV(WSNuserValue,(long)6);
    fdiavtex015->setVisible(True);

    WSCvlabel* fdiavtex016 = new  WSCvlabel(_area2,"fdiavtex016");
    fdiavtex016->initialize();
    fdiavtex016->setPropertyV(WSNlabelString,"FONT6:");
    WSGFsetGeometry(fdiavtex016,5,150,110,20);
    fdiavtex016->setPropertyV(WSNuserValue,(long)6);
    fdiavtex016->setVisible(True);

    WSCvlabel* fdiavtex017 = new  WSCvlabel(_area2,"fdiavtex017");
    fdiavtex017->initialize();
    fdiavtex017->setPropertyV(WSNlabelString,"FONT7:");
    WSGFsetGeometry(fdiavtex017,5,170,110,20);
    fdiavtex017->setPropertyV(WSNuserValue,(long)6);
    fdiavtex017->setVisible(True);

    WSCvlabel* fdiavtex071 = new  WSCvlabel(_area2,"fdiavtex071");
    fdiavtex071->initialize();
//    fdiavtex071->setPropertyV(WSNlabelString,"ENCODING");
    fdiavtex071->setPropertyV(WSNlabelString,WSGFgettext("l3:WSSTR ENCODING"));
    WSGFsetGeometry(fdiavtex071,5,30,110,20);
    fdiavtex071->setPropertyV(WSNuserValue,(long)7);
    fdiavtex071->setVisible(True);
    WSGFsetMargin(fdiavtex071,0);

    _opt1 = new  WSCoption(_area2,"fdiavopt1");
    _opt1->initialize();
    WSGFsetGeometry(_opt1,120,30,400,20);
    _opt1->setPropertyV(WSNuserValue,(long)7);
    _opt1->setProperty(WSNshadowThickness,1);
    _opt1->setProperty(WSNmenuItems,"");
    _opt1->setVisible(True);
//    _object_index["#ENCODING"] = (void*)((WSCbase*)_opt1);

    WSCvlabel* fdiavtex072 = new  WSCvlabel(_area2,"fdiavtex071");
    fdiavtex072->initialize();
    fdiavtex072->setPropertyV(WSNlabelString,WSGFgettext("l3:WSSTR COMPAT"));
    WSGFsetGeometry(fdiavtex072,5,60,110,20);
    fdiavtex072->setPropertyV(WSNuserValue,(long)7);
    fdiavtex072->setVisible(True);
    WSGFsetMargin(fdiavtex072,0);

    _pe_radio1 = new  WSCvradio(_area2,"fdiavopt1");
    _pe_radio1->initialize();
    WSGFsetGeometry(_pe_radio1,120,57,400,26);
    _pe_radio1->setPropertyV(WSNuserValue,(long)7);
    _pe_radio1->setProperty(WSNshadowThickness,2);
    _pe_radio1->setProperty(WSNlabelString,WSGFgettext("l3:WSSTR Platform compatible"));
    _pe_radio1->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    _pe_radio1->setProperty(WSNalignmentH,WS_LEFT);
    _pe_radio1->setPropertyV(WSNindicatorSize,(unsigned char)16);
    _pe_radio1->setPropertyV(WSNalignmentH,(unsigned char)0);
    _pe_radio1->setPropertyV(WSNmarginTop,(unsigned char)0);
    _pe_radio1->setPropertyV(WSNmarginBottom,(unsigned char)0);
    _pe_radio1->setPropertyV(WSNmarginLeft,(unsigned char)10);
    _pe_radio1->setPropertyV(WSNmarginRight,(unsigned char)0);
    _pe_radio1->setVisible(True);
    _object_index["#COMPAT"] = (void*)((WSCbase*)_pe_radio1);
    _pe_radio1->setUserData("this",(void*)this);

    WSCprocedure* op__pe_rd1_0 = new WSCprocedure("compat-ch",WSEV_VALUE_CH);
    op__pe_rd1_0->setFunction(_compat_work,"_compat_work");
    _pe_radio1->addProcedure(op__pe_rd1_0);

    WSCvlabel* sp71 = new  WSCvlabel(_area2,"_pe_sp3");
    sp71->initialize();
    sp71->setPropertyV(WSNshadowType,(char)1);
    sp71->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    sp71->setProperty(WSNtopShadowColor,WS_DF_TOPSHADOWCOLOR);
    sp71->setProperty(WSNbottomShadowColor,WS_DF_BOTTOMSHADOWCOLOR);
    sp71->setPropertyV(WSNuserValue,(long)7);
    WSGFsetGeometry(sp71,0,85,1280,2);
    sp71->setVisible(True);

    WSCvlabel* fdiavtex073 = new  WSCvlabel(_area2,"fdiavtex073");
    fdiavtex073->initialize();
    fdiavtex073->setPropertyV(WSNlabelString,WSGFgettext("l3:WSSTR Gui Policy"));
    WSGFsetGeometry(fdiavtex073,5,90,110,20);
    fdiavtex073->setPropertyV(WSNuserValue,(long)7);
    fdiavtex073->setVisible(True);
    WSGFsetMargin(fdiavtex073,0);


//option..
    _pe_radio2 = new  WSCvradio(_area2,"fdiavopt1");
    _pe_radio2->initialize();
    WSGFsetGeometry(_pe_radio2,120,87,400,26);
    _pe_radio2->setPropertyV(WSNuserValue,(long)7);
    _pe_radio2->setProperty(WSNshadowThickness,2);
    _pe_radio2->setProperty(WSNlabelString,"OFF");
    _pe_radio2->setProperty(WSNselectString,"ON");
    _pe_radio2->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    _pe_radio2->setProperty(WSNalignmentH,WS_LEFT);
    _pe_radio2->setPropertyV(WSNindicatorSize,(unsigned char)16);
    _pe_radio2->setPropertyV(WSNalignmentH,(unsigned char)0);
    _pe_radio2->setPropertyV(WSNmarginTop,(unsigned char)0);
    _pe_radio2->setPropertyV(WSNmarginBottom,(unsigned char)0);
    _pe_radio2->setPropertyV(WSNmarginLeft,(unsigned char)10);
    _pe_radio2->setPropertyV(WSNmarginRight,(unsigned char)0);
    _pe_radio2->setUserData("this",(void*)this);
    _pe_radio2->setVisible(True);

    WSCprocedure* op__pe_rd1_1 = new WSCprocedure("policy-ch",WSEV_VALUE_CH);
    op__pe_rd1_1->setFunction(_policy_select_work,"_policy_select_work");
    _pe_radio2->addProcedure(op__pe_rd1_1);




    WSCvlabel* fdiavtex074 = new  WSCvlabel(_area2,"fdiavtex073");
    fdiavtex074->initialize();
    fdiavtex074->setPropertyV(WSNlabelString,WSGFgettext("l3:WSSTR Look & Feel"));
    WSGFsetGeometry(fdiavtex074,5,120,110,20);
    fdiavtex074->setPropertyV(WSNuserValue,(long)7);
    fdiavtex074->setVisible(True);
    WSGFsetMargin(fdiavtex074,0);



    _polvrad_002 = new  WSCvradio(_area2,"polvrad_002");
    _polvrad_002->initialize();
    _polvrad_002->setPropertyV(WSNindicatorSize,(unsigned char)16);
    _polvrad_002->setPropertyV(WSNindicatorColor,"white");
    _polvrad_002->setPropertyV(WSNuserValue,(long)7);
    _polvrad_002->setPropertyV(WSNselectColor,"DEF14");
    _polvrad_002->setPropertyV(WSNunique,(WSCbool)1);
    _polvrad_002->setPropertyV(WSNgroup,"lookfeel");
    _polvrad_002->setPropertyV(WSNid,(short)1);
    _polvrad_002->setPropertyV(WSNbackColor,"DEF10");
    _polvrad_002->setPropertyV(WSNtopShadowColor,"DEF3");
    _polvrad_002->setPropertyV(WSNbottomShadowColor,"DEF4");
    _polvrad_002->setPropertyV(WSNlabelString,"Original");
    _polvrad_002->setPropertyV(WSNalignmentH,(unsigned char)0);
    _polvrad_002->setPropertyV(WSNmarginTop,(unsigned char)0);
    _polvrad_002->setPropertyV(WSNmarginBottom,(unsigned char)0);
    _polvrad_002->setPropertyV(WSNmarginLeft,(unsigned char)10);
    _polvrad_002->setPropertyV(WSNmarginRight,(unsigned char)0);
    _polvrad_002->setPropertyV(WSNname,"polvrad_002");
    _polvrad_002->setPropertyV(WSNvis,(WSCbool)1);
    _polvrad_002->setPropertyV(WSNx,(short)120);
    _polvrad_002->setPropertyV(WSNy,(short)117);
    _polvrad_002->setPropertyV(WSNwidth,(unsigned short)400);
    _polvrad_002->setPropertyV(WSNheight,(unsigned short)26);
    _polvrad_002->setProperty(WSNemboss,True);
    _polvrad_002->setProperty(WSNselectReset,False);

    _polvrad_003 = new  WSCvradio(_area2,"polvrad_003");
    _polvrad_003->initialize();
    _polvrad_003->setPropertyV(WSNindicatorSize,(unsigned char)16);
    _polvrad_003->setPropertyV(WSNindicatorColor,"white");
    _polvrad_003->setPropertyV(WSNuserValue,(long)7);
    _polvrad_003->setPropertyV(WSNselectColor,"DEF14");
    _polvrad_003->setPropertyV(WSNunique,(WSCbool)1);
    _polvrad_003->setPropertyV(WSNgroup,"lookfeel");
    _polvrad_003->setPropertyV(WSNid,(short)2);
    _polvrad_003->setPropertyV(WSNbackColor,"DEF10");
    _polvrad_003->setPropertyV(WSNtopShadowColor,"DEF3");
    _polvrad_003->setPropertyV(WSNbottomShadowColor,"DEF4");
    _polvrad_003->setPropertyV(WSNlabelString,"Windows");
    _polvrad_003->setPropertyV(WSNalignmentH,(unsigned char)0);
    _polvrad_003->setPropertyV(WSNmarginTop,(unsigned char)0);
    _polvrad_003->setPropertyV(WSNmarginBottom,(unsigned char)0);
    _polvrad_003->setPropertyV(WSNmarginLeft,(unsigned char)10);
    _polvrad_003->setPropertyV(WSNmarginRight,(unsigned char)0);
    _polvrad_003->setPropertyV(WSNname,"polvrad_003");
    _polvrad_003->setPropertyV(WSNvis,(WSCbool)1);
    _polvrad_003->setPropertyV(WSNx,(short)120);
    _polvrad_003->setPropertyV(WSNy,(short)142);
    _polvrad_003->setPropertyV(WSNwidth,(unsigned short)400);
    _polvrad_003->setPropertyV(WSNheight,(unsigned short)26);
    _polvrad_003->setProperty(WSNemboss,True);
    _polvrad_003->setUserData("this",(void*)this);
    _polvrad_003->setProperty(WSNselectReset,False);
    _polvrad_003->setStatus(True);

    WSCprocedure* op__pe_rd1_2 = new WSCprocedure("policy-ch",WSEV_VALUE_CH);
    op__pe_rd1_2->setFunction(_policy_select_work,"_policy_select_work");
    _polvrad_003->addProcedure(op__pe_rd1_2);


    WSCvlabel* fdiavtex075 = new  WSCvlabel(_area2,"fdiavtex073");
    fdiavtex075->initialize();
    fdiavtex075->setPropertyV(WSNlabelString,WSGFgettext("l3:WSSTR Gradation"));
    WSGFsetGeometry(fdiavtex075,5,170,110,20);
    fdiavtex075->setPropertyV(WSNuserValue,(long)7);
    fdiavtex075->setVisible(True);
    WSGFsetMargin(fdiavtex075,0);

    _pe_radio3 = new  WSCvradio(_area2,"fdiavopt1");
    _pe_radio3->initialize();
    WSGFsetGeometry(_pe_radio3,120,167,400,26);
    _pe_radio3->setPropertyV(WSNuserValue,(long)7);
    _pe_radio3->setProperty(WSNshadowThickness,2);
    _pe_radio3->setProperty(WSNlabelString,WSGFgettext("l3:WSSTR Gradation"));
    _pe_radio3->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    _pe_radio3->setProperty(WSNalignmentH,WS_LEFT);
    _pe_radio3->setPropertyV(WSNindicatorSize,(unsigned char)16);
    _pe_radio3->setPropertyV(WSNalignmentH,(unsigned char)0);
    _pe_radio3->setPropertyV(WSNmarginTop,(unsigned char)0);
    _pe_radio3->setPropertyV(WSNmarginBottom,(unsigned char)0);
    _pe_radio3->setPropertyV(WSNmarginLeft,(unsigned char)10);
    _pe_radio3->setPropertyV(WSNmarginRight,(unsigned char)0);
    _pe_radio3->setProperty(WSNemboss,True);
    _pe_radio3->setVisible(True);
    _pe_radio3->setStatus(True);
    _pe_radio3->setUserData("this",(void*)this);

    WSCprocedure* op__pe_rd1_3 = new WSCprocedure("policy-ch",WSEV_VALUE_CH);
    op__pe_rd1_3->setFunction(_policy_select_work,"_policy_select_work");
    _pe_radio3->addProcedure(op__pe_rd1_3);

    _policy_select_work(_pe_radio3);


    WSCvlabel* fdiavtex076 = new  WSCvlabel(_area2,"fdiavtex076");
    fdiavtex076->initialize();
    fdiavtex076->setPropertyV(WSNlabelString,WSGFgettext("l3:WSSTR Language"));
    WSGFsetGeometry(fdiavtex076,5,200,110,20);
    fdiavtex076->setPropertyV(WSNuserValue,(long)7);
    fdiavtex076->setVisible(True);
    WSGFsetMargin(fdiavtex076,0);

    _opt2 = new  WSCoption(_area2,"fdiavopt1");
    _opt2->initialize();
    WSGFsetGeometry(_opt2,120,200,200,20);
    _opt2->setPropertyV(WSNuserValue,(long)7);
    _opt2->setProperty(WSNshadowThickness,1);
    _opt2->setProperty(WSNmenuItems,"C/C++:0,Ruby:1,Python:2,Perl:3");
    _opt2->setVisible(True);






    _set_visible(_area2);
    onGuiPolicyChange(WSGIappDev()->getGuiPolicy());
  return WS_NO_ERR;
}
void WSCprojectEditor::_policy_select_work(WSCbase* obj){
  WSCprojectEditor* _this = (WSCprojectEditor*)obj->getUserData("this");
  if (_this->_pe_radio2->getStatus() == False){
    _this->_polvrad_002->setProperty(WSNindicatorColor,WS_DF_DARKBACKCOLOR);
    _this->_polvrad_002->setSensitive(False);
    _this->_polvrad_003->setProperty(WSNindicatorColor,WS_DF_DARKBACKCOLOR);
    _this->_polvrad_003->setSensitive(False);
    _this->_pe_radio3->setSensitive(False);
    _this->_pe_radio3->setProperty(WSNindicatorColor,WS_DF_DARKBACKCOLOR);
    _this->_policy = 0;
  }else{
    _this->_polvrad_002->setProperty(WSNindicatorColor,WS_DF_WORKBACKCOLOR);
    _this->_polvrad_002->setSensitive(True);
    _this->_polvrad_003->setProperty(WSNindicatorColor,WS_DF_WORKBACKCOLOR);
    _this->_polvrad_003->setSensitive(True);
    _this->_pe_radio3->setSensitive(True);
    _this->_pe_radio3->setProperty(WSNindicatorColor,WS_DF_WORKBACKCOLOR);
    _this->_policy = _this->_polvrad_003->getGroupValue();
    if ( _this->_pe_radio3->getStatus() != False){
      _this->_policy |= 4;
    }
    WSGIappDev()->setGuiPolicy(_this->_policy,True);
  }
//printf("WSCprojectEditor::_policy_select_work  policy=0x%x\n",_this->_policy);
}
void WSCprojectEditor::_compat_work(WSCbase* obj){
  WSCprojectEditor* _this = (WSCprojectEditor*)obj->getUserData("this");
  
  WSCbool fl = _this->_pe_radio1->getStatus();
  long num = _this->_object_index3.getNum();
//printf("WSCprojectEditor::_compat_work obj3 num=%d\n",num);
//fflush(stdout);
  long i;
  for(i=0; i<num; i++){
    WSCbase* item = (WSCbase*)_this->_object_index3.getData(i);
    if (item == NULL){
      continue;
    }
    if (fl == False){
      if (item->cast("WSCvifield") != NULL){
        item->setProperty(WSNbackColor,WS_DF_WORKBACKCOLOR);
      }
      item->setSensitive(True);      
    }else{
      if (item->cast("WSCvifield") != NULL){
        item->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
      }
      item->setSensitive(False);      
    }
  }
}
void WSCprojectEditor::setEncodingMenu(char* menu,long dval){
  _opt1->setProperty(WSNmenuItems,menu);
  _opt1->setProperty(WSNvalue,dval);
}
void WSCprojectEditor::onResize(WSCrect* rect){
  WSCbaseDialog::onResize(rect);
  long diff = 0;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
    diff = 0;
  }else
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    diff = 5;
  }

  if(_area1 != NULL){
    if (_w > 2){
      _area1->setPropertyV(WSNwidth, (WSCushort)(_w - 2));
    }else{
      _area1->setPropertyV(WSNwidth, (WSCushort)(1));
    }
    if (_h+diff > 45){
      _area1->setPropertyV(WSNheight,(WSCushort)(_h+diff - 45));
    }else{
      _area1->setPropertyV(WSNheight,(WSCushort)(1));
    }
    if (_w > 10){
      _area2->setPropertyV(WSNwidth, (WSCushort)(_w - 10));
    }else{
      _area2->setPropertyV(WSNwidth, (WSCushort)(1));
    }
    if (_h+diff > 65){
      _area2->setPropertyV(WSNheight,(WSCushort)(_h+diff - 65));
    }else{
      _area2->setPropertyV(WSNheight,(WSCushort)(1));
    }
  }  
}
void WSCprojectEditor::onVisibleChange(WSCbool fl){
  WSCbaseDialog::onVisibleChange(fl);
  if (fl == False){
    if (getStatus() != WS_DIALOG_OK){
      cancelData();
    }
  }
}
void WSCprojectEditor::onActivate(){
  WSCbaseDialog::onActivate();
  if (getStatus() == WS_DIALOG_OK){
    updateData();
  }
  if (getStatus() != WS_DIALOG_CANCEL){
    setVisible(False);
  }
}
void WSCprojectEditor::_feditop(WSCbase* btn){
  WSCbase* fs = WSGFgetFontEditor();
  if (fs != NULL){
    fs->setProperty(WSNfontName,btn->getProperty(WSNlabelString));
    fs->setProperty(WSNfont,(WSCuchar)((long)btn->getUserData("FONTNO")));
    WSCbaseDialog* fsd = (WSCbaseDialog*)fs->cast("WSCbaseDialog");
    if (fsd != NULL){
      long ret = fsd->popup();
      if (ret == WS_DIALOG_OK){
        btn->setProperty(WSNlabelString,fs->getProperty(WSNfontName));
      }
    }
  }else{
fprintf(stderr,"WSCprojectEditor::_feditop(): please create font selector...\n");
  }
}
void WSCprojectEditor::_ifnum_op(WSCbase* ifd){
  WSCvslider* sld = (WSCvslider*)ifd->getUserData("SLD"); 
  WSCstring tmp(ifd->getProperty(WSNlabelString));
  tmp.delHeadSpace();
  tmp.delTailSpace();
  tmp.delLineFeed();
  short val = atoi(tmp.getString());
  short max = 100;
  sld->getPropertyV(WSNmaximum,&max);
  if (val > max){
    val = max;
  }
  short min = 0;
  sld->getPropertyV(WSNminimum,&min);
  if (val < min){
    val = min;
  }
  char buffer[128];
  sprintf(buffer,"%d",val);
  ifd->setPropertyV(WSNlabelString, buffer );
  sld->setPropertyV(WSNvalue, val );

  if ((long)ifd->getUserData("GRIDX") != 0){
    WSCushort gx,gy;
    WSCbase::getGripHandGrid(&gx,&gy);
    gx = ifd->getProperty(WSNlabelString);
    WSCbase::setGripHandGrid(gx,gy);
  }
  if ((long)ifd->getUserData("GRIDY") != 0){
    WSCushort gx,gy;
    WSCbase::getGripHandGrid(&gx,&gy);
    gy = ifd->getProperty(WSNlabelString);
    WSCbase::setGripHandGrid(gx,gy);
  }


}

void WSCprojectEditor::_sldnum_op(WSCbase* sld){
  WSCvifield* ifd = (WSCvifield*)sld->getUserData("IFD"); 
  ifd->setProperty(WSNlabelString,sld->getProperty(WSNvalue));
}
char* WSCprojectEditor::getGuiPolicy(){
static char buffer[32];
  sprintf(buffer,"%d",_policy);
  return buffer;
}
char* WSCprojectEditor::getProjectData(char* index){
  updateData();
  if (index != NULL){
    char* val = (char*)_project_data.getData(index);
    if (val == NULL){
      val = (char*)_project_data2.getData(index);
    }
    if (val == NULL){
      val = (char*)_project_data3.getData(index);
    }
    if (!strcmp(index,"#ENCODING")){
      val = getUseLocaleName();
    }
    if (!strcmp(index,"#POLICY")){
      val = getGuiPolicy();
    }
    if (!strcmp(index,"#LANG")){
      long ln = getLanguage();
      if (ln == WS_LANG_CPP){
        val = "C++";
      }else
      if (ln == WS_LANG_RUBY){
        val = "Ruby";
      }else
      if (ln == WS_LANG_PYTHON){
        val = "Python";
      }else
      if (ln == WS_LANG_PERL){
        val = "Perl";
      }
    }
    return val;
  }else{
static WSCstring output;
    output = "";
    long i;
    long num = _project_data.getNum();
    for(i=0; i<num; i++){
      char* index = _project_data.getIndex(i);
      char* data = (char*)_project_data.getData(i);
      if (data != NULL){
        output << index << "\n";
        output << data << "\n";
      }
    }
    output << "#ENCODING\n" << getUseLocaleName() << "\n";
    output << "#POLICY\n" << getGuiPolicy() << "\n";
    output << "#LANG\n";
    long ln = getLanguage();
    if (ln == WS_LANG_CPP){
      output << "C++\n";
    }else
    if (ln == WS_LANG_RUBY){
      output << "Ruby\n";
    }else
    if (ln == WS_LANG_PYTHON){
      output << "Python\n";
    }else
    if (ln == WS_LANG_PERL){
      output << "Perl\n";
    }


    if (_pe_radio1->getStatus() == False){
      num = _project_data3.getNum();
      for(i=0; i<num; i++){
        char* index = _project_data3.getIndex(i);
        char* data = (char*)_project_data3.getData(i);
        if (data != NULL){
          output << index << "\n";
          output << data << "\n";
        }
      }
    }
    return (char*)output;
  }
  return "";
}
char* WSCprojectEditor::getProjectData(char* index,WSCindexData* pdata,WSCindexData* objs){
  updateData();
  if (index != NULL){
//    if (!strcmp(index,"#POLICY")){
//      return getGuiPolicy();
//    }
    return (char*)(*pdata)[index];
  }else{
static WSCstring output;
    output = "";
    long i;
    long num = pdata->getNum();
    for(i=0; i<num; i++){
      char* index = pdata->getIndex(i);
      char* data = (char*)pdata->getData(i);
      if (data != NULL){
        WSCstring tmp;
        if (!strcmp(index,"#WS_DLL")){
          WSClist* list = (WSClist*)objs->getData("#WS_DLL");
          long j;
          for(j=0; j<list->getNum(); j++){
            WSCstring str = list->getItem(j);
            str.replaceString(" ","\\ ",0);
            tmp << str << " ";
          }
          tmp.delTailSpace();
          data = tmp;
        }
        output << index << "\n";
        output << data << "\n";
      }
    }
    if (pdata == &_project_data){
      output << "#ENCODING\n" << getUseLocaleName() << "\n";
      output << "#POLICY\n" << getGuiPolicy() << "\n";
      output << "#LANG\n";
      long ln = getLanguage();
      if (ln == WS_LANG_CPP){
        output << "C++\n";
      }else
      if (ln == WS_LANG_RUBY){
        output << "Ruby\n";
      }else
      if (ln == WS_LANG_PYTHON){
        output << "Python\n";
      }else
      if (ln == WS_LANG_PERL){
        output << "Perl\n";
      }
    }
    return (char*)output;
  }
  return "";
}


void WSCprojectEditor::updateData(){
   _update_data(&_project_data,&_object_index);
   _update_data(&_project_data2,&_object_index2);
   _update_data(&_project_data3,&_object_index3);
}
void WSCprojectEditor::cancelData(){
   _cancel_data(&_project_data,&_object_index);
   _cancel_data(&_project_data2,&_object_index2);
   _cancel_data(&_project_data3,&_object_index3);
}


void WSCprojectEditor::_update_data(WSCindexData* project_data,WSCindexData* object_index){
  long i;
  long num = object_index->getNum();
  for(i=0; i<num; i++){
    WSCbase* target = (WSCbase*)object_index->getData(i);
    char* index = object_index->getIndex(i);
    if (target == NULL){
      continue;
    }
    if (!strcmp(index,"#WS_DLL")){
      WSClist* list = (WSClist*)target->cast("WSClist");
      long n = list->getNum();
      long j;
      WSCstring tmp;
      for(j=0; j< n; j++){
//        tmp << list->getItem(j) << " ";
        WSCstring t = list->getItem(j);
        t.replaceString(" ","\\ ",0);
        tmp << t << " ";
      }
      char* str = (char*)(*project_data)[index];
      if (str != NULL){
        delete str;
      }
      (*project_data)[index] = WSGFstrdup( (char*)tmp);
    }else
    if (target->cast("WSCvifield")){
      char* str = (char*)(*project_data)[index];
      if (str != NULL){
        delete str;
      }
      (*project_data)[index] = WSGFstrdup( target->getProperty(WSNlabelString) );
    }else if (target->cast("WSCvtoggle")){
      char* str = (char*)(*project_data)[index];
      if (str != NULL){
        delete str;
      }
      WSCvtoggle* tg = (WSCvtoggle*)target->cast("WSCvtoggle");
      (*project_data)[index] = WSGFstrdup( WSGFltoa(tg->getStatus()));
    }else
    if (target->cast("WSCvbtn")){
      char* str = (char*)(*project_data)[index];
      if (str != NULL){
        delete str;
      }
      (*project_data)[index] = WSGFstrdup( target->getProperty(WSNlabelString) );
    }else{
    }
  }
}
void WSCprojectEditor::_cancel_data(WSCindexData* project_data,WSCindexData* object_index){
  long i;
  long num = object_index->getNum();
  for(i=0; i<num; i++){
    WSCbase* target = (WSCbase*)object_index->getData(i);
    char* index = object_index->getIndex(i);
    if (target == NULL){
      continue;
    }
    if (!strcmp(index,"#WS_DLL")){
      WSClist* list = (WSClist*)target->cast("WSClist");
      list->delAll();
      char* str = (char*)(*project_data)[index];
      WSCstring tmp(str);
      long n = tmp.getWords();
      long i;
      WSCstring t;
      for(i=0; i<n; i++){
//        WSCstring t = tmp.getWord(i);
        t << tmp.getWord(i);
        if (t[strlen(t) -1] == '\\'){
          t[strlen(t)-1] = ' ';
          continue;
        }
        list->addItem((char*)t);
        setUseDll((char*)t);
        t.clear();
      }
    }else
    if (target->cast("WSCvifield")){
      char* str = (char*)(*project_data)[index];
      if (str != NULL){
        target->setProperty(WSNlabelString,(char*)str);
      }else{
        target->setProperty(WSNlabelString,(char*)"");
      }
    }else if (target->cast("WSCvtoggle")){
      char* str = (char*)(*project_data)[index];
      WSCvtoggle* tg = (WSCvtoggle*)target->cast("WSCvtoggle");
      if (str != NULL){
        if (!strcmp(str,"T") || !strcmp(str,"t") || atoi(str) != 0){
          tg->setStatus(1);
        }else{ 
          tg->setStatus(0);
        }
      }else{
        tg->setStatus(0);
      }
    }else
    if (target->cast("WSCvbtn")){
      char* str = (char*)(*project_data)[index];
      if (str != NULL){
        target->setProperty(WSNlabelString,(char*)str);
      }else{
        target->setProperty(WSNlabelString,(char*)"");
      }
    }else{
    }
  }
}
void WSCprojectEditor::setGuiPolicy(char* val){
  long value = atoi(val);
  if (value == 0){
    _pe_radio2->setStatus(False);
  }else{
    _pe_radio2->setStatus(True);
  }
  if (value & 0x04){
    _pe_radio3->setStatus(True);
  }else{
    _pe_radio3->setStatus(False);
  }
  _polvrad_002->setGroupValue(value & 0x0b);
  _policy = value;
  _policy_select_work(_pe_radio3);
}
void WSCprojectEditor::setProjectData(char* str,char* data){
  WSCstring index(str);
  if (!strcmp("#ENCODING",str)){
    setUseLocaleName(data);
    return;
  }
  if (!strcmp("#LANG",str)){
    if (!strcmp(data,"Ruby")){
      _opt2->setProperty(WSNvalue,WS_LANG_RUBY);
    }else
    if (!strcmp(data,"Python")){
      _opt2->setProperty(WSNvalue,WS_LANG_PYTHON);
    }else
    if (!strcmp(data,"Perl")){
      _opt2->setProperty(WSNvalue,WS_LANG_PERL);
    }else{
      _opt2->setProperty(WSNvalue,WS_LANG_CPP);
    }
    return;
  }
  if (!strcmp("#POLICY",str)){
    setGuiPolicy(data);
    return;
  }
  WSCbase* target = (WSCbase*)_object_index[(char*)index];
  WSCindexData*  project_data = &_project_data;
  if (target == NULL){
    target = (WSCbase*)_object_index2[(char*)index];
    project_data = &_project_data2;
  }
  if (target == NULL){
    target = (WSCbase*)_object_index3[(char*)index];
    project_data = &_project_data3;
  }

  char* tmp = (char*)(*project_data)[index];
  if (tmp != NULL){
    delete tmp;
  }
  if (target != NULL){
    (*project_data)[index] = WSGFstrdup(data);
  }else{
    (*project_data)[index] = NULL;
  }
  if (target != NULL){
    if (!strcmp(str,"#WS_DLL")){
      WSClist* list = (WSClist*)target->cast("WSClist");
      list->delAll();
      WSCstring tmp(data);
      long n = tmp.getWords();
      long i;
      WSCstring t;
      for(i=0; i<n; i++){
//        WSCstring t = tmp.getWord(i);
        t << tmp.getWord(i);
        if (t[strlen(t)-1] == '\\'){
          t[strlen(t)-1] = ' ';
          continue;
        }
        list->addItem((char*)t);
        setUseDll((char*)t);
        t.clear();
      }
    }else
    if (target->cast("WSCvifield")){
      target->setProperty(WSNlabelString,(char*)data);
    }else
    if (target->cast("WSCvbtn")){
      target->setProperty(WSNlabelString,(char*)data);
    }else
    if ( target->cast("WSCvtoggle")){
      WSCvtoggle* tg = (WSCvtoggle*)target->cast("WSCvtoggle");
      if (!strcmp(data,"T") || !strcmp(data,"t") || atoi(data) != 0){
        tg->setStatus(1);
      }else{ 
        tg->setStatus(0);
      }
    }
  }else{
fprintf(stderr,"WSCproject::open Warring. %s is no effect value...\n",(char*)index);
  }
}

long WSCprojectEditor::open(char* filename){
  return _open(filename,&_project_data,&_object_index);
}
long WSCprojectEditor::open_global(char* filename){
  return _open(filename,&_project_data2,&_object_index2);
}
long WSCprojectEditor::_open(char* filename,WSCindexData* project_data,WSCindexData* object_index){
  WSCstring* src = WSGFreadTextFile(filename,WSGIappLocaleSet()->getSystemLocaleEncoding());
//printf("WSCprojectEditor::_open %s 0x%x\n",filename,src);
  if (src == NULL){
    return WS_ERR;
  }
  while(src->eof() == False){
    WSCstring index = src->gets();
    WSCstring data = src->gets();
    index.delHeadSpace();
    index.delTailSpace();
    index.delLineFeed();
    data.delLineFeed();
    if (!strcmp((char*)index,"#ENCODING")){
      setUseLocaleName(data);
    }else
    if (!strcmp((char*)index,"#LANG")){
      if (!strcmp(data,"Ruby")){
        _opt2->setProperty(WSNvalue,WS_LANG_RUBY);
      }else
      if (!strcmp(data,"Python")){
        _opt2->setProperty(WSNvalue,WS_LANG_PYTHON);
      }else
      if (!strcmp(data,"Perl")){
        _opt2->setProperty(WSNvalue,WS_LANG_PERL);
      }else{
        _opt2->setProperty(WSNvalue,WS_LANG_CPP);
      }
    }else
    if (!strcmp((char*)index,"#POLICY")){
      setGuiPolicy(data);
    }else
    if (!strcmp((char*)index,"#OUTPUT") && !strcmp((char*)data,"")){
      WSCstring fname(filename);
      long wnum = fname.getWords("/");
      data = fname.getWord(wnum -1,"/");
      data.replaceString(".prj","",1);
    }else
    if (!strcmp((char*)index,"#DBG_OUTPUT") && !strcmp((char*)data,"")){
      WSCstring fname(filename);
      long wnum = fname.getWords("/");
      data = fname.getWord(wnum -1,"/");
      data.replaceString(".prj","D",1);
    }
    if (!strncmp((char*)index,"#FONT",5)){
      long fno = atoi(&index[5]);
	  WSDfont* font = WSGIappFontSet()->getFont((short)fno);
	  if (font != NULL){
        font->setFontName(data);
	  }
    }
    setProjectData(index,data);
#if 0
    char* tmp = (char*)(*project_data)[index];
    if (tmp != NULL){
      delete tmp;
    }
    (*project_data)[index] = WSGFstrdup((char*)data);
    WSCbase* target = (WSCbase*)(*object_index)[(char*)index];
    if (target != NULL){
      if (!strcmp(target->getClassName(),"WSCvifield")){
        target->setProperty(WSNlabelString,(char*)data);
      }
    }else{
fprintf(stderr,"WSCproject::open Warring. %s is no effect value...\n",(char*)index);
    }
#endif
  }
  return 0;
}

long WSCprojectEditor::save(char* filename){
  if (_pe_radio1->getStatus() == False){
    updateData();
    WSCstring output(getProjectData(NULL,&_project_data,&_object_index));
    output << getProjectData(NULL,&_project_data3,&_object_index3);
    char* ptr = output.getString(WSGIappLocaleSet()->getSystemLocaleEncoding());
    
    long ret = WSGFreplaceFile(filename,(char*)ptr,strlen((char*)ptr),True);
    if (ret != WS_NO_ERR){
fprintf(stderr,"Error: WSCproejctEditor::_save() can not create project file...\n");
    }
    return ret;
  }else{
    return  _save(filename,&_project_data,&_object_index);
  }
}
long WSCprojectEditor::save_global(char* filename){
  return _save(filename,&_project_data2,&_object_index2);
}
long WSCprojectEditor::_save(char* filename,WSCindexData* project_data,WSCindexData* object_index){
  updateData();
  WSCstring output(getProjectData(NULL,project_data,object_index));
  char* ptr = output.getString(WSGIappLocaleSet()->getSystemLocaleEncoding());
    
  long ret = WSGFreplaceFile(filename,(char*)ptr,strlen((char*)ptr),True);
  if (ret != WS_NO_ERR){
fprintf(stderr,"Error: WSCproejctEditor::_save() can not create project file...\n");
  }
  return ret;
}

void WSCprojectEditor::setMenu(long no){
  _area2->setPropertyV(WSNvalue,(WSCuchar)no);
}
void WSCprojectEditor::adjustForm(){
  long diff = 0;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
    diff = 0;
  }else
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    diff = 5;
  }

  WSCbaseDialog::adjustForm();
  if (_h+diff > 100){
    _pe_elist->setPropertyV(WSNheight,(WSCushort)(_h+diff - 100));
  }else{
    _pe_elist->setPropertyV(WSNheight,(WSCushort)(1));
  }
  if (_w > 175){
    _pe_elist->setPropertyV(WSNwidth,(WSCushort)(_w - 175));
  }else{
    _pe_elist->setPropertyV(WSNwidth,(WSCushort)(1));
  }
}
void WSCprojectEditor::_pe_btn1_work(WSCbase* obj){
  WSCprojectEditor* pe = (WSCprojectEditor*)obj->getUserData("THIS");
  if (pe == NULL){
    return;
  }
  WSCfileSelect* fs = WSGIappFileSelect();
  fs->setPropertyV(WSNfileName,"");
#ifdef MSW
  fs->setPropertyV(WSNmaskFileName,"dll");
#else /*MSW*/
  fs->setPropertyV(WSNmaskFileName,"so");
#endif /*MSW*/
  long ret = fs->popup();
  if (ret == WS_DIALOG_OK){
    char buffer[2048];
    strcpy(buffer,fs->getFileName());
    WSGFcheckNameString(buffer);

    pe->_pe_elist->addItem(buffer,-1);
    pe->_pe_elist->draw();
    pe->setUseDll(buffer);
  }
}

void WSCprojectEditor::_pe_btn3_work(WSCbase* obj){
  WSCprojectEditor* pe = (WSCprojectEditor*)obj->getUserData("THIS");
  if (pe == NULL){
    return;
  }
  long pos = pe->_pe_elist->getSelectedPos();
  if (pos == -1){
    WSCmessageDialog* message = WSGIappMessageDialog();
    message->initialize();
    message->setPropertyV(WSNlabelString,WSGFgettext("l3:WSSTR Please select a target to delete."));
    message->popup();
    return;
  }
  pe->_pe_elist->delPos(pos);
  pe->_pe_elist->redraw();
}
void WSCprojectEditor::clearUseDll(){
  _dll_str.setString("");

  //WSCexternal instances will leak...
  long i;
  long num = _dll_list.getNum();
  for(i=0; i<num; i++){
    WSDexternal* ext = (WSDexternal*)_dll_list[i];
    ext->close();
    delete ext;
  }
  _dll_list.clear();
  if (_obox != NULL){
    _obox->clearItems();
  }
}
void WSCprojectEditor::setUseDll(char* str){
  _dll_str.setString(str);
  WSCstring dlls;
  dlls.setString(str);
  long num = dlls.getWords(",");
  long i;
  for(i=0; i<num; i++){
    WSCstring dll = dlls.getWord(i,",");
    dll.delHeadSpace();
    dll.delTailSpace();
    dll.delLineFeed();
    if (strcmp(dll.getString(),"")){
      long dnum = _dll_list.getNum();
      long j;
      WSCbool fl = False;
      for(j=0; j<dnum;j++){
        WSDexternal* ext = (WSDexternal*)_dll_list.getData(j);
        if (!strcmp(ext->getName(),dll.getString())){
//printf("WSCprojectEditor::setUseDll %s num=%d hit.\n",str,num);
          fl = True;
          break;
        }
      }
      if (fl == False){
//printf("WSCprojectEditor::setUseDll %s oldnum=%d\n",str,num);
        WSDexternal* ext = WSDexternal::getNewInstance();
        long ret = ext->open(dll.getString());
        if (ret == WS_NO_ERR){
          WSCstring* sym = ext->getObjectSymbols();
          if (_obox != NULL&& sym != NULL){
//printf("WSCprojectEditor::setUseDll add objbox  #%s#\n",sym->getString());
            _obox->addItems(sym);
            delete sym;
            _dll_list.add((void*)ext);
          }else{
            delete ext;
          }
        }
      }
    }
  }
}
void WSCprojectEditor::setObjectBox(WSCobjectBox* obox){
  _obox = obox;
}
void WSCprojectEditor::onGuiPolicyChange(long policy){
  if (_area1 != NULL){
    WSCbaseDialog::onGuiPolicyChange(policy);
    if (policy & WS_POLICY_ORIGINAL){
      _area1->setProperty(WSNy,5);
      _area1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
      _area2->setPropertyV(WSNshadowThickness,(WSCuchar)1);
      _pe_elist->setPropertyV(WSNshadowThickness,(WSCuchar)1);
      index002->setPropertyV(WSNshadowThickness,(WSCuchar)1);
      index0052->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    }else{
      _area1->setProperty(WSNy,0);
      _area1->setPropertyV(WSNshadowThickness,(WSCuchar)0);
      _area2->setPropertyV(WSNshadowThickness,(WSCuchar)2);
      _pe_elist->setPropertyV(WSNshadowThickness,(WSCuchar)2);
      index002->setPropertyV(WSNshadowThickness,(WSCuchar)2);
      index0052->setPropertyV(WSNshadowThickness,(WSCuchar)2);
    }
    if (policy & WS_POLICY_GRADATION){
      _pe_bt1->setProperty(WSNgradation,WS_GR_T_B);
      _pe_btn3->setProperty(WSNgradation,WS_GR_T_B);
      _opt1->setProperty(WSNgradation,WS_GR_L_R);
    }else{
      _pe_bt1->setProperty(WSNgradation,WS_GR_NONE);
      _pe_btn3->setProperty(WSNgradation,WS_GR_NONE);
      _opt1->setProperty(WSNgradation,WS_GR_NONE);
    }
    adjustForm();
  }
}
void WSCprojectEditor::setUseLocaleName(char* lname){
  _locale_name = lname;
  long i;
  long num = _opt1->getItemNum();
  for(i=0; i<num; i++){
    char* ptr = (char*)_opt1->getItemValue(i);
    if (ptr != NULL && !strcmp(lname,ptr)){
      _opt1->setProperty(WSNvalue,(long)ptr);
      return;
    }
  }
}
char* WSCprojectEditor::getUseLocaleName(){
//  return _locale_name.getString();
  return (char*)_opt1->getValue();
}

void WSCprojectEditor::_pe_fbt1_work(WSCbase* obj){
  WSCprojectEditor* _this = (WSCprojectEditor*)obj->getUserData("this");
#ifdef MSW
  WSGIappFileSelect()->setProperty(WSNmaskFileName,"exe");
#else
  WSGIappFileSelect()->setProperty(WSNmaskFileName,"");
#endif 
  long ret = WSGIappFileSelect()->popup();
  if (ret == WS_DIALOG_OK){
    WSCstring fname = WSGIappFileSelect()->getFileName();
    _this->_pe_ifi002->setPropertyV(WSNlabelString,(char*)fname);
  }
}
void WSCprojectEditor::_pe_fbt2_work(WSCbase* obj){
  WSCprojectEditor* _this = (WSCprojectEditor*)obj->getUserData("this");
#ifdef MSW
  WSGIappFileSelect()->setProperty(WSNmaskFileName,"exe");
#else
  WSGIappFileSelect()->setProperty(WSNmaskFileName,"");
#endif 
  long ret = WSGIappFileSelect()->popup();
  if (ret == WS_DIALOG_OK){
    WSCstring fname = WSGIappFileSelect()->getFileName();
    _this->_pe_ifi003->setPropertyV(WSNlabelString,(char*)fname);
  }
}
void WSCprojectEditor::_pe_fbt3_work(WSCbase* obj){
  WSCprojectEditor* _this = (WSCprojectEditor*)obj->getUserData("this");
#ifdef MSW
  WSGIappFileSelect()->setProperty(WSNmaskFileName,"exe");
#else
  WSGIappFileSelect()->setProperty(WSNmaskFileName,"");
#endif 
  long ret = WSGIappFileSelect()->popup();
  if (ret == WS_DIALOG_OK){
    WSCstring fname = WSGIappFileSelect()->getFileName();
    _this->_pe_ifi005->setPropertyV(WSNlabelString,(char*)fname);
  }
}
void WSCprojectEditor::_pe_fbt4_work(WSCbase* obj){
  WSCprojectEditor* _this = (WSCprojectEditor*)obj->getUserData("this");
#ifdef MSW
  WSGIappFileSelect()->setProperty(WSNmaskFileName,"exe");
#else
  WSGIappFileSelect()->setProperty(WSNmaskFileName,"");
#endif 
  long ret = WSGIappFileSelect()->popup();
  if (ret == WS_DIALOG_OK){
    WSCstring fname = WSGIappFileSelect()->getFileName();
    _this->_pe_ifi006->setPropertyV(WSNlabelString,(char*)fname);
  }
}
void WSCprojectEditor::_pe_fbt5_work(WSCbase* obj){
  WSCprojectEditor* _this = (WSCprojectEditor*)obj->getUserData("this");
#ifdef MSW
  WSGIappFileSelect()->setProperty(WSNmaskFileName,"exe");
#else
  WSGIappFileSelect()->setProperty(WSNmaskFileName,"");
#endif 
  long ret = WSGIappFileSelect()->popup();
  if (ret == WS_DIALOG_OK){
    WSCstring fname = WSGIappFileSelect()->getFileName();
    _this->_pe_ifi007->setPropertyV(WSNlabelString,(char*)fname);
  }
}
void WSCprojectEditor::_pe_fbt6_work(WSCbase* obj){
  WSCprojectEditor* _this = (WSCprojectEditor*)obj->getUserData("this");
#ifdef MSW
  WSGIappFileSelect()->setProperty(WSNmaskFileName,"exe");
#else
  WSGIappFileSelect()->setProperty(WSNmaskFileName,"");
#endif 
  long ret = WSGIappFileSelect()->popup();
  if (ret == WS_DIALOG_OK){
    WSCstring fname = WSGIappFileSelect()->getFileName();
    _this->_pe_ifi008->setPropertyV(WSNlabelString,(char*)fname);
  }
}
void WSCprojectEditor::_pe_fbt7_work(WSCbase* obj){
  WSCprojectEditor* _this = (WSCprojectEditor*)obj->getUserData("this");
#ifdef MSW
  WSGIappFileSelect()->setProperty(WSNmaskFileName,"exe");
#else
  WSGIappFileSelect()->setProperty(WSNmaskFileName,"");
#endif 
  long ret = WSGIappFileSelect()->popup();
  if (ret == WS_DIALOG_OK){
    WSCstring fname = WSGIappFileSelect()->getFileName();
    _this->_pe_ifi009->setPropertyV(WSNlabelString,(char*)fname);
  }
}
void WSCprojectEditor::_pe_fbt8_work(WSCbase* obj){
  WSCprojectEditor* _this = (WSCprojectEditor*)obj->getUserData("this");
#ifdef MSW
  WSGIappFileSelect()->setProperty(WSNmaskFileName,"exe");
#else
  WSGIappFileSelect()->setProperty(WSNmaskFileName,"");
#endif 
  long ret = WSGIappFileSelect()->popup();
  if (ret == WS_DIALOG_OK){
    WSCstring fname = WSGIappFileSelect()->getFileName();
    _this->_pe_ifi010->setPropertyV(WSNlabelString,(char*)fname);
  }
}
void WSCprojectEditor::_pe_fbt9_work(WSCbase* obj){
  WSCprojectEditor* _this = (WSCprojectEditor*)obj->getUserData("this");
#ifdef MSW
  WSGIappFileSelect()->setProperty(WSNmaskFileName,"exe");
#else
  WSGIappFileSelect()->setProperty(WSNmaskFileName,"");
#endif 
  long ret = WSGIappFileSelect()->popup();
  if (ret == WS_DIALOG_OK){
    WSCstring fname = WSGIappFileSelect()->getFileName();
    _this->_pe_ifi011->setPropertyV(WSNlabelString,(char*)fname);
  }
}

void WSCprojectEditor::_editor_option_work(WSCbase* obj){
  WSCprojectEditor* _this = (WSCprojectEditor*)obj->getUserData("this");
  long val = _this->_opt3->getValue();
  char* str = (char*)val;
  if (str != NULL){
//printf("WSCprojectEditor::_editor_option_work %s\n",str);
    _this->_pe_ifi012->setProperty(WSNlabelString,str);
  }
}


long WSCprojectEditor::getLanguage(){
  return _opt2->getValue();
}

void WSCprojectEditor::setLanguage(long val){
  _opt2->setProperty(WSNvalue,val);
}
void WSCprojectEditor::loadEditorOptions(char* fname){
  WSCstring* edata = WSGFreadTextFile(fname);
  if (edata != NULL){
    WSCstring opt;
    while(1){
      WSCstring ldata = edata->gets();
      WSCstring ename = ldata.getWord(0,":");
      WSCstring eopt = ldata.getWord(1,":");
//printf("WSCprojectEditor::loadEditorOptions %s %s %s\n",ldata.getString(),ename.getString(),eopt.getString());
      if (edata->eof()){
        opt << ename << ":" << (long)WSGFstrdup(eopt.getString()) << ":";
        break;
      }
      opt << ename << ":" << (long)WSGFstrdup(eopt.getString()) << ":,";
    }
//printf("WSCprojectEditor::loadEditorOptions %s\n",opt.getString());
    _opt3->setProperty(WSNmenuItems,opt.getString());
    delete edata;
  }
}
