//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCclassInformation.h>
#include <WSDdev.h>
#include <WSCdevice.h>
#include <WSCform.h>
#include <WSCvlabel.h>
#include <WSCindexForm.h>
#include <WSCsform.h>
#include <WSClist.h>
#include <WSCpopupMenu.h>
#include <WSCbaseList.h>
#include <WSDmouse.h>
#include <WSCfform.h>
#include <advance/WSCinspector.h>
#include <advance/WSCpropertyEditor.h>
#include <advance/WSCprocedureEditor.h>
#include <advance/WSCwindowEditor.h>

//#define WS_YOFFSET 5
//#define FLIPPED True
#define WS_YOFFSET 30
#define FLIPPED False

WSMFguiClassInitialize(WSCinspector,WSCsform);
WSMFversion(WSCinspector,WSCsform);
#define MENUSTR1  WSGFgettext("R3:WSSTR %s:DISP:,Save:SAVE:,Search:SEARCH:,SP,Compile:COMP:,%s:PRJ:,SP,Copy:COPY:,Paste:PASTE:,SP,Delete:DEL:")

#define D_BTN_WIDTH 80
WSMFpropertyValueChange(WSCinspector,WSNno,WSCbool,False);

WSCinspector::WSCinspector(WSCbase* base,char* objname):
                WSCsform(base,objname){

//  _base = NULL;
//  _area1 = NULL;
  _area2 = NULL;
  _prope = NULL;
  _we = NULL;
//  _no = 0;
  _w = 500;
  _h = 400;
  _pmenu = NULL;
  _list = NULL;
  _list2 = NULL;
  _selected = NULL;
  _pmenu_client = NULL;
  _file_list = NULL;
  _editor_proc = NULL;
  _fform = NULL;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCinspector);
//    WSMFpropertyCreate(WSNlabelString,   char*, _label_string,WSSlabelString);
    WSMFpropertyValueChangeDef(WSCinspector,WSNno,WSCbool);
    WSMFparentCheckVerSrc(WSCinspector);
  WSMFpropertyCreateEnd
}

WSCinspector::~WSCinspector(){
}

//WSMFproperty( WSCinspector, WSNlabelString, char*, _label_string,WSGFstrdup(""));
//void WSCinspector::setWorkWSNlabelString(char* str){
//    _label->setPropertyV(WSNlabelString,str);
//}
//void WSCinspector::getWorkWSNlabelString(char** str){}

void WSCinspector::setWorkWSNwidth(WSCushort data){
  WSCsform::setWorkWSNwidth(data);
//  _adjust();
}

void WSCinspector::setWorkWSNheight(WSCushort data){
  WSCsform::setWorkWSNheight(data);
//  _adjust();
}
void WSCinspector::setWorkWSNshadowThickness(WSCuchar data){
  WSCsform::setWorkWSNshadowThickness(data);
  _list2->setPropertyV(WSNshadowThickness,(WSCuchar)data);
  _area2->setPropertyV(WSNshadowThickness,(WSCuchar)data);
  _list->setPropertyV(WSNshadowThickness,(WSCuchar)data);
  _prope->setPropertyV(WSNshadowThickness,(WSCuchar)data);
  _ope->setPropertyV(WSNshadowThickness,(WSCuchar)data);
  _pmenu->setPropertyV(WSNshadowThickness,(WSCuchar)data);
  _pmenu2->setPropertyV(WSNshadowThickness,(WSCuchar)data);
  _file_list->setPropertyV(WSNshadowThickness,(WSCuchar)data);
}

long WSCinspector::initialize(){
  WSCsform::initialize();

  _list = new WSClist(this,(WSCstring)"is-lt-" + getInstanceName());
  _list->setInternalObject(True);
  _list->initialize();
  _list->setPropertyV(WSNx,     (short)0 );
  _list->setPropertyV(WSNy,     (short)0 );
  _list->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _list->setPropertyV(WSNtype,(WSCuchar)WS_TREE);
  _list->setPropertyV(WSNuseIcon,(WSCbool)True);
  _list->setPropertyV(WSNreverseSelect,(WSCbool)False);
  _list->setProperty(WSNpixmapStyle,WS_DYNAMIC_PIXMAP);
  _list->setVisible(True);
  _list->setUserData("inspector",this);

  _fform = new WSCfform(this,(WSCstring)"is-a1-" + getInstanceName());
  _fform->setInternalObject(True);
  _fform->initialize();
  _fform->setUserData("inspector",this);
  _fform->setProperty(WSNx,1);
  _fform->setProperty(WSNx,35);
  _fform->setPropertyV(WSNwidth,     (WSCushort)50 );
  _fform->setPropertyV(WSNheight,     (WSCushort)50 );
  _fform->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _fform->setProperty(WSNorientation,WS_HORIZONTAL);
  _fform->setProperty(WSNshadowThickness,0);
//  _fform->setProperty(WSNshadowType,WS_SHADOW_IN);

  _fform->setVisible(True);
  WSCprocedure* opf1 = new WSCprocedure("op0",WSEV_STATUS_CH);
  opf1->setFunction(_float_work,"WSCinspector::_float_work");
  _fform->addProcedure(opf1);
  WSCprocedure* op3 = new WSCprocedure("op0",WSEV_RESIZE);
  op3->setFunction(_area2_work,"WSCinspector::_area2_work");
  _fform->addProcedure(op3);


  _area2 = new WSCindexForm(_fform,(WSCstring)"is-a1-" + getInstanceName());
  _area2->setInternalObject(True);
  _area2->initialize();
  _area2->setPropertyV(WSNx,     (short)0 );
  _area2->setPropertyV(WSNy,     (short)15 );
  _area2->setPropertyV(WSNwidth,     (WSCushort)50 );
  _area2->setPropertyV(WSNheight,     (WSCushort)50 );
  _area2->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _area2->setPropertyV(WSNmenuItems,WSGFgettext("S3:WSSTR Files,Instances,Properties,Procedures,Attributes"));
  _area2->setProperty(WSNflip,FLIPPED);
  _area2->setProperty(WSNshadowType,WS_SHADOW_NONE);

#if 0
  _area2->setProperty(WSNanchorTopFlag,True);
  _area2->setProperty(WSNanchorTop,15);
  _area2->setProperty(WSNanchorBottomFlag,True);
  _area2->setProperty(WSNanchorBottom,0);
  _area2->setProperty(WSNanchorLeftFlag,True);
  _area2->setProperty(WSNanchorLeft,0);
  _area2->setProperty(WSNanchorRightFlag,True);
  _area2->setProperty(WSNanchorRight,0);
#endif
  _area2->setVisible(True);
  _area2->setUserData("inspector",this);

  _list2 = new WSClist(_area2,(WSCstring)"is-lt-" + getInstanceName());
  _list2->setInternalObject(True);
  _list2->initialize();
//  _list2->setPropertyV(WSNx,     (short)5 );
  _list2->setPropertyV(WSNx,     (short)0 );
  _list2->setPropertyV(WSNy,     (short)WS_YOFFSET );
  _list2->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _list2->setPropertyV(WSNtype,(WSCuchar)WS_VERBOSE);
  _list2->setPropertyV(WSNtitleString,WSGFgettext("T3:WSSTR Name,Class"));
  _list2->setPropertyV(WSNtitleHeight,(WSCuchar)20);
  _list2->setPropertyV(WSNbarValue,"150");
  _list2->setPropertyV(WSNuseIcon,(WSCbool)True);
  _list2->setPropertyV(WSNreverseSelect,(WSCbool)True);
  _list2->setPropertyV(WSNmultiSelect,(WSCbool)True);
  _list2->setPropertyV(WSNuserValue,(long)2);
  _list2->setVisible(True);
  _list2->setUserData("inspector",this);

  _file_list = new WSClist(_area2,(WSCstring)"is-lt-" + getInstanceName());
  _file_list->setInternalObject(True);
  _file_list->initialize();
//  _file_list->setPropertyV(WSNx,     (short)5 );
  _file_list->setPropertyV(WSNx,     (short)0 );
  _file_list->setPropertyV(WSNy,     (short)WS_YOFFSET );
  _file_list->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _file_list->setPropertyV(WSNtype,(WSCuchar)WS_TREE);
  _file_list->setPropertyV(WSNuseIcon,(WSCbool)True);
  _file_list->setPropertyV(WSNreverseSelect,(WSCbool)True);
  _file_list->setProperty(WSNpixmapStyle,WS_DYNAMIC_PIXMAP);
  _file_list->setPropertyV(WSNuserValue,(long)1);
  _file_list->setVisible(True);
  _file_list->setUserData("inspector",this);
  WSCprocedure* opf0 = new WSCprocedure("opf0",WSEV_VISIBLE_CH);
  opf0->setFunction(_file_list_vis_work,"WSCinspector::_file_list_vis_work");
  _file_list->addProcedure(opf0);



  _prope = new WSCpropertyEditor(_area2,(WSCstring)"is-e-" + getInstanceName());
  _prope->setInternalObject(True);
  _prope->initialize();
//  _prope->setPropertyV(WSNx,(short)5 );
  _prope->setPropertyV(WSNx,(short)0 );
  _prope->setPropertyV(WSNy,(short)WS_YOFFSET );
  _prope->setPropertyV(WSNwidth,     (WSCushort)50 );
  _prope->setPropertyV(WSNheight,     (WSCushort)50 );
//  _prope->setPropertyV(WSNtopShadowColor,WSGFcolor("gray95"));
//  _prope->setPropertyV(WSNbackColor,WSGFcolor("gray80"));
  _prope->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
//  _prope->setProperty(WSNworkBackColor,WS_DF_DARKBACKCOLOR);
//  _prope->setPropertyV(WSNbottomShadowColor,WSGFcolor("gray55"));
  _prope->setPropertyV(WSNuserValue,(long)3);
//  _prope->setPropertyV(WSNworkBackColor,WSGFcolor("gray85"));
  _prope->setPropertyV(WSNpixmapStyle,(WSCuchar)WS_DYNAMIC_PIXMAP);
  _prope->setVisible(True);
  _prope->setUserData("inspector",this);
  WSCprocedure* op0 = new WSCprocedure("op0",WSEV_ACTIVATE);
  op0->setFunction(_prope_activate_work,"WSCinspector::_prope_activate_work");
  _prope->addProcedure(op0);
  op0 = new WSCprocedure("op0",WSEV_VALUE_CH);
  op0->setFunction(_pe_select_work,"WSCinspector::_pe_select_work");
  _prope->addProcedure(op0);

  _ope = new WSCprocedureEditor(_area2,(WSCstring)"is-ope-" +getInstanceName());
  _ope->setInternalObject(True);
  _ope->initialize();
  _ope->setInternalObject(True);
//  _ope->setPropertyV(WSNx,(short)5 );
  _ope->setPropertyV(WSNx,(short)0 );
  _ope->setPropertyV(WSNy,(short)WS_YOFFSET );
  _ope->setPropertyV(WSNuserValue,(long)4);
  _ope->setVisible(True);
  _ope->setUserData("inspector",this);

  _we = new WSCwindowEditor(_area2,(WSCstring)"is-we-" + getInstanceName());
  _we->setInternalObject(True);
  _we->initialize();
//  _we->setPropertyV(WSNx,(short)5 );
  _we->setPropertyV(WSNx,(short)0 );
  _we->setPropertyV(WSNy,(short)WS_YOFFSET );
  _we->setPropertyV(WSNwidth,     (WSCushort)300 );
  _we->setPropertyV(WSNheight,     (WSCushort)300 );
//  _we->setPropertyV(WSNtopShadowColor,WSGFcolor("gray95"));
//  _we->setPropertyV(WSNbackColor,WSGFcolor("gray80"));
  _we->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _we->setProperty(WSNworkBackColor,WS_DF_DARKBACKCOLOR);
  _we->setProperty(WSNworkWidth,460);
//  _we->setProperty(WSNworkHeight,380);
  _we->setProperty(WSNworkHeight,410);
  _we->setProperty(WSNframe,False);
  _we->setProperty(WSNvbarVisible,True);
  _we->setProperty(WSNhbarVisible,True);
//  _we->setPropertyV(WSNbottomShadowColor,WSGFcolor("gray55"));
//  _we->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _we->setPropertyV(WSNuserValue,(long)5);
  _we->setVisible(True);
  _we->setUserData("inspector",this);
  WSCprocedure* op1 = new WSCprocedure("op0",WSEV_ACTIVATE);
  op1->setFunction(_prope_activate_work,"WSCinspector::_prope_activate_work");
  _we->addProcedure(op1);

  _pmenu = new WSCpopupMenu(NULL,"menu");
  _pmenu->initialize();
  _pmenu->setPropertyV(WSNmenuItemHeight,(WSCushort)20);
  _pmenu->setPropertyV(WSNmenuItems,"");
//  _pmenu->setPropertyV(WSNbackColor,"gray85");
//  _pmenu->setPropertyV(WSNtopShadowColor,"gray95");
//  _pmenu->setPropertyV(WSNbottomShadowColor,"gray55");
  _pmenu->setEmboss(True);
  _pmenu->setUserData("inspector",(void*)this); 
  WSCprocedure* op00 = new WSCprocedure("op0",WSEV_ACTIVATE);
  op00->setFunction(_popup_ch_work,"WSCinspector::_popup_ch_work");
  _pmenu->addProcedure(op00);

  WSCprocedure* pmop = new WSCprocedure("DISP",WSEV_NONE);
  pmop->setFunction(_disp_work,"_disp_work");
  _pmenu->addProcedure(pmop);

  pmop = new WSCprocedure("SAVE",WSEV_NONE);
  pmop->setFunction(_save_work,"_save_work");
  _pmenu->addProcedure(pmop);

  pmop = new WSCprocedure("COMP",WSEV_NONE);
  pmop->setFunction(_cmpl_work,"_cmpl_work");
  _pmenu->addProcedure(pmop);

  pmop = new WSCprocedure("PRJ",WSEV_NONE);
  pmop->setFunction(_prj_work,"_prj_work");
  _pmenu->addProcedure(pmop);

  pmop = new WSCprocedure("DEL",WSEV_NONE);
  pmop->setFunction(_del_work,"_del_work");
  _pmenu->addProcedure(pmop);

  pmop = new WSCprocedure("SEARCH",WSEV_NONE);
  pmop->setFunction(_search_work,"_search_work");
  _pmenu->addProcedure(pmop);

  pmop = new WSCprocedure("COPY",WSEV_NONE);
  pmop->setFunction(_copy_work,"_copy_work");
  _pmenu->addProcedure(pmop);

  pmop = new WSCprocedure("PASTE",WSEV_NONE);
  pmop->setFunction(_paste_work,"_paste_work");
  _pmenu->addProcedure(pmop);

  _pmenu2 = new WSCpopupMenu(NULL,"menu");
  _pmenu2->initialize();
  _pmenu2->setPropertyV(WSNmenuItemHeight,(WSCushort)20);
  _pmenu2->setPropertyV(WSNmenuItems,"");
//  _pmenu2->setPropertyV(WSNbackColor,"gray85");
//  _pmenu2->setPropertyV(WSNtopShadowColor,"gray95");
//  _pmenu2->setPropertyV(WSNbottomShadowColor,"gray55");
  _pmenu2->setEmboss(True);
  _pmenu2->setUserData("inspector",(void*)this); 
  WSCprocedure* op01 = new WSCprocedure("op0",WSEV_ACTIVATE);
  op01->setFunction(_popup_ch_work,"WSCinspector::_popup_ch_work");
  _pmenu2->addProcedure(op01);

  pmop = new WSCprocedure("DISP",WSEV_NONE);
  pmop->setFunction(_disp_work,"_disp_work");
  _pmenu2->addProcedure(pmop);

  pmop = new WSCprocedure("SAVE",WSEV_NONE);
  pmop->setFunction(_save_work,"_save_work");
  _pmenu2->addProcedure(pmop);

  pmop = new WSCprocedure("COMP",WSEV_NONE);
  pmop->setFunction(_cmpl_work,"_cmpl_work");
  _pmenu2->addProcedure(pmop);

  pmop = new WSCprocedure("PRJ",WSEV_NONE);
  pmop->setFunction(_prj_work,"_prj_work");
  _pmenu2->addProcedure(pmop);

  pmop = new WSCprocedure("DEL",WSEV_NONE);
  pmop->setFunction(_del_work,"_del_work");
  _pmenu2->addProcedure(pmop);

  pmop = new WSCprocedure("SEARCH",WSEV_NONE);
  pmop->setFunction(_search_work,"_search_work");
  _pmenu2->addProcedure(pmop);

  pmop = new WSCprocedure("COPY",WSEV_NONE);
  pmop->setFunction(_copy_work,"_copy_work");
  _pmenu2->addProcedure(pmop);

  pmop = new WSCprocedure("PASTE",WSEV_NONE);
  pmop->setFunction(_paste_work,"_paste_work");
  _pmenu2->addProcedure(pmop);

  _adjust_work();
  return WS_NO_ERR;
}
void WSCinspector::_popup_ch_work(WSCbase* ptr){
  WSCinspector* obj = (WSCinspector*)ptr->getUserData("inspector");

  WSCbase* client;
  ptr->getPropertyV(WSNclient,(void**)&client);
  obj->_pmenu_client = (WSCbase*)client->getUserData("client");
  WSCbase* target = obj->_pmenu_client;

  if (target == NULL){
    ptr->setPropertyV(WSNmenuItems,WSGFgettext("U3:WSSTR None:NONE:"));
    return;
  }
  while(1){
    if (target->getParent() == NULL){
      break;
    }
    target = target->getParent();
  }
  char buffer[256];
  if (target->getVisible() == False){
    sprintf(buffer,MENUSTR1,WSGFgettext("V3:WSSTR Display"),WSGFgettext("W3:WSSTR Add to project"));
  }else{
    sprintf(buffer,MENUSTR1,WSGFgettext("X3:WSSTR Dismiss"),WSGFgettext("Y3:WSSTR Remove from project"));
  }
  ptr->setPropertyV(WSNmenuItems,buffer);
}

void WSCinspector::_disp_work(WSCbase* ptr){
  WSCinspector* obj = (WSCinspector*)ptr->getUserData("inspector");
  WSCbase* target = obj->getPopupMenuSelectedClient();
  while(1){
    if (target->getParent() == NULL){
      break;
    }
    target = target->getParent();
  }
  if (target->getVisible() == False){
    target->setVisible(True);
  }else{
    target->setVisible(False);
  }
}
void WSCinspector::_cmpl_work(WSCbase* ptr){
  WSCinspector* obj = (WSCinspector*)ptr->getUserData("inspector");
  obj->execProcedure("COMP");
  obj->_pmenu_client = NULL;
}

void WSCinspector::_prj_work(WSCbase* ptr){
  WSCinspector* obj = (WSCinspector*)ptr->getUserData("inspector");
  obj->execProcedure("PRJ");
  obj->_pmenu_client = NULL;
}

void WSCinspector::_save_work(WSCbase* ptr){
  WSCinspector* obj = (WSCinspector*)ptr->getUserData("inspector");
  obj->execProcedure("SAVE");
  obj->_pmenu_client = NULL;
}

void WSCinspector::_del_work(WSCbase* ptr){
  WSCinspector* obj = (WSCinspector*)ptr->getUserData("inspector");
  obj->execProcedure("DEL");
  obj->_pmenu_client = NULL;
}
void WSCinspector::_search_work(WSCbase* ptr){
  WSCinspector* obj = (WSCinspector*)ptr->getUserData("inspector");
  obj->execProcedure("SEARCH");
  obj->_pmenu_client = NULL;
}
void WSCinspector::_paste_work(WSCbase* ptr){
  WSCinspector* obj = (WSCinspector*)ptr->getUserData("inspector");
  obj->execProcedure("PASTE");
  obj->_pmenu_client = NULL;
}
void WSCinspector::_copy_work(WSCbase* ptr){
  WSCinspector* obj = (WSCinspector*)ptr->getUserData("inspector");
  obj->execProcedure("COPY");
  obj->_pmenu_client = NULL;
}
void WSCinspector::_float_work(WSCbase* fform){
  WSCinspector* obj = (WSCinspector*)fform->getUserData("inspector");
  WSCbool floated = obj->_fform->getFloated();
  if (floated == True){
    obj->setManaged(fform,False);
  }else{
    obj->setManaged(fform,True);
  }
}
void WSCinspector::_area2_work(WSCbase* area){
  if (area->getVisible() == False){
    return;
  }
  WSCinspector* obj = (WSCinspector*)area->getUserData("inspector");

  if (obj->getStatus() == WS_SFORM_UNDER_RESIZING){
    return;
  }

  WSCushort w,h,b,h2;
//  obj->_area2->getPropertyV(WSNwidth,&w); 
  obj->_fform->getPropertyV(WSNwidth,&w); 
//  obj->_area2->getPropertyV(WSNheight,&h); 
  obj->_fform->getPropertyV(WSNheight,&h2); 
  obj->_area2->getPropertyV(WSNbarThickness,&b); 

  if (w > 0){
    obj->_area2->setPropertyV(WSNwidth, (WSCushort)(w));
  }else{
    obj->_area2->setPropertyV(WSNwidth, (WSCushort)(1));
  }
  if (w > 1){
    obj->_list2->setPropertyV(WSNwidth, (WSCushort)(w));
    obj->_prope->setPropertyV(WSNwidth, (WSCushort)(w));
    obj->_ope->setPropertyV(WSNwidth, (WSCushort)(w));
    obj->_we->setPropertyV(WSNwidth, (WSCushort)(w));
    obj->_file_list->setPropertyV(WSNwidth, (WSCushort)(w));
#if 0
    obj->_list2->setPropertyV(WSNwidth, (WSCushort)(w - 10));
    obj->_prope->setPropertyV(WSNwidth, (WSCushort)(w - 10));
    obj->_ope->setPropertyV(WSNwidth, (WSCushort)(w - 10));
    obj->_we->setPropertyV(WSNwidth, (WSCushort)(w - 10));
    obj->_file_list->setPropertyV(WSNwidth, (WSCushort)(w - 10));
#endif
  }else{
    obj->_list2->setPropertyV(WSNwidth, (WSCushort)(1));
    obj->_prope->setPropertyV(WSNwidth, (WSCushort)(1));
    obj->_ope->setPropertyV(WSNwidth, (WSCushort)(1));
    obj->_we->setPropertyV(WSNwidth, (WSCushort)(1));
    obj->_file_list->setPropertyV(WSNwidth, (WSCushort)(1));
  }
  h = h2 - 15;
  if (h > 0){
    obj->_area2->setPropertyV(WSNheight,(WSCushort)(h));
  }else{
    obj->_area2->setPropertyV(WSNheight,(WSCushort)(1));
  }
  h -= 2;
  if (h > 5 +b){
    obj->_list2->setPropertyV(WSNheight,(WSCushort)(h - 5 -b));
    obj->_prope->setPropertyV(WSNheight,(WSCushort)(h - 5 -b));
    obj->_ope->setPropertyV(WSNheight,(WSCushort)(h - 5 -b));
    obj->_we->setPropertyV(WSNheight,(WSCushort)(h - 5 -b));
    obj->_file_list->setPropertyV(WSNheight,(WSCushort)(h - 5 -b));
#if 0
    obj->_list2->setPropertyV(WSNheight,(WSCushort)(h - 10 -b));
    obj->_prope->setPropertyV(WSNheight,(WSCushort)(h - 10 -b));
    obj->_ope->setPropertyV(WSNheight,(WSCushort)(h - 10 -b));
    obj->_we->setPropertyV(WSNheight,(WSCushort)(h - 10 -b));
    obj->_file_list->setPropertyV(WSNheight,(WSCushort)(h - 10 -b));
#endif
  }else{
    obj->_list2->setPropertyV(WSNheight,(WSCushort)(1));
    obj->_prope->setPropertyV(WSNheight,(WSCushort)(1));
    obj->_ope->setPropertyV(WSNheight,(WSCushort)(1));
    obj->_we->setPropertyV(WSNheight,(WSCushort)(1));
    obj->_file_list->setPropertyV(WSNheight,(WSCushort)(1));
  }
}

void WSCinspector::onResize(WSCrect* rect){
  WSCsform::onResize(rect);
  _adjust_work();
}

void WSCinspector::_adjust_work(){
//  _area2->execResizeEvent(); 
}
WSCbase* WSCinspector::getPropertyEditor(){
  return _prope;
}
WSCbase* WSCinspector::getProcedureEditor(){
  return _ope;
}
WSCbase* WSCinspector::getSelectedClient(){
  WSCbase* client;
  _we->getPropertyV(WSNclient,(void**)&client);
  return client;
}

//list1(left) label selected...
void WSCinspector::_lb_activate_work(WSCbase* label){
//printf("WSCinspector::_lb_activate_work...\n");
  static long time = 0;
  long time2 = WSGFclocktime();
  long diff = time2 - time;
  time = time2;
//printf("diff=%d\n",diff);

  WSCbase* list = label->getParent();
  if (list == NULL){
    return;
  }

  if (diff < WS_DOUBLE_CLICK_TIME){
    long val = (long)label->getUserData(WS_LIST_TREE_OPEN);
    if (val == 1){
      label->setUserData(WS_LIST_TREE_OPEN,(void*)0);
    }else{
      label->setUserData(WS_LIST_TREE_OPEN,(void*)1);
    }
    WSClist* list2 = (WSClist*)list->cast("WSClist");
    list2->updateList();
    list2->redraw();
  }

  WSCinspector* ins = (WSCinspector*)list->getUserData("inspector");
  if (ins == NULL){
    return;
  }

  WSCbase* cl = (WSCbase*)label->getUserData("client");
  WSCbase* client;
  ins->_we->getPropertyV(WSNclient,(void**)&client);

  if (ins->_selected != NULL){
    ins->_selected->clear();
    if (cl != NULL){
      ins->_selected->add((void*)cl);
//printf("WSCinspector::_lb_active_work selected <= %s\n",cl->getInstanceName())
;
    }
  }
  if (client != cl){
    cl->setShowGriphand(True);
    ins->_prope->setPropertyV(WSNclient,(void*)cl);
    ins->_ope->setPropertyV(WSNclient,(void*)cl);
    ins->_we->setPropertyV(WSNclient,(void*)cl);
    long i;
    long num = ins->_target_list->getNum();
    ins->_we->setEditable(False);
    for(i=0; i<num; i++){
      WSCbase* window = (WSCbase*)(*ins->_target_list)[i];
      if (window == cl){
        ins->_we->setEditable(True);
        break;
      }
    }
  }

  ins->_list2->delAll();
  WSClistData children = cl->getChildren();
  long num = children.getNum();
  long i;
  for(i=0; i< num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      WSCstring str(child->getInstanceName());
      str << "," << child->getClassName();
      ins->_list2->addItem((char*)str);
      WSCbase* label =  ins->_list2->getLabel(-1);
      if (child->getObjectType() & WS_TYPE_MANAGER){
        label->setPropertyV(WSNlabelPixmap,"$(WSDIR)/sys/pixmaps/bi16.xpm");
      }else{
        label->setPropertyV(WSNlabelPixmap,"$(WSDIR)/sys/pixmaps/bi17.xpm");
      }
      ins->_pmenu2->registerClient(label);

      WSCprocedure* op = new WSCprocedure("label_selected",WSEV_ACTIVATE);
      op->setFunction(_lb_activate2_work,"WSCinspector::_lb_activate2_work");
      label->addProcedure(op);
      label->setUserData("client",(void*)child);

    }
  }
  ins->_list2->updateList();
  ins->_list2->redraw();
//printf("WSCinspector::_lb_activate_work done..\n");
}



void WSCinspector::_flb_activate_work(WSCbase* label){
//printf("WSCinspector::_lb_activate_work...\n");
  static long time = 0;
  long time2 = WSGFclocktime();
  long diff = time2 - time;
  time = time2;
//printf("diff=%d\n",diff);

  WSCbase* list = label->getParent();
  if (list == NULL){
    return;
  }

  WSCinspector* ins = (WSCinspector*)list->getUserData("inspector");
  if (ins == NULL){
    return;
  }
  if (diff < WS_DOUBLE_CLICK_TIME){
    if ( ins->_editor_proc != NULL){
      WSCstring str;
      str = label->getProperty(WSNuserString);
      ins->_editor_proc(ins->_ope,(char*)str);
    }
  }
}
void WSCinspector::_lb_press_work(WSCbase* label){
//printf("WSCinspector::_lb_press_work...\n");
  WSCbase* ptr = label->getParent();
  WSClist* list = (WSClist*)ptr->cast("WSClist");
  if (list == NULL){
    return;
  }
  long i;
  long num = list->getNum();
  for(i=0; i<num; i++){
    WSCbase* lb = list->getLabel(i);
    WSCbase* client = (WSCbase*)lb->getUserData("client");
    if (client != NULL && WSGIappObjectList()->existInstance(client)){
      client->setUserData(WS_LIST_TREE_OPEN,lb->getUserData(WS_LIST_TREE_OPEN));
//printf("WSCinspector::_lb_press_work %s open=%d\n",client->getInstanceName(),lb->getUserData(WS_LIST_TREE_OPEN));
    }
  }
}

void WSCinspector::_flb_press_work(WSCbase* label){
//printf("WSCinspector::_lb_press_work...\n");
  WSCbase* ptr = label->getParent();
  WSClist* list = (WSClist*)ptr->cast("WSClist");
  if (list == NULL){
    return;
  }

  WSCinspector* ins = (WSCinspector*)list->getUserData("inspector");
  if (ins == NULL){
    return;
  }

  WSCbase* cl = (WSCbase*)label->getUserData("client");
  WSCbase* client;
  ins->_we->getPropertyV(WSNclient,(void**)&client);

  if (ins->_selected != NULL){
    ins->_selected->clear();
    if (cl != NULL){
      ins->_selected->add((void*)cl);
    }
  }
  if (client != cl){
    cl->setShowGriphand(True);
    ins->_prope->setPropertyV(WSNclient,(void*)cl);
    ins->_ope->setPropertyV(WSNclient,(void*)cl);
    ins->_we->setPropertyV(WSNclient,(void*)cl);
    long i;
    long num = ins->_target_list->getNum();
    ins->_we->setEditable(False);
    for(i=0; i<num; i++){
      WSCbase* window = (WSCbase*)(*ins->_target_list)[i];
      if (window == cl){
        ins->_we->setEditable(True);
        break;
      }
    }
  }


  long i;
  long num = list->getNum();
  for(i=0; i<num; i++){
    WSCbase* lb = list->getLabel(i);
    WSCbase* client = (WSCbase*)lb->getUserData("client");
    if (client != NULL && WSGIappObjectList()->existInstance(client)){
      client->setUserData("file-list-tree-open",lb->getUserData(WS_LIST_TREE_OPEN));
    }
  }

}

//list2(right) label selected...
void WSCinspector::_lb_activate2_work(WSCbase* label){
//printf("WSCinspector::_lb_activate2_work...\n");
  WSCbase* list = label->getParent();
  if (list == NULL){
    return;
  }
  WSCinspector* ins = (WSCinspector*)list->getUserData("inspector");
  if (ins == NULL){
    return;
  }

  if (ins->_selected != NULL){
    WSClistData lbs;
    ins->_list2->getSelectedLabels(lbs);
    ins->_selected->clear();
    long num = lbs.getNum();
    long i;
    for(i=0; i<num; i++){
      WSCbase* lb = (WSCbase*)lbs[i];
      WSCbase* client = (WSCbase*)lb->getUserData("client");
      if (client != NULL){
        ins->_selected->add((void*)client);
      }
    }
  }
}


void WSCinspector::setSelectedClientList(WSClistData* list){
  _selected = list;
}
void WSCinspector::setClients(WSClistData* list){
  _target_list = list;
  updateList();
  _we->setPropertyV(WSNclient,(void*)NULL);
}
void WSCinspector::updateList(){
  _list->delAll();
  _file_list->delAll();
  long i;
  long num = _target_list->getNum();
  for(i=0; i<num; i++){
    WSCbase* item = (WSCbase*)(*_target_list)[i];
    _set_list_work(item,0);
    WSCstring fname(item->getInstanceName());
    fname << ".win";
    _file_list->addItem(fname);
    _file_list->getLabel(-1)->setPropertyV(WSNlabelPixmap,"$(WSDIR)/sys/pixmaps/bi17.xpm");
    WSCbase* label = _file_list->getLabel(-1);
    label->setUserData(WS_LIST_TREE_OPEN,item->getUserData("file-list-tree-open"));
    _set_file_list_work(item);

//    WSCprocedure* op = new WSCprocedure("label_selected",WSEV_ACTIVATE);
//    op->setFunction(_lb_activate_work,"WSCinspector::_lb_activate_work");
//    label->addProcedure(op);

    WSCprocedure* op = new WSCprocedure("label_pressed",WSEV_MOUSE_PRESS);
    op->setFunction(_flb_press_work,"WSCinspector::_flb_press_work");
    label->addProcedure(op);

    label->setUserData("client",(void*)item);
  }

  _list->updateList();
  _list->redraw();
  _list2->updateList();
  _list2->cdraw();
  _list2->redraw();
  _file_list->updateList();
  _file_list->redraw();
}
void WSCinspector::_file_list_vis_work(WSCbase* obj){
  if (obj->getVisible() == False){
    return;
  }
  WSCinspector* ins = (WSCinspector*)obj->getUserData("inspector");

  ins->_file_list->delAll();
  long i;
  long num = ins->_target_list->getNum();
  for(i=0; i<num; i++){
    WSCbase* item = (WSCbase*)ins->_target_list->getData(i);

    WSCstring fname(item->getInstanceName());
    fname << ".win";
    ins->_file_list->addItem(fname);
    WSCbase* label = ins->_file_list->getLabel(-1);

    label->setPropertyV(WSNlabelPixmap,"$(WSDIR)/sys/pixmaps/bi17.xpm");
    label->setUserData(WS_LIST_TREE_OPEN,item->getUserData("file-list-tree-open"));

//    WSCprocedure* op = new WSCprocedure("label_selected",WSEV_ACTIVATE);
//    op->setFunction(_flb_activate_work,"WSCinspector::_flb_activate_work");
//    label->addProcedure(op);

    WSCprocedure* op2 = new WSCprocedure("label_pressed",WSEV_MOUSE_PRESS);
    op2->setFunction(_flb_press_work,"WSCinspector::_flb_press_work");
    label->addProcedure(op2);

    label->setUserData("client",(void*)item);

    ins->_set_file_list_work(item);
  }

  ins->_file_list->updateList();
  ins->_file_list->redraw();
}

void WSCinspector::_set_file_list_work(WSCbase* item){
  WSClistData* plist = item->getProcedureList();
  if (plist != NULL){
    long num = plist->getNum();
    long i;
    for(i=0; i<num; i++){
      WSCprocedure* proc = (WSCprocedure*)plist->getData(i);
      if (proc->getInternal() != False){
        continue;
      }
      if (proc->getUseFile() == False){
        continue;
      }

      WSCbase* win = item->getParentWindow();
      WSCstring srcname;
      long lang = WSGFgetLanguage();
      if (lang == WS_LANG_CPP){
        srcname << proc->getFunctionName() << ".cpp";
        if (win != NULL && win->getUserData(WS_WIN_CLASS) != 0){
          srcname = "";
          srcname << win->getInstanceName() << "_" <<
                     proc->getFunctionName() << ".cpp";
        }
      }else
      if (lang == WS_LANG_RUBY){
        srcname << proc->getFunctionName() << ".rb";
      }else
      if (lang == WS_LANG_PYTHON){
        srcname << proc->getFunctionName() << ".py";
      }else
      if (lang == WS_LANG_PERL){
        srcname << proc->getFunctionName() << ".pl";
      }

      WSCstring fname(srcname);
      fname << ": " << item->getInstanceName();
      _file_list->addItem(fname);

      _file_list->getLabel(-1)->setPropertyV(WSNlabelPixmap,"$(WSDIR)/sys/pixmaps/bi17.xpm");
      _file_list->setItemValue(-1,WS_INDENT_LEVEL,1);

      WSCbase* label = _file_list->getLabel(-1);
      WSCprocedure* op = new WSCprocedure("label_selected",WSEV_ACTIVATE);
      op->setFunction(_flb_activate_work,"WSCinspector::_flb_activate_work");
      label->addProcedure(op);
      label->setProperty(WSNuserString,srcname);


      WSCprocedure* op2 = new WSCprocedure("label_pressed",WSEV_MOUSE_PRESS);
      op2->setFunction(_flb_press_work,"WSCinspector::_flb_press_work");
      label->addProcedure(op2);

      label->setUserData("client",(void*)item);
    }
  }

  WSClistData children = item->getChildren();
  long i;
  long num = children.getNum();
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      _set_file_list_work(child);
    }
  }
}

void WSCinspector::_set_list_work(WSCbase* item,long level){
  _list->addItem(item->getInstanceName());
  if (item->getObjectType() & WS_TYPE_MANAGER){
    _list->getLabel(-1)->setPropertyV(WSNlabelPixmap,"$(WSDIR)/sys/pixmaps/bi16.xpm");
  }else{
    _list->getLabel(-1)->setPropertyV(WSNlabelPixmap,"$(WSDIR)/sys/pixmaps/bi17.xpm");
  }
  _list->setItemValue(-1,WS_INDENT_LEVEL,level);
  WSCbase* label = _list->getLabel(-1);

  WSCprocedure* op = new WSCprocedure("label_selected",WSEV_ACTIVATE);
  op->setFunction(_lb_activate_work,"WSCinspector::_lb_activate_work");
  label->addProcedure(op);

  op = new WSCprocedure("label_pressed",WSEV_MOUSE_PRESS);
  op->setFunction(_lb_press_work,"WSCinspector::_lb_press_work");
  label->addProcedure(op);

  label->setUserData("client",(void*)item);
  label->setUserData(WS_LIST_TREE_OPEN,item->getUserData(WS_LIST_TREE_OPEN));
//printf("WSCinspector::_set_list_work %s open=%d\n",item->getInstanceName(),item->getUserData(WS_LIST_TREE_OPEN));
  _pmenu->registerClient(label);

  WSCbase* fclient;
  _prope->getPropertyV(WSNclient,(void**)&fclient);
  if (item == fclient){
    _list->setSelectPos(-1);
    label->execProcedure(WSEV_ACTIVATE);
  }

  WSClistData children = item->getChildren();
  long i;
  long num = children.getNum();
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      _set_list_work(child,level+1);
    }
  }
}
void WSCinspector::_pe_select_work(WSCbase* pe){
//printf("WSCinspector::_pe_select_work ..\n");
  WSCinspector* ins = (WSCinspector*)pe->getUserData("inspector");
  WSCbase* client;
  pe->getPropertyV(WSNclient,(void**)&client);
  ins->_we->setPropertyV(WSNclient,(void*)client);
  ins->_ope->setPropertyV(WSNclient,(void*)client);
  if (client == NULL){
    ins->_list2->delAll();
    ins->_list2->redraw();
//printf("WSCinspector::_pe_select_work return NULL.\n");
    return;
  }
  long num = ins->_list->getNum();
  long i;
//printf("WSCinspector::_pe_select_work num=%d\n",num);
  for(i=0; i<num; i++){
    WSCbase* lb = ins->_list->getLabel(i);
    WSCbase* cl = (WSCbase*)lb->getUserData("client");
    if (cl == client){
      long sp = ins->_list->getSelectedPos();
      if (sp != i){
        ins->_list->setSelectPos(i);
//printf("WSCinspector::_pe_select_work exec lb activate.\n");
        ins->_list->setItemValue(i,WS_ABSOLUTE_OPEN,1);
        lb->execProcedure(WSEV_ACTIVATE); 
        ins->_list->updateList();
        ins->_list->redraw();
      }
      return;
    } 
  }
}
WSCbase* WSCinspector::_search_inst_work(char* name,WSCbase* target){
  if (!strcmp(name,target->getInstanceName())){
    return target;
  }
  long i;
  WSClistData children = target->getChildren();
  long num = children.getNum();
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      WSCbase* ret = _search_inst_work(name,child);
      if (ret != NULL){
        return ret;
      }
    }
  }
  return NULL;
}

void WSCinspector::_prope_activate_work(WSCbase* ptr){
  WSCinspector* obj = (WSCinspector*)ptr->getUserData("inspector");
  WSCbase* client;
  ptr->getPropertyV(WSNclient,(void**)&client);
  if (client != NULL){
    obj->_update_lb();
  }
}

void WSCinspector::_update_lb(){
  long num = _list->getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* label = _list->getLabel(i);
    WSCbase* target = (WSCbase*)label->getUserData("client");
    char* lbstr;
    label->getPropertyV(WSNlabelString,&lbstr);
    if (strcmp(lbstr,target->getInstanceName())){
      label->setPropertyV(WSNlabelString,target->getInstanceName());
    }
  }
}
void WSCinspector::setGetDirHandler(void* hd){
  _ope->setGetDirHandler(hd);
}
void WSCinspector::setEditorExecuteHandler(void* hd){
  _editor_proc = (void(*)(WSCprocedureEditor*,char*))hd;
  _ope->setEditorExecuteHandler(hd);
}
WSCbase* WSCinspector::getPopupMenuSelectedClient(){
  return _pmenu_client;
}
WSCbase* WSCinspector::getPropertyInheritChild(){
  return _area2;
}

long WSCinspector::draw(){
  if (getVisible() == False){
    return WS_NO_ERR;
  }
  if (_adjust_init == 0){
    _adjust_init = 1;
    _parse_pos(_pos);
  }
  if (_need_adjust != False){
    _adjust();
  }
  if (_no_refresh != False){
    WSCbase::update();
    setAbsoluteDraw(False);
    return WS_NO_ERR;
  }
#if 0
  if (getVisible() == False){
    return WS_NO_ERR;
  }
#endif
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }

  WSCbool absolute = getAbsoluteDraw();
  if (absolute == False  ){
    if ( dev->isExposed(0,0,_w,_h) == False ){
      return WS_NO_ERR;
    }
  }
  long err = dev->beginDraw(0,0,_w,_h,absolute);
  if (err != WS_NO_ERR){
    return WS_NO_ERR;
  }
  short ex = 0;
  short ey = 0;
  WSCushort ew = _w;
  WSCushort eh = _h;
  if (absolute == False){
    dev->getExposedArea(&ex,&ey,&ew,&eh);
  }
  WSCbase::update();
  setAbsoluteDraw(False);
  if (_bp_color == -1){
    if (_grad_no == 0){
      dev->setForeColor(_back_color);
      dev->drawFillRect(0,0,_w,_h);
    }else{
      dev->drawGradation(_grad_no,_ts_color,_back_color,_bs_color,0,0,_w,_h,_grad_margin);
    }
  }
  if (getDotMode() == True){
    dev->setForeColor(_fore_color);
    long i,j;
    for(i=0; i<_w; i+=10){
      for(j=0; j<_h; j+=10){
        if (ex < i && i < ex+ ew &&
            ey < j && j < ey+ eh ){
          dev->drawFillRect(i,j,1,1);
        }
      }
    }
  }
  dev->endDraw();
  return WS_NO_ERR;
}

