/*-------------------------------------------------------------------------*/
/*  J3W ver 6.40  3D Animation Kit                                         */
/*  vertex.h      11/22/97                                                 */
/*  Copyright (C) 1996 - 1999 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_vertex_h)
#define _vertex_h

#include "misc3d.h"

class
  TVertex {
    int    Max;
    int    Count;
    int    Offset;
    Vector rposition;
  public:
    VectorSet **vert;
    TVertex(int vn);
    ~TVertex();

    int  GetCount() { return Count;}

    int  GetMaxCount() { return Max;}

    void Add(Vector v);

    void Assign(int pos, Vector v);

    void Query(int pos, Vector &v);

    void SetPosition(Vector v) { rposition = v;}

    void Transpose(int pos, Vector v);

    void UpdateOffset() { Offset = Count;}

    void ResetOffset() { Offset = 0;}

    int  GetOffset() { return Offset;}

  };

#endif
