//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSDPRDEV_H
#define WSDPRDEV_H

#include <WScom.h>
#include <WSCroot.h>
#include <WSDdev.h>
#include <WSClistData.h>
#include <WSDfile.h>

class WSDprDev :public WSDdev{

 protected:
  WSDfile* _file;
  short _work_x;
  short _work_y;
  WSCushort _work_width;
  WSCushort _work_height;
  unsigned  _format:4;
  unsigned  _type:2;
  unsigned  _orientation:1;
  
  
 public:
  WSDprDev();

  virtual long    initialize();
  virtual long    beginDraw(short x,short y,WSCushort w,WSCushort h,WSCbool absolute,WSCbool scaling = True);
  virtual long    endDraw();
  virtual long  setValue(long kind,void* data);
  virtual long  getValue(long kind, void* value);
  virtual WSCbool getReady();
  virtual long getExposedArea(short* x,short* y,WSCushort* w,WSCushort* h,WSCbool scaling = True);
  void setFile(WSDfile*);
  virtual WSCbool isExposed(short,short,WSCushort,WSCushort,WSCbool scaling = True);

  virtual long getDeviceResource();
  virtual long getWindowResource();
  virtual long getContextResource();
  virtual long getSpecialResource();


  WSMFclassDef(WSDprDev,WSDdev);
};
#endif
