#ifndef WSCDBDRV_H
#define WSCDBDRV_H

#include <stdio.h>

#include <WScom.h>
#include <WSCvariant.h>
#include <WSCdb.h>

class WSCdbDrvRecord;

class WSCdbDrvDatabase
{
protected:
	void* _this;
public:
	WSCdbDrvDatabase();
	virtual ~WSCdbDrvDatabase();
	
	virtual long    open(char* host, char* uid, char* pwd, char* dbname, char* port = NULL);
	virtual long    close();
	virtual long    beginTran();
	virtual long    commitTran();
	virtual long    abortTran();
	virtual long    sqlExecute(const char* stmt);
	virtual WSCbool isOpen();
	virtual void    getErrorMsg(char* szState, char* szMsg);
	virtual void    getErrorMsg(char* szMsg,long size);
	virtual void    setEncode(long code);
	virtual long    getEncode();

private:
	void getError();

public:
	void setThisPtr(void*);
	void* getThisPtr();

};

class WSCdbDrvRecord
{
public:
	WSCdbDrvRecord(WSCdbDrvDatabase* pDatabase);
	virtual ~WSCdbDrvRecord();
	virtual long    open(const char* stmt);
	virtual long    open(const char* stmt, short eCousor, short eAccess = WSCDB_SQL_CONCUR_LOCK);
	virtual long    close();
	virtual WSCbool isEOF();
	virtual WSCbool isOpen();
	virtual long    getColValue(long index, WSCvariant* var);
	virtual long    getColValue(const char* name, WSCvariant* var);
	virtual long    getColStringValue(long index, char* var);
	virtual long    getColStringValue(const char* name, char* var);
	virtual long    setColValue(long index, WSCvariant var);
	virtual long    setColValue(const char* name, WSCvariant var);
	virtual long    edit();
	virtual long    update();
	virtual long    addnew();
	virtual long    deleterow();
	virtual long    moveNext();
	virtual long    movePrevious();
	virtual long    moveFirst();
	virtual long    moveLast();
	virtual long    getColName(long index, char* name);
	virtual long    getColIndex(const char* name);
	virtual long    getColType(long index);
	virtual long    getColType(const char* name);
	virtual long    getColLength(long index);
	virtual long    getColLength(const char* name);
	virtual long    getRowCount();
	virtual long    getColCount();
	virtual void    getErrorMsg(char* szState, char* szMsg);

private:
	void Cleanup(WSCdbDrvDatabase* pDatabase);
	long BindCols();
	void ReleaseCols();
	void getValue(int index, WSCvariant* var);
	void setValue(int index, WSCvariant* var);
	void getError();

};

#endif		// WSCDBDRV_H


