/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import weka.LocalString;
import weka.gui.ResultHistoryPanel;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TextEvent;
import weka.gui.beans.TextListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;

public class TextViewer
extends JPanel
implements TextListener,
DataSourceListener,
TrainingSetListener,
TestSetListener,
Visible,
UserRequestAcceptor,
Serializable,
BeanContextChild {
    protected BeanVisual m_visual;
    private transient JFrame m_resultsFrame = null;
    private transient JTextArea m_outText = new JTextArea(20, 80);
    protected transient ResultHistoryPanel m_history = new ResultHistoryPanel(this.m_outText);
    protected boolean m_design;
    protected transient BeanContext m_beanContext = null;
    protected BeanContextChildSupport m_bcSupport = new BeanContextChildSupport(this);

    public TextViewer() {
        this.appearanceFinal();
    }

    protected void appearanceDesign() {
        this.setUpResultHistory();
        this.removeAll();
        this.m_visual = new BeanVisual(LocalString.get("TextViewer"), "weka/gui/beans/icons/DefaultText.gif", "weka/gui/beans/icons/DefaultText_animated.gif");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    protected void appearanceFinal() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setUpFinal();
    }

    protected void setUpFinal() {
        this.setUpResultHistory();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.m_outText);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(LocalString.get("Text")));
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)this.m_history, "West");
        this.add((Component)jPanel, "Center");
    }

    public String globalInfo() {
        return LocalString.get("General purpose text display.");
    }

    private void setUpResultHistory() {
        if (this.m_outText == null) {
            this.m_outText = new JTextArea(20, 80);
            this.m_history = new ResultHistoryPanel(this.m_outText);
        }
        this.m_outText.setEditable(false);
        this.m_outText.setFont(new Font(LocalString.get("Monospaced"), 0, 12));
        this.m_outText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_history.setBorder(BorderFactory.createTitledBorder(LocalString.get("Result list")));
    }

    public synchronized void acceptDataSet(DataSetEvent dataSetEvent) {
        TextEvent textEvent = new TextEvent(dataSetEvent.getSource(), dataSetEvent.getDataSet().toString(), dataSetEvent.getDataSet().relationName());
        this.acceptText(textEvent);
    }

    public synchronized void acceptTrainingSet(TrainingSetEvent trainingSetEvent) {
        TextEvent textEvent = new TextEvent(trainingSetEvent.getSource(), trainingSetEvent.getTrainingSet().toString(), trainingSetEvent.getTrainingSet().relationName());
        this.acceptText(textEvent);
    }

    public synchronized void acceptTestSet(TestSetEvent testSetEvent) {
        TextEvent textEvent = new TextEvent(testSetEvent.getSource(), testSetEvent.getTestSet().toString(), testSetEvent.getTestSet().relationName());
        this.acceptText(textEvent);
    }

    public synchronized void acceptText(TextEvent textEvent) {
        if (this.m_outText == null) {
            this.setUpResultHistory();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(textEvent.getText());
        String string = new SimpleDateFormat(LocalString.get("HH:mm:ss - ")).format(new Date());
        string = string + textEvent.getTextTitle();
        System.err.println(string);
        if (string.length() > 30) {
            string = string.substring(0, 30);
        }
        int n = 2;
        String string2 = new String(string);
        while (this.m_history.getNamedBuffer(string) != null) {
            string = new String(string2 + "" + n);
            ++n;
        }
        this.m_history.addResult(string, stringBuffer);
        this.m_history.setSingle(string);
    }

    public void setVisual(BeanVisual beanVisual) {
        this.m_visual = beanVisual;
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultText.gif", "weka/gui/beans/icons/DefaultText_animated.gif");
    }

    public void showResults() {
        if (this.m_resultsFrame == null) {
            if (this.m_outText == null) {
                this.setUpResultHistory();
            }
            this.m_resultsFrame = new JFrame(LocalString.get("Text Viewer"));
            this.m_resultsFrame.getContentPane().setLayout(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane(this.m_outText);
            jScrollPane.setBorder(BorderFactory.createTitledBorder(LocalString.get("Text")));
            this.m_resultsFrame.getContentPane().add((Component)jScrollPane, "Center");
            this.m_resultsFrame.getContentPane().add((Component)this.m_history, "West");
            this.m_resultsFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    TextViewer.this.m_resultsFrame.dispose();
                    TextViewer.this.m_resultsFrame = null;
                }
            });
            this.m_resultsFrame.pack();
            this.m_resultsFrame.setVisible(true);
        } else {
            this.m_resultsFrame.toFront();
        }
    }

    public Enumeration enumerateRequests() {
        Vector<String> vector = new Vector<String>(0);
        vector.addElement(LocalString.get("Show results"));
        vector.addElement(LocalString.get("Clear results"));
        return vector.elements();
    }

    public void performRequest(String string) {
        if (string.compareTo(LocalString.get("Show results")) == 0) {
            this.showResults();
        } else if (string.compareTo(LocalString.get("Clear results")) == 0) {
            this.m_outText.setText("");
        } else {
            throw new IllegalArgumentException(string + LocalString.get(" not supported (TextViewer)"));
        }
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_bcSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_bcSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void addVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        this.m_bcSupport.addVetoableChangeListener(string, vetoableChangeListener);
    }

    public void removeVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        this.m_bcSupport.removeVetoableChangeListener(string, vetoableChangeListener);
    }

    public void setBeanContext(BeanContext beanContext) {
        this.m_beanContext = beanContext;
        this.m_design = this.m_beanContext.isDesignTime();
        if (this.m_design) {
            this.appearanceDesign();
        } else {
            this.appearanceFinal();
        }
    }

    public BeanContext getBeanContext() {
        return this.m_beanContext;
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame();
            jFrame.getContentPane().setLayout(new BorderLayout());
            TextViewer textViewer = new TextViewer();
            textViewer.acceptText(new TextEvent(textViewer, LocalString.get("Here is some test text from the main ") + LocalString.get("method of this class."), LocalString.get("The Title")));
            jFrame.getContentPane().add((Component)textViewer, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.setSize(800, 600);
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

