/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.arffviewer;

import java.awt.datatransfer.StringSelection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import weka.LocalString;
import weka.gui.ComponentHelper;
import weka.gui.JTableHelper;
import weka.gui.arffviewer.ArffTableCellRenderer;
import weka.gui.arffviewer.ArffTableSorter;

public class ArffTable
extends JTable {
    private String searchString;
    private HashSet changeListeners;

    public ArffTable() {
        this(new ArffTableSorter(""));
    }

    public ArffTable(TableModel tableModel) {
        super(tableModel);
        this.setAutoResizeMode(0);
    }

    public void setModel(TableModel tableModel) {
        this.searchString = null;
        if (this.changeListeners == null) {
            this.changeListeners = new HashSet();
        }
        super.setModel(tableModel);
        if (tableModel == null) {
            return;
        }
        if (!(tableModel instanceof ArffTableSorter)) {
            return;
        }
        ArffTableSorter arffTableSorter = (ArffTableSorter)tableModel;
        arffTableSorter.addMouseListenerToHeaderInTable(this);
        arffTableSorter.addTableModelListener(this);
        arffTableSorter.sortByColumn(0);
        this.setLayout();
        this.setSelectedColumn(0);
    }

    private void setLayout() {
        ArffTableSorter arffTableSorter = (ArffTableSorter)this.getModel();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            JTableHelper.setOptimalHeaderWidth(this, i);
            this.getColumnModel().getColumn(i).setCellRenderer(new ArffTableCellRenderer());
            if (i <= 0) continue;
            if (arffTableSorter.getType(i) == 1) {
                JComboBox jComboBox = new JComboBox();
                jComboBox.addItem(null);
                Enumeration enumeration = arffTableSorter.getInstances().attribute(i - 1).enumerateValues();
                while (enumeration.hasMoreElements()) {
                    jComboBox.addItem(enumeration.nextElement());
                }
                this.getColumnModel().getColumn(i).setCellEditor(new DefaultCellEditor(jComboBox));
                continue;
            }
            this.getColumnModel().getColumn(i).setCellEditor(null);
        }
    }

    public String getPlainColumnName(int n) {
        String string = "";
        if (this.getModel() == null) {
            return string;
        }
        if (!(this.getModel() instanceof ArffTableSorter)) {
            return string;
        }
        ArffTableSorter arffTableSorter = (ArffTableSorter)this.getModel();
        if (n >= 0 && n < this.getColumnCount()) {
            string = n == 0 ? "No." : arffTableSorter.getAttributeAt(n).name();
        }
        return string;
    }

    public StringSelection getStringSelection() {
        int n;
        int[] nArray;
        StringSelection stringSelection = null;
        if (this.getSelectedRow() == -1) {
            if (ComponentHelper.showMessageBox(this.getParent(), LocalString.get("Question..."), LocalString.get("Do you really want to copy the whole table?"), 0, 3) != 0) {
                return stringSelection;
            }
            nArray = new int[this.getRowCount()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = n;
            }
        } else {
            nArray = this.getSelectedRows();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.getColumnCount(); ++n) {
            if (n > 0) {
                stringBuffer.append("\t");
            }
            stringBuffer.append(this.getPlainColumnName(n));
        }
        stringBuffer.append("\n");
        for (n = 0; n < nArray.length; ++n) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (i > 0) {
                    stringBuffer.append("\t");
                }
                stringBuffer.append(this.getValueAt(nArray[n], i).toString());
            }
            stringBuffer.append("\n");
        }
        stringSelection = new StringSelection(stringBuffer.toString());
        return stringSelection;
    }

    public void setSearchString(String string) {
        this.searchString = string;
        this.repaint();
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSelectedColumn(int n) {
        this.getColumnModel().getSelectionModel().clearSelection();
        this.getColumnModel().getSelectionModel().setSelectionInterval(n, n);
        this.resizeAndRepaint();
        if (this.getTableHeader() != null) {
            this.getTableHeader().resizeAndRepaint();
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        this.setLayout();
        this.notifyListener();
    }

    private void notifyListener() {
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(new ChangeEvent(this));
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }
}

