/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.LocalString;
import weka.core.Instances;
import weka.gui.arffviewer.ArffPanel;

public class ViewerDialog
extends JDialog
implements ChangeListener {
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    protected int m_Result = 1;
    protected JButton m_OkButton = new JButton("OK");
    protected JButton m_CancelButton = new JButton(LocalString.get("Cancel"));
    protected JButton m_UndoButton = new JButton(LocalString.get("Undo"));
    protected ArffPanel m_ArffPanel = new ArffPanel();

    public ViewerDialog(Frame frame) {
        super(frame, true);
        this.createDialog();
    }

    protected void createDialog() {
        this.setTitle(LocalString.get("Viewer"));
        this.getContentPane().setLayout(new BorderLayout());
        this.m_ArffPanel.addChangeListener(this);
        this.getContentPane().add((Component)this.m_ArffPanel, "Center");
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.getContentPane().add((Component)jPanel, "South");
        this.m_UndoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewerDialog.this.undo();
            }
        });
        this.getContentPane().add((Component)jPanel, "South");
        this.m_CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewerDialog.this.m_Result = 1;
                ViewerDialog.this.setVisible(false);
            }
        });
        this.m_OkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewerDialog.this.m_Result = 0;
                ViewerDialog.this.setVisible(false);
            }
        });
        jPanel.add(this.m_UndoButton);
        jPanel.add(this.m_OkButton);
        jPanel.add(this.m_CancelButton);
        this.pack();
    }

    public void setInstances(Instances instances) {
        this.m_ArffPanel.setInstances(new Instances(instances));
    }

    public Instances getInstances() {
        return this.m_ArffPanel.getInstances();
    }

    protected void setButtons() {
        this.m_OkButton.setEnabled(true);
        this.m_CancelButton.setEnabled(true);
        this.m_UndoButton.setEnabled(this.m_ArffPanel.canUndo());
    }

    private void undo() {
        this.m_ArffPanel.undo();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.setButtons();
    }

    public int showDialog() {
        this.m_Result = 1;
        this.setVisible(true);
        this.setButtons();
        return this.m_Result;
    }

    public int showDialog(Instances instances) {
        this.setInstances(instances);
        return this.showDialog();
    }
}

