/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SparseInstance;
import weka.core.UnassignedClassException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;

public class NominalToBinary
extends Filter
implements SupervisedFilter,
OptionHandler {
    private int[][] m_Indices = null;
    private boolean m_Numeric = true;
    private boolean m_TransformAll = false;

    public String globalInfo() {
        return LocalString.get("Converts all nominal attributes into binary numeric attributes. An ") + LocalString.get("attribute with k values is transformed into k binary attributes if ") + LocalString.get("the class is nominal (using the one-attribute-per-value approach). ") + LocalString.get("Binary attributes are left binary, if option '-A' is not given.") + LocalString.get("If the class is numeric, k - 1 new binary attributes are generated ") + LocalString.get("in the manner described in \"Classification and Regression ") + LocalString.get("Trees\" by Breiman et al. (i.e. taking the average class value associated ") + LocalString.get("with each attribute value into account)");
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        if (instances.classIndex() < 0) {
            throw new UnassignedClassException(LocalString.get("No class has been assigned to the instances"));
        }
        this.setOutputFormat();
        this.m_Indices = null;
        return instances.classAttribute().isNominal();
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException(LocalString.get("No input instance format defined"));
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_Indices != null || this.getInputFormat().classAttribute().isNominal()) {
            this.convertInstance(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException(LocalString.get("No input instance format defined"));
        }
        if (this.m_Indices == null && this.getInputFormat().classAttribute().isNumeric()) {
            this.computeAverageClassValues();
            this.setOutputFormat();
            for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
                this.convertInstance(this.getInputFormat().instance(i));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option(LocalString.get("\tSets if binary attributes are to be coded as nominal ones."), "N", 0, "-N"));
        vector.addElement(new Option(LocalString.get("\tFor each nominal value a new attribute is created, \nnot only if there are more than 2 values."), "A", 0, "-A"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setBinaryAttributesNominal(Utils.getFlag('N', stringArray));
        this.setTransformAllValues(Utils.getFlag('A', stringArray));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[1];
        int n = 0;
        if (this.getBinaryAttributesNominal()) {
            stringArray[n++] = "-N";
        }
        if (this.getTransformAllValues()) {
            stringArray[n++] = "-A";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String binaryAttributesNominalTipText() {
        return LocalString.get("Whether resulting binary attributes will be nominal.");
    }

    public boolean getBinaryAttributesNominal() {
        return !this.m_Numeric;
    }

    public void setBinaryAttributesNominal(boolean bl) {
        this.m_Numeric = !bl;
    }

    public String transformAllValuesTipText() {
        return LocalString.get("Whether all nominal values are turned into new attributes, not only if there are more than 2.");
    }

    public boolean getTransformAllValues() {
        return this.m_TransformAll;
    }

    public void setTransformAllValues(boolean bl) {
        this.m_TransformAll = bl;
    }

    private void computeAverageClassValues() {
        double[][] dArray = new double[this.getInputFormat().numAttributes()][0];
        this.m_Indices = new int[this.getInputFormat().numAttributes()][0];
        for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
            int n;
            Attribute attribute = this.getInputFormat().attribute(i);
            if (!attribute.isNominal()) continue;
            dArray[i] = new double[attribute.numValues()];
            double[] dArray2 = new double[attribute.numValues()];
            for (n = 0; n < this.getInputFormat().numInstances(); ++n) {
                Instance instance = this.getInputFormat().instance(n);
                if (instance.classIsMissing() || instance.isMissing(i)) continue;
                int n2 = (int)instance.value(i);
                dArray2[n2] = dArray2[n2] + instance.weight();
                double[] dArray3 = dArray[i];
                int n3 = (int)instance.value(i);
                dArray3[n3] = dArray3[n3] + instance.weight() * instance.classValue();
            }
            double d = Utils.sum(dArray[i]);
            double d2 = Utils.sum(dArray2);
            if (Utils.gr(d2, 0.0)) {
                for (n = 0; n < attribute.numValues(); ++n) {
                    if (Utils.gr(dArray2[n], 0.0)) {
                        double[] dArray4 = dArray[i];
                        int n4 = n;
                        dArray4[n4] = dArray4[n4] / dArray2[n];
                        continue;
                    }
                    dArray[i][n] = d / d2;
                }
            }
            this.m_Indices[i] = Utils.sort(dArray[i]);
        }
    }

    private void setOutputFormat() {
        if (this.getInputFormat().classAttribute().isNominal()) {
            this.setOutputFormatNominal();
        } else {
            this.setOutputFormatNumeric();
        }
    }

    private void convertInstance(Instance instance) {
        if (this.getInputFormat().classAttribute().isNominal()) {
            this.convertInstanceNominal(instance);
        } else {
            this.convertInstanceNumeric(instance);
        }
    }

    private void setOutputFormatNominal() {
        int n = this.getInputFormat().classIndex();
        FastVector fastVector = new FastVector();
        for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
            Attribute attribute = this.getInputFormat().attribute(i);
            if (!attribute.isNominal() || i == this.getInputFormat().classIndex()) {
                fastVector.addElement(attribute.copy());
                continue;
            }
            if (attribute.numValues() <= 2 && !this.m_TransformAll) {
                if (this.m_Numeric) {
                    fastVector.addElement(new Attribute(attribute.name()));
                    continue;
                }
                fastVector.addElement(attribute.copy());
                continue;
            }
            if (i < this.getInputFormat().classIndex()) {
                n += attribute.numValues() - 1;
            }
            for (int j = 0; j < attribute.numValues(); ++j) {
                StringBuffer stringBuffer = new StringBuffer(attribute.name() + "=");
                stringBuffer.append(attribute.value(j));
                if (this.m_Numeric) {
                    fastVector.addElement(new Attribute(stringBuffer.toString()));
                    continue;
                }
                FastVector fastVector2 = new FastVector(2);
                fastVector2.addElement("f");
                fastVector2.addElement("t");
                fastVector.addElement(new Attribute(stringBuffer.toString(), fastVector2));
            }
        }
        Instances instances = new Instances(this.getInputFormat().relationName(), fastVector, 0);
        instances.setClassIndex(n);
        this.setOutputFormat(instances);
    }

    private void setOutputFormatNumeric() {
        if (this.m_Indices == null) {
            this.setOutputFormat(null);
            return;
        }
        int n = this.getInputFormat().classIndex();
        FastVector fastVector = new FastVector();
        for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
            Attribute attribute = this.getInputFormat().attribute(i);
            if (!attribute.isNominal() || i == this.getInputFormat().classIndex()) {
                fastVector.addElement(attribute.copy());
                continue;
            }
            if (i < this.getInputFormat().classIndex()) {
                n += attribute.numValues() - 2;
            }
            for (int j = 1; j < attribute.numValues(); ++j) {
                StringBuffer stringBuffer = new StringBuffer(attribute.name() + "=");
                for (int k = j; k < attribute.numValues(); ++k) {
                    if (k > j) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(attribute.value(this.m_Indices[i][k]));
                }
                if (this.m_Numeric) {
                    fastVector.addElement(new Attribute(stringBuffer.toString()));
                    continue;
                }
                FastVector fastVector2 = new FastVector(2);
                fastVector2.addElement("f");
                fastVector2.addElement("t");
                fastVector.addElement(new Attribute(stringBuffer.toString(), fastVector2));
            }
        }
        Instances instances = new Instances(this.getInputFormat().relationName(), fastVector, 0);
        instances.setClassIndex(n);
        this.setOutputFormat(instances);
    }

    private void convertInstanceNominal(Instance instance) {
        double[] dArray = new double[this.outputFormatPeek().numAttributes()];
        int n = 0;
        for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
            int n2;
            Attribute attribute = this.getInputFormat().attribute(i);
            if (!attribute.isNominal() || i == this.getInputFormat().classIndex()) {
                dArray[n] = instance.value(i);
                ++n;
                continue;
            }
            if (attribute.numValues() <= 2 && !this.m_TransformAll) {
                dArray[n] = instance.value(i);
                ++n;
                continue;
            }
            if (instance.isMissing(i)) {
                for (n2 = 0; n2 < attribute.numValues(); ++n2) {
                    dArray[n + n2] = instance.value(i);
                }
            } else {
                for (n2 = 0; n2 < attribute.numValues(); ++n2) {
                    dArray[n + n2] = n2 == (int)instance.value(i) ? 1.0 : 0.0;
                }
            }
            n += attribute.numValues();
        }
        Instance instance2 = null;
        instance2 = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), dArray) : new Instance(instance.weight(), dArray);
        this.copyStringValues(instance2, false, instance.dataset(), this.getInputStringIndex(), this.getOutputFormat(), this.getOutputStringIndex());
        instance2.setDataset(this.getOutputFormat());
        this.push(instance2);
    }

    private void convertInstanceNumeric(Instance instance) {
        double[] dArray = new double[this.outputFormatPeek().numAttributes()];
        int n = 0;
        for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
            int n2;
            Attribute attribute = this.getInputFormat().attribute(i);
            if (!attribute.isNominal() || i == this.getInputFormat().classIndex()) {
                dArray[n] = instance.value(i);
                ++n;
                continue;
            }
            if (instance.isMissing(i)) {
                for (n2 = 0; n2 < attribute.numValues() - 1; ++n2) {
                    dArray[n + n2] = instance.value(i);
                }
            } else {
                n2 = 0;
                while ((int)instance.value(i) != this.m_Indices[i][n2]) {
                    dArray[n + n2] = 1.0;
                    ++n2;
                }
                while (n2 < attribute.numValues() - 1) {
                    dArray[n + n2] = 0.0;
                    ++n2;
                }
            }
            n += attribute.numValues() - 1;
        }
        Instance instance2 = null;
        instance2 = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), dArray) : new Instance(instance.weight(), dArray);
        this.copyStringValues(instance2, false, instance.dataset(), this.getInputStringIndex(), this.getOutputFormat(), this.getOutputStringIndex());
        instance2.setDataset(this.getOutputFormat());
        this.push(instance2);
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new NominalToBinary(), stringArray);
            } else {
                Filter.filterFile(new NominalToBinary(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

