/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import weka.LocalString;
import weka.estimators.ConditionalEstimator;
import weka.estimators.DiscreteEstimator;
import weka.estimators.Estimator;
import weka.estimators.NormalEstimator;

public class DNConditionalEstimator
implements ConditionalEstimator {
    private NormalEstimator[] m_Estimators;
    private DiscreteEstimator m_Weights;

    public DNConditionalEstimator(int n, double d) {
        this.m_Estimators = new NormalEstimator[n];
        for (int i = 0; i < n; ++i) {
            this.m_Estimators[i] = new NormalEstimator(d);
        }
        this.m_Weights = new DiscreteEstimator(n, true);
    }

    public void addValue(double d, double d2, double d3) {
        this.m_Estimators[(int)d].addValue(d2, d3);
        this.m_Weights.addValue((int)d, d3);
    }

    public Estimator getEstimator(double d) {
        DiscreteEstimator discreteEstimator = new DiscreteEstimator(this.m_Estimators.length, false);
        for (int i = 0; i < this.m_Estimators.length; ++i) {
            discreteEstimator.addValue(i, this.m_Weights.getProbability(i) * this.m_Estimators[i].getProbability(d));
        }
        return discreteEstimator;
    }

    public double getProbability(double d, double d2) {
        return this.getEstimator(d2).getProbability(d);
    }

    public String toString() {
        String string = LocalString.get("DN Conditional Estimator. ") + this.m_Estimators.length + LocalString.get(" sub-estimators:\n");
        for (int i = 0; i < this.m_Estimators.length; ++i) {
            string = string + LocalString.get("Sub-estimator ") + i + ": " + this.m_Estimators[i];
        }
        string = string + LocalString.get("Weights of each estimator given by ") + this.m_Weights;
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            int n2;
            if (stringArray.length == 0) {
                System.out.println(LocalString.get("Please specify a set of instances."));
                return;
            }
            int n3 = n2 = Integer.parseInt(stringArray[0]);
            int n4 = n = Integer.parseInt(stringArray[1]);
            for (int i = 2; i < stringArray.length - 1; i += 2) {
                n2 = Integer.parseInt(stringArray[i]);
                n = Integer.parseInt(stringArray[i + 1]);
                if (n2 > n3) {
                    n3 = n2;
                }
                if (n <= n4) continue;
                n4 = n;
            }
            DNConditionalEstimator dNConditionalEstimator = new DNConditionalEstimator(n3 + 1, 1.0);
            for (int i = 0; i < stringArray.length - 1; i += 2) {
                n2 = Integer.parseInt(stringArray[i]);
                n = Integer.parseInt(stringArray[i + 1]);
                System.out.println(dNConditionalEstimator);
                System.out.println(LocalString.get("Prediction for ") + n2 + '|' + n + " = " + dNConditionalEstimator.getProbability(n2, n));
                dNConditionalEstimator.addValue(n2, n, 1.0);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

