/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.lazy;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.UpdateableClassifier;
import weka.classifiers.lazy.kstar.KStarCache;
import weka.classifiers.lazy.kstar.KStarConstants;
import weka.classifiers.lazy.kstar.KStarNominalAttribute;
import weka.classifiers.lazy.kstar.KStarNumericAttribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;

public class KStar
extends Classifier
implements KStarConstants,
UpdateableClassifier {
    protected Instances m_Train;
    protected int m_NumInstances;
    protected int m_NumClasses;
    protected int m_NumAttributes;
    protected int m_ClassType;
    protected int[][] m_RandClassCols;
    protected int m_ComputeRandomCols = 1;
    protected int m_InitFlag = 1;
    protected KStarCache[] m_Cache;
    protected int m_MissingMode = 4;
    protected int m_BlendMethod = 1;
    protected int m_GlobalBlend = 20;
    public static final Tag[] TAGS_MISSING = new Tag[]{new Tag(1, LocalString.get("Ignore the instances with missing values")), new Tag(2, LocalString.get("Treat missing values as maximally different")), new Tag(3, LocalString.get("Normalize over the attributes")), new Tag(4, LocalString.get("Average column entropy curves"))};

    public String globalInfo() {
        return LocalString.get("K* is an instance-based classifier, that is the class of a test ") + LocalString.get("instance is based upon the class of those training instances ") + LocalString.get("similar to it, as determined by some similarity function.  It differs ") + LocalString.get("from other instance-based learners in that it uses an entropy-based ") + LocalString.get("distance function. For more information on K*, see\n\n") + LocalString.get("John, G. Cleary and Leonard, E. Trigg (1995) \"K*: An Instance- ") + LocalString.get("based Learner Using an Entropic Distance Measure\", ") + LocalString.get("Proceedings of the 12th International Conference on Machine ") + LocalString.get("learning, pp. 108-114.");
    }

    public void buildClassifier(Instances instances) throws Exception {
        String string = LocalString.get("(KStar.buildClassifier) ");
        if (instances.classIndex() < 0) {
            throw new Exception(LocalString.get("No class attribute assigned to instances"));
        }
        if (instances.checkForStringAttributes()) {
            throw new UnsupportedAttributeTypeException(LocalString.get("Cannot handle string attributes!"));
        }
        this.m_Train = new Instances(instances, 0, instances.numInstances());
        this.m_Train.deleteWithMissingClass();
        this.init_m_Attributes();
    }

    public void updateClassifier(Instance instance) throws Exception {
        String string = LocalString.get("(KStar.updateClassifier) ");
        if (!this.m_Train.equalHeaders(instance.dataset())) {
            throw new Exception(LocalString.get("Incompatible instance types"));
        }
        if (instance.classIsMissing()) {
            return;
        }
        this.m_Train.add(instance);
        this.update_m_Attributes();
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int n;
        String string = LocalString.get("(KStar.distributionForInstance) ");
        double d = 0.0;
        double d2 = 0.0;
        double[] dArray = new double[this.m_NumClasses];
        double[] dArray2 = new double[1];
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = 0.0;
        }
        dArray2[0] = 0.0;
        if (this.m_InitFlag == 1) {
            if (this.m_BlendMethod == 2) {
                this.generateRandomClassColomns();
            }
            this.m_Cache = new KStarCache[this.m_NumAttributes];
            for (n = 0; n < this.m_NumAttributes; ++n) {
                this.m_Cache[n] = new KStarCache();
            }
            this.m_InitFlag = 0;
        }
        Enumeration enumeration = this.m_Train.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance2 = (Instance)enumeration.nextElement();
            d = this.instanceTransformationProbability(instance, instance2);
            switch (this.m_ClassType) {
                case 1: {
                    int n2 = (int)instance2.classValue();
                    dArray[n2] = dArray[n2] + d;
                    break;
                }
                case 0: {
                    dArray2[0] = dArray2[0] + d * instance2.classValue();
                    d2 += d;
                }
            }
        }
        if (this.m_ClassType == 1) {
            double d3 = Utils.sum(dArray);
            if (d3 <= 0.0) {
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = 1.0 / (double)this.m_NumClasses;
                }
            } else {
                Utils.normalize(dArray, d3);
            }
            return dArray;
        }
        dArray2[0] = d2 != 0.0 ? dArray2[0] / d2 : 0.0;
        return dArray2;
    }

    private double instanceTransformationProbability(Instance instance, Instance instance2) {
        String string = LocalString.get("(KStar.instanceTransformationProbability) ");
        double d = 1.0;
        int n = 0;
        for (int i = 0; i < this.m_NumAttributes; ++i) {
            if (i == this.m_Train.classIndex()) continue;
            if (instance.isMissing(i)) {
                ++n;
                continue;
            }
            d *= this.attrTransProb(instance, instance2, i);
            d = n != this.m_NumAttributes ? Math.pow(d, (double)this.m_NumAttributes / (double)(this.m_NumAttributes - n)) : 0.0;
        }
        return d / (double)this.m_NumInstances;
    }

    private double attrTransProb(Instance instance, Instance instance2, int n) {
        String string = "(KStar.attrTransProb)";
        double d = 0.0;
        switch (this.m_Train.attribute(n).type()) {
            case 1: {
                KStarNominalAttribute kStarNominalAttribute = new KStarNominalAttribute(instance, instance2, n, this.m_Train, this.m_RandClassCols, this.m_Cache[n]);
                kStarNominalAttribute.setOptions(this.m_MissingMode, this.m_BlendMethod, this.m_GlobalBlend);
                d = kStarNominalAttribute.transProb();
                kStarNominalAttribute = null;
                break;
            }
            case 0: {
                KStarNumericAttribute kStarNumericAttribute = new KStarNumericAttribute(instance, instance2, n, this.m_Train, this.m_RandClassCols, this.m_Cache[n]);
                kStarNumericAttribute.setOptions(this.m_MissingMode, this.m_BlendMethod, this.m_GlobalBlend);
                d = kStarNumericAttribute.transProb();
                kStarNumericAttribute = null;
            }
        }
        return d;
    }

    public String missingModeTipText() {
        return LocalString.get("Determines how missing attribute values are treated.");
    }

    public SelectedTag getMissingMode() {
        return new SelectedTag(this.m_MissingMode, TAGS_MISSING);
    }

    public void setMissingMode(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_MISSING) {
            this.m_MissingMode = selectedTag.getSelectedTag().getID();
        }
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option(LocalString.get("\tManual blend setting (default 20%)\n"), "B", 1, LocalString.get("-B <num>")));
        vector.addElement(new Option(LocalString.get("\tEnable entropic auto-blend setting (symbolic class only)\n"), "E", 0, "-E"));
        vector.addElement(new Option(LocalString.get("\tSpecify the missing value treatment mode (default a)\n") + LocalString.get("\tValid options are: a(verage), d(elete), m(axdiff), n(ormal)\n"), "M", 1, LocalString.get("-M <char>")));
        return vector.elements();
    }

    public String globalBlendTipText() {
        return LocalString.get("The parameter for global blending. Values are restricted to [0,100].");
    }

    public void setGlobalBlend(int n) {
        this.m_GlobalBlend = n;
        if (this.m_GlobalBlend > 100) {
            this.m_GlobalBlend = 100;
        }
        if (this.m_GlobalBlend < 0) {
            this.m_GlobalBlend = 0;
        }
    }

    public int getGlobalBlend() {
        return this.m_GlobalBlend;
    }

    public String entropicAutoBlendTipText() {
        return LocalString.get("Whether entropy-based blending is to be used.");
    }

    public void setEntropicAutoBlend(boolean bl) {
        this.m_BlendMethod = bl ? 2 : 1;
    }

    public boolean getEntropicAutoBlend() {
        return this.m_BlendMethod == 2;
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = "(KStar.setOptions)";
        String string2 = Utils.getOption('B', stringArray);
        if (string2.length() != 0) {
            this.setGlobalBlend(Integer.parseInt(string2));
        }
        this.setEntropicAutoBlend(Utils.getFlag('E', stringArray));
        String string3 = Utils.getOption('M', stringArray);
        if (string3.length() != 0) {
            switch (string3.charAt(0)) {
                case 'a': {
                    this.setMissingMode(new SelectedTag(4, TAGS_MISSING));
                    break;
                }
                case 'd': {
                    this.setMissingMode(new SelectedTag(1, TAGS_MISSING));
                    break;
                }
                case 'm': {
                    this.setMissingMode(new SelectedTag(2, TAGS_MISSING));
                    break;
                }
                case 'n': {
                    this.setMissingMode(new SelectedTag(3, TAGS_MISSING));
                    break;
                }
                default: {
                    this.setMissingMode(new SelectedTag(4, TAGS_MISSING));
                }
            }
        }
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[5];
        int n = 0;
        stringArray[n++] = "-B";
        stringArray[n++] = "" + this.m_GlobalBlend;
        if (this.getEntropicAutoBlend()) {
            stringArray[n++] = "-E";
        }
        stringArray[n++] = "-M";
        if (this.m_MissingMode == 4) {
            stringArray[n++] = "a";
        } else if (this.m_MissingMode == 1) {
            stringArray[n++] = "d";
        } else if (this.m_MissingMode == 2) {
            stringArray[n++] = "m";
        } else if (this.m_MissingMode == 3) {
            stringArray[n++] = "n";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LocalString.get("KStar Beta Verion (0.1b).\n") + LocalString.get("Copyright (c) 1995-97 by Len Trigg (trigg@cs.waikato.ac.nz).\n") + LocalString.get("Java port to Weka by Abdelaziz Mahoui ") + LocalString.get("(am14@cs.waikato.ac.nz).\n\nKStar options : "));
        String[] stringArray = this.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i] + ' ');
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new KStar(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void init_m_Attributes() {
        try {
            this.m_NumInstances = this.m_Train.numInstances();
            this.m_NumClasses = this.m_Train.numClasses();
            this.m_NumAttributes = this.m_Train.numAttributes();
            this.m_ClassType = this.m_Train.classAttribute().type();
            this.m_InitFlag = 1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void update_m_Attributes() {
        this.m_NumInstances = this.m_Train.numInstances();
        this.m_InitFlag = 1;
    }

    private void generateRandomClassColomns() {
        String string = "(KStar.generateRandomClassColomns)";
        Random random = new Random(42L);
        this.m_RandClassCols = new int[6][];
        int[] nArray = this.classValues();
        for (int i = 0; i < 5; ++i) {
            this.m_RandClassCols[i] = this.randomize(nArray, random);
        }
        this.m_RandClassCols[5] = nArray;
    }

    private int[] classValues() {
        String string = "(KStar.classValues)";
        int[] nArray = new int[this.m_NumInstances];
        for (int i = 0; i < this.m_NumInstances; ++i) {
            try {
                nArray[i] = (int)this.m_Train.instance(i).classValue();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return nArray;
    }

    private int[] randomize(int[] nArray, Random random) {
        String string = "(KStar.randomize)";
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        for (int i = nArray2.length - 1; i > 0; --i) {
            int n = (int)(random.nextDouble() * (double)i);
            int n2 = nArray2[i];
            nArray2[i] = nArray2[n];
            nArray2[n] = n2;
        }
        return nArray2;
    }
}

