/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.pace;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import weka.LocalString;

public class FloatingPointFormat
extends DecimalFormat {
    protected DecimalFormat nf;
    protected int width;
    protected int decimal;
    protected boolean trailing = true;

    public FloatingPointFormat() {
        this(8, 5);
    }

    public FloatingPointFormat(int n) {
        this(8, 2);
    }

    public FloatingPointFormat(int n, int n2) {
        this.width = n;
        this.decimal = n2;
        this.nf = new DecimalFormat(FloatingPointFormat.pattern(n, n2));
        this.nf.setPositivePrefix(" ");
        this.nf.setNegativePrefix("-");
    }

    public FloatingPointFormat(int n, int n2, boolean bl) {
        this(n, n2);
        this.trailing = bl;
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        int n;
        StringBuffer stringBuffer2 = new StringBuffer(this.nf.format(d));
        if (stringBuffer2.length() > this.width) {
            if (stringBuffer2.charAt(0) == ' ' && stringBuffer2.length() == this.width + 1) {
                stringBuffer2.deleteCharAt(0);
            } else {
                stringBuffer2.setLength(this.width);
                for (n = 0; n < this.width; ++n) {
                    stringBuffer2.setCharAt(n, '*');
                }
            }
        } else {
            for (n = 0; n < this.width - stringBuffer2.length(); ++n) {
                stringBuffer2.insert(0, ' ');
            }
        }
        if (!this.trailing && this.decimal > 0) {
            while (stringBuffer2.charAt(stringBuffer2.length() - 1) == '0') {
                stringBuffer2.deleteCharAt(stringBuffer2.length() - 1);
            }
            if (stringBuffer2.charAt(stringBuffer2.length() - 1) == '.') {
                stringBuffer2.deleteCharAt(stringBuffer2.length() - 1);
            }
        }
        return stringBuffer.append(stringBuffer2);
    }

    public static String pattern(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(FloatingPointFormat.padding(n - n2 - 3, '#'));
        if (n2 == 0) {
            stringBuffer.append('0');
        } else {
            stringBuffer.append("0.");
            stringBuffer.append(FloatingPointFormat.padding(n2, '0'));
        }
        return stringBuffer.toString();
    }

    private static StringBuffer padding(int n, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer;
    }

    public int width() {
        if (!this.trailing) {
            throw new RuntimeException(LocalString.get("flexible width"));
        }
        return this.width;
    }
}

