/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import java.io.Serializable;
import weka.LocalString;
import weka.classifiers.evaluation.Prediction;

public class NumericPrediction
implements Prediction,
Serializable {
    private double m_Actual = Prediction.MISSING_VALUE;
    private double m_Predicted = Prediction.MISSING_VALUE;
    private double m_Weight = 1.0;

    public NumericPrediction(double d, double d2) {
        this(d, d2, 1.0);
    }

    public NumericPrediction(double d, double d2, double d3) {
        this.m_Actual = d;
        this.m_Predicted = d2;
        this.m_Weight = d3;
    }

    public double actual() {
        return this.m_Actual;
    }

    public double predicted() {
        return this.m_Predicted;
    }

    public double weight() {
        return this.m_Weight;
    }

    public double error() {
        if (this.m_Actual == Prediction.MISSING_VALUE || this.m_Predicted == Prediction.MISSING_VALUE) {
            return Prediction.MISSING_VALUE;
        }
        return this.m_Predicted - this.m_Actual;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LocalString.get("NUM: ")).append(this.actual()).append(' ').append(this.predicted());
        stringBuffer.append(' ').append(this.weight());
        return stringBuffer.toString();
    }
}

