#!/usr/bin/perl

use strict;
use warnings;

# |設定 -------------------------------------------------------------------
# +-- 一行あたりの画面表示列: デスクトップのみまもり画面の横幅
      my $row     =	3;		# デフォルト値: 3
# +-- タイムアウト: この秒数以上経過すると画像は表示されなくなる
      my $timeout =	900;	# デフォルト値: 900
# -------------------------------------------------------------------------

$| = 1;

my $basedir = './dwfiles/';
my $datafile = './addrs.ini';
my $htmlhead = <<__END__;
Content-Type: text/html;charset=UTF-8

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>deskwatcher QuickWatch mode</title>
<meta http-equiv="Content-type" content="text/html; charset=utf-8">
<meta http-equiv="Refresh" content="60">
<link type="text/css" href="../webescorter.css" rel="stylesheet">
<script type="text/javascript" src="highslide.js"></script>
<script type="text/javascript">

// remove the registerOverlay call to disable the controlbar
hs.registerOverlay({
	thumbnailId: null,
	overlayId: 'controlbar',
	position: 'top right',
	hideOnMouseOut: true
});

hs.graphicsDir = './highslide/graphics/';
hs.outlineType = 'rounded-white';
// Tell Highslide to use the thumbnail's title for captions
hs.captionEval = 'this.thumb.title';


</script>
<style type="text/css">
* {
    font-family: Verdana, Helvetica;
    font-size: 10pt;
}
.highslide {
	cursor: url(highslide/graphics/zoomin.cur), pointer;
    outline: none;
}
.highslide-active-anchor img {
	visibility: hidden;
}
.highslide img {
	border: 2px solid gray;
}
.highslide:hover img {
	border: 2px solid white;
}

.highslide-wrapper {
	background: white;
}
.highslide-image {
    border: 2px solid white;
}
.highslide-image-blur {
}
.highslide-caption {
    display: none;
    
    border: 2px solid white;
    border-top: none;
    font-family: Verdana, Helvetica;
    font-size: 10pt;
    padding: 5px;
    background-color: white;
}
.highslide-loading {
    display: block;
	color: black;
	font-size: 8pt;
	font-family: sans-serif;
	font-weight: bold;
    text-decoration: none;
	padding: 2px;
	border: 1px solid black;
    background-color: white;
    
    padding-left: 22px;
    background-image: url(highslide/graphics/loader.white.gif);
    background-repeat: no-repeat;
    background-position: 3px 1px;
}
a.highslide-credits,
a.highslide-credits i {
    display: none;
    padding: 2px;
    color: silver;
    text-decoration: none;
	font-size: 10px;
}
a.highslide-credits:hover,
a.highslide-credits:hover i {
    color: white;
    background-color: gray;
}

.highslide-move {
    cursor: move;
}

.highslide-overlay {
	display: none;
}

a.highslide-full-expand {
	background: url(highslide/graphics/fullexpand.gif) no-repeat;
	display: block;
	margin: 0 10px 10px 0;
	width: 34px;
	height: 34px;
}


/* Controlbar example */
.controlbar {	
	background: url(highslide/graphics/controlbar4.gif);
	width: 167px;
	height: 34px;
}
.controlbar a {	
	display: block;
	float: left;
	/*margin: 0px 0 0 4px;*/	
	height: 27px;
}
.controlbar a:hover {
	background-image: url(highslide/graphics/controlbar4-hover.gif);
}
.controlbar .previous {
	width: 50px;
}
.controlbar .next {
	width: 40px;
	background-position: -50px 0;
}
.controlbar .highslide-move {
	width: 40px;
	background-position: -90px 0;
}
.controlbar .close {
	width: 36px;
	background-position: -130px 0;
}


/* Necessary for functionality */
.highslide-display-block {
    display: block;
}
.highslide-display-none {
    display: none;
}
</style>
</head>
<body>
__END__

# まず
#

print $htmlhead;
print <<__END__;
<table><tr><td width="87%"><h1>deskwatcher QuickWatch mode</h1></td>
<td><p>&gt;<a href="../index.html">トップメニュー</a></p></td></tr></table>
<div id="controlbar" class="highslide-overlay controlbar">
	<a href="#" class="previous" onclick="return hs.previous(this)" title="Previous (left arrow key)"></a>
	<a href="#" class="next" onclick="return hs.next(this)" title="Next (right arrow key)"></a>
    <a href="#" class="highslide-move" onclick="return false" title="Click and drag to move"></a>
    <a href="#" class="close" onclick="return hs.close(this)" title="Close"></a>

</div>
__END__

&read;

print<<__END__;
<hr>
<address>
Copyright &#169; 2008-2010 Keiya CHINEN. All rights reserved.<br>

Powered by Highslide JS:<br>
(c) 2007 Geoff Stearns and is released under the MIT License<br>
</address>
</body>
</html>
__END__

sub read {
    open( FH,"< $datafile");
    my @pcs = <FH>;
    chomp(@pcs);
    
    print "<table>\n<tr>\n";
    
    my $cnt=0;
    foreach my $pc(@pcs) {
        my $metafile = $basedir.'meta'.$pc.'.txt';
        
        # 3列ごとにテーブルのつぎの行へ
        if (0 == ($cnt % int($row)) and $cnt > 0) {
            print "</tr>\n<tr>\n";
        }
        
        # テーブルつくりながら画像貼っていく
        if (-e $metafile) {
            my @filetime = stat($metafile);
            if (time() < (($filetime[9]) + int($timeout))) {
                open(PFH, "< ".$metafile);
                my $mpc = <PFH>;
                my ($ipaddr,$date) = (split(/\,/,$mpc));
                my $hostname = gethostbyaddr(pack("C4", split(/\./, $ipaddr)),2);
                # TODO:参照渡し
                &picture("thumb$ipaddr.png","$ipaddr.png","$date ; $hostname ($ipaddr)");
                close(PFH);
            } else {
                print "  <td><img src=\"".$basedir."na.png\" alt=\"$pc\" title=\"$pc\"></td>\n";
            }
        } else {
            print "  <td><img src=\"".$basedir."na.png\" alt=\"$pc\" title=\"$pc\"></td>\n";
        }
        $cnt++
    }
    close(FH);
    print "</tr>\n</table>\n";
}

sub picture {
    print "  <td><a id=\"$_[0]\" href=\"$basedir$_[1]\" class=\"highslide\" onclick=\"return hs.expand(this)\"><img src=\"$basedir$_[0]\" alt=\"$_[2]\" title=\"$_[2]\"></a></td>\n";
}


__END__
