#!/usr/bin/perl

use strict;
use warnings;
use HTTP::Request::Common;
use LWP::UserAgent;

$| = 1;

# -- 設定開始 --
# サーバのdeskwatchersv.cgiのディレクトリを設定します Scheme://Host/Directory/CGI
my $upload_to = 'http://192.168.0.4/cgi-bin/deskwatcher/deskwatchersv.cgi';

my $upload_timeout = '10';	# サーバへアップロードするタイムアウト（秒）
my $upload_reslimit = '8192';	# サーバからのレスポンスを受け取る最大値
# -- 設定ここまで --

my $version ='1.0.1';
my $boundary = '----BOUNDARYBOUNDARY----';

print <<__EOM__;
deskwatcher perl client v.$version by Keiya CHINEN

Upload to:	$upload_to
Upload Timeout:	$upload_timeout
Responce size limit:	$upload_reslimit

__EOM__

# 無限ループ
while (1) {
    my $random  = int(rand(1024));
    my $tmpfile = "/tmp/deskwatcher$random.png";

    # 画面撮影、失敗すると一度ループ飛ばす
    print "Taking Screen Picture...";
    my $res = system "import -window root $tmpfile";
    next if $res == -1;
    print "done.\n";

    # ファイル転送
    print "Sending the Picture...";
    my $ua = LWP::UserAgent->new;
    $ua->env_proxy();
    $ua->timeout($upload_timeout);
    $ua->max_size($upload_reslimit);
    my $res = $ua->request(POST $upload_to,
    Content_type => "form-data",
    Content => [imagedata => [$tmpfile]],
    );
    if ($res->is_success) {
        print "done.\n";
    } else {
        print "ERROR: ".$res->status_line."\n";
    }

    unlink $tmpfile;

} continue {
    sleep 60;
}
