#!/usr/bin/perl
use strict;
use warnings;
use CGI;
use Fcntl ':flock'; # import LOCK_* constants

# 出力バッファリング無効にする
$| = 1;

# 保存先ディレクトリ
my $logfiles = "./dwfiles";

# POSTサイズの上限
$CGI::POST_MAX = 100000 * 1024; # 1MB

my $query = new CGI;

# 初期設定 -------------------------------------
# 最大許容サイズ（KByte）
my $maxsize = 30000;

# アップロードを許可するファイルの種類（MIMEと拡張子）
my %hash_mime = (
  'image/png' => 'png', # PNG Imageファイル
  );

# 設定ここまで ---------------------------------


# 送られてきたデータを処理する -----------------
# ファイル取得
my $ipadr = $ENV{'REMOTE_ADDR'};
my $fH = $query->upload('imagedata');

# エラーチェック
if ($query->cgi_error) {
  my $err = $query->cgi_error;
  &error("$err") if ($err);
}

&error("File transfer error.") unless (defined($fH));

# MIMEタイプ取得
my $mimetype = $query->uploadInfo($fH)->{'Content-Type'};

# ファイルサイズ取得
my $size = (stat($fH))[7];

# サイズ制限
&error("The filesize is too large. Max $maxsize KB") if ($size > $maxsize * 1024);


# HTML出力 -------------------------------------
print $query->header(-charset=>'utf-8');
print "completed\n";


FORK: {
	if (my $pid = fork ) {

	close(STDOUT);
	wait;
	} elsif (defined $pid) {

	# ここ以降子プロセス
	# 重い処理開始。
	# 標準入力を閉じて、apacheをだます。クライアントと通信終了。

	close(STDOUT);


	# ファイル保存 ---------------------------------

	# 保存するファイル名を取得
	my $set = &set_name($mimetype);

	my ($buffer);
	open (OUT, ">$logfiles/$set") || &error("Can't open $set");
	binmode (OUT);
	while(read($fH, $buffer, 1024)){
	    print OUT $buffer;
	}
	close (OUT);
	close ($fH) if ($CGI::OS ne 'UNIX'); # Windowsプラットフォーム用
	chmod (0666, "$logfiles/$set");


	# requireでいい感じに読み込み
	# ここからは画像の縮小、保存の処理
	require Image::Magick;
	my $image=Image::Magick->new;
	$image->Read("$logfiles/$set");
	my ($x,$y) = $image->Get('width','height');
	my $ry;
	my $host = gethostbyaddr(pack("C4", split(/\./, $ipadr)), 2);

	# 割り算エラートラップ
	eval {$ry = $y*(320/$x)};
	$image->Resize(width=>'320',height=>$ry);
	$image->Annotate(
	text=>$host,
	pointsize=>12,
	stroke=>'#ffffff',
	strokewidth=>1,
	fill=>'#505080',
	gravity=>'SouthWest',
	);
	my $thumbfile = $logfiles."/thumb".$set;
	$image->Write($thumbfile);

	# DBに追加する文字列
	my ($sec, $min, $hour, $mday, $mon, $year) = localtime();
	my $yyyymmddJ = sprintf("%04d/%02d/%02d ", $year + 1900, $mon +1, $mday);
	my $hhmmssJ = sprintf("%02d:%02d:%02d", $hour, $min, $sec);
	my $date = $yyyymmddJ.$hhmmssJ;
	my $dataline = "$ipadr,$date";
	
	# インデックスDBファイルの行を追加
	open(DB, "> $logfiles/meta$ipadr.txt"); # 追加モードで開く
	  flock(DB, LOCK_EX);             # ロック確認。ロック
	  print DB "$dataline\n";       # 書き込む
	close(DB);                # closeすれば自動でロック解除
	
	#exit;


	# ファイル名を設定 -----------------------------
	sub set_name {
	  my ($mime) = @_;

	  # 拡張子をセット
	  my $ext = $hash_mime{$mime} ? $hash_mime{$mime} : &error("Can't permit this file.");

	  # ファイル名のフォーマット
	  $set = $ipadr.'.'.$ext;
	  return $set;
	}


	} elsif ($!=~/No more process/) {
	# プロセスが多すぎて子プロセスがつくれないとき
	sleep 5;
	redo FORK;
	} else {
	# フォークできなかった
	die "Cannot fork!!!: $\n";
	}
}


# エラー出力 -----------------------------------
sub error {
  my ($mes) = @_;
  #die "ERROR: $mes";
  #exit;
}


__END__


