package org.itscool.weber.testcase;

import java.net.URL;
import java.util.LinkedList;

import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.connection.ConnectionManager;
import org.itscool.commons.connection.Transaction;
import org.itscool.commons.connection.TransactionUtil;
import org.itscool.commons.dao.EntityInfoMapping;
import org.itscool.weber.action.Action;
import org.itscool.weber.user.User;

/**
 * <p>
 * f[^x[X̒P̃eXg@\geXgNXł
 * </p>
 *
 * <p>
 * ̃NXorg.itscool.weber.testcase.WeberTestCaseNX̊{@\
 * pAf[^x[Xł̃eXg@\ǉĂ܂<br/>
 * </p>
 *
 * <p>
 * ANVNXf[^x[XɃANZX鏈ĂꍇA
 * ǂ̂悤ȃeXgsKv̂ł傤H
 * </p>
 *
 * <p>
 * f[^@\f[^o^@\Ƃf[^x[XɃANZXNX
 * eXgꍇAeXgsɓK؂ȃeXgf[^f[^x[Xɓo^
 * ĂKv܂B<br>
 * ꂪAeXg̎ɂꍇ܂B
 * </p>
 *
 * <p>
 * eXgf[^炩DBɊi[Ăꍇł́AقƂǂ̏ꍇ
 * ܂sȂP[X܂B
 * </p>
 *
 * <p>
 * ̃eXgƓɍXṼeXg폜̃eXgsꍇA
 * f[^x[X̓eςĂ܂AʂƂăeXgʂςĂ܂܂B
 * </p>
 *
 * <p>
 * ̖ɂ̓eXgJnOɃe[uAeXgf[^쐬
 * Kv܂B
 * </p>
 *
 * <p>
 * WeberDbTestCaseNX͂̂悤ȏ菕Ă܂B
 * </p>
 *
 * <p>
 * WeberDbTestCaseNXgP̃eXgs߂ɂ͈ȉ̏Kvł<br/><br/>
 * <li>eXgp̃f[^x[Xyуe[u݂邱</li>
 * <li>eXgf[^`XMLt@C݂邱</li>
 * <li>ConnectionManagerNX̐ݒ肪di-config.xmlɓo^Ă邱</li>
 * </p><br/>
 *
 * <p>
 * (1) ConnectionManagerNX̓o^<br/>
 * ConnectionManagerC^[tF[Xitscool-commons.jarɊ܂܂Ă
 * f[^x[Xp̃gUNVǗNXŁAWeberDbTestCase͂̃NX
 * găeXgpf[^x[X̏eXgf[^̍쐬s܂<br/>
 * ConnectionManager̐ݒJDBCDataSourcêǂ𗘗p邩di-config.xml
 * ̐ݒeς܂B
 * </p>
 *
 * <p>ȉ́AJDBC𗘗pꍇ̐ݒł</p>
 * <pre>
 * &lt;bean id="ConnectionManager" type="org.itscool.commons.connection.OriginalConnectionManager" singleton="true"&gt;
 *   &lt;property name="url" value="jdbc:hsqldb:hsql://localhost"/&gt;
 *   &lt;property name="user" value="sa"/&gt;
 *   &lt;property name="pwd" value=""/&gt;
 *   &lt;property name="drvname" value="org.hsqldb.jdbcDriver"/&gt;
 *   &lt;property name="timeout" value="300"/&gt;
 *   &lt;property name="initSize" value="3"/&gt;
 *   &lt;property name="maxSize" value="10"/&gt;
 *   &lt;property name="mode" value="false"/&gt;
 *   &lt;property name="showSql" value="false"/&gt;
 * &lt;/bean&gt;
 * </pre><br/>
 *
 * <p>ȉ́ADataSource𗘗pꍇ̐ݒł</p>
 * <pre>
 * &lt;bean id="ConnectionManager" type="org.itscool.commons.connection.DataSourceManager" singleton="true"&gt;
 *   &lt;property name="dsName" value="java:comp/env/weber-jndi"/&gt;
 *   &lt;property name="mode" value="false"/&gt;
 *   &lt;property name="showSql" value="true"/&gt;
 * &lt;/bean&gt;
 * </pre>
 *
 * <p>
 * (2) eXgf[^`t@C̍쐬<br/>
 * eXgf[^͈ȉ̌`ŋLqXMLt@Cł<br>
 * </p>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS" ?&gt;
 *
 * &lt;dbdata-config&gt;
 *   &lt;table name="WEBER_ROLE"&gt;
 *       &lt;record id="1" name="'test_role'"/&gt;
 *       &lt;record id="2" name="'test_role2'"/&gt;
 *       &lt;record id="3" name="'test_role3'"/&gt;
 *   &lt;/table&gt;
 *   &lt;table name="WEBER_USER"&gt;
 *       &lt;record id="1" name="'test'" password="'test-pwd'" role_id="1"/&gt;
 *       &lt;record id="2" name="'test'" password="'test-pwd2'" role_id="2"/&gt;
 *       &lt;record id="3" name="'test'" password="'test-pwd3'" role_id="3"/&gt;
 *       &lt;record id="4" name="'best'" password="'test-pwd'" role_id="1"/&gt;
 *   &lt;/table&gt;
 *   &lt;table name="MESSAGE"&gt;
 *       &lt;record id="1" user_id="'ق'" subject="'hello'" contents="'eXgbZ[Wł'" /&gt;
 *       &lt;record id="2" user_id="'Y'" subject="'ɂ'" contents="'͂߂܂'" /&gt;
 *       &lt;record id="3" user_id="'Ԏq'" subject="'΂'" contents="'܂ǂł'" /&gt;
 *   &lt;/table&gt;
 * &lt;/dbdata-config&gt;
 * </pre>
 *
 * <p>
 * table^O̓eXge[u̖O`܂<br>
 * recored^O̓eXgf[^1R[hɊY܂<br/>
 * record^O̊éAeXge[ůetB[hw肵Alɂ
 * tB[hɃZbglw肵܂<br>
 * Zbgl^̏ꍇ́Aݒl̗[VONH[e[V(')
 * ܂<br/>
 * </p><br/>
 *
 * <p><strong>
 * eXge[u݂AeXge[uق̃e[uQƂĂ
 * ꍇ͐ݒ̏ɒӂĂ<br/>
 * ƂΏL̗ŁAWEBER_USERe[uWEBER_ROLEe[uQƂĂꍇ
 * WEBER_ROLEe[uʂɒ`Ȃ΂Ȃ܂<br>
 * ܂MESSAGEe[uWEBER_USERe[uQƂĂ̂ł΁A
 * MESSAGEe[uWEBER_USERe[u艺ʂɒ`ĂȂ΂Ȃ܂<br>
 * </strong></p><br>
 *
 * <p>ȉ̓eXgNX̎ł</p>
 * <pre>
 * package test.org.itscool.msgbord;
 *
 * import org.itscool.msgbord.SaveMessageAction;
 * import org.itscool.webertest.testcase.WeberDbTestCase;
 *
 * import org.itscool.msgbord.Message;
 *
 * public class TestSaveMessageAction extends WeberDbTestCase{
 *     public void setUp(){
 *         this.initTables("test/org/itscool/msgbord/test-db-data.xml");
 *     }
 *
 *     public void testDoExecute(){
 *         SaveMessageAction action = new SaveMessageAction();
 *         Message message = new Message();
 *         message.setUserId("q");
 *         message.setSubject("aaa");
 *         message.setContents("bbb");
 *
 *         this.assertDoExecute(action, message, "success");
 *     }
 * }
 * </pre><br>
 *
 * <p>
 * this.initTables()\bh͈Ɏw肳ꂽeXgf[^`t@C
 * [hAe[ũNAƃeXgf[^̓o^s܂<br>
 * </p>
 *
 * <p>
 * ȉ̓eXgΏۂƂȂANVNX̗ł
 * </p>
 * <pre>
 *
 * import java.util.List;
 *
 * import org.itscool.weber.action.Action;
 * import org.itscool.weber.action.ActionBucket;
 *
 * public class SaveMessageAction extends Action {
 *     public String doExecute(ActionBucket bucket){
 *         Message message = (Message)bucket.getForm();
 *         MessageDao dao = new MessageDao();
 *         dao.save(message);
 *
 *         List messages = (List)dao.getAllData();
 *         bucket.setAttribute("messages", messages);
 *         return "success";
 *     }
 * }
 * </pre><br>
 * <p>
 * WeberTestCase𗘗peXgsꍇAʓrJUnitNXCu
 * Kvł
 * </p>
 * <br>
 *
 * @author kano
 * @version 1.00A 2006/01/31 VK쐬
 */
public abstract class WeberDbTestCase extends WeberTestCase{
    /** ConnectionManagerCX^X */
    protected ConnectionManager mgr;
    /** eXgf[^`t@Ci[XgNX */
    protected static LinkedList testDataList = new LinkedList();
    
    private static boolean initFlg = false;
    
    public WeberDbTestCase(){
        super();
        if(!initFlg){
            init();
            initFlg = true;
        }
    }
    
    /**
     * eXgŜʂ1񂾂s鏉֐
     */
    public void init(){
        try{
            ClassLoader parent = Thread.currentThread().getContextClassLoader();
            URL diconfigUrl = parent.getResource("di-config.xml");
            
            String configFwName;
            //System.out.println("di-config.xml path use = " + diconfigUrl.getPath());
            if(diconfigUrl == null ){
                String err = "di-config.xml path is null.";
                fail(err);
                log.error(err);
                return;
            }else{
                configFwName = diconfigUrl.getPath();
            }
            BeanFactory factory = BeanFactory.getInstance();
            factory.create(configFwName);
            mgr = (ConnectionManager) factory.createInstance("ConnectionManager");
            mgr.init();
            try{
                EntityInfoMapping daoMapping = (EntityInfoMapping)factory.createInstance("EntityInfoMapping");
            }catch(Exception ioe){
                log.info("DaoConfigReader͎s܂");
            }
        }catch(Exception e){
            log.error(e.getMessage());
            e.printStackTrace();
            mgr.destroy();
            throw new WeberDbTestCaseInitException(e.getMessage());
        }
    }
    
    public void tearDown(){
        TransactionUtil.returnTransaction();
    }
    
    /**
     * eXgf[^쐬܂
     * @param configName eXgf[^`t@C̃pX(AvP[V
     * sfBNg̑΃pXjw肵܂
     */
    public void initTables(String configName){
        //ClassLoader parent = ClassLoader.getSystemClassLoader();
        //ClassLoader parent = filterConfig.getClass().getClassLoader();
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        URL configUrl = parent.getResource(configName);
        
        //DB`񃍁[h
        String path = configUrl.getPath();
        
        DbTestConfigReader dbReader = new DbTestConfigReader();
        try{
            testDataList.clear();
            dbReader.create(path, testDataList);
            //test.initTables();
            clearTables();
            insertDatas();
        }catch(Exception e){
            log.error(e.getMessage());
            throw new WeberDbTestCaseInitException(e.getMessage());
        }
        
    }
    
    /**
     * SẴeXgf[^폜܂
     * @throws Exception
     */
    protected void clearTables(){
        Transaction transaction = TransactionUtil.getTransaction();
        if( testDataList.size() == 0 ) return;
        
        System.out.println("---- delete data start --- ");
        
        try{
            for(int i=testDataList.size(); i>0; i--){
                TableData table = (TableData)testDataList.get(i-1);
                StringBuffer sql = new StringBuffer("Delete From ");
                sql.append(table.getTableName());
                System.out.println(sql.toString());
                transaction.execute(sql.toString());
                TransactionUtil.commitTransaction();
            }
        }catch(Exception e){
            log.error(e.getMessage() + ", Execute role back.");
            TransactionUtil.rollbackTransaction();
            throw new WeberDbTestCaseInitException(e.getMessage());
        }finally{
            TransactionUtil.returnTransaction();
        }
        
        System.out.println("---- delete data end --- ");
        
    }
    
    /**
     * eXgf[^f[^x[Xɑ}܂
     * @throws Exception
     */
    protected void insertDatas(){
        Transaction transaction = TransactionUtil.getTransaction();
        
        System.out.println("---- insert data start --- ");
        try{
            for(int i=0; i<testDataList.size(); i++){
                TableData table = (TableData)testDataList.get(i);
                for( int j=0; j<table.getRecordSize(); j++ ){
                    RecordData record = (RecordData)table.getRecordData(j);
                    StringBuffer sql = new StringBuffer("Insert Into ");
                    sql.append(table.getTableName());
                    sql.append(" ( ");
                    
                    //INSERT INTO e[u ( ,  ,.......)
                    //   VALUES(f[^ , f[^ ,.......);
                    if(record.getFieldSize() == 0 ){
                        continue;
                    }
                    for(int k=0; k<record.getFieldSize(); k++){
                        FieldData field = (FieldData)record.getFieldData(k);
                        sql.append(field.getName());
                        if( (k+1)<record.getFieldSize()){
                            sql.append(", ");
                        }
                    }
                    sql.append(" ) Values ( ");
                    for(int k=0; k<record.getFieldSize(); k++){
                        FieldData field = (FieldData)record.getFieldData(k);
                        sql.append(field.getValue());
                        if( (k+1)<record.getFieldSize()){
                            sql.append(", ");
                        }
                    }
                    sql.append(" )");
                    System.out.println(sql.toString());
                    transaction.execute(sql.toString());
                }
            }
            
            TransactionUtil.commitTransaction();
        }catch(Exception e){
            log.error(e.getMessage() + ", Execute role back.");
            TransactionUtil.rollbackTransaction();
            throw new WeberDbTestCaseInitException(e.getMessage());
        }finally{
            TransactionUtil.returnTransaction();
        }
        System.out.println("---- insert data end --- ");
        
    }
    
    /**
     * ANVdoExecute\bh؂܂B<BR>
     * f[^x[X̍XVsꂽꍇ̓R~bg/[obNs܂B
     * @param action Action ANVIuWFNg
     * @param form Form tH[IuWFNg
     * @param forward ANV̎sʂ̗\l
     */
    public void assertDoExecute(Action action, Object form, String forward)throws Exception{
        try{
            super.assertDoExecute(action, form, forward);
        }catch(Exception e){
            throw e;
        }finally{
            int trnStatus = TransactionUtil.getTransaction().getTranStatus();
            if( trnStatus == Transaction.PLEASE_COMMIT ){
                TransactionUtil.commitTransaction();
            }else if( trnStatus == Transaction.PLEASE_ROLLBACK ){
                TransactionUtil.rollbackTransaction();
            }
        }
    }
    
    /**
     * ANVcheckUserRole\bh؂܂B<BR>
     * f[^x[X̍XVsꂽꍇ̓R~bg/[obNs܂B
     * @param action Action ANVIuWFNg
     * @param user [UIuWFNg
     * @param ret [U`FbN
     */
    public void assertCheckUserRole(Action action, User user, boolean ret){
        try{
            super.assertCheckUserRole(action, user, ret);
        }finally{
            int trnStatus = TransactionUtil.getTransaction().getTranStatus();
            if( trnStatus == Transaction.PLEASE_COMMIT ){
                TransactionUtil.commitTransaction();
            }else if( trnStatus == Transaction.PLEASE_ROLLBACK ){
                TransactionUtil.rollbackTransaction();
            }
        }
    }
    
    /**
     * ANVvalidate\bh؂܂B<BR>
     * f[^x[X̍XVsꂽꍇ̓R~bg/[obNs܂B
     * @param action Action ANVIuWFNg
     * @param forward ANV̎sʂ̗\l
     */
    public void assertValidate(Action action, String forward)throws Exception{
        try{
            super.assertValidate(action, forward);
        }catch(Exception e){
            throw e;
        }finally{
            int trnStatus = TransactionUtil.getTransaction().getTranStatus();
            if( trnStatus == Transaction.PLEASE_COMMIT ){
                TransactionUtil.commitTransaction();
            }else if( trnStatus == Transaction.PLEASE_ROLLBACK ){
                TransactionUtil.rollbackTransaction();
            }
        }
    }
}
