package org.itscool.commons.threadpool;

import java.util.Vector;

/**
 * This class represents the Request Buffer. <BR>
 * It's a FIFO queue which is unbounded i.e. infinite size of
 * course limited by physical memory size.<BR>
 * ̃NX́ANGXgEobt@[\܂B<BR>
 * ́AʂĂȂȂ킿̃TCYłL[
 * EETCYɂĐFIFOłB<BR>
 * @author Ashwin Desai.
 * @version 1.00A @\C
 *    obt@TCY̋eʂǉ
 *    add()ŃL[̃obt@TCY𒴂ꍇAThreadBuffer
 *      ExceptionX[Aobt@̒ǉLZB
 */
public class FIFOQueue {
    /** NGXgobt@ */
    private Vector requestVector;
    /** obt@̏ */
    private boolean closed = false;
    /** ftHgobt@TCY */
    public static final int DEFAULT_BUFFER_SIZE = 100;
    /** obt@TCY */
    private int bufferSize = DEFAULT_BUFFER_SIZE;

    /**
    * L[̏
    */
    public FIFOQueue() {
        this(DEFAULT_BUFFER_SIZE);
    }

    /**
    * L[̏
    * @param bufferSize obt@TCY
    */
    public FIFOQueue(int bufferSize) {
        this.bufferSize = bufferSize;
        requestVector = new Vector(bufferSize);
    }

    /**
    * obt@TCY̎擾
    * @return bufferSize obt@TCYԂ܂
    */
    public synchronized int getBufferSize() {
        return bufferSize;
    }

    /**
    * obt@TCY̐ݒ
    * @param bufferSize obt@TCY
    */
    public synchronized void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    /**
    * requestVector vfȂǂ𔻒肷B
    * @return Vector vfĂȂA܂肻̃TCY 0 ̏ꍇ
    * ɂ trueAłȂꍇ false
    */
    public synchronized boolean requestEmpty() {
        return requestVector.isEmpty();
    }

    /**
    * Adds an Object r to the Queue. <BR>
    * If the queue is already closed, throws a ClosedException. <BR>
    * L[ɃIuWFNgr܂B<BR>
    * AL[łɕĂƂ́AClosedException𓊂܂B<BR>
    * <<ǉ>>
    * requestVector̃TCYbuffer_size𒴂ꍇ́Aobt@ւ̒ǉ
    * LZAOThreadBufferExceptionX[܂B
    */
    protected void add(Object r)
        throws ClosedException, ThreadBufferException {
        if (closed){
            throw new ClosedException("Queue closed .... ");
        }
        
        if (requestVector.size() > bufferSize) {
            throw new ThreadBufferException(
                "buffer size[" + requestVector.size() + "] buffer full");
        }

        synchronized (requestVector) {
            requestVector.addElement(r);
            requestVector.notifyAll();
        }
    }

    /**
     * Fetches and Removes the next available object in the queue. 
     * This method blocks if the queue is empty.
     * L[̗̎płIuWFNgtFb`(zo)Ĉڂ
     * ܂BL[ۂȂÃ\bh͍ǂ܂B
     */
    protected Object fetch(WorkerThread thread) {
        synchronized (requestVector) {
            while (requestVector.size() == 0) {
                try {
                    thread.setWaitStatus(); //adding
                    requestVector.wait();
                    thread.unsetWaitStatus(); //adding
                } catch (InterruptedException ie) {
                }
            }
            Object tmp = requestVector.elementAt(0);
            requestVector.removeElementAt(0);
            return tmp;
        }
    }

    /**
     * Marks the queue as Closed. 
     * Additional add() will throw ClosedException.
     * rIƂăL[}[N܂B
     * ǉł܂( )ClosedException𓊂ł傤B
     */
    void close() {
        closed = true;
    }
}
