package org.itscool.commons.dao;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.itscool.commons.bean.BeanUtil;

/**
 * RecordMapNXFieldMapCX^XǗNXł<BR>
 * ̃NXJavaBeanƃe[ů֘AFieldMapCX^X̔z
 * ŊǗĂ܂B
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 */
//public class RecordMap implements Cloneable {
public class RecordMap {
    /**
     * JavaBeans̃NX
     */
    private String className;
    /**
     * JavaBeansɑΉe[u
     */
    private String tableName;
    /**
     * JavaBeans̃vpeBɑΉtB[h̃Xg
     * L[Fe[u.tB[hŕێ܂
     */
    private HashMap fields = new HashMap();
    
    /**
     * RecordMapCX^X̓o^e擾܂
     * @return String RecordMapCX^X̓o^eԂ܂
     */
    public String toString(){
        String line = System.getProperty("line.separator");
        String tab = "  ";
        
        StringBuffer sb = new StringBuffer();
        sb.append("TABLE[").append(tableName).append("] ");
        sb.append("CLASS[").append(className).append("] ");
        sb.append(line);
        Set keySet = fields.keySet();
        Iterator it = keySet.iterator();
        while(it.hasNext()){
            String key = (String)it.next();
            FieldMap fieldMap = (FieldMap)fields.get(key);
            sb.append(tab).append("KEY[").append(key).append("] ");
            sb.append("COLUM[").append(fieldMap.getColumName()).append("] ");
            sb.append("PROPERTY[").append(fieldMap.getPropertyName()).append("] ");
            sb.append(line);
        }
        return sb.toString();
    }
    
    /**
     * w肳ꂽNXƃe[uRecordMapCX^X
     * ܂
     * @param className NX
     * @param tableName e[u
     */
    public RecordMap(String className, String tableName){
        this.tableName = tableName;
        this.className = className;
    }
    
    /**
     * pbP[Wt̃NXNX݂̂擾܂
     * @return pbP[Wt̃NXNX̂ݎ擾܂
     */
    public String getClassOnlyName(){
        int classOnlyNameIndex = className.lastIndexOf(".") + 1;
        String classOnlyName = className.substring(classOnlyNameIndex, className.length());
        return classOnlyName;
    }
    
    /**
     * ̃NXɃZbgꂽJavaBeans̃NX擾܂
     * @return NX
     */
    public String getClassName(){
        return className;
    }
    
    /**
     * RecordMapCX^X̃NXZbg܂
     * @param className ̃e[uɊ֘ANX
     */
    public void setClassName(String className){
        this.className = className;
    }
    
    /**
     * ̃NXɃZbgꂽe[u擾܂
     * @return e[u
     */
    public String getTableName(){
        return tableName;
    }
    
    /**
     * FieldMapCX^Xǉ܂
     * @param field FieldMapCX^X
     */
    public void addField(FieldMap field){
        //fields.add(field);
        fields.put(tableName + "." + field.getColumName(), field);
        //fields.put(field.getPropertyName(), field);
    }
    
    /**
     * ̃NXɓo^ĂSĂFieldMapCX^X擾܂
     * @return ̃NXɓo^ĂSĂFieldMapCX^X
     * ԋp܂
     */
    public HashMap getFields(){
        return fields;
    }
    
    /**
     * ̃NXɓo^ĂFieldMapCX^X"e[u.tB[h"
     * Ŏw肵R[h擾܂
     * @return "e[u.tB[h"Ŏw肵FieldMapCX^XԂ܂
     */
    public FieldMap getField(String tableDotFieldName){
        FieldMap field = (FieldMap)fields.get(tableDotFieldName.toUpperCase());
        return field;
    }
    
    /**
     * Ɏw肵JtB[h擾܂
     * @param argFieldName e[ũJ
     * @return FieldMap tB[hԂ܂
     */
    public FieldMap getFieldByFieldName(String argFieldName){
        String fieldName = argFieldName.toUpperCase();
        Set keySet = fields.keySet();
        Iterator it = keySet.iterator();
        while(it.hasNext()){
            String key = (String)it.next();
            FieldMap fieldMap = (FieldMap)fields.get(key);
            if(fieldMap.getColumName().equals(fieldName)){
                return fieldMap;
            }
        }
        return null;
    }
    
    
    /**
     * Ɏw肵vpeBtB[h擾܂
     * @param argFieldName e[ũJ
     * @return FieldMap tB[hԂ܂
     */
    public FieldMap getFieldByPropertyName(String propertyName){
        Set keySet = fields.keySet();
        Iterator it = keySet.iterator();
        while(it.hasNext()){
            String key = (String)it.next();
            FieldMap fieldMap = (FieldMap)fields.get(key);
            if(fieldMap.getPropertyName().equals(propertyName)){
                return fieldMap;
            }
        }
        return null;
    }
    
    /**
     * RecordMapCX^XɃe[uZbg܂
     * @param tableName e[u
     */
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
    
    public static boolean isEquals(Object obj1, Object obj2, RecordMap recordMap){
        HashMap fieldMap = recordMap.getFields();
        Set keySet = fieldMap.keySet();
        Iterator it = keySet.iterator();
        while(it.hasNext()){
            Object key = it.next();
            FieldMap field = (FieldMap)fieldMap.get(key);
            if( !field.isPrimaryKey() ){
                continue;
            }
            String propertyName = field.getPropertyName();
            Object property1 = BeanUtil.getProperty(obj1, propertyName);
            Object property2 = BeanUtil.getProperty(obj2, propertyName);
            if( !property1.equals(property2) ){
                return false;
            }
        }
        return true;
    }
}
