package org.itscool.commons.dao;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.bean.BeanUtilRuntimeException;
import org.itscool.commons.util.StringUtil;

/**
 * <p>
 * POJO-SQL}bsONX
 * </p>
 *
 * RecordMapCX^Xgăe[uɕKvȃNG쐬NXł <BR>
 * iΏۂƂȂJavaBeans̃NXɃe[u}bsONX(RecordMap)
 * CX^X𐶐܂ <BR>
 * JavaBeansNXɂ́AiΏۂƂȂvpeBƂ̃ANZbT\bh(getter/setter)
 * `ĂKv܂ <BR>
 * ANXƃe[ũ}bsOƃvpeBƃtB[h̃}bsO
 * JavaBeansɒ`Ȃ΂Ȃ܂B <BR>
 * e[ũ}bsOpublic static final String TABLE="e[u" `܂B <BR>
 * TABLE萔`̏ꍇ́AJavaBeans̃NXe[uƃ}bsO܂ <BR>
 * vpeBƃtB[h̃}bsOpublic static final String CULM_vpeB="tB[h" Œ`܂
 * <BR>
 * tB[h萔`̏ꍇ́AvpeBƃtB[h̃}bsO͍s܂B
 * <P>
 * <PRE>
 * JavaBeans̍쐬
 * -----------------
 *
 * public class Customer {
 *    //CustomerNXCUSTOMERe[ũ}bsO`܂B
 *    //TABEL="e[u"ł̃NXɑΉe[u`Ă܂
 *    //COLUM_o="tB[h"CustomerNX̊eoɑΉtB[h`Ă܂<BR>
 *    public static final String TABLE = "CUSTOMER";
 *    public static final String PK_COLUM_id = "id";
 *    public static final String COLUM_name = "name";
 *    public static final String COLUM_companyId = "company_id";
 *    public static final String COLUM_postId = "post_id";
 *
 *    //11֘A 11֘A`ꍇ͈ȉ̂悤ɋLq܂B
 *    //FK_TABLE_IuWFNg="e[u"
 *    //OQƐ̃e[u`Ă܂B
 *    //IuWFNǵAOQƐe[uɑΉJavaBeansNX`܂B
 *    //̃IuWFNgɑΉIuWFNg̐錾ÃNXɒ`ĂKv܂B
 *    //
 *    //Ⴆ΁AOQƐe[u"POST"̐錾͈ȉ̂悤ɂȂ܂B
 *    //
 *    //public static final String FK_TABLE_post = "POST";
 *    //
 *    //ÅOQƐe[uɑΉIuWFNg̐錾ȉ̂悤ɒ`Ȃ΂Ȃ܂B
 *    //
 *    //private Post post; //PostNXɃe[u}bsO񂪒`Ă̂Ƃ܂
 *    //
 *    //FK_COLUM_IuWFNg_o="tB[h"
 *    //IuWFNg_o͂̃NXŒ`ꂽOQƃIuWFNg
 *    //OQƃL[킷vpeB錾܂B
 *    //"tB[h"ɂ͊OQƃe[u̎QƐtB[hw肵܂B
 *    //
 *    //ႦPostNXpostIuWFNg̎QƃL[postId̏ꍇAȉ̂悤ɒ`܂
 *    //
 *    //public static final String FK_COLUM_post_postId = "id";
 *    //
 *    public static final String FK_TABLE_post = "POST"; 			//OQƃe[u
 *    public static final String FK_COLUM_post_postId = "id";		//OQƃL[Ɗ֘AtB[h̎w
 *
 *    public static final String FK_TABLE_company = "COMPANY"; 		//OQƃe[u
 *    public static final String FK_COLUM_company_companyId = "id";	//OQƃL[Ɗ֘AtB[h̎w
 *
 *    private int id;
 *    private String name;
 *    private int companyId;
 *    private int
 *    postId;
 *
 *    private Post post; private Company company;
 *
 *   // EEEȉALõANZbT\bh`Ă
 * }
 *
 *
 * Criteriagpf[^ANZXNX̎
 * --------------------------------------------
 *
 * public class CustomerDao extends BaseDao{
 *    public CustomerDao(Transaction trn){
 *        super(trn);
 *    }
 *
 *    public List getCustomerAll(){
 *        Criteria crt = new Criteria(Customer.class);
 *        System.out.println(crt.toString());
 *        System.out.println(crt.toSelectString());
 *        List lst = select(crt);
 *        return lst;
 *    }
 *
 *    //eXg\bh
 *    public static void main(String[] argv){
 *       //iO)
 *       //ConnectionCX^X擾
 *       Connection con = ds.getConnection();
 *       Transaction trn = new Transaction(con);
 *       CustomerDao dao = new CustomerDao(trn);
 *       List customers = dao.getCustomerAll();
 *       for(int i=0; i<customers.size(); i++){
 *           Customer customer = (Customer)customers.get(i);
 *           String postName = "(null)";
 *           String companyName = "(null)";
 *           Post post = customer.getPost();
 *           Company company = customer.getCompany();
 *           if( post != null )postName = post.getName();
 *           if( company != null )companyName = company.getName();
 *
 *           System.out.print("ID[" + customer.getId() + "] NAME["+ customer.getName() + "] ");
 *           System.out.println("POST[" + postName + "] COMPANY["+ companyName + "] ");
 *       }
 *   }
 * </PRE>
 *
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 */
public class Criteria{
    protected Class entity;
    
    /**
     * sR[h
     */
    protected static final String line
            = System.getProperty("line.separator");
    
    /**
     * ^uR[h
     */
    protected static final String tab = "    ";
    
    /**
     * {ƂȂRecordMapCX^X
     */
    protected RecordMap gRecordMap;
    
    /**
     * WHERE僊Xg
     */
    protected LinkedList whereList;
    
    /**
     * ORDER BY僊Xg
     */
    protected LinkedList orderByList;
    
    /**
     * GROUP BY僊Xg
     */
    protected LinkedList groupByList;
    
    /**
     * OQƁiForigne KeyŎw肵tB[hje[ũXg
     */
    protected HashMap fkRecordMaps;
    
    private HashMap oneToManyRecordMaps;
    private boolean oneToMany = false;
    
    /**
     * LIMIT 
     */
    protected String limit = null;
    
    /**
     * LIMIT̃Zbg
     * @param startRow 擾Jns(1)
     * @param row 擾s
     */
    public void setLimit(int startRow, int row){
        EntityInfoMapping mapping = EntityInfoMapping.getInstance();
        String dbType = mapping.getDbType();
        if( startRow > 0 ){
            startRow --;
        }
        if( dbType.equals(EntityInfoMapping.DB_HSQL) ){
            limit = "LIMIT " + startRow + " " + row;
        }else{
            limit = "LIMIT " + startRow + ", " + row;
        }
    }
    
    /**
     * LIMIT̎擾
     */
    public String getLimit(){
        return limit;
    }
    
    /**
     * CriteriaCX^X̏<BR>
     * entityr[NXɒ`ĂTABELACOLUM_o͂A
     * entityr[ɑΉRecordMapCX^X쐬܂B<BR>
     * @param entity iΏۂƂȂJavaBeans̃NX
     */
    public Criteria(Class entity){
        this.entity = entity;
        EntityInfoMapping mapping = EntityInfoMapping.getInstance();
        gRecordMap = mapping.getGRecordMap(entity);
        fkRecordMaps = mapping.getFkRecordMaps(entity);
        setOneToManyRecordMaps(mapping.getOneToManyRecordMaps(entity));
        if( getOneToManyRecordMaps().size() > 0 ){
            this.setOneToMany(true);
        }
        //EntityInfoMappingŐ邽߁Asv
//        if(gRecordMap==null){
//            this.gRecordMap = RecordMapFactory.createRecordMap(entity);
//        }
//        if(fkRecordMaps==null){
//            //OQƗpRecordMapCX^X̔z쐬
//            this.fkRecordMaps = RecordMapFkFactory.createFkRecordMaps(entity);
//        }
        
        this.orderByList = new LinkedList();
        this.groupByList = new LinkedList();
        this.whereList = new LinkedList();
    }
    
    /**
     * JavaBeans̃vpeBJ擾܂
     * vpeB"."ŋ؂Ăꍇ́AOQƐIuWFNg
     * vpeBƂ݂Ȃ܂B
     * @param propertyName vpeB
     * @return String ̃vpeBɑΉJ
     */
    public String getColumName(String propertyName){
        int index = propertyName.indexOf(".");
        String columName;
        if( index > 0 ){
            String fkObjectName = propertyName.substring(0, index);
            String fkPropertyName = propertyName.substring(index+1, propertyName.length());

            columName = cnvFkColumName(fkObjectName, fkPropertyName);
        }else{
            columName = cnvColumName(propertyName);
        }
        //ΉJ݂Ȃꍇ
        if( columName == null ){
            columName = StringUtil.cnvUpperNameToUnderScoreName(propertyName);
        }
        return columName;
    }
    
    /**
     * JavaBeans̃vpeBJ擾܂
     * @param propertyName vpeBP
     * @return String ̃vpeBɑΉJ
     */
    protected String cnvColumName(String propertyName){
        EntityInfoMapping mapping = EntityInfoMapping.getInstance();
        RecordMap recordMap = mapping.getGRecordMap(entity.getName());
        if( recordMap == null) return null;
        FieldMap fieldMap = recordMap.getFieldByPropertyName(propertyName);
        if( fieldMap == null ) return null;
        String columWithTableName =fieldMap.getColumWithTableName();
        return columWithTableName;
    }
    
    /**
     * JavaBeans̊OQƃNX̃vpeBJ擾܂
     * @param fkObjectName JavaBeansɒ`ꂽOQƃe[ũIuWFNg
     * @param propertyName OQƃIuWFNg̃vpeB
     * @return String ̃vpeBɑΉJ
     */
    protected String cnvFkColumName(String fkObjectName, String fkPropertyName){
        EntityInfoMapping mapping = EntityInfoMapping.getInstance();
        RecordMap fkRecordMap = mapping.getFkRecordMap(entity.getName(), fkObjectName );
        if( fkRecordMap == null) return null;
        FieldMap fkFieldMap = fkRecordMap.getFieldByPropertyName(fkPropertyName);
        if( fkFieldMap == null ) return null;
        String fkColumName = fkFieldMap.getColumWithTableName();
        return fkColumName;
    }
    
    /**
     * {ƂȂRecordMapCX^X擾܂
     * @return RecordMapCX^X
     */
    public RecordMap getRecord(){
        return gRecordMap;
    }
    
    /**
     * w肳ꂽRecordMapCX^X̗񃊃Xg쐬܂
     * @param record RecordMapCX^X
     * @return w肳ꂽRecordMapCX^X̗񃊃XgԂ܂
     */
    protected String getColNames(RecordMap record){
        StringBuffer sb = new StringBuffer(line);
        HashMap fields = record.getFields();
        Set keySet = fields.keySet();
        Iterator it = keySet.iterator();
        while( it.hasNext() ){
            Object key = it.next();
            FieldMap item = (FieldMap)fields.get(key);
            String colWithTableName = item.getColumWithTableName();
            String colAsName = item.getColumAsName();
            sb.append( tab );
            sb.append( colWithTableName );
            sb.append(" as ");
            sb.append( colAsName );
            if( it.hasNext() ){
                sb.append(",");
                sb.append( line );
            }
        }
        return sb.toString();
    }
    
    /**
     * ֘Ae[u̗񃊃Xg쐬܂
     * @param records RecordMapCX^X
     * @return ֘Ae[u̗񃊃XgԂ܂
     */
    protected String getColNamesByTable(HashMap records){
        StringBuffer sb = new StringBuffer();
        Set keySet = records.keySet();
        Iterator it = keySet.iterator();
        
        while( it.hasNext() ){
            Object key = it.next();
            RecordMap recordMap = (RecordMap)records.get(key);
            
            sb.append(getColNames(recordMap));
        }
        return sb.toString();
    }
    
    /**
     * ֘Ae[ũXgԂ܂
     * @param records RecordMapCX^X
     * @return ֘Ae[ũXgԂ܂
     */
    protected String getTableNames(HashMap records){
        StringBuffer sb = new StringBuffer();
        Set keySet = records.keySet();
        Iterator it = keySet.iterator();
        
        while( it.hasNext() ){
            Object key = it.next();
            RecordMap recordMap = (RecordMap)records.get(key);
            
            sb.append(recordMap.getTableName());
            if(it.hasNext()){
                sb.append(",");
            }
        }
        return sb.toString();
    }
    
    /**
     * Criteria\擾܂
     * @return Criteria\
     */
    public String toString(){
        StringBuffer sb = new StringBuffer();
        sb.append(gRecordMap.toString());
        sb.append(line);
        Set keySet = fkRecordMaps.keySet();
        Iterator it = keySet.iterator();
        while(it.hasNext()){
            String key = (String)it.next();
            RecordMap recordMap = (RecordMap)fkRecordMaps.get(key);
            sb.append("FK_KEY[").append(key).append("] ").append(recordMap.toString());
            sb.append(line);
        }
        return sb.toString();
    }
    
    /**
     * SELECT쐬܂<BR>
     * [select [cols] from [table] where [name]=[value] [and|or] ]
     * `SQL\z܂
     * @return SELECTXe[ggԂ܂
     */
    public String toSelectString(){
        EntityInfoMapping mapping = EntityInfoMapping.getInstance();
        String dbType = mapping.getDbType();
        
        StringBuffer sql = new StringBuffer("SELECT");
        
        //LIMITiHSQLj
        if( dbType.equals(EntityInfoMapping.DB_HSQL) && limit != null ){
            sql.append(line+tab);
            sql.append(limit);
        }
        
        //W̍쐬
        sql.append(getColNames(gRecordMap));
        //OQƃe[ũtB[h擾
        sql.append(getFkSelectString());
        if(isOneToMany()){
            sql.append(getOneToManySelectString());
        }
        
        //Pe[ũ`FbN
        sql.append(line);
        sql.append("FROM");
        sql.append(line + tab).append(gRecordMap.getTableName());
        
        //OQƃe[u擾
        sql.append(getFkTableString());
        if(isOneToMany()){
            //ONE TO MANY
            sql.append(getOneToManyTableString());
        }
        //Where̍쐬
        FieldMap deleteFg = gRecordMap.getFieldByFieldName(FieldMap.FLD_DELETE_FG);
        if( whereList.size() > 0 || fkRecordMaps.size() > 0 ||  deleteFg != null ||
            (getOneToManyRecordMaps().size() > 0 && isOneToMany())){
            sql.append(line);
            sql.append("WHERE").append(line + tab);
        }
        
        sql.append(getWhereString());
        
        //_폜tB[h݂ꍇ
        //_폜ںނO
        if( deleteFg != null ){
            if( whereList.size() > 0 ){
                sql.append(line + tab);
                sql.append("AND ");
            } 
            sql.append(deleteFg.getColumWithTableName());
            sql.append(" != 1 ");
        }
        
        //OQƃtB[h擾
        sql.append(getFkWhereString());
        if(isOneToMany()){
            sql.append(getOneToManyWhereString());
        }
        //Group By̍쐬
        if( groupByList.size() > 0 ){
            sql.append(line);
            sql.append("GROUP BY");
            sql.append(getGroupByString());
        }
        
        //Order By̍쐬
        if( orderByList.size() > 0 ){
            sql.append(line);
            sql.append("ORDER BY");
            sql.append(getOrderByString());
        }
        
        //LIMITiHSQLȊOj
        if( !dbType.equals(EntityInfoMapping.DB_HSQL) && limit != null ){
            sql.append(line+tab);
            sql.append(limit);
        }
        return sql.toString();
    }
    
    /**
     * SELECT COUNT 쐬܂<BR>
     * [select [cols] from [table] where [name]=[value] [and|or] ]
     * `SQL\z܂
     * @return SELECTXe[ggԂ܂
     */
    public String toCountString(){
        EntityInfoMapping mapping = EntityInfoMapping.getInstance();
        String dbType = mapping.getDbType();
        
        StringBuffer sql = new StringBuffer("SELECT");
        
        sql.append(" COUNT(*) AS DATA_NUM");
        
        //Pe[ũ`FbN
        sql.append(line);
        sql.append("FROM");
        sql.append(line + tab).append(gRecordMap.getTableName());
        
        //OQƃe[u擾
        sql.append(getFkTableString());
        
        //Where̍쐬
        FieldMap deleteFg = gRecordMap.getFieldByFieldName(FieldMap.FLD_DELETE_FG);
        if( whereList.size() > 0 || fkRecordMaps.size() > 0 || deleteFg != null){
            sql.append(line);
            sql.append("WHERE").append(line + tab);
        }
        
        sql.append(getWhereString());
        
        //_폜tB[h݂ꍇ
        //_폜ںނO
        if( deleteFg != null ){
            if( whereList.size() > 0 ){
                sql.append(line + tab);
                sql.append("AND ");
            } 
            sql.append(deleteFg.getColumWithTableName());
            sql.append(" != 1 ");
        }
        
        //OQƃtB[h擾
        sql.append(getFkWhereString());
        
        //Group By̍쐬
        if( groupByList.size() > 0 ){
            sql.append(line);
            sql.append("GROUP BY");
            sql.append(getGroupByString());
        }
        
        return sql.toString();
    }
    
    /**
     * OQƗpRecordMapCX^XSELECT擾܂
     * @param sql SELECTԂ܂
     */
    private String getFkSelectString() {
        StringBuffer sql = new StringBuffer();
        //OQƃe[ũtB[h擾
        Set keySet = fkRecordMaps.keySet();
        Iterator it = keySet.iterator();
        if( it.hasNext() ){
            sql.append(",");
        }
        while(it.hasNext()){
            String key = (String)it.next();
            //OQƏ擾
            RecordMap fkRecordMap = (RecordMap)fkRecordMaps.get(key);
            //OQƏŎ擾NXRecordMapCX^X쐬
            sql.append(getColNames(fkRecordMap));
            if( it.hasNext() ){
                sql.append(",");
            }
        }
        return sql.toString();
    }
    
    private String getOneToManySelectString() {
        StringBuffer sql = new StringBuffer();
        //OQƃe[ũtB[h擾
        Set keySet = getOneToManyRecordMaps().keySet();
        Iterator it = keySet.iterator();
        if( it.hasNext() ){
            sql.append(",");
        }
        while(it.hasNext()){
            String key = (String)it.next();
            //OQƏ擾
            RecordMap oneToManyRecordMap = (RecordMap)getOneToManyRecordMaps().get(key);
            //OQƏŎ擾NXRecordMapCX^X쐬
            sql.append(getColNames(oneToManyRecordMap));
            if( it.hasNext() ){
                sql.append(",");
            }
        }
        return sql.toString();
    }
    
    /**
     * OQƗpRecordMapCX^X猋̃e[u擾܂
     * @param sql e[uԂ܂
     */
    private String getFkTableString() {
        StringBuffer sql = new StringBuffer();
        //OQƃe[ũtB[h擾
        Set keySet = fkRecordMaps.keySet();
        Iterator it = keySet.iterator();
        if( it.hasNext() ){
            sql.append(",");
            sql.append(line + tab);
        }
        while(it.hasNext()){
            String key = (String)it.next();
            //OQƏ擾
            RecordMap fkRecordMap = (RecordMap)fkRecordMaps.get(key);
            //OQƏŎ擾NXRecordMapCX^X쐬
            String fkTableName = fkRecordMap.getTableName();
            sql.append(fkTableName);
            if( it.hasNext() ){
                sql.append(",");
                sql.append(line + tab);
            }
        }
        return sql.toString();
    }
    
    private String getOneToManyTableString() {
        StringBuffer sql = new StringBuffer();
        //OQƃe[ũtB[h擾
        Set keySet = getOneToManyRecordMaps().keySet();
        Iterator it = keySet.iterator();
        if( it.hasNext() ){
            sql.append(",");
            sql.append(line + tab);
        }
        while(it.hasNext()){
            String key = (String)it.next();
            //OQƏ擾
            RecordMap oneToManyRecordMap = (RecordMap)getOneToManyRecordMaps().get(key);
            //OQƏŎ擾NXRecordMapCX^X쐬
            String fkTableName = oneToManyRecordMap.getTableName();
            sql.append(fkTableName);
            if( it.hasNext() ){
                sql.append(",");
                sql.append(line + tab);
            }
        }
        return sql.toString();
    }
    
    /**
     * OQƗpRecordMapCX^XWHERE擾܂
     * @param sql WHEREԂ܂
     */
    private String getFkWhereString(){
        StringBuffer sql = new StringBuffer();
        //OQƃe[ũtB[h擾
        Set keySet = fkRecordMaps.keySet();
        Iterator it = keySet.iterator();
        
        if( it.hasNext() && 
            ( whereList.size() > 0 || gRecordMap.getFieldByFieldName(FieldMap.FLD_DELETE_FG) != null) ){
            sql.append(line + tab);
            sql.append("AND ");
        }
        while(it.hasNext()){
            String key = (String)it.next();
            //OQƏ擾
            RecordMap fkRecordMap = (RecordMap)fkRecordMaps.get(key);
            //OQƏɃZbgĂe[uǉ
            Set fieldKeySet = fkRecordMap.getFields().keySet();
            Iterator fieldIt = fieldKeySet.iterator();
            
            while(fieldIt.hasNext()){
                String fieldKey = (String)fieldIt.next();
                FieldMap fieldMap = (FieldMap)fkRecordMap.getField(fieldKey);
                if(!fieldMap.isForignKey()){
                    continue;
                }
                String propertyName = fieldMap.getPropertyName();
                String columWithTableName = fieldMap.getColumWithTableName();
                String fkPropertyName = fieldMap.getFkPropertyName();
                sql.append(columWithTableName);
                sql.append(" = ");
                sql.append(getFkFieldName(fkPropertyName));
                if( it.hasNext() ){
                    sql.append(line + tab);
                    sql.append("AND ");
                }
            }
        }
        return sql.toString();
    }
    
    private String getOneToManyWhereString(){
        StringBuffer sql = new StringBuffer();
        //OQƃe[ũtB[h擾
        Set keySet = getOneToManyRecordMaps().keySet();
        Iterator it = keySet.iterator();
        
        if( it.hasNext() && 
            ( whereList.size() > 0 || gRecordMap.getFieldByFieldName(FieldMap.FLD_DELETE_FG) != null) ){
            sql.append(line + tab);
            sql.append("AND ");
        }
        while(it.hasNext()){
            String key = (String)it.next();
            //OQƏ擾
            RecordMap oneToManyRecordMap = (RecordMap)getOneToManyRecordMaps().get(key);
            //OQƏɃZbgĂe[uǉ
            Set fieldKeySet = oneToManyRecordMap.getFields().keySet();
            Iterator fieldIt = fieldKeySet.iterator();
            
            while(fieldIt.hasNext()){
                String fieldKey = (String)fieldIt.next();
                FieldMap fieldMap = (FieldMap)oneToManyRecordMap.getField(fieldKey);
                if(!fieldMap.isForignKey()){
                    continue;
                }
                String propertyName = fieldMap.getPropertyName();
                String columWithTableName = fieldMap.getColumWithTableName();
                String oneToManyPropertyName = fieldMap.getFkPropertyName();
                sql.append(columWithTableName);
                sql.append(" = ");
                //sql.append(getFkFieldName(oneToManyPropertyName));
                FieldMap current = gRecordMap.getFieldByPropertyName(oneToManyPropertyName);
                sql.append(current.getColumWithTableName());
                
                if( it.hasNext() ){
                    sql.append(line + tab);
                    sql.append("AND ");
                }
            }
        }
        return sql.toString();
    }
    
    /**
     * OQƗpRecordMapCX^XWHEREɎw肷tB[h
     * 擾܂
     * @param propertyName OQƐ̃vpeB
     * @param sql tB[hԂ܂
     */
    private String getFkFieldName(String propertyName){
        HashMap fields = gRecordMap.getFields();
        Set keySet = fields.keySet();
        Iterator it = keySet.iterator();
        String fkFieldName = "";
        while(it.hasNext()){
            String key = (String)it.next();
            FieldMap fieldMap = (FieldMap)fields.get(key);
            if( fieldMap.getPropertyName().equals(propertyName)){
                return fieldMap.getColumWithTableName();
            }
        }
        return fkFieldName;
    }
    
    /**
     * DELETE쐬܂<BR>
     * [delte * from [table] where [name]=[value] [and|or] ]
     * `SQL\z܂
     * @return DELETEXe[ggԂ܂
     */
    public String toDeleteString(){
        if( gRecordMap.getFieldByFieldName(FieldMap.FLD_DELETE_FG) != null){
            return toLogicalDeleteString();
        }else{
            StringBuffer sql = new StringBuffer("DELETE FROM ");
            sql.append(" ").append(gRecordMap.getTableName()).append(" ");
            //Where̍쐬
            if( whereList.size() > 0 ){
                sql.append(line);
                sql.append("WHERE").append(line + tab);
                sql.append(getWhereString());
            }
            return sql.toString();
        }
    }
    
    public String toLogicalDeleteString(){
        StringBuffer sql = new StringBuffer("UPDATE ");
        FieldMap deleteFg = gRecordMap.getFieldByFieldName(FieldMap.FLD_DELETE_FG);
        FieldMap deleteDt = gRecordMap.getFieldByFieldName(FieldMap.FLD_DELETE_DT);
        
        sql.append(line);
            
        sql.append(" ").append(gRecordMap.getTableName()).append(" ");
        sql.append(" SET ");
        sql.append(line + tab);
        sql.append(deleteFg.getColumWithTableName());
        sql.append("=1");
        if( deleteDt != null ){
            sql.append(", ");
            sql.append(deleteDt.getColumWithTableName());
            sql.append("=");
            sql.append(deleteDt.cnvSqlValue(new Date()));
        }
        //Where̍쐬
        if( whereList.size() > 0 ){
            sql.append(line);
            sql.append("WHERE").append(line + tab);
            sql.append(getWhereString());
        }
        return sql.toString();
    }
    
    /**
     * INSERT쐬܂<BR>
     * [insert into [table]([name],) values([value],) ]
     * `SQL\z܂
     * @param bean iΏۃIuWFNg
     * @return INSERTXe[ggԂ܂
     */
    public String toInsertString(Object bean){
        StringBuffer sql = new StringBuffer("INSERT INTO");
        HashMap fields = gRecordMap.getFields();
        sql.append(" ").append(gRecordMap.getTableName());
        sql.append("(");
        sql.append( toItemNames(fields) );
        sql.append(") VALUES(");
        sql.append( toItemValues(fields, bean) );
        sql.append(")");
        
        return sql.toString();
    }
    
    /**
     * yϓIbNp̃o[WԍUPDATE쐬܂<br/>
     * tB[hROCK_VERSION݂ꍇAyϓIbNpUPDATE
     * 쐬܂B
     * @param bean iΏۃIuWFNg
     * [update [table] set [name] = [value], ]
     */
    public String toUpdateString(Object bean){
        StringBuffer sql = new StringBuffer("UPDATE");
        HashMap fields = gRecordMap.getFields();
        Object version = null;
        try{
            version = getLockVersion(bean);
        }catch(Exception e){}
        
        sql.append(" ").append(gRecordMap.getTableName()).append(line);;
        sql.append("SET ").append(line + tab);;
        sql.append(toUpdateNames(fields, bean));
        
        //Where̍쐬
        if( whereList.size() > 0 ){
            sql.append(line);
            sql.append("WHERE").append(line + tab);
            sql.append(getWhereString());
        }
        if( version != null ){
            if(  whereList.size() == 0 ){
                sql.append(line);
                sql.append("WHERE").append(line + tab);
            }else{
                sql.append(line + tab).append("AND ");
            }
            
            try{
                int versionNum = Integer.parseInt(version.toString());
                if( versionNum == 0){
                    //bNo[Wo^̉\̂NULLɊ܂߂
                    sql.append("(");
                    sql.append(FieldMap.FLD_LOCK_VERSION).append(" = ").append(version);
                    sql.append(" OR ").append(FieldMap.FLD_LOCK_VERSION).append(" is null");
                    sql.append(")");
                }else{
                    sql.append(FieldMap.FLD_LOCK_VERSION).append(" = ").append(version);
                }
            }catch(Exception e){
                sql.append(FieldMap.FLD_LOCK_VERSION).append(" = ").append(version);
            }
        }
        return sql.toString();
    }

    public Object getLockVersion(Object bean) throws BeanUtilRuntimeException {
        Object version;
        FieldMap rockVersionField = 
            gRecordMap.getFieldByFieldName(FieldMap.FLD_LOCK_VERSION);
        if( rockVersionField == null ){
            return null;
        }
        version = BeanUtil.getProperty(bean, rockVersionField.getPropertyName());
        return version;
    }
    /**
     * UPDATEsetȍ~̃L[[h쐬܂B<BR>
     * @param bean iΏۃIuWFNg
     * [name] = [value],
     */
    protected static String toUpdateNames(HashMap fields, Object bean){
        StringBuffer sb = new StringBuffer();
        Set keySet = fields.keySet();
        Iterator it = keySet.iterator();
        boolean nextFlg = false;
        while( it.hasNext() ){
            Object key = it.next();
            FieldMap item = (FieldMap)fields.get(key);
            if( item.isPrimaryKey() ){
                continue;
            }else if(nextFlg){
                sb.append(",");
                sb.append(line + tab);
            }
            String propertyName = item.getPropertyName();
//            String value = String.valueOf(BeanUtil.getProperty(bean, propertyName));
            Object value = BeanUtil.getProperty(bean, propertyName);
            sb.append( item.getColumName() );
            sb.append( "=" );
            //yϓIbNΉ
            if( item.getColumName().equals(FieldMap.FLD_LOCK_VERSION)){
                //so[W{PZbg
                value = String.valueOf( Integer.parseInt(value.toString()) + 1 );
                //Vo[WZbg
//                BeanUtil.setProperty(bean, propertyName, value);
                sb.append(value);
            //ŏIXVt̎ZbgΉ
            }else if( item.getColumName().equals(FieldMap.FLD_UPDATE_DT)){
                //ŏIXVZbg
                Date updateDt = new Date();
                value = item.cnvSqlValue(updateDt);
                //ŏIXVZbg
//                BeanUtil.setProperty(bean, propertyName, updateDt);
                sb.append(value);
            }else{
                sb.append(item.cnvSqlValue(value));
            }
            
            if( !nextFlg ){
                nextFlg = true;
            }
        }
        return sb.toString();
    }
    
    /**
     * SELECT쐬܂<BR>
     * [select [cols] from [table] where [name]=[value] [and|or] ]
     * `SQL\z܂
     * @return SELECTXe[ggԂ܂
     */
    public String toSelectLockVersionString(){
        EntityInfoMapping mapping = EntityInfoMapping.getInstance();
        String dbType = mapping.getDbType();
        
        StringBuffer sql = new StringBuffer("SELECT");
        FieldMap lckField = gRecordMap.getFieldByFieldName(FieldMap.FLD_LOCK_VERSION);
        if(lckField ==null ) return null;
        
        sql.append(line+tab);
        sql.append(gRecordMap.getTableName()).append(".");
        sql.append(lckField.getColumName());
        sql.append(" AS ").append(lckField.getColumName());
        
        //Pe[ũ`FbN
        sql.append(line);
        sql.append("FROM");
        sql.append(line + tab).append(gRecordMap.getTableName());
        
        //OQƃe[u擾
        sql.append(getFkTableString());
        
        //Where̍쐬
        if( whereList.size() > 0 || fkRecordMaps.size() > 0 ){
            sql.append(line);
            sql.append("WHERE").append(line + tab);
        }
        
        sql.append(getWhereString());
        //OQƃtB[h擾
        sql.append(getFkWhereString());
        
        //Group By̍쐬
        if( groupByList.size() > 0 ){
            sql.append(line);
            sql.append("GROUP BY");
            sql.append(getGroupByString());
        }
        
        //Order By̍쐬
        if( orderByList.size() > 0 ){
            sql.append(line);
            sql.append("ORDER BY");
            sql.append(getOrderByString());
        }
        return sql.toString();
    }
    
    /**
     * [ [name],[name] ]`SQL\z܂
     * @param fields tB[h̃Xg
     * @return SQLԂ܂
     */
    protected static String toItemNames(HashMap fields){
        StringBuffer sb = new StringBuffer();
        Set keySet = fields.keySet();
        Iterator it = keySet.iterator();
        
        while( it.hasNext() ){
            Object key = it.next();
            FieldMap item = (FieldMap)fields.get(key);
            sb.append( item.getColumName().toUpperCase() );
            if( it.hasNext() ){
                sb.append(",");
            }
        }
        return sb.toString();
    }
    
    /**
     * [ [value],['value(string)'] ]`SQL\z܂
     * @param fields tB[h̃Xg
     * @return SQLԂ܂
     */
    protected static String toItemValues(HashMap fields, Object bean){
        StringBuffer sb = new StringBuffer();
        Set keySet = fields.keySet();
        Iterator it = keySet.iterator();
        
        while( it.hasNext() ){
            Object key = it.next();
            FieldMap item = (FieldMap)fields.get(key);
            String propertyName = item.getPropertyName();
            //String className = item.getRecordMap().getClassName();
            Object value = BeanUtil.getProperty(bean, propertyName);
            
            //yϓIbNΉ
            if( item.getColumName().equals(FieldMap.FLD_LOCK_VERSION)){
                //Vo[WPZbg
                value = String.valueOf(1);
                //Vo[WZbg
                BeanUtil.setProperty(bean, propertyName, value);
                sb.append(value);
            //ŏIXVt̎ZbgΉ
            }else if( item.getColumName().equals(FieldMap.FLD_UPDATE_DT)){
                //ŏIXVZbg
                Date updateDt = new Date();
                value = item.cnvSqlValue(updateDt);
                //ŏIXVZbg
                BeanUtil.setProperty(bean, propertyName, updateDt);
                sb.append(value);
            }else if(item.getColumName().equals(FieldMap.FLD_DELETE_DT)){
                sb.append("null");
            }else{
                sb.append(item.cnvSqlValue(value));
            }
            
            if( it.hasNext() ){
                sb.append(",");
            }
        }
        return sb.toString();
    }
    
    /**
     * CriteriaCX^Xɓo^ĂWhere擾܂
     * @return CriteriaCX^Xɓo^ĂWhere
     */
    public String getWhereString(){
        StringBuffer sb = new StringBuffer();
        Iterator it = whereList.iterator();
        
        while( it.hasNext() ){
            String sql = (String)it.next();
            sb.append(sql);
//modify 2005/07/25 Start
//            if( it.hasNext() ){
//                sb.append(line + tab);
//                sb.append("AND ");
//            }
//modify 2005/07/25 End
        }
        return sb.toString();
    }
    
    /**
     * CriteriaCX^Xɓo^ĂOrder By擾܂
     * @return CriteriaCX^Xɓo^ĂWhere
     */
    public String getOrderByString(){
        StringBuffer sb = new StringBuffer();
        Iterator it = orderByList.iterator();
        
        while( it.hasNext() ){
            String sql = (String)it.next();
            sb.append(sql.toUpperCase());
            if( it.hasNext() ){
                sb.append(",");
            }
        }
        return sb.toString();
    }
    
    /**
     * CriteriaCX^Xɓo^ĂGroup By擾܂
     * @return CriteriaCX^Xɓo^ĂWhere
     */
    public String getGroupByString(){
        StringBuffer sb = new StringBuffer();
        Iterator it = groupByList.iterator();
        
        while( it.hasNext() ){
            String sql = (String)it.next();
            sb.append(sql.toUpperCase());
            if( it.hasNext() ){
                sb.append(",");
            }
        }
        return sb.toString();
    }
    
    /**
     * OR쐬܂
     */
    public Criteria or(){
        StringBuffer sb = new StringBuffer();
        sb.append(line);
        sb.append(tab);
        sb.append("OR ");
        whereList.add( sb.toString() );
        return this;
    }
    
    /**
     * AND쐬܂
     */
    public Criteria and(){
        StringBuffer sb = new StringBuffer();
        sb.append(line);
        sb.append(tab);
        sb.append("AND ");
        whereList.add( sb.toString() );
        return this;
    }
    
    /**
     * ORDER BY쐬܂
     * @param propertyName JavaBeans̃vpeB
     */
    public Criteria orderby(String propertyName){
        return orderby(propertyName, true);
    }
    
    /**
     * ORDER BY쐬܂
     * @param propertyName JavaBeans̃vpeB
     * @param sort /~w肵܂Btruew肷ƏɂȂ܂
     */
    public Criteria orderby(String propertyName, boolean sort){
        FieldMap fieldMap = null;
        String fieldName = getColumName(propertyName);
        if( fieldName != null ){
            fieldMap = gRecordMap.getField(fieldName);
        }
        String sortStr = "";
        if(sort == true){
            sortStr = "ASC";
        }else{
            sortStr = "DESC";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(line);
        sb.append(tab);
        sb.append(fieldName);
        sb.append(" ").append(sortStr);
        orderByList.add( sb.toString() );
        
        return this;
    }
    
    /**
     * GROUP BY쐬܂
     * @param JavaBeans̃vpeB
     */
    public Criteria groupby(String propertyName){
        FieldMap fieldMap = null;
        String fieldName = getColumName(propertyName);
        if( fieldName != null ){
            fieldMap = gRecordMap.getField(fieldName);
        }
        String sortStr = "";
        StringBuffer sb = new StringBuffer();
        sb.append(line);
        sb.append(tab);
        sb.append(fieldName);
        sb.append(" ").append(sortStr);
        groupByList.add( sb.toString() );
        return this;
    }
    
    /**
     * OQƃtB[h擾܂
     * @param propertyName JavaBeans̃vpeB
     */
    public FieldMap getFkField(String propertyName){
        String fieldName = getColumName(propertyName);
        if( fieldName == null){
            fieldName = propertyName;
        }
        Set keySet = fkRecordMaps.keySet();
        Iterator it = keySet.iterator();
        while(it.hasNext()){
            Object key = it.next();
            //OQƏ擾
            RecordMap fkRecordMap = (RecordMap)fkRecordMaps.get(key);
            FieldMap fieldMap = fkRecordMap.getField(fieldName);
            if(fieldMap != null){
                return fieldMap;
            }
        }
        return null;
    }
    
    /**
     * IS NULL쐬܂
     * @param propertyName JavaBeans̃vpeB
     */
    public Criteria isnull(String propertyName){
        FieldMap fieldMap = null;
        String fieldName = getColumName(propertyName);
        if( fieldName != null ){
            fieldMap = gRecordMap.getField(fieldName);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(fieldName).append(" IS NULL");
        whereList.add( sb.toString() );
        return this;
    }
    
    /**
     * IS NOT NULL 쐬܂
     * @param propertyName JavaBeans̃vpeB
     */
    public Criteria isnotnull(String propertyName){
        FieldMap fieldMap = null;
        String fieldName = getColumName(propertyName);
        if( fieldName != null ){
            fieldMap = gRecordMap.getField(fieldName);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(fieldName).append(" IS NOT NULL");
        whereList.add( sb.toString() );
        return this;
    }
    
    /**
     * [BETWEEN e[u.tB[h l1 AND l2] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value1 l1
     * @param value2 l2
     */
    public Criteria between(String propertyName, Object value1, Object value2){
        FieldMap fieldMap = null;
        String fieldName = getColumName(propertyName);
        if( fieldName != null ){
            fieldMap = gRecordMap.getField(fieldName);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(fieldName);
        sb.append(" BETWEEN ");
        sb.append(fieldMap.cnvSqlValue(value1));
        sb.append(" AND ");
        sb.append(fieldMap.cnvSqlValue(value2));
        whereList.add( sb.toString() );
        return this;
    }
    
    /**
     * [BETWEEN e[u.tB[h l1 AND l2] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value1 l1
     * @param value2 l2
     */
    public Criteria between(String propertyName, int value1, int value2){
        return between(propertyName, String.valueOf(value1), String.valueOf(value2));
    }
    
    /**
     * [BETWEEN e[u.tB[h l1 AND l2] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value1 l1
     * @param value2 l2
     */
    public Criteria between(String propertyName, short value1, short value2){
        return between(propertyName, String.valueOf(value1), String.valueOf(value2));
    }
    
    /**
     * [BETWEEN e[u.tB[h l1 AND l2] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value1 l1
     * @param value2 l2
     */
    public Criteria between(String propertyName, double value1, double value2){
        return between(propertyName, String.valueOf(value1), String.valueOf(value2));
    }
    
    /**
     * [BETWEEN e[u.tB[h l1 AND l2] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value1 l1
     * @param value2 l2
     */
    public Criteria between(String propertyName, long value1, long value2){
        return between(propertyName, String.valueOf(value1), String.valueOf(value2));
    }
    
    /**
     * [BETWEEN e[u.tB[h l1 AND l2] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value1 l1
     * @param value2 l2
     */
    public Criteria between(String propertyName, float value1, float value2){
        return between(propertyName, String.valueOf(value1), String.valueOf(value2));
    }
    
    /**
     * [e[u.tB[h LIKE l] 쐬܂
     * @param field hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria like(String propertyName, Object value){
        FieldMap fieldMap = null;
        String fieldName = getColumName(propertyName);
        if( fieldName != null ){
            fieldMap = gRecordMap.getField(fieldName);
        }
        StringBuffer sb = new StringBuffer();
        
        sb.append(fieldName).append(" ");
        sb.append("LIKE ");
        sb.append(fieldMap.cnvSqlValue(value));
        whereList.add( sb.toString() );
        
        return this;
    }
    
    /**
     * [e[u.tB[h LIKE l] 쐬܂
     * @param fieldName hJavaBeans̃vpeB
     * @param value l
     */
    public void like(String fieldName, int value){
        like(fieldName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h LIKE l] 쐬܂
     * @param fieldName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria like(String fieldName, short value){
        return like(fieldName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h LIKE l] 쐬܂
     * @param fieldName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria like(String fieldName, double value){
        return like(fieldName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h LIKE l] 쐬܂
     * @param fieldName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria like(String fieldName, long value){
        return like(fieldName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h LIKE l] 쐬܂
     * @param fieldName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria like(String fieldName, float value){
        return like(fieldName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h = l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria eq(String propertyName, Object value){
        FieldMap fieldMap = null;
        String fieldName = getColumName(propertyName);
        if( fieldName != null ){
            fieldMap = gRecordMap.getField(fieldName);
        }
        if(fieldMap == null){
            fieldMap = getFkField(propertyName);
        }
        StringBuffer sb = new StringBuffer();
        
        if( fieldMap == null ){
            sb.append(propertyName).append(" = ");
            sb.append(value);
        }else{
            sb.append(fieldMap.getColumWithTableName()).append(" = ");
            sb.append(fieldMap.cnvSqlValue(value));
        }
        whereList.add(sb.toString());
        
        return this;
    }
    
    /**
     * [e[u.tB[h = l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria eq(String propertyName, int value){
        return eq(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h = l] 쐬܂
     * @param propertyName JavaBeans̃vpeB
     * @param value l
     */
    public Criteria eq(String propertyName, short value){
        return eq(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h = l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria eq(String propertyName, double value){
        return eq(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h = l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria eq(String propertyName, long value){
        return eq(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h = l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria eq(String propertyName, float value){
        return eq(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h != l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria neq(String propertyName, Object value){
        FieldMap fieldMap = null;
        String fieldName = getColumName(propertyName);
        if( fieldName != null ){
            fieldMap = gRecordMap.getField(fieldName);
        }
        StringBuffer sb = new StringBuffer();
        if( fieldMap == null ){
            sb.append(fieldName).append(" != ");
            sb.append(value);
        }else{
            sb.append(fieldMap.getColumWithTableName()).append(" != ");
            sb.append(fieldMap.cnvSqlValue(value));
        }
        whereList.add( sb.toString() );
        
        return this;
    }
    
    /**
     * [e[u.tB[h != l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria neq(String propertyName, short value){
        return neq(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h != l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria neq(String propertyName, int value){
        return neq(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h != l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria neq(String propertyName, long value){
        return neq(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h != l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria neq(String propertyName, double value){
        return neq(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h != l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria neq(String propertyName, float value){
        return neq(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h != l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria neq(String propertyName, Date value){
        return neq(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h > l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria morebig(String propertyName, Object value){
        FieldMap fieldMap = null;
        String fieldName = getColumName(propertyName);
        if( fieldName != null ){
            fieldMap = gRecordMap.getField(fieldName);
        }
        StringBuffer sb = new StringBuffer();
        if( fieldMap == null ){
            sb.append(fieldName).append(" > ");
            sb.append(value);
        }else{
            sb.append(fieldMap.getColumWithTableName()).append(" > ");
            sb.append(fieldMap.cnvSqlValue(value));
        }
        whereList.add( sb.toString() );
        
        return this;
    }
    
    /**
     * [e[u.tB[h > l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria morebig(String propertyName, short value){
        return morebig(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h > l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria morebig(String propertyName, int value){
        return morebig(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h > l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria morebig(String propertyName, long value){
        return morebig(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h > l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria morebig(String propertyName, double value){
        return morebig(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h > l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria morebig(String propertyName, float value){
        return morebig(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h > l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria morebig(String propertyName, Date value){
        return morebig(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h < l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria moresmall(String propertyName, Object value){
        FieldMap fieldMap = null;
        String fieldName = getColumName(propertyName);
        if( fieldName != null ){
            fieldMap = gRecordMap.getField(fieldName);
        }
        StringBuffer sb = new StringBuffer();
        if( fieldMap == null ){
            sb.append(fieldName).append(" < ");
            sb.append(value);
        }else{
            sb.append(fieldMap.getColumWithTableName()).append(" < ");
            sb.append(fieldMap.cnvSqlValue(value));
        }
        whereList.add( sb.toString() );
        
        return this;
    }
    
    /**
     * [e[u.tB[h < l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria moresmall(String propertyName, short value){
        return moresmall(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h < l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria moresmall(String propertyName, int value){
        return moresmall(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h < l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria moresmall(String propertyName, long value){
        return moresmall(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h < l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria moresmall(String propertyName, double value){
        return moresmall(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h < l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l     */
    public Criteria moresmall(String propertyName, float value){
        return moresmall(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h < l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria moresmall(String propertyName, Date value){
        return moresmall(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h >= l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria overbig(String propertyName, Object value){
        FieldMap fieldMap = null;
        String fieldName = getColumName(propertyName);
        if( fieldName != null ){
            fieldMap = gRecordMap.getField(fieldName);
        }
        StringBuffer sb = new StringBuffer();
        if( fieldMap == null ){
            sb.append(fieldName).append(" >= ");
            sb.append(value);
        }else{
            sb.append(fieldMap.getColumWithTableName()).append(" >= ");
            sb.append(fieldMap.cnvSqlValue(value));
        }
        whereList.add( sb.toString() );
        
        return this;
    }
    
    /**
     * [e[u.tB[h >= l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria overbig(String propertyName, short value){
        return overbig(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h >= l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria overbig(String propertyName, int value){
        return overbig(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h >= l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria overbig(String propertyName, long value){
        return overbig(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h >= l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria overbig(String propertyName, double value){
        return overbig(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h >= l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria overbig(String propertyName, float value){
        return overbig(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h >= l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria overbig(String propertyName, Date value){
        return overbig(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h <= l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria oversmall(String propertyName, Object value){
        FieldMap fieldMap = null;
        String fieldName = getColumName(propertyName);
        if( fieldName != null ){
            fieldMap = gRecordMap.getField(fieldName);
        }
        StringBuffer sb = new StringBuffer();
        if( fieldMap == null ){
            sb.append(fieldName).append(" <= ");
            sb.append(value);
        }else{
            sb.append(fieldMap.getColumWithTableName()).append(" <= ");
            sb.append(fieldMap.cnvSqlValue(value));
        }
        whereList.add( sb.toString() );
        
        return this;
    }
    
    /**
     * [e[u.tB[h <= l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria oversmall(String propertyName, short value){
        return oversmall(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h <= l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria oversmall(String propertyName, int value){
        return oversmall(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h <= l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria oversmall(String propertyName, long value){
        return oversmall(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h <= l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria oversmall(String propertyName, double value){
        return oversmall(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h <= l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria oversmall(String propertyName, float value){
        return oversmall(propertyName, String.valueOf(value));
    }
    
    /**
     * [e[u.tB[h <= l] 쐬܂
     * @param propertyName hJavaBeans̃vpeB
     * @param value l
     */
    public Criteria oversmall(String propertyName, Date value){
        return oversmall(propertyName, String.valueOf(value));
    }
    
    /**
     * @return fkRecordMaps ߂܂B
     */
    public HashMap getFkRecordMaps() {
        return fkRecordMaps;
    }
    /**
     * @param fkRecordMaps fkRecordMaps ݒB
     */
    public void setFkRecordMaps(HashMap fkRecordMaps) {
        this.fkRecordMaps = fkRecordMaps;
    }

    public boolean isOneToMany() {
        return oneToMany;
    }

    public void setOneToMany(boolean oneToMany) {
        this.oneToMany = oneToMany;
    }

    public HashMap getOneToManyRecordMaps() {
        return oneToManyRecordMaps;
    }

    public void setOneToManyRecordMaps(HashMap oneToManyRecordMaps) {
        this.oneToManyRecordMaps = oneToManyRecordMaps;
    }
}