package test.org.itscool.weber.user;

import java.io.IOException;

import junit.framework.TestCase;

import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.connection.ConnectionManager;
import org.itscool.commons.connection.TransactionUtil;
import org.itscool.weber.user.Role;
import org.itscool.weber.user.User;
import org.itscool.weber.user.UserEntityManager;

/**
 * ̃eXg{ꍇ́Af[^x[XƐڑAȉ
 * e[u`ĂKv܂<P>
 *
 * WEBER_USERe[u<BR>
 * WEBER_ROLEe[u<BR>
 *
 * @author ios
 *
 */
public class RoleDbManagerTest extends TestCase{
    
    public RoleDbManagerTest(){
        BeanFactory factory = BeanFactory.getInstance();
        String rootPath = System.getProperty("user.dir");
        try{
            factory.createForUrl("di-config.xml");
            ConnectionManager mgr = (ConnectionManager) factory.createInstance("ConnectionManager");
            mgr.init();
        }catch(IOException ioe){
            ioe.printStackTrace();
        }
    }
    
    public void testMakeUser(){
        UserEntityManager manager = UserEntityManager.getInstance();
        boolean ret;
        try{
            manager.init();
            
            Role role = new Role();
            role.setName("guest1");
            
            ret = manager.addRole(role);
            assertEquals(ret, true);
            
            User user = new User();
            user.setName("taro");
            user.setPwd("ios");
            
            ret = manager.add("guest1", user);
            assertEquals(ret, true);
            
            User checkUser = manager.getUser("guest1", "taro");
            
            assertNotNull(checkUser);
            assertEquals(user.getName(), checkUser.getName());
            assertEquals(user.getPwd(), checkUser.getPwd());
            
            //manager.delete("guest1", user);
            //TransactionUtil.commitTransaction();
            TransactionUtil.rollbackTransaction();
        }catch(IOException ioe){
            ioe.printStackTrace();
            fail(ioe.getMessage());
            TransactionUtil.rollbackTransaction();
        }
    }
    
    public void testMakeUserKana(){
        UserEntityManager manager = UserEntityManager.getInstance();
        boolean ret;
        try{
            manager.init();
            Role role = new Role();
            role.setName("guest1");
            
            ret = manager.addRole(role);
            assertEquals(ret, true);
            
            User user = new User();
            user.setName("kanou");
            user.setPwd("ios");
            
            ret = manager.add("guest1", user);
            assertEquals(ret, true);
            
            //TransactionUtil.commitTransaction();
            
            User checkUser = manager.getUser("guest1", "kanou");
            
            assertNotNull(checkUser);
            assertEquals(user.getName(), checkUser.getName());
            assertEquals(user.getPwd(), checkUser.getPwd());
            //manager.delete("guest1", user);
            //TransactionUtil.commitTransaction();
            TransactionUtil.rollbackTransaction();
        }catch(IOException ioe){
            ioe.printStackTrace();
            fail(ioe.getMessage());
            TransactionUtil.rollbackTransaction();
        }
    }
    
    public void testIsUser(){
        UserEntityManager manager = UserEntityManager.getInstance();
        boolean ret;
        try{
            manager.init();
            Role role = new Role();
            role.setName("guest1");
            
            ret = manager.addRole(role);
            assertEquals(ret, true);
            
            User user = new User();
            user.setName("kanou");
            user.setPwd("ios");
            
            ret = manager.add("guest1", user);
            assertEquals(ret, true);
            
            //TransactionUtil.commitTransaction();
            
            //assertEquals(manager.isUserCheck(mappings, user), true);
            
            //manager.delete("guest1", user);
            //TransactionUtil.commitTransaction();
            TransactionUtil.rollbackTransaction();
        }catch(IOException ioe){
            ioe.printStackTrace();
            fail(ioe.getMessage());
            TransactionUtil.rollbackTransaction();
        }
    }
    
    public void testIsUserFailPwd(){
        UserEntityManager manager = UserEntityManager.getInstance();
        boolean ret;
        try{
            manager.init();
            Role role = new Role();
            role.setName("guest1");
            
            ret = manager.addRole(role);
            assertEquals(ret, true);
            
            User user = new User();
            user.setName("kanou");
            user.setPwd("ios");
            
            ret = manager.add("guest1", user);
            assertEquals(ret, true);
            
            //TransactionUtil.commitTransaction();
            
            //قȂpX[hZbg
            user.setPwd("hogehoge");
            //assertEquals(manager.isUserCheck(mappings, user), false);
            
            //manager.delete("guest1", user);
            //TransactionUtil.commitTransaction();
            TransactionUtil.rollbackTransaction();
        }catch(IOException ioe){
            ioe.printStackTrace();
            fail(ioe.getMessage());
            TransactionUtil.rollbackTransaction();
        }
    }
    
    public void testIsUserFailName(){
        UserEntityManager manager = UserEntityManager.getInstance();
        boolean ret;
        try{
            manager.init();
            Role role = new Role();
            role.setName("guest1");
            
            ret = manager.addRole(role);
            assertEquals(ret, true);
            
            User user = new User();
            user.setName("kanou");
            user.setPwd("ios");
            
            ret = manager.add("guest1", user);
            assertEquals(ret, true);
            
            //TransactionUtil.commitTransaction();
            
            //قȂ閼OZbg
            user.setName("hogehoge");
            //assertEquals(manager.isUserCheck(mappings, user), false);
            
            user.setName("kanou");
            //manager.delete("guest1", user);
            //TransactionUtil.commitTransaction();
            TransactionUtil.rollbackTransaction();
            
        }catch(IOException ioe){
            ioe.printStackTrace();
            fail(ioe.getMessage());
            TransactionUtil.rollbackTransaction();
        }
    }
}
